/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.central.dataentity.service.DEServiceBase;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DEServiceInvocationHandler<T>
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(DEServiceInvocationHandler.class);
    private IDataEntityRuntime iDataEntityRuntime = null;
    private Class<T> cls = null;
    private T t = null;
    private IDEService realDEService = null;

    public DEServiceInvocationHandler(IDataEntityRuntimeContext iDataEntityRuntimeContext, Class<T> cls) throws Exception {
        this.iDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntimeContext.getDataEntityRuntime();
        this.cls = cls;
        this.t = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{cls}, (InvocationHandler)this);
        if (IDEService.class.isAssignableFrom(cls)) {
            this.realDEService = new DEServiceBase<IEntityDTO, ISearchContextDTO>(){

                public String getDataEntityId() {
                    return DEServiceInvocationHandler.this.iDataEntityRuntime.getId();
                }

                public IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
                    return null;
                }

                public ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
                    return null;
                }
            };
            this.realDEService.init(this.iDataEntityRuntime.getSystemRuntime(), (net.ibizsys.central.dataentity.IDataEntityRuntime)this.iDataEntityRuntime);
        }
    }

    protected IDataEntityRuntime getDataEntityRuntime() {
        return this.iDataEntityRuntime;
    }

    protected Class<T> getIntCls() {
        return this.cls;
    }

    public T getProxyDEService() {
        return this.t;
    }

    protected IDEService getRealDEService() {
        return this.realDEService;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(IDEService.class)) {
            return method.invoke((Object)this.getRealDEService(), args);
        }
        return this.getDataEntityRuntime().invokeMethod(method.getName(), args, null);
    }
}

