/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudExtensionClient;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.cloud.core.dataentity.ac.IDEChatCompletionRuntime;
import net.ibizsys.central.cloud.core.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.V2ImportSchema;
import net.ibizsys.central.dataentity.service.DEServiceAPIRuntimeException;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRSRuntime;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.IWebContext;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DEServiceAPIRuntime
extends net.ibizsys.central.dataentity.service.DEServiceAPIRuntime
implements IDEServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(DEServiceAPIRuntime.class);
    public static final String HEADER_DATAACCACTION = "srfdataaccaction";
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
    private ICloudExtensionClient iCloudExtensionClient = null;

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        if (this.iSysCloudClientUtilRuntime == null) {
            this.iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
        }
        return this.iSysCloudClientUtilRuntime;
    }

    protected ICloudExtensionClient getCloudExtensionClient() {
        if (this.iCloudExtensionClient == null) {
            this.iCloudExtensionClient = (ICloudExtensionClient)this.getSysCloudClientUtilRuntime().getServiceClient("EXTENSION", ICloudExtensionClient.class, true);
        }
        return this.iCloudExtensionClient;
    }

    @Override
    public Object chatCompletion(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strACTag, String strMethod, Object objBody, String strKey, Object objTag) throws Throwable {
        try {
            if (ObjectUtils.isEmpty((Object)strKey)) {
                throw new Exception("\u6ca1\u6709\u6307\u5b9a\u8f93\u5165\u53c2\u6570");
            }
            return this.onChatCompletion(strScope, iDEServiceAPIRSRuntime, strParentKey, strACTag, strMethod, objBody, strKey, objTag);
        }
        catch (Throwable ex) {
            if (ex instanceof DEServiceAPIRuntimeException) {
                throw (DEServiceAPIRuntimeException)ex;
            }
            throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("\u4ea4\u8c08\u8865\u5168\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onChatCompletion(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strACTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEChatCompletionRuntime iDEChatCompletionRuntime = (IDEChatCompletionRuntime)this.getDataEntityRuntime().getDEAutoCompleteRuntime(strACTag, false);
        if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), iDEServiceAPIRSRuntime == null ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), strParentKey, (Object)strKey, null, "READ")) {
            throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("%1$s[%2$s]\u4e0d\u5177\u5907\u64cd\u4f5c\u80fd\u529b[%3$s]", this.getLogicName(), strKey, "READ"), 2);
        }
        Object key = this.getDataEntityRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), strKey);
        if ("SSECHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iDEChatCompletionRuntime.sseChatCompletion(key, (ChatCompletionRequest)((Object)JsonUtils.as((Object)objBody, ChatCompletionRequest.class)));
        }
        if ("CHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iDEChatCompletionRuntime.chatCompletion(key, (ChatCompletionRequest)((Object)JsonUtils.as((Object)objBody, ChatCompletionRequest.class)));
        }
        if ("ASYNCCHATCOMPLETION".equalsIgnoreCase(strMethodName)) {
            return iDEChatCompletionRuntime.asyncChatCompletion(key, (ChatCompletionRequest)((Object)JsonUtils.as((Object)objBody, ChatCompletionRequest.class)));
        }
        if ("HISTORIES".equalsIgnoreCase(strMethodName)) {
            return iDEChatCompletionRuntime.getHistories(key, objBody, null);
        }
        throw new Exception(String.format("\u672a\u8bc6\u522b\u7684\u8bf7\u6c42\u65b9\u6cd5[%1$s]", strMethodName));
    }

    @Override
    public Object importData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        return null;
    }

    @Override
    public Object importData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        return null;
    }

    @Override
    public Object asyncImportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        return null;
    }

    @Override
    public Object asyncImportData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        try {
            return this.onAsyncImportData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, strOSSFileId, strImportSchemaId, objTag);
        }
        catch (Throwable ex) {
            if (ex instanceof DEServiceAPIRuntimeException) {
                throw (DEServiceAPIRuntimeException)ex;
            }
            throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("\u5f02\u6b65\u5bfc\u5165\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onAsyncImportData2(String strScope, final IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, final String strParentKey, final String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        if (!(this.getDataEntityRuntime() instanceof IDataEntityRuntime)) {
            throw new Exception("\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        final IDataEntityRuntime realDataEntityRuntime = (IDataEntityRuntime)this.getDataEntityRuntime();
        if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), iDEServiceAPIRSRuntime == null ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), strParentKey, null, null, "CREATE")) {
            throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("%1$s\u4e0d\u5177\u5907\u64cd\u4f5c\u80fd\u529b[%2$s]", this.getLogicName(), "CREATE"), 2);
        }
        final IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
        Object objValue = null;
        if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength((String)strParentKey)) {
            IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
            if (parentIdPSDEField != null) {
                objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
                iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
            } else {
                throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, "\u89e3\u6790\u5bfc\u5165Excel\u53d1\u751f\u5f02\u5e38\uff1a\u7f3a\u5c11\u5173\u7cfb\u5c5e\u6027");
            }
        }
        V2ImportSchema v2ImportSchema2 = null;
        if (StringUtils.hasLength((String)strImportSchemaId)) {
            try {
                v2ImportSchema2 = this.getImportSchema(strImportSchemaId);
            }
            catch (Exception ex) {
                throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("\u83b7\u53d6\u5bfc\u5165\u4f53\u7cfb\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
        InputStream inputStream2 = null;
        try {
            inputStream2 = this.getImportDataInputStream(strOSSFileId, iEntityDTO);
        }
        catch (Exception ex) {
            throw new DEServiceAPIRuntimeException((net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime)this, String.format("\u83b7\u53d6\u8f93\u5165\u6d41\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        final String strValue = objValue == null ? null : String.valueOf(objValue);
        HashMap<String, String> actionTagMap = new HashMap<String, String>();
        actionTagMap.put("actiontype", "DEIMPORTDATA2");
        actionTagMap.put("actionparam", this.getDataEntityRuntime().getName());
        actionTagMap.put("actionparam2", strImportTag);
        final InputStream inputStream = inputStream2;
        final V2ImportSchema v2ImportSchema = v2ImportSchema2;
        return this.getSystemRuntime().asyncExecute((IAction)new INamedAction(){

            public Object execute(Object[] args) throws Throwable {
                if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength((String)strParentKey)) {
                    return realDataEntityRuntime.importData2(strImportTag, (IEntity)iEntityDTO, inputStream, v2ImportSchema, true, (IDataEntityRuntime)iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), strValue);
                }
                return realDataEntityRuntime.importData2(strImportTag, (IEntity)iEntityDTO, inputStream, v2ImportSchema, true, null, null);
            }

            public String getName() {
                if (StringUtils.hasLength((String)strImportTag)) {
                    return String.format("[%1$s]\u6570\u636e\u5bfc\u5165\u4f5c\u4e1a[%2$s]", DEServiceAPIRuntime.this.getDataEntityRuntime().getLogicName(), strImportTag);
                }
                return String.format("[%1$s]\u6570\u636e\u5bfc\u5165\u4f5c\u4e1a", DEServiceAPIRuntime.this.getDataEntityRuntime().getLogicName());
            }
        }, null, actionTagMap);
    }

    protected InputStream getImportDataInputStream(Object objBody, IEntityDTO iEntityDTO) throws Exception {
        if (objBody instanceof String) {
            String strFileId = (String)objBody;
            ISysOSSUtilRuntime iSysOSSUtilRuntime = (ISysOSSUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
            net.ibizsys.runtime.util.domain.File file = iSysOSSUtilRuntime.getOSSFile(strFileId, "temp", true);
            if (file == null) {
                throw new Exception(String.format("\u65e0\u6cd5\u4e0b\u8f7d\u6307\u5b9aOSS\u6587\u4ef6[%1$s]", strFileId));
            }
            if (iEntityDTO != null && !ObjectUtils.isEmpty((Object)file.getFileName())) {
                iEntityDTO.set("srfimportfilename", file.getFileName());
            }
            return new FileInputStream(new File(file.getLocalPath()));
        }
        return super.getImportDataInputStream(objBody, iEntityDTO);
    }

    protected V2ImportSchema getImportSchema(String strImportSchemaId) throws Exception {
        return this.getCloudExtensionClient().getImportSchema(strImportSchemaId);
    }

    protected Object onFetchDataSet(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {
        String strRequestDataAccessAction;
        IWebContext iWebContext;
        Object ret = super.onFetchDataSet(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
        if (ret == null || !(ret instanceof Page) || EmployeeContext.getCurrent() == null) {
            return ret;
        }
        Page page = (Page)ret;
        if (ObjectUtils.isEmpty((Object)page.getContent())) {
            return ret;
        }
        if (!(page.getContent().get(0) instanceof IEntityDTO)) {
            return ret;
        }
        String strVersionId = null;
        if ((this.getDataEntityRuntime().isEnableVersionControl() || this.getDataEntityRuntime().isEnableVersionStorage()) && (iWebContext = UserContext.getCurrentMust().getWebContext()) != null) {
            strVersionId = iWebContext.getParameter("SRFVERSIONID");
        }
        if (ObjectUtils.isEmpty(strVersionId) && StringUtils.hasLength((String)(strRequestDataAccessAction = this.getRequestDataAccessAction()))) {
            if ("false".equalsIgnoreCase(strRequestDataAccessAction)) {
                return ret;
            }
            if ("true".equalsIgnoreCase(strRequestDataAccessAction)) {
                strRequestDataAccessAction = "";
            }
            IDataEntityAccessManager iDataEntityAccessManager = (IDataEntityAccessManager)this.getDataEntityRuntime().getDataEntityAccessManager();
            iDataEntityAccessManager.fillDataAccessActions(EmployeeContext.getCurrent(), page.getContent(), strRequestDataAccessAction, null);
        }
        return ret;
    }

    protected Object onExecuteAction(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {
        String strRequestDataAccessAction;
        IWebContext iWebContext;
        Object ret = super.onExecuteAction(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
        if (ret == null || !(ret instanceof IEntityDTO) || EmployeeContext.getCurrent() == null) {
            return ret;
        }
        String strVersionId = null;
        if ((this.getDataEntityRuntime().isEnableVersionControl() || this.getDataEntityRuntime().isEnableVersionStorage()) && (iWebContext = UserContext.getCurrentMust().getWebContext()) != null) {
            strVersionId = iWebContext.getParameter("SRFVERSIONID");
        }
        if (ObjectUtils.isEmpty(strVersionId) && StringUtils.hasLength((String)(strRequestDataAccessAction = this.getRequestDataAccessAction()))) {
            if ("false".equalsIgnoreCase(strRequestDataAccessAction)) {
                return ret;
            }
            if ("true".equalsIgnoreCase(strRequestDataAccessAction)) {
                strRequestDataAccessAction = "";
            }
            IDataEntityAccessManager iDataEntityAccessManager = (IDataEntityAccessManager)this.getDataEntityRuntime().getDataEntityAccessManager();
            iDataEntityAccessManager.fillDataAccessActions(EmployeeContext.getCurrent(), Arrays.asList((IEntityDTO)ret), strRequestDataAccessAction, null);
        }
        return ret;
    }

    protected String getRequestDataAccessAction() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
            return httpServletRequest.getHeader(HEADER_DATAACCACTION);
        }
        return null;
    }
}

