/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.security.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.dr.DataEntityDRProviderBase;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class OrgDRProvider
extends DataEntityDRProviderBase {
    private static final Log log = LogFactory.getLog(OrgDRProvider.class);

    public boolean support(IPSDEUserRole iPSDEUserRole) {
        return iPSDEUserRole.isEnableOrgDR();
    }

    public boolean isSupportMerge() {
        return true;
    }

    public IPSDEUserRole merge(IPSDEUserRole mergeDEUserRole, Collection<IPSDEUserRole> iPSDEUserRoles) {
        iPSDEUserRoles.stream().forEach(iPSDEUserRole -> {
            if (this.support((IPSDEUserRole)iPSDEUserRole)) {
                mergeDEUserRole.getObjectNode().put("enableOrgDR", true);
                mergeDEUserRole.getObjectNode().put("orgDR", mergeDEUserRole.getOrgDR() | iPSDEUserRole.getOrgDR());
            }
        });
        return mergeDEUserRole;
    }

    public List<ISearchCond> getDRSearchConds(IDataEntityRuntime iDataEntityRuntime, IPSDEUserRole iPSDEUserRole, String action) {
        ArrayList<ISearchCond> searchConds = new ArrayList<ISearchCond>();
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        long orgDR = iPSDEUserRole.getOrgDR();
        if (orgDR > 0L) {
            if (iDataEntityRuntime.getOrgIdPSDEField() == null) {
                log.warn((Object)String.format("\u5b9e\u4f53[%s]\u672a\u6307\u5b9a\u6743\u9650[\u7ec4\u7ec7]\u5b57\u6bb5", iDataEntityRuntime.getName()));
            } else {
                SearchFieldCond searchFieldCond;
                if ((1L & orgDR) > 0L) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getOrgIdPSDEField().getName());
                    searchFieldCond.setCondOp("EQ");
                    searchFieldCond.setValue((Object)iEmployeeContext.getOrgid());
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((2L & orgDR) > 0L && StringUtils.hasLength((String)iEmployeeContext.getPorg())) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getOrgIdPSDEField().getName());
                    searchFieldCond.setCondOp("IN");
                    searchFieldCond.setValue((Object)String.format("'%s'", String.join((CharSequence)"','", iEmployeeContext.getPorg().split(","))));
                    searchFieldCond.setParamMode(false);
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((4L & orgDR) > 0L && StringUtils.hasLength((String)iEmployeeContext.getSorg())) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getOrgIdPSDEField().getName());
                    searchFieldCond.setCondOp("IN");
                    searchFieldCond.setValue((Object)String.format("'%s'", String.join((CharSequence)"','", iEmployeeContext.getSorg().split(","))));
                    searchFieldCond.setParamMode(false);
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((8L & orgDR) > 0L) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getOrgIdPSDEField().getName());
                    searchFieldCond.setCondOp("ISNULL");
                    searchConds.add((ISearchCond)searchFieldCond);
                }
            }
        }
        return searchConds;
    }
}

