/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.security.dr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.dr.DataEntityDRProviderBase;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DeptDRProvider
extends DataEntityDRProviderBase {
    private static final Log log = LogFactory.getLog(DeptDRProvider.class);

    public boolean support(IPSDEUserRole iPSDEUserRole) {
        return iPSDEUserRole.isEnableSecDR();
    }

    public boolean isSupportMerge() {
        return true;
    }

    public IPSDEUserRole merge(IPSDEUserRole mergeDEUserRole, Collection<IPSDEUserRole> iPSDEUserRoles) {
        iPSDEUserRoles.stream().forEach(iPSDEUserRole -> {
            if (this.support((IPSDEUserRole)iPSDEUserRole)) {
                mergeDEUserRole.getObjectNode().put("enableSecDR", true);
                mergeDEUserRole.getObjectNode().put("secDR", mergeDEUserRole.getSecDR() | iPSDEUserRole.getSecDR());
            }
        });
        return mergeDEUserRole;
    }

    public List<ISearchCond> getDRSearchConds(IDataEntityRuntime iDataEntityRuntime, IPSDEUserRole iPSDEUserRole, String action) {
        ArrayList<ISearchCond> searchConds = new ArrayList<ISearchCond>();
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        long secDR = iPSDEUserRole.getSecDR();
        if (secDR > 0L) {
            if (iDataEntityRuntime.getDeptIdPSDEField() == null) {
                log.warn((Object)String.format("\u5b9e\u4f53[%s]\u672a\u6307\u5b9a\u6743\u9650[\u90e8\u95e8]\u8303\u56f4\u5b57\u6bb5", iDataEntityRuntime.getName()));
            } else {
                SearchFieldCond searchFieldCond;
                if ((1L & secDR) > 0L) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getDeptIdPSDEField().getName());
                    searchFieldCond.setCondOp("EQ");
                    searchFieldCond.setValue((Object)iEmployeeContext.getDeptid());
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((2L & secDR) > 0L && StringUtils.hasLength((String)iEmployeeContext.getPdept())) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getDeptIdPSDEField().getName());
                    searchFieldCond.setCondOp("IN");
                    searchFieldCond.setValue((Object)String.format("'%s'", String.join((CharSequence)"','", iEmployeeContext.getPdept().split(","))));
                    searchFieldCond.setParamMode(false);
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((4L & secDR) > 0L && StringUtils.hasLength((String)iEmployeeContext.getSdept())) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getDeptIdPSDEField().getName());
                    searchFieldCond.setCondOp("IN");
                    searchFieldCond.setValue((Object)String.format("'%s'", String.join((CharSequence)"','", iEmployeeContext.getSdept().split(","))));
                    searchFieldCond.setParamMode(false);
                    searchConds.add((ISearchCond)searchFieldCond);
                }
                if ((8L & secDR) > 0L) {
                    searchFieldCond = new SearchFieldCond();
                    searchFieldCond.setFieldName(iDataEntityRuntime.getDeptIdPSDEField().getName());
                    searchFieldCond.setCondOp("ISNULL");
                    searchConds.add((ISearchCond)searchFieldCond);
                }
            }
        }
        return searchConds;
    }
}

