/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.logic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.dataentity.logic.DELogicSession;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudLogUtilRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DELogicRuntime
extends net.ibizsys.central.dataentity.logic.DELogicRuntime {
    private static final Log log = LogFactory.getLog(DELogicRuntime.class);
    public static final String CONSOLESENDER_DELOGICDEBUGGER = "DELogic\u8c03\u8bd5\u4fe1\u606f";
    private ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = null;

    protected void onInit() throws Exception {
        if (this.getDebugMode() != 0 && this.getSystemRuntime() instanceof IServiceSystemRuntime && ((IServiceSystemRuntime)this.getSystemRuntime()).isEnableProdMode()) {
            String strLogCat = String.format("%1$s|%2$s(%3$s)", this.getDataEntityRuntime().getName(), this.getLogicName(), this.getPSDELogic().getCodeName());
            log.warn((Object)String.format("\u5904\u7406\u903b\u8f91[%1$s]\u8c03\u8bd5\u6a21\u5f0f\u5728\u751f\u4ea7\u6a21\u5f0f\u4e0b\u7981\u7528", strLogCat));
            this.setDebugMode(0);
        }
        super.onInit();
    }

    protected ISysCloudLogUtilRuntime getSysCloudLogUtilRuntime() {
        if (this.iSysCloudLogUtilRuntime == null) {
            this.iSysCloudLogUtilRuntime = (ISysCloudLogUtilRuntime)this.getDELogicRuntimeContext().getSystemRuntime().getSysUtilRuntime(ISysCloudLogUtilRuntime.class, false);
        }
        return this.iSysCloudLogUtilRuntime;
    }

    protected IDELogicSession createDELogicSession(Map<String, Object> params) {
        if (params != null) {
            return new DELogicSession(this.getDELogicRuntimeContext(), params);
        }
        return this.createDELogicSession();
    }

    protected IDELogicSession createDELogicSession() {
        return new DELogicSession(this.getDELogicRuntimeContext());
    }

    protected void outputDebugInfo(IDELogicSession iDELogicSession, Throwable ex) {
        super.outputDebugInfo(iDELogicSession, ex);
        if (this.isOutputDebugInfo()) {
            String strLogCat = String.format("%1$s|%2$s(%3$s)", this.getDataEntityRuntime().getName(), this.getLogicName(), this.getPSDELogic().getCodeName());
            String strInfo = this.getDebugConsoleInfo(iDELogicSession, ex);
            if (StringUtils.hasLength((String)strInfo)) {
                String[] infos;
                for (String strPart : infos = DELogicRuntime.splitByLength(strInfo, 20480)) {
                    if (ex == null) {
                        this.getSysCloudLogUtilRuntime().sendConsoleMessage(null, CONSOLESENDER_DELOGICDEBUGGER, false, 20000, strLogCat, strPart);
                        continue;
                    }
                    this.getSysCloudLogUtilRuntime().sendConsoleMessage(null, CONSOLESENDER_DELOGICDEBUGGER, false, 40000, strLogCat, strPart);
                }
            }
        }
    }

    public static String[] splitByLength(String str, int length) {
        int strLength = str.length();
        int arrayLength = (int)Math.ceil((double)strLength / (double)length);
        String[] result = new String[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            int beginIndex = i * length;
            int endIndex = Math.min(beginIndex + length, strLength);
            result[i] = str.substring(beginIndex, endIndex);
        }
        return result;
    }

    protected String getDebugConsoleInfo(IDELogicSession iDELogicSession, Throwable ex) {
        if (iDELogicSession.getDebugArrayNode() != null) {
            StringBuilder sb = new StringBuilder();
            int nSize = iDELogicSession.getDebugArrayNode().size();
            int nBlank = 0;
            int nBlankLevel = 2;
            for (int i = 0; i < nSize; ++i) {
                JsonNode jsonNode = iDELogicSession.getDebugArrayNode().get(i);
                if (!(jsonNode instanceof ObjectNode)) continue;
                ObjectNode objectNode = (ObjectNode)jsonNode;
                JsonNode type = objectNode.get("type");
                JsonNode time = objectNode.get("time");
                JsonNode name = objectNode.get("name");
                JsonNode info = objectNode.get("info");
                JsonNode data = objectNode.get("data");
                JsonNode codeName = objectNode.get("codeName");
                if (type == null) continue;
                sb.append("\r\n");
                for (int j = 0; j < nBlank; ++j) {
                    sb.append(" ");
                }
                if (time != null) {
                    sb.append(time.asText());
                    sb.append(" ");
                }
                String strType = type.asText();
                sb.append(String.format("[%1$s]", strType));
                if (name != null) {
                    sb.append(String.format(" %1$s", name.asText()));
                    if (codeName != null) {
                        sb.append(String.format("(%1$s)", codeName.asText()));
                    }
                    if (info != null) {
                        sb.append(String.format("\uff0c %1$s", info.asText()));
                    }
                } else if (info != null) {
                    sb.append(String.format(" %1$s", info.asText()));
                }
                if (data != null) {
                    sb.append("\r\n");
                    for (int j = 0; j < nBlank; ++j) {
                        sb.append(" ");
                    }
                    sb.append(" ");
                    sb.append(data.toPrettyString());
                }
                if ("enternode".equals(strType)) {
                    nBlank += nBlankLevel;
                    continue;
                }
                if (!"exitnode".equals(strType) || (nBlank -= nBlankLevel) >= 0) continue;
                nBlank = 0;
            }
            sb.append("\r\n");
            sb.append("\r\n");
            return sb.toString();
        }
        return null;
    }
}

