/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.ac;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.dataentity.ac.IDEChatCompletionRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysAIUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysPortalUtilRuntime;
import net.ibizsys.central.cloud.core.util.ChatMessagesBuilder;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncActionState;
import net.ibizsys.central.dataentity.ac.DEAutoCompleteRuntimeBase;
import net.ibizsys.central.msg.ISysMsgTemplRuntime;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class DEChatCompletionRuntimeBase
extends DEAutoCompleteRuntimeBase
implements IDEChatCompletionRuntime {
    private static final Log log = LogFactory.getLog(DEChatCompletionRuntimeBase.class);
    private ISysAIUtilRuntime iSysAIUtilRuntime = null;
    private ISysPortalUtilRuntime iSysPortalUtilRuntime = null;
    private ISysMsgTemplRuntime historySysMsgTemplRuntime = null;

    protected void onInit() throws Exception {
        IPSSysMsgTempl historyPSSysMsgTempl = this.getPSDEACMode().getHistoryPSSysMsgTempl();
        if (historyPSSysMsgTempl != null) {
            this.historySysMsgTemplRuntime = (ISysMsgTemplRuntime)this.getSystemRuntime().getSysMsgTemplRuntime(historyPSSysMsgTempl);
        }
        super.onInit();
    }

    protected ISysAIUtilRuntime getSysAIUtilRuntime() {
        if (this.iSysAIUtilRuntime == null) {
            this.iSysAIUtilRuntime = (ISysAIUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysAIUtilRuntime.class, false);
        }
        return this.iSysAIUtilRuntime;
    }

    protected ISysPortalUtilRuntime getSysPortalUtilRuntime() {
        if (this.iSysPortalUtilRuntime == null) {
            this.iSysPortalUtilRuntime = (ISysPortalUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysPortalUtilRuntime.class, false);
        }
        return this.iSysPortalUtilRuntime;
    }

    protected ISysMsgTemplRuntime getHistorySysMsgTemplRuntime(boolean bTryMode) {
        if (this.historySysMsgTemplRuntime != null || bTryMode) {
            return this.historySysMsgTemplRuntime;
        }
        throw new RuntimeException(String.format("\u4ea4\u4e92\u5386\u53f2\u6a21\u677f\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected String getCodeItemTextSuffix() {
        return "text";
    }

    @Override
    public List<ChatMessage> getHistories(Object key, Object body) throws Throwable {
        return this.getHistories(key, body, null);
    }

    @Override
    public List<ChatMessage> getHistories(Object key, Object body, Map<String, Object> templParams) throws Throwable {
        try {
            return this.onGetHistories(key, body, templParams);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException.rethrow((IModelRuntime)this, (Throwable)ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u4ea4\u4e92\u5386\u53f2\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected List<ChatMessage> onGetHistories(Object key, Object body, Map<String, Object> templParams) throws Throwable {
        ISysMsgTemplRuntime iMsgTemplRuntime = this.getHistorySysMsgTemplRuntime(true);
        if (iMsgTemplRuntime == null) {
            return new ArrayList<ChatMessage>();
        }
        Object iEntity = null;
        iEntity = key instanceof net.ibizsys.central.util.IEntity ? (net.ibizsys.central.util.IEntity)key : this.getDataEntityRuntime().get(key);
        this.getDataEntityRuntime().fillEntityCodeListTexts((IEntity)iEntity, this.getCodeItemTextSuffix());
        String strContent = iMsgTemplRuntime.getContent(iEntity, templParams);
        if (StringUtils.hasLength((String)strContent)) {
            return new ChatMessagesBuilder().xml(strContent).build();
        }
        return new ArrayList<ChatMessage>();
    }

    @Override
    public ChatCompletionResult chatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        try {
            return this.onChatCompletion(key, chatCompletionRequest);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException.rethrow((IModelRuntime)this, (Throwable)ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u4ea4\u4e92\u8865\u5168\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ChatCompletionResult onChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public PortalAsyncAction asyncChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        try {
            return this.onAsyncChatCompletion(key, chatCompletionRequest);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException.rethrow((IModelRuntime)this, (Throwable)ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u5f02\u6b65\u4ea4\u4e92\u8865\u5168\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected PortalAsyncAction onAsyncChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        return this.getSysAIUtilRuntime().asyncChatCompletion(this.getAIPlatformType(), chatCompletionRequest);
    }

    protected String getAIPlatformType() {
        return this.getSysAIUtilRuntime().getDefaultAIPlatformType();
    }

    @Override
    public SseEmitter sseChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        try {
            return this.onSseChatCompletion(key, chatCompletionRequest);
        }
        catch (Throwable ex) {
            DataEntityRuntimeException.rethrow((IModelRuntime)this, (Throwable)ex);
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("SSE\u4ea4\u4e92\u8865\u5168\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected SseEmitter onSseChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
        final PortalAsyncAction portalAsyncAction = this.asyncChatCompletion(key, chatCompletionRequest);
        final long nTimeout = 120000L;
        return (SseEmitter)this.getSystemRuntime().sseExecute(new IAction(){

            public Object execute(Object[] args) throws Throwable {
                long nCurrentTime = System.currentTimeMillis();
                ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
                while (true) {
                    PortalAsyncAction last = DEChatCompletionRuntimeBase.this.getSysPortalUtilRuntime().getAsyncAction(portalAsyncAction.getAsyncAcitonId());
                    double fCompletionRate = 0.0;
                    if (last.getCompletionRate() != null) {
                        fCompletionRate = last.getCompletionRate().doubleValue();
                    }
                    actionSession.updateActionStep(last.getStepInfo(), fCompletionRate, last.getActionResult());
                    int nActionState = DataTypeUtils.getIntegerValue((Object)last.getActionState(), (Integer)PortalAsyncActionState.EXECUTING.getValue());
                    if (nActionState == PortalAsyncActionState.FINISHED.getValue()) {
                        return last.getActionResult();
                    }
                    if (nActionState == PortalAsyncActionState.FAILED.getValue()) {
                        throw new Exception(last.getActionResult());
                    }
                    if (System.currentTimeMillis() - nCurrentTime >= nTimeout) {
                        throw new Exception("\u53cd\u9988\u8d85\u65f6");
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex);
                        continue;
                    }
                    break;
                }
            }
        }, null, null, -1L);
    }
}

