/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.app;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.app.ApplicationRuntimeBase;
import net.ibizsys.central.cloud.core.app.IServletAppRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public abstract class ServletAppRuntimeBase
extends ApplicationRuntimeBase
implements IServletAppRuntime {
    private static final Log log = LogFactory.getLog(ServletAppRuntimeBase.class);
    private String baseUrl = null;
    private String resourceRoot = null;
    private boolean fromClassPathResource = false;
    private int requestPathOffset = 0;

    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getBaseUrl())) {
            this.prepareBaseUrl();
        }
        super.onInit();
        if (!StringUtils.hasLength((String)this.getResourceRoot())) {
            this.prepareResourceRoot();
        }
        this.registerIgnoreAuthPattern();
    }

    protected void registerIgnoreAuthPattern() {
    }

    protected void prepareBaseUrl() throws Exception {
        this.setBaseUrl(String.format("/%1$s/%2$s/%3$s", ServiceHub.getInstance().getServletAppBaseUrl(), this.getSystemRuntime().getServiceId(), this.getPSApplication().getCodeName()).toLowerCase());
        this.requestPathOffset = this.getBaseUrl().length() - 1 - ServiceHub.getInstance().getServletAppBaseUrl().length();
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getResourceRoot() {
        return this.resourceRoot;
    }

    protected void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    protected void prepareResourceRoot() throws Exception {
    }

    protected boolean isFromClassPathResource() {
        return this.fromClassPathResource;
    }

    protected void setFromClassPathResource(boolean fromClassPathResource) {
        this.fromClassPathResource = fromClassPathResource;
    }

    @Override
    public Resource resolveResource(HttpServletRequest request, String requestPath) {
        if ((requestPath = requestPath.indexOf("/") == 0 ? requestPath.substring(this.requestPathOffset) : requestPath.substring(this.requestPathOffset - 1)).indexOf("/") == 0) {
            requestPath = requestPath.substring(1);
        }
        if (!StringUtils.hasLength((String)requestPath)) {
            requestPath = this.getStartPage();
        }
        return this.onResolveResource(request, requestPath);
    }

    protected String getStartPage() {
        return "index.html";
    }

    protected Resource onResolveResource(HttpServletRequest request, String requestPath) {
        return this.getResource(requestPath);
    }

    protected Resource getResource(String requestPath) {
        String fullPath = String.format("%1$s%2$s%3$s", this.getResourceRoot(), File.separator, requestPath);
        if (this.isFromClassPathResource()) {
            ClassPathResource classPathResource = new ClassPathResource(fullPath);
            if (classPathResource.exists()) {
                return classPathResource;
            }
            return null;
        }
        File file = new File(fullPath);
        if (file.exists()) {
            return new FileSystemResource(file);
        }
        return null;
    }
}

