/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.app;

import net.ibizsys.central.app.ApplicationRuntime;
import net.ibizsys.central.cloud.core.app.IServiceAppRuntime;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRequestMappingAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class ServiceAppRuntimeBase
extends ApplicationRuntime
implements IServiceAppRuntime {
    private static final Log log = LogFactory.getLog(ServiceAppRuntimeBase.class);
    private String baseUrl = null;

    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getBaseUrl())) {
            this.prepareBaseUrl();
        }
        super.onInit();
        this.registerIgnoreAuthPattern();
    }

    protected void registerIgnoreAuthPattern() {
    }

    protected void prepareBaseUrl() throws Exception {
        this.setBaseUrl(String.format("/%1$s/%2$s", this.getSystemRuntime().getServiceId(), this.getPSApplication().getCodeName()).toLowerCase());
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void registerMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        iSysServiceAPIRequestMappingAdapter.registerMapping(this);
        this.onRegisterMapping(iSysServiceAPIRequestMappingAdapter);
    }

    protected void onRegisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
    }

    @Override
    public void unregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        iSysServiceAPIRequestMappingAdapter.unregisterMapping(this);
        this.onUnregisterMapping(iSysServiceAPIRequestMappingAdapter);
    }

    protected void onUnregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
    }
}

