/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.addin;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudSaaSUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUtilRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysNotifyUtilRuntime;
import net.ibizsys.central.cloud.core.util.ConfigEntity;
import net.ibizsys.central.cloud.core.util.IConfigEntity;
import net.ibizsys.central.sysutil.ISysUniStateUtilRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.ModelRTAddinBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class CloudUtilRTAddinBase
extends ModelRTAddinBase {
    private static final Log log = LogFactory.getLog(CloudUtilRTAddinBase.class);
    private ICloudSaaSUtilRuntime iCloudSaaSUtilRuntime = null;
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
    private ISysNotifyUtilRuntime iSysNotifyUtilRuntime = null;
    private ISysUniStateUtilRuntime iSysUniStateUtilRuntime = null;
    private IConfigEntity iConfigEntity = null;
    private String strServiceUrl = null;
    private String strAccessTokenUr = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private boolean bEnabled = true;

    protected void prepareDefaultSetting() throws Exception {
        if (this.isPrepareConfigEntity()) {
            this.prepareConfigEntityIf();
        }
        super.prepareDefaultSetting();
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getCloudSaaSUtilRuntime(true) == null) {
            this.prepareCloudSaaSUtilRuntime();
        }
        if (this.isPrepareSysCloudClientUtilRuntime() && this.getSysCloudClientUtilRuntime(true) == null) {
            this.prepareSysCloudClientUtilRuntime(false);
        }
        if (this.isPrepareSysNotifyUtilRuntime() && this.getSysNotifyUtilRuntime(true) == null) {
            this.prepareSysNotifyUtilRuntime(false);
        }
        if (this.isPrepareSysUniStateUtilRuntime() && this.getSysUniStateUtilRuntime(true) == null) {
            this.prepareSysUniStateUtilRuntime(false);
        }
    }

    protected void onPrepareDefaultSetting() throws Exception {
        if (this.getConfigEntity(true) != null) {
            this.setServiceUrl(this.getConfigEntity().getString("serviceurl", this.getServiceUrl()));
            this.setAccessTokenUrl(this.getConfigEntity().getString("accesstokenurl", this.getAccessTokenUrl()));
            this.setClientId(this.getConfigEntity().getString("clientid", this.getClientId()));
            this.setClientSecret(this.getConfigEntity().getString("clientsecret", this.getClientSecret()));
        }
        super.onPrepareDefaultSetting();
    }

    protected boolean isPrepareConfigEntity() {
        return false;
    }

    protected void prepareConfigEntityIf() throws Exception {
        if (this.getConfigEntity(true) == null) {
            this.prepareConfigEntity();
        }
    }

    protected void prepareConfigEntity() throws Exception {
        String strCloudConfigId = this.getCloudConfigId();
        if (!StringUtils.hasLength((String)strCloudConfigId)) {
            log.warn((Object)String.format("\u672a\u5b9a\u4e49Cloud\u914d\u7f6e\u6807\u8bc6\uff0c\u5ffd\u7565\u914d\u7f6e\u52a0\u8f7d", new Object[0]));
            return;
        }
        String strConfig = ServiceHub.getInstance().getConfig(strCloudConfigId);
        try {
            this.setConfigEntity(new ConfigEntity(strConfig));
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u52a0\u8f7d\u914d\u7f6e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IConfigEntity getConfigEntity(boolean bTryMode) {
        if (this.iConfigEntity != null || bTryMode) {
            return this.iConfigEntity;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudUtilRuntime(), "\u672a\u6307\u5b9a\u63d2\u4ef6\u914d\u7f6e\u5bf9\u8c61");
    }

    protected IConfigEntity getConfigEntity() {
        return this.getConfigEntity(false);
    }

    protected void setConfigEntity(IConfigEntity iConfigEntity) {
        this.iConfigEntity = iConfigEntity;
    }

    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    public String getAccessTokenUrl() {
        return this.strAccessTokenUr;
    }

    protected void setAccessTokenUrl(String strAccessTokenUr) {
        this.strAccessTokenUr = strAccessTokenUr;
    }

    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    protected void setEnabled(boolean bEnabled) {
        this.bEnabled = bEnabled;
    }

    protected abstract ICloudUtilRuntime getCloudUtilRuntime();

    protected abstract ISystemRuntime getSystemRuntime();

    protected ICloudSaaSUtilRuntime getCloudSaaSUtilRuntime() {
        return this.getCloudSaaSUtilRuntime(false);
    }

    protected ICloudSaaSUtilRuntime getCloudSaaSUtilRuntime(boolean bTryMode) {
        if (this.iCloudSaaSUtilRuntime != null || bTryMode) {
            return this.iCloudSaaSUtilRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudUtilRuntime(), "\u672a\u6307\u5b9aCloud\u4f53\u7cfbSaaS\u7ba1\u7406\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setCloudSaaSUtilRuntime(ICloudSaaSUtilRuntime iCloudSaaSUtilRuntime) {
        this.iCloudSaaSUtilRuntime = iCloudSaaSUtilRuntime;
    }

    protected void prepareCloudSaaSUtilRuntime() throws Exception {
        this.setCloudSaaSUtilRuntime((ICloudSaaSUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ICloudSaaSUtilRuntime.class, false));
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        return this.getSysCloudClientUtilRuntime(false);
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime(boolean bTryMode) {
        if (this.iSysCloudClientUtilRuntime != null || bTryMode) {
            return this.iSysCloudClientUtilRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudUtilRuntime(), "\u672a\u6307\u5b9a\u7cfb\u7edf\u4e91\u4f53\u7cfb\u5ba2\u6237\u7aef\u7ec4\u4ef6");
    }

    protected void setSysCloudClientUtilRuntime(ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime) {
        this.iSysCloudClientUtilRuntime = iSysCloudClientUtilRuntime;
    }

    protected void prepareSysCloudClientUtilRuntime(boolean bTryMode) throws Exception {
        this.setSysCloudClientUtilRuntime((ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, bTryMode));
    }

    protected boolean isPrepareSysCloudClientUtilRuntime() {
        return false;
    }

    protected ISysNotifyUtilRuntime getSysNotifyUtilRuntime() {
        return this.getSysNotifyUtilRuntime(false);
    }

    protected ISysNotifyUtilRuntime getSysNotifyUtilRuntime(boolean bTryMode) {
        if (this.iSysNotifyUtilRuntime != null || bTryMode) {
            return this.iSysNotifyUtilRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudUtilRuntime(), "\u672a\u6307\u5b9a\u7cfb\u7edf\u901a\u77e5\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysNotifyUtilRuntime(ISysNotifyUtilRuntime iSysNotifyUtilRuntime) {
        this.iSysNotifyUtilRuntime = iSysNotifyUtilRuntime;
    }

    protected void prepareSysNotifyUtilRuntime(boolean bTryMode) throws Exception {
        this.setSysNotifyUtilRuntime((ISysNotifyUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysNotifyUtilRuntime.class, bTryMode));
    }

    protected boolean isPrepareSysNotifyUtilRuntime() {
        return false;
    }

    protected ISysUniStateUtilRuntime getSysUniStateUtilRuntime() {
        return this.getSysUniStateUtilRuntime(false);
    }

    protected ISysUniStateUtilRuntime getSysUniStateUtilRuntime(boolean bTryMode) {
        if (this.iSysUniStateUtilRuntime != null || bTryMode) {
            return this.iSysUniStateUtilRuntime;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudUtilRuntime(), "\u672a\u6307\u5b9a\u7cfb\u7edf\u7edf\u4e00\u72b6\u6001\u529f\u80fd\u7ec4\u4ef6");
    }

    protected void setSysUniStateUtilRuntime(ISysUniStateUtilRuntime iSysUniStateUtilRuntime) {
        this.iSysUniStateUtilRuntime = iSysUniStateUtilRuntime;
    }

    protected void prepareSysUniStateUtilRuntime(boolean bTryMode) throws Exception {
        this.setSysUniStateUtilRuntime((ISysUniStateUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysUniStateUtilRuntime.class, bTryMode));
    }

    protected boolean isPrepareSysUniStateUtilRuntime() {
        return false;
    }

    protected String getCloudConfigIdPrefix() {
        return null;
    }

    protected String getCloudConfigId() {
        if (!StringUtils.hasLength((String)this.getCloudConfigIdPrefix())) {
            return null;
        }
        String strAddinTag = null;
        if (this.getAddinData() instanceof String) {
            strAddinTag = (String)this.getAddinData();
        }
        if (!StringUtils.hasLength(strAddinTag)) {
            return null;
        }
        strAddinTag = strAddinTag.replace(":", "-");
        return String.format("%1$s%2$s", this.getCloudConfigIdPrefix(), strAddinTag).toLowerCase();
    }
}

