/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.ibizsys.central.cloud.core.IHubSystemRuntime;
import net.ibizsys.central.cloud.core.ServiceSystemRuntimeBase;
import net.ibizsys.central.cloud.core.cloudutil.ICloudAIUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudAuthUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudConfUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudDataFlowUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudDevOpsUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudKBUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudLogUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudNotifyUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOSSUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOUUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudOpenUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudPortalUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudReportUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudSaaSUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudTaskUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUAAUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudWFUtilRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.res.ISysUtilRuntime;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class HubSystemRuntime
extends ServiceSystemRuntimeBase
implements IHubSystemRuntime {
    private static final Log log = LogFactory.getLog(HubSystemRuntime.class);
    private static Map<String, String> SYSUTILTYPEMAP = new HashMap<String, String>();

    public static void registerSysUtilType(Class<?> cls, String strType, String strRTClassName) {
        if (HubSystemRuntime.registerRuntimeObject(ISysUtilRuntime.class, (String)strType, (Object)strRTClassName)) {
            SYSUTILTYPEMAP.put(cls.getSimpleName(), strType);
        }
    }

    public static void registerSysUtilTypeIf(Class<?> cls, String strType, String strRTClassName) {
        if (HubSystemRuntime.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)strType, (Object)strRTClassName)) {
            SYSUTILTYPEMAP.put(cls.getSimpleName(), strType);
        }
    }

    public static void registerSysUtilTypePrimary(Class<?> cls, String strType, String strRTClassName) {
        if (HubSystemRuntime.registerRuntimeObjectPrimary(ISysUtilRuntime.class, (String)strType, (Object)strRTClassName)) {
            SYSUTILTYPEMAP.put(cls.getSimpleName(), strType);
        }
    }

    public static void registerSysUtilType(Class<?> cls, String strType, String strRTClassName, int nOrderValue) {
        if (HubSystemRuntime.registerRuntimeObject(ISysUtilRuntime.class, (String)strType, (Object)strRTClassName, (int)nOrderValue)) {
            SYSUTILTYPEMAP.put(cls.getSimpleName(), strType);
        }
    }

    protected IPSSystemService createPSSystemService() throws Exception {
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath("/sysmodel/gateway", true);
        return psModelServiceImpl;
    }

    public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode) {
        if (!bTryMode) {
            Object t = super.getSysUtilRuntime(cls, true);
            if (t != null) {
                if (t instanceof net.ibizsys.central.sysutil.ISysUtilRuntime) {
                    if (((net.ibizsys.central.sysutil.ISysUtilRuntime)t).isInstalled()) {
                        return (T)t;
                    }
                } else {
                    return (T)t;
                }
            }
            return this.createAndInitSysUtilRuntime(cls);
        }
        return (T)super.getSysUtilRuntime(cls, bTryMode);
    }

    protected synchronized <T> T createAndInitSysUtilRuntime(Class<T> cls) {
        Object t = super.getSysUtilRuntime(cls, true);
        if (t != null) {
            return (T)t;
        }
        IPSSysUtil iPSSysUtil = this.getPSSysUtil(cls, false);
        try {
            ISysUtilRuntime iSysUtilRuntime = this.registerPSSysUtil(iPSSysUtil);
            if (iSysUtilRuntime != null) {
                if (iSysUtilRuntime instanceof net.ibizsys.central.sysutil.ISysUtilRuntime) {
                    ((net.ibizsys.central.sysutil.ISysUtilRuntime)iSysUtilRuntime).install();
                }
                return (T)iSysUtilRuntime;
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u51c6\u5907\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", cls.getCanonicalName(), ex.getMessage()), ex);
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u51c6\u5907\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", cls.getCanonicalName(), ex.getMessage()));
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", cls.getCanonicalName()));
    }

    protected IPSSysUtil getPSSysUtil(Class<?> cls, boolean bTryMode) {
        String strType = SYSUTILTYPEMAP.get(cls.getSimpleName());
        if (StringUtils.hasLength((String)strType)) {
            String[] items = strType.split("[:]");
            ObjectNode objNode = JsonUtils.createObjectNode();
            objNode.put("id", strType.replace(":", "_"));
            objNode.put("codeName", strType.replace(":", "_"));
            if (items.length == 2) {
                objNode.put("name", items[1]);
                objNode.put("utilType", items[0]);
                objNode.put("utilTag", items[1]);
            } else {
                objNode.put("name", items[0]);
                objNode.put("utilType", items[0]);
            }
            return (IPSSysUtil)this.getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSSystemService().getPSSystem(), IPSSysUtil.class, objNode);
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]\u6a21\u578b\u5bf9\u8c61", cls.getCanonicalName()));
    }

    protected boolean isEnableCloudExtend() {
        return true;
    }

    public ISysUtilRuntime createSysUtilRuntime(IPSSysUtil iPSSysUtil) {
        return super.createSysUtilRuntime(iPSSysUtil);
    }

    @Override
    protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = HubSystemRuntime.getGlobalWorkThreadPoolExecutor();
        if (threadPoolExecutor == null) {
            threadPoolExecutor = new ThreadPoolExecutor(this.getWorkThreadCorePoolSize(), this.getWorkThreadMaximumPoolSize(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.getWorkThreadBlockingQueueSize()), new ThreadPoolExecutor.AbortPolicy());
            HubSystemRuntime.setGlobalWorkThreadPoolExecutor(threadPoolExecutor);
        }
        return threadPoolExecutor;
    }

    protected int getWorkThreadCorePoolSize() {
        return ServiceHub.getInstance().getWorkThreadCorePoolSize();
    }

    protected int getWorkThreadMaximumPoolSize() {
        return ServiceHub.getInstance().getWorkThreadMaximumPoolSize();
    }

    protected int getWorkThreadBlockingQueueSize() {
        return ServiceHub.getInstance().getWorkThreadBlockingQueueSize();
    }

    static {
        HubSystemRuntime.registerSysUtilTypeIf(ICloudSaaSUtilRuntime.class, "USER:CLOUD_EBSXSAAS", "net.ibizsys.central.cloud.saas.ebsx.cloudutil.EBSXCloudSaaSUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudAuthUtilRuntime.class, "USER:CLOUD_AUTH", "net.ibizsys.central.cloud.uaa.core.cloudutil.DefaultCloudAuthUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudUAAUtilRuntime.class, "USER:CLOUD_JWTUAA", "net.ibizsys.central.cloud.uaa.core.cloudutil.JWTCloudUAAUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudWFUtilRuntime.class, "USER:CLOUD_FLOWABLEWF", "net.ibizsys.central.cloud.workflow.flowable.cloudutil.EBSXCloudFlowableUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudAuthUtilRuntime.class, "USER:CLOUD_AUTH", "net.ibizsys.central.cloud.uaa.core.cloudutil.DefaultCloudAuthUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudOSSUtilRuntime.class, "USER:CLOUD_SIMPLEOSS", "net.ibizsys.central.cloud.oss.core.cloudutil.SimpleCloudOSSUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudConfUtilRuntime.class, "USER:CLOUD_CONF", "net.ibizsys.central.cloud.conf.core.cloudutil.DefaultCloudConfUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudDevOpsUtilRuntime.class, "USER:CLOUD_DEVOPS", "net.ibizsys.central.cloud.devops.ebsx.cloudutil.EBSXCloudDevOpsUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudLogUtilRuntime.class, "USER:CLOUD_LOG", "net.ibizsys.central.cloud.log.core.cloudutil.DefaultCloudLogUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudTaskUtilRuntime.class, "USER:CLOUD_TASK", "net.ibizsys.central.cloud.task.ebsx.cloudutil.EBSXCloudTaskUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudNotifyUtilRuntime.class, "USER:CLOUD_NOTIFY", "net.ibizsys.central.cloud.notify.ebsx.cloudutil.EBSXCloudNotifyUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudOpenUtilRuntime.class, "USER:CLOUD_OPEN", "net.ibizsys.central.cloud.open.ebsx.cloudutil.EBSXCloudOpenUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudOUUtilRuntime.class, "USER:CLOUD_OU", "net.ibizsys.central.cloud.ou.core.cloudutil.DefaultCloudOUUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudReportUtilRuntime.class, "USER:CLOUD_REPORT", "net.ibizsys.central.cloud.report.core.cloudutil.DefaultCloudReportUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudPortalUtilRuntime.class, "USER:CLOUD_PORTAL", "net.ibizsys.central.cloud.portal.ebsx.cloudutil.EBSXCloudPortalUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudAIUtilRuntime.class, "USER:CLOUD_AI", "net.ibizsys.central.cloud.ai.core.cloudutil.DefaultCloudAIUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudKBUtilRuntime.class, "USER:CLOUD_KB", "net.ibizsys.central.cloud.kb.core.cloudutil.DefaultCloudKBUtilRuntime");
        HubSystemRuntime.registerSysUtilTypeIf(ICloudDataFlowUtilRuntime.class, "USER:CLOUD_DATAFLOW", "net.ibizsys.central.cloud.dataflow.core.cloudutil.DefaultCloudDataFlowUtilRuntime");
        HubSystemRuntime.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:HUBDEVOPS", (Object)"net.ibizsys.central.plugin.cloud.sysutil.HubSysDevOpsUtilRuntime");
        HubSystemRuntime.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:HUBREPORT", (Object)"net.ibizsys.central.plugin.cloud.sysutil.HubSysReportUtilRuntime");
        HubSystemRuntime.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:HUBEXTENSION", (Object)"net.ibizsys.central.plugin.extension.sysutil.HubSysExtensionUtilRuntime");
    }
}

