package net.ibizsys.central.cloud.core.util;

import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.tools.ant.filters.StringInputStream;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.ChatMessageRole;

public class ChatMessagesBuilder {

	private List<ChatMessage> list = new ArrayList<ChatMessage>();

	public ChatMessagesBuilder user(String strMessage) {
		ChatMessage chatMessage = new ChatMessage();
		chatMessage.setRole(ChatMessageRole.USER.getValue());
		chatMessage.setContent(strMessage);
		list.add(chatMessage);
		return this;
	}

	public ChatMessagesBuilder assistant(String strMessage) {
		ChatMessage chatMessage = new ChatMessage();
		chatMessage.setRole(ChatMessageRole.ASSISTANT.getValue());
		chatMessage.setContent(strMessage);
		list.add(chatMessage);
		return this;
	}

	public ChatMessagesBuilder system(String strMessage) {
		ChatMessage chatMessage = new ChatMessage();
		chatMessage.setRole(ChatMessageRole.SYSTEM.getValue());
		chatMessage.setContent(strMessage);
		list.add(chatMessage);
		return this;
	}

	public ChatMessagesBuilder xml(String strXmlMessages) throws Exception {

		if (!StringUtils.hasLength(strXmlMessages)) {
			return this;
		}

		strXmlMessages = strXmlMessages.trim();
		// if(strXmlMessage.indexOf("<?xml") !=0) {
		//
		// }

		String strXML = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<CHATMESSAGES>\r\n%1$s\r\n</CHATMESSAGES>", strXmlMessages);

		// 创建 DocumentBuilderFactory 对象
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

		// 创建 DocumentBuilder 对象
		DocumentBuilder builder = factory.newDocumentBuilder();

		try (StringInputStream is = new StringInputStream(strXML, "UTF-8")) {
			// 从 XML 文件加载 Document 对象
			Document document = builder.parse(is);

			// 获取根节点
			Element root = document.getDocumentElement();

			// 获取子节点列表
			NodeList nodeList = root.getChildNodes();

			// 遍历子节点
			for (int i = 0; i < nodeList.getLength(); i++) {
				Node node = nodeList.item(i);
				if (node.getNodeType() == Node.ELEMENT_NODE) {
					// 处理每个元素节点
					Element element = (Element) node;
					String nodeName = element.getNodeName();
					String nodeValue = element.getTextContent();
					if(StringUtils.hasLength(nodeValue)) {
						nodeValue = nodeValue.replace("\r\n", "\n");
						nodeValue = nodeValue.replace("\r", "\n");
						nodeValue = StringUtils.trimLeadingCharacter(nodeValue, '\n');
						nodeValue = StringUtils.trimTrailingCharacter(nodeValue, '\n');
					}

					if (ChatMessageRole.SYSTEM.getValue().equalsIgnoreCase(nodeName)) {
						this.system(nodeValue);
						continue;
					}

					if (ChatMessageRole.USER.getValue().equalsIgnoreCase(nodeName)) {
						this.user(nodeValue);
						continue;
					}

					if (ChatMessageRole.ASSISTANT.getValue().equalsIgnoreCase(nodeName)) {
						this.assistant(nodeValue);
						continue;
					}

					throw new Exception(String.format("无法识别的节点[%1$s]", nodeName));
				}
			}
		}

		return this;
	}

	public List<ChatMessage> build() {
		return this.build(null);
	}

	public List<ChatMessage> build(List<ChatMessage> dst) {
		if (dst == null) {
			dst = new ArrayList<ChatMessage>();
		}
		dst.addAll(this.list);
		return dst;
	}
}
