package net.ibizsys.central.cloud.core.sysutil;

import java.io.File;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudExtensionClient;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.cloud.core.dataentity.util.IDEExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.CodeList;

public interface IHubSysExtensionUtilRuntime extends ISysUtilRuntime{

	/**
	 * 获取Cloud扩展客户端
	 * @return
	 */
	ICloudExtensionClient getCloudExtensionClient();
	
	/**
	 * 调用WebHook逻辑
	 * @param iSystemRuntime
	 * @param strKey
	 * @param param
	 * @return
	 */
	Object invokeWebHook(ISystemRuntime iSystemRuntime, String strKey, Object param);
	
	/**
	 * 调用动态模型接口
	 * @param iSystemRuntime
	 * @param strPModel
	 * @param strPKey
	 * @param strModel
	 * @param strMethod
	 * @param strKey
	 * @param param
	 * @return
	 */
	Object invokeDynaModelAPI(ISystemRuntime iSystemRuntime, String strPModel, String strPKey, String strModel, String strMethod, String strKey, Object param);
	
	
	
	
	/**
	 * 获取指定应用实体JsonSchema
	 * @param iSystemRuntime
	 * @param strAppTag
	 * @param strAppDataEntityTag
	 * @param param
	 * @param bTryMode 尝试模式
	 * @return
	 */
	File getAppDataEntityJsonSchema(ISystemRuntime iSystemRuntime, String strAppTag, String strAppDataEntityTag, Object param, boolean bTryMode);
	
	
	
	/**
	 * 获取HubApp动态模型文件
	 * @param iSystemRuntime
	 * @param strAppTag
	 * @param param
	 * @param bTryMode 尝试模式
	 * @return
	 */
	File getHubAppDynaModelFile(ISystemRuntime iSystemRuntime, String strAppTag, Object param, boolean bTryMode);
	
	
	/**
	 * 获取App动态模型文件
	 * @param iSystemRuntime
	 * @param strAppTag
	 * @param strModelUri
	 * @param param
	 * @param bTryMode 尝试模式
	 * @return
	 */
	File getAppDynaModelFile(ISystemRuntime iSystemRuntime, String strAppTag, String strModelUri, Object param, boolean bTryMode);
	
	
	/**
	 * 获取HubApp子应用动态模型文件
	 * @param iSystemRuntime
	 * @param strAppTag
	 * @param strSubAppTag
	 * @param strModelUri
	 * @param param
	 * @param bTryMode 尝试模式
	 * @return
	 */
	File getHubSubAppDynaModelFile(ISystemRuntime iSystemRuntime, String strAppTag, String strSubAppTag, String strModelUri, Object param, boolean bTryMode);
	
	
	/**
	 * 获取指定Hub子应用实体JsonSchema
	 * @param iSystemRuntime
	 * @param strAppTag
	 * @param strSubAppTag
	 * @param strAppDataEntityTag
	 * @param param
	 * @param bTryMode 尝试模式
	 * @return
	 */
	File getHubSubAppDataEntityJsonSchema(ISystemRuntime iSystemRuntime, String strAppTag, String strSubAppTag, String strAppDataEntityTag, Object param, boolean bTryMode);
	
	
	/**
	 * 重新加载扩展
	 * @param iSystemRuntime
	 * @param strExtensionId
	 */
	void reloadExtension(ISystemRuntime iSystemRuntime, String strExtensionId);
	
	
	
	/**
	 * 建立传入实体的默认实体扩展功能运行时对象
	 * @param iDataEntityRuntime
	 * @return
	 */
	IDEExtensionUtilRuntime createDEExtensionUtilRuntime(IDataEntityRuntime iDataEntityRuntime);
	
	
	
	
	
	/**
	 * 获取代码表对象
	 * @param iSystemRuntime
	 * @param strCodeListTag
	 * @param nMaxSize 最大项数量
	 * @param param 
	 * @param bTryMode 尝试模式
	 * @return
	 */
	CodeList getCodeList(ISystemRuntime iSystemRuntime, String strCodeListTag, int nMaxSize, Object param, boolean bTryMode);
}
