package net.ibizsys.central.cloud.core.dataentity.ac;

import java.util.List;
import java.util.Map;

import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import net.ibizsys.central.cloud.core.cloudutil.ICloudAIUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysAIUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysPortalUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncActionState;
import net.ibizsys.central.dataentity.ac.DEAutoCompleteRuntimeBase;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;

public abstract class DEChatCompletionRuntimeBase extends DEAutoCompleteRuntimeBase implements IDEChatCompletionRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DEChatCompletionRuntimeBase.class);
	
	private ISysAIUtilRuntime iSysAIUtilRuntime = null;
	
	private ISysPortalUtilRuntime iSysPortalUtilRuntime = null;
	
	protected ISysAIUtilRuntime getSysAIUtilRuntime() {
		if (this.iSysAIUtilRuntime == null) {
			this.iSysAIUtilRuntime = this.getSystemRuntime().getSysUtilRuntime(ISysAIUtilRuntime.class, false);
		}
		return this.iSysAIUtilRuntime;
	}
	
	protected ISysPortalUtilRuntime getSysPortalUtilRuntime() {
		if (this.iSysPortalUtilRuntime == null) {
			this.iSysPortalUtilRuntime = this.getSystemRuntime().getSysUtilRuntime(ISysPortalUtilRuntime.class, false);
		}
		return this.iSysPortalUtilRuntime;
	}
	
	@Override
	public List<ChatMessage> getHistories(Object key, Object body) throws Throwable {
		return this.getHistories(key, body, null);
	}
	
	
	@Override
	public List<ChatMessage> getHistories(Object key, Object body, Map<String, Object> templParams) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}
	
	

	@Override
	public ChatCompletionResult chatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public PortalAsyncAction asyncChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
		return this.onAsyncChatCompletion(key, chatCompletionRequest);
				
	}
	
	protected PortalAsyncAction onAsyncChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
		return this.getSysAIUtilRuntime().asyncChatCompletion(getAIPlatformType(), chatCompletionRequest);
	}
	
	protected String getAIPlatformType() {
		return ICloudAIUtilRuntime.AIPLATFORM_BAICHUAN;
	}

	@Override
	public SseEmitter sseChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
		return this.onSseChatCompletion(key, chatCompletionRequest);
	}

	protected SseEmitter onSseChatCompletion(Object key, ChatCompletionRequest chatCompletionRequest) throws Throwable {
		
		PortalAsyncAction portalAsyncAction = this.asyncChatCompletion(key, chatCompletionRequest);
		
		long nTimeout = 120000;

		return (SseEmitter)this.getSystemRuntime().sseExecute(new IAction() {
			@Override
			public Object execute(Object[] args) throws Throwable {

				long nCurrentTime = System.currentTimeMillis();
				ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
				while(true) {
					PortalAsyncAction last = getSysPortalUtilRuntime().getAsyncAction(portalAsyncAction.getAsyncAcitonId());
					
					double fCompletionRate = 0.0f;
					if(last.getCompletionRate()!=null) {
						fCompletionRate = last.getCompletionRate().doubleValue();
					}
					actionSession.updateActionStep(last.getStepInfo(), fCompletionRate, last.getActionResult());
					
					int nActionState = DataTypeUtils.getIntegerValue(last.getActionState(), PortalAsyncActionState.EXECUTING.getValue());
					if(nActionState == PortalAsyncActionState.FINISHED.getValue()) {
						return last.getActionResult();
					}
					if(nActionState == PortalAsyncActionState.FAILED.getValue()) {
						throw new Exception(last.getActionResult());
					}
					
					if(System.currentTimeMillis() - nCurrentTime >= nTimeout) {
						throw new Exception("反馈超时");
					}
	
					try {
						Thread.sleep(500);
					} catch (InterruptedException ex) {
						log.error(ex);
					}
				}
			}
		}, null, null, -1);
	}
	
	
	
}
