package net.ibizsys.central.cloud.core.dataentity;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.dataentity.dataflow.DEDataFlowRuntime;
import net.ibizsys.central.cloud.core.dataentity.logic.DELogicRuntime;
import net.ibizsys.central.cloud.core.dataentity.service.DEServiceInvocationHandler;
import net.ibizsys.central.cloud.core.dataentity.util.IDEExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.domain.V2ImportSchema;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionLogic;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionSuite;
import net.ibizsys.central.dataentity.dataflow.IDEDataFlowRuntime;
import net.ibizsys.central.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.dataentity.service.IDEMethodDTO;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelEnums.DEUtilType;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRQueryCountCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.util.IPSDEUtil;
import net.ibizsys.model.dataentity.util.PSDEUtilImpl;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.runtime.dataentity.defield.DEFDataTypes;
import net.ibizsys.runtime.dataentity.logic.IDELogicRuntime;
import net.ibizsys.runtime.dataentity.logic.IDEMSLogicRuntime;
import net.ibizsys.runtime.dataentity.util.IDEUtilRuntime;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.IActionSessionLog;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.LogCats;
import net.ibizsys.runtime.util.LogLevels;

/**
 * @author lionlau
 *
 */
public class DataEntityRuntime extends net.ibizsys.central.dataentity.DataEntityRuntime implements IDataEntityRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DataEntityRuntime.class);

	private boolean bEnableRTCodeMode = false;
	
	private Map<Class<?>, Object> proxyDEServiceMap = null;
	private Map<Class<?>, Map<String, String>> rtObjectNameMap = null;
	private IDEService proxyDEService = null;
	private boolean bEnableExtension = false;
	private IDEExtensionUtilRuntime iDEExtensionUtilRuntime = null;
	
	@Override
	protected void onInit() throws Exception {
		IServiceSystemRuntime iServiceSystemRuntime = null;
		if(this.getSystemRuntime() instanceof IServiceSystemRuntime) {
			iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
    	}
		
		if(iServiceSystemRuntime!=null) {
			this.bEnableRTCodeMode = iServiceSystemRuntime.isEnableRTCodeMode();
		}
		
		if(this.isEnableRTCodeMode()) {
			registerRTObjects();
		}
		
		if(DataTypeUtils.getIntegerValue(this.getPSDataEntity().getDynaSysMode(), 0) > 0) {
			this.prepareDEExtensionUtilRuntime();
		}
		
		
		super.onInit();
	}
	
	protected void registerRTObjects() throws Exception{
		
		IPSDataEntity iPSDataEntity = this.getPSDataEntity();
		
		if(this.getSystemRuntime() instanceof IServiceSystemRuntime) {
			IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
			String strDEServiceObjectName = iServiceSystemRuntime.getRTCodeUtils().getDEServiceObjectName(iPSDataEntity);
			if(StringUtils.hasLength(strDEServiceObjectName)) {
				this.registerRTObjectName(IDEService.class, iPSDataEntity.getId(), strDEServiceObjectName);
				Class<?> deServiceCls = RuntimeObjectFactory.getInstance().getObjectClass(IDEService.class, strDEServiceObjectName);
				IDEService proxyDEService = null;
				if(deServiceCls != null) {
					Object objService = this.getProxyDEService(deServiceCls);
					if(objService instanceof IDEService) {
						proxyDEService = (IDEService)objService;
					}
				}
				if(proxyDEService == null) {
					proxyDEService = this.getProxyDEService(IDEService.class);
				}
				this.proxyDEService = proxyDEService;
			}
			
			List<IPSDEMethodDTO> psDEMethodDTOList = iPSDataEntity.getAllPSDEMethodDTOs();
			if(!ObjectUtils.isEmpty(psDEMethodDTOList)) {
				for(IPSDEMethodDTO iPSDEMethodDTO : psDEMethodDTOList) {
					String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getRTObjectName(iPSDEMethodDTO);
					if(StringUtils.hasLength(strRTObjectName)) {
						this.registerRTObjectName(IDEMethodDTO.class, iPSDEMethodDTO.getId(), strRTObjectName);
					}
				}
			}
		}
	}
	
	protected boolean registerRTObjectName(Class<?> cls, String strId, String strRTObjectName) {
		if(!StringUtils.hasLength(strId) || !StringUtils.hasLength(strRTObjectName)) {
			return false;
		}
		
		//要先判断外围是否已经注册部件
		if(!RuntimeObjectFactory.getInstance().containsObject(cls, strRTObjectName)) {
			if(!RuntimeObjectFactory.getInstance().registerObjectIf(cls, strRTObjectName, strRTObjectName)) {
				return false;
			}
		}
		
		if(this.rtObjectNameMap == null) {
			this.rtObjectNameMap = new ConcurrentHashMap<Class<?>, Map<String,String>>();
		}
		
		Map<String, String> map = this.rtObjectNameMap.get(cls);
		if(map == null) {
			map = new HashMap<String, String>();
			this.rtObjectNameMap.put(cls, map);
		}
		map.put(strId, strRTObjectName);
		return true;
	}
	
	protected String getRTObjectName(Class<?> cls, String strId) {
		if(this.rtObjectNameMap == null) {
			return null;
		}
		
		Map<String, String> map = this.rtObjectNameMap.get(cls);
		if(map == null) {
			return null;
		}
		
		return map.get(strId);
	}
	
	protected <T> T getRTObject(Class<T> cls, String strId) {
		return this.getRTObject(cls, strId, true);
	}
	
	protected <T> T  getRTObject(Class<T> cls, String strId, boolean bAutowire) {
		String strRTObjectName = this.getRTObjectName(cls, strId);
		if(!StringUtils.hasLength(strRTObjectName)) {
			return null;
		}
		T t = RuntimeObjectFactory.getInstance().getObject(cls, strRTObjectName);
		if(t != null && bAutowire) {
			this.getSystemRuntime().autowareObject(t);
		}
		return t;
	}
	
	
	@Override
	protected boolean isEnableRuntimeServiceMode() {
		return this.isEnableRTCodeMode();
	}
	
	@Override
	protected IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
		Object object = this.getRTObject(IDEMethodDTO.class, iPSDEMethodDTO.getId(), false);
		if(object!=null) {
			return (IEntityDTO)object;
		}
		
		return super.createEntityDTO(iPSDEMethodDTO);
	}
	
	
	@Override
	protected ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
		Object object = this.getRTObject(IDEMethodDTO.class, iPSDEMethodDTO.getId(), false);
		if(object!=null) {
			return (ISearchContextDTO)object;
		}
		return super.createSearchContextDTO(iPSDEMethodDTO);
	}
	
//	@Override
//	protected List<IEntityDTO> createEntityDTOList(IPSDEMethodDTO iPSDEMethodDTO) {
//		return super.createEntityDTOList(iPSDEMethodDTO);
//	}
	
	
  //  private static DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();


//    @Override
//    protected IUserContext getUserContext() {
//        return AuthenticationUser.getAuthenticationUser();
//    }

    @Override
    public boolean fillEntityKeyValue(IEntityBase objEntity) {
    	
    	if(DataTypeUtils.isNumberDataType(this.getKeyPSDEField().getStdDataType())) {
    		String strDEFType = this.getKeyPSDEField().getDataType();
    		if (DEFDataTypes.ACID.equals(strDEFType)) {
                this.resetFieldValue(objEntity, this.getKeyPSDEField());
            } else {
            	this.setFieldValue(objEntity, this.getKeyPSDEField(), getNumberId());
            }
            return false;
    	}
//    	if (DEFDataTypes.ACID.equals(strDEFType) || DEFDataTypes.BIGINT.equals(strDEFType)
//                || DEFDataTypes.BIGDECIMAL.equals(strDEFType)) {
//            if (DEFDataTypes.ACID.equals(this.getKeyPSDEField().getDataType()) && this.getSysDBSchemeRuntime().getDBType().equals(DBTypes.MYSQL5)) {
//                this.resetFieldValue(objEntity, this.getKeyPSDEField());
//            } else {
//            	this.setFieldValue(objEntity, this.getKeyPSDEField(), getNumberId());
//            }
//            return false;
//        }
        return super.fillEntityKeyValue(objEntity);
    }
    
    protected Object getNumberId() {
    	String strTableName = this.getTableName();
    	return KeyValueUtils.genNumberId(String.format("%1$s|%2$s", this.getSystemRuntime().getDeploySystemId(), StringUtils.hasLength(strTableName)?strTableName:this.getId()));
    }


    @Override
    public void setSearchCustomCondition(ISearchContextBase iSearchContextBase, String strCustomCondition) {
        Pattern bracketPattern = Pattern.compile("\\[(.*?)]");
        Matcher matcher = bracketPattern.matcher(strCustomCondition);
        if (matcher.find()) {
            ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
            SearchContextDTO.addSearchPredefinedCond(iSearchContextDTO, strCustomCondition, null);
            return;
        }
        super.setSearchCustomCondition(iSearchContextBase, strCustomCondition);
    }

//    @Override
//    public IDEPrintRuntime createDEPrintRuntime(IPSDEPrint iPSDEPrint) {
//        try {
//            IDEPrintRuntime iDEPrintRuntime = SpringContextHolder.getBean(String.format("%s_DEPRINT_%s", this.getName(), iPSDEPrint.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导入模式[%s]使用[%s]进行导入处理", this.getName(), iPSDEPrint.getCodeName().toUpperCase(), iPSDEPrint.getClass()));
//            return iDEPrintRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        Assert.notNull(iPSDEPrint, "实体打印模型对象无效");
//        if (DEReportTypes.JR.equals(iPSDEPrint.getReportType())) {
//            return new R8DEJRPrintRuntime();
//        }
//        return super.createDEPrintRuntime(iPSDEPrint);
//    }
//
//    @Override
//    public IDEDataImportRuntime createDEDataImportRuntime(IPSDEDataImport iPSDEDataImport) {
//        try {
//            IDEDataImportRuntime iDEDataImportRuntime = SpringContextHolder.getBean(String.format("%s_DEDATAIMPORT_%s", this.getName(), iPSDEDataImport.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导入模式[%s]使用[%s]进行导入处理", this.getName(), iPSDEDataImport.getCodeName().toUpperCase(), iDEDataImportRuntime.getClass()));
//            return iDEDataImportRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导入模式[%s]处理，使用默认导入处理", this.getName(), iPSDEDataImport.getCodeName().toUpperCase()));
//        return super.createDEDataImportRuntime(iPSDEDataImport);
//    }


//    @Override
//    protected IDEDataImportRuntime createDefaultDEDataImportRuntime() {
//        return new R8DEDataImportRuntime();
//    }
//
//    @Override
//    public IDEDataExportRuntime createDEDataExportRuntime(IPSDEDataExport iPSDEDataExport) {
//        try {
//            IDEDataExportRuntime iDEDataExportRuntime = SpringContextHolder.getBean(String.format("%s_DEDATAEXPORT_%s", this.getName(), iPSDEDataExport.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导出模式[%s]使用[%s]进行导出处理", this.getName(), iPSDEDataExport.getCodeName().toUpperCase(), iDEDataExportRuntime.getClass()));
//            return iDEDataExportRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导出模式[%s]处理，使用默认导出处理", this.getName(), iPSDEDataExport.getCodeName().toUpperCase()));
//        return super.createDEDataExportRuntime(iPSDEDataExport);
//    }
//
//    @Override
//    protected IDEDataExportRuntime createDefaultDEDataExportRuntime() {
//        return new R8DEDataExportRuntime();
//    }
//
//    @Override
//    public IDENotifyRuntime createDENotifyRuntime(IPSDENotify iPSDENotify) {
//        try {
//            IDENotifyRuntime iDENotifyRuntime = SpringContextHolder.getBean(String.format("%s_DENOTIFY_%s", this.getName(), iPSDENotify.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]实体通知模式[%s]使用[%s]进行导入处理", this.getName(), iPSDENotify.getCodeName().toUpperCase(), iDENotifyRuntime.getClass()));
//            return iDENotifyRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导入模式[%s]处理，使用默认导入处理", this.getName(), iPSDENotify.getCodeName().toUpperCase()));
//        return new R8DENotifyRuntime();
//    }

    @Override
    protected boolean checkFieldQueryCountCondition(Object objValue, IEntityBase arg0, IPSDEFVRQueryCountCondition iPSDEFVRQueryCountCondition, IPSDEField iPSDEField) throws Throwable {
        String strRuleInfo = iPSDEFVRQueryCountCondition.getRuleInfo();
        IPSDEDataQuery iPSDEDataQuery = iPSDEFVRQueryCountCondition.getPSDEDataQuery();
        ISearchContextDTO searchContext = this.createSearchContext();
        searchContext.setCount(true);
        //设置上下文
        EntityBase datacontext = (EntityBase) arg0;
        if (datacontext != null) {
            searchContext.set("datacontext", datacontext.any());
        }
        searchContext.set("sessioncontext",  ActionSessionManager.getUserContextMust().getSessionParams());
        java.util.List result = this.selectDataQuery(iPSDEDataQuery, searchContext);

        Integer nMinValue = iPSDEFVRQueryCountCondition.getMinValue();
        Integer nMaxValue = iPSDEFVRQueryCountCondition.getMaxValue();
        boolean bIncMinValue = iPSDEFVRQueryCountCondition.isIncludeMinValue();
        boolean bIncMaxValue = iPSDEFVRQueryCountCondition.isIncludeMaxValue();
        boolean bTryMode = !iPSDEFVRQueryCountCondition.isKeyCond();
        int nSize = result.size();
        if (nMinValue != null) {
            if (bIncMinValue) {
                if (nSize < nMinValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else {
                if (nSize <= nMinValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            }
        }

        if (nMaxValue != null) {
            if (bIncMaxValue) {
                if (nSize > nMaxValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else {
                if (nSize >= nMaxValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            }
        }

        return true;
    }
    
    @Override
    public IDEWFRuntime getDefaultDEWFRuntime() {
    	return (IDEWFRuntime)super.getDefaultDEWFRuntime();
    }
    
    @Override
    public IDEWFRuntime getDEWFRuntime(IPSDEWF iPSDEWF) {
    	return (IDEWFRuntime)super.getDEWFRuntime(iPSDEWF);
    }
    
    
    @Override
    public IDELogicRuntime createDELogicRuntime(IPSDELogic iPSDELogic) {
    	if(isEnableRTCodeMode() && iPSDELogic.getPSSysSFPlugin()==null) {
    		if(this.getSystemRuntime() instanceof IServiceSystemRuntime) {
    			IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
    			try {
    				String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getRTObjectName(iPSDELogic);
    				this.registerRTObjectName(IDELogicRuntime.class, iPSDELogic.getId(), strRTObjectName);
    				IDELogicRuntime iDELogicRuntime = this.getRTObject(IDELogicRuntime.class, iPSDELogic.getId(), true);
    				if(iDELogicRuntime != null) {
    					return iDELogicRuntime;
    				}
    			}
    			catch (Exception ex) {
    				throw new DataEntityRuntimeException(this, String.format("获取实体逻辑[%1$s]运行时对象发生异常，%2$s", iPSDELogic.getName(), ex.getMessage()), ex);
    			}
    		}
    	}
    	return super.createDELogicRuntime(iPSDELogic);
    }
    
    @Override
    protected IDELogicRuntime createDefaultDELogicRuntime() {
    	return new DELogicRuntime();
    }
    
    
    @Override
    protected IDEDataFlowRuntime createDefaultDEDataFlowRuntime() {
    	return new DEDataFlowRuntime();
    }
    
    /**
     * 实体是否启用运行时代码模式
     * @return
     */
    public boolean isEnableRTCodeMode() {
    	this.prepare();
    	return this.bEnableRTCodeMode;
    }
    
    @Override
    public IDEService getDEService() {
    	if(isEnableRTCodeMode()) {
    		if(this.proxyDEService == null) {
    			this.prepare();
    		}
    		return this.proxyDEService;
    	}
    	return super.getDEService();
    }

	@Override
	public <T> T getProxyDEService(Class<?> cls) {
		try {
			if(this.proxyDEServiceMap == null) {
				this.proxyDEServiceMap = new ConcurrentHashMap<Class<?>, Object>();
			}
			Object serviceObject = this.proxyDEServiceMap.get(cls);
			if(serviceObject == null) {
				serviceObject = this.createProxyDEService(cls);
				this.proxyDEServiceMap.put(cls, serviceObject);
			}
			return (T)serviceObject;
		}
		catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("获取实体代理服务对象[%1$s]发生异常，%2$s", cls.getName(), ex.getMessage()), ex);
		}
		
	}
	
	protected  <T> T createProxyDEService(Class<?> cls) throws Exception {
		DEServiceInvocationHandler<T> deServiceInvocationHandler = new DEServiceInvocationHandler(this.getDataEntityRuntimeContext(), cls);
		return deServiceInvocationHandler.getProxyDEService();
	}
	
	@Override
	protected IDataEntityAccessManager createDataEntityAccessManager() {
		if(isEnableRTCodeMode() ) {
			if(this.getSystemRuntime() instanceof IServiceSystemRuntime) {
    			IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
    			
	    		try {
	 				String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getDEAccessManagerObjectName(this.getPSDataEntity());
					this.registerRTObjectName(IDataEntityAccessManager.class, getPSDataEntity().getId(), strRTObjectName);
					IDataEntityAccessManager iDataEntityAccessManager = this.getRTObject(IDataEntityAccessManager.class, getPSDataEntity().getId(), true);
					if(iDataEntityAccessManager != null) {
						return iDataEntityAccessManager;
					}
				}
				catch (Exception ex) {
					throw new DataEntityRuntimeException(this, String.format("获取实体访问控制运行时对象发生异常，%1$s", ex.getMessage()), ex);
				}
			}
    	}

		return super.createDataEntityAccessManager();
	}
	
	@Override
	public ImportDataResult importData2(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		prepare();

		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();

			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("导入数据[%1$s]", strImportTag));

			ImportDataResult ret = this.onImportData2(strImportTag, baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= ActionSessionManager.getImportDataLogPOTime()) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEDATAIMP, iActionSessionLog.toString(true), this.getName(), String.format("导入数据[%1$s]", strImportTag), iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);
			}

			return ret;

		} catch (Throwable ex) {
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
			if (bOpenActionSession) {

				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(ex.getMessage(), true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]数据导入[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEDATAIMP, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}
	}

	protected ImportDataResult onImportData2(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		IDEDataImportRuntime iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
		if (iDEDataImportRuntime instanceof net.ibizsys.central.cloud.core.dataentity.dataimport.IDEDataImportRuntime) {
			return ((net.ibizsys.central.cloud.core.dataentity.dataimport.IDEDataImportRuntime) iDEDataImportRuntime).importStream2(baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
		}

		throw new Exception(String.format("对象[%1$s]未支持增强导入数据", iDEDataImportRuntime));
	}

	@Override
	public Map<Integer, EntityError> importData(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		prepare();

		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();

			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("导入数据[%1$s]", strImportTag));

			Map<Integer, EntityError> ret = this.onImportData(strImportTag, baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= ActionSessionManager.getImportDataLogPOTime()) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEDATAIMP, iActionSessionLog.toString(true), this.getName(), String.format("导入数据[%1$s]", strImportTag), iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);
			}

			return ret;

		} catch (Throwable ex) {
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
			if (bOpenActionSession) {

				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(ex.getMessage(), true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]数据导入[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEDATAIMP, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}
	}
	
	protected Map<Integer, EntityError> onImportData(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		IDEDataImportRuntime iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
		if (iDEDataImportRuntime instanceof net.ibizsys.central.cloud.core.dataentity.dataimport.IDEDataImportRuntime) {
			return ((net.ibizsys.central.cloud.core.dataentity.dataimport.IDEDataImportRuntime) iDEDataImportRuntime).importStream(baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
		}

		throw new Exception(String.format("对象[%1$s]未支持增强导入数据", iDEDataImportRuntime));
	}

	@Override
	public boolean isEnableExtension() {
		this.prepare();
		return this.bEnableExtension;
	}
	
	protected void prepareDEExtensionUtilRuntime() throws Exception{
		if(this.iDEExtensionUtilRuntime != null) {
			return;
		}
		//从预置实体功能中加载
		java.util.List<IPSDEUtil> psDEUtils = this.getPSDataEntity().getAllPSDEUtils();
		if(!ObjectUtils.isEmpty(psDEUtils)) {
			for(IPSDEUtil iPSDEUtil : psDEUtils) {
				if(!DEUtilType.EXTENSION.value.equals(iPSDEUtil.getUtilType())) {
					continue;
				}
				IDEUtilRuntime iDEUtilRuntime = this.registerPSDEUtil(iPSDEUtil);
				if(iDEUtilRuntime instanceof IDEExtensionUtilRuntime) {
					this.iDEExtensionUtilRuntime = (IDEExtensionUtilRuntime)iDEUtilRuntime;
					break;
				}
			}
		}
		if(this.iDEExtensionUtilRuntime == null) {
			IDEExtensionUtilRuntime iDEExtensionUtilRuntime = null;
			//从系统扩展功能中加载
			ISysExtensionUtilRuntime iSysExtensionUtilRuntime = this.getSystemRuntime().getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
			if(iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
				iDEExtensionUtilRuntime = ((IHubSysExtensionUtilRuntime)iSysExtensionUtilRuntime).createDEExtensionUtilRuntime(this);
			}
			else {
				iDEExtensionUtilRuntime =  iSysExtensionUtilRuntime.createDEExtensionUtilRuntime(this);
			}
			if(iDEExtensionUtilRuntime != null) {
				ObjectNode objectNode = JsonUtils.createObjectNode();
				objectNode.put(PSDEUtilImpl.ATTR_GETUTILTYPE, DEUtilType.EXTENSION.value);
				objectNode.put(PSDEUtilImpl.ATTR_GETID, DEUtilType.EXTENSION.value);
				objectNode.put(PSDEUtilImpl.ATTR_GETNAME, DEUtilType.EXTENSION.value);
				
				IPSDEUtil iPSDEUtil = this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSDataEntity(), IPSDEUtil.class, objectNode);
				iDEExtensionUtilRuntime.init(this.getDataEntityRuntimeContext(), iPSDEUtil);
				this.iDEExtensionUtilRuntime = iDEExtensionUtilRuntime;
			}
			
		}
		
		this.bEnableExtension = this.iDEExtensionUtilRuntime!=null;
	}
	
	@Override
	public IDEExtensionUtilRuntime getDEExtensionUtilRuntime() {
		this.prepare();
		return this.iDEExtensionUtilRuntime;
	}
	
	@Override
	public void reloadExtension(V2SystemExtensionSuite v2SystemExtensionSuite) {
		this.prepare();
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			this.getDEExtensionUtilRuntime().reloadExtension(v2SystemExtensionSuite);
		}
	}
	
	@Override
	protected IDELogicRuntime getDELogicRuntime(IPSDELogic iPSDELogic, boolean bTryMode) {
		IDELogicRuntime iDELogicRuntime = super.getDELogicRuntime(iPSDELogic, bTryMode);
		if(iDELogicRuntime != null && this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			return this.getDEExtensionUtilRuntime().getDELogicRuntime((net.ibizsys.central.dataentity.logic.IDELogicRuntime)iDELogicRuntime);
		}
		return iDELogicRuntime;
	}
	
	@Override
	protected IDEMSLogicRuntime getDEMSLogicRuntime(IPSDEMSLogic iPSDEMSLogic, boolean bTryMode) {
		IDEMSLogicRuntime iDEMSLogicRuntime = super.getDEMSLogicRuntime(iPSDEMSLogic, bTryMode);
		if(iDEMSLogicRuntime != null && this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			return this.getDEExtensionUtilRuntime().getDEMSLogicRuntime((net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime)iDEMSLogicRuntime);
		}
		return iDEMSLogicRuntime;
	}
	
	
	@Override
	protected boolean isEnableActionLogic(IPSDEAction iPSDEAction, String strAttachMode) {
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			if(this.getDEExtensionUtilRuntime().isEnableActionLogic(iPSDEAction, strAttachMode)) {
				return true;
			}
		}
		return super.isEnableActionLogic(iPSDEAction, strAttachMode);
	}
	
	@Override
	protected void executeActionLogics(IEntityBase arg0, IPSDEAction iPSDEAction, String strAttachMode, IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		super.executeActionLogics(arg0, iPSDEAction, strAttachMode, iDynaInstDataEntityRuntime, iDynaInstRuntime, actionData);
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			this.getDEExtensionUtilRuntime().executeActionLogics(arg0, iPSDEAction, strAttachMode);
		}
	}
	
	
	@Override
	public V2SystemExtensionLogic[] getExtensionLogics(String strLogicType) {
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			return this.getDEExtensionUtilRuntime().getExtensionLogics(strLogicType);
		}
		return null;
	}

	@Override
	public Object executeExtensionLogic(V2SystemExtensionLogic v2SystemExtensionLogic, Object objData) throws Throwable {
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			return this.getDEExtensionUtilRuntime().executeExtensionLogic(v2SystemExtensionLogic, objData);
		}
		throw new DataEntityRuntimeException(this, String.format("未支持实体扩展"));
	}
	
	@Override
	public void notify(Object key, String strEvent, Object eventData, Object eventData2, Object eventData3, Object eventData4) throws Throwable {
		super.notify(key, strEvent, eventData, eventData2, eventData3, eventData4);
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			this.getDEExtensionUtilRuntime().notify(key, strEvent, eventData, eventData2, eventData3, eventData4);
		}
	}
	
	@Override
	public net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime getDEMSLogicRuntime(IEntity iEntity, boolean bTryMode) {
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime iDEMSLogicRuntime = this.getDEExtensionUtilRuntime().getDEMSLogicRuntime(iEntity, true);
			if(iDEMSLogicRuntime != null) {
				return iDEMSLogicRuntime;
			}
		}
		return super.getDEMSLogicRuntime(iEntity, bTryMode);
	}
	
	@Override
	protected void checkDEMainState(Object arg, IPSDEAction iPSDEAction) throws Exception {
		if(this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			this.getDEExtensionUtilRuntime().checkDEMainState(arg, iPSDEAction);
		}
		super.checkDEMainState(arg, iPSDEAction);
	}
	
	@Override
	protected boolean onTestDataAccessAction(Object dataOrKey, String strAccessAction) throws Exception {
		if(!this.isEnableExtension() && this.getDEExtensionUtilRuntime() != null) {
			if(this.getDEExtensionUtilRuntime().testDataAccessAction(dataOrKey, strAccessAction)) {
				return false;
			}
		}
		return super.onTestDataAccessAction(dataOrKey, strAccessAction);
	}
	
}
