package net.ibizsys.central.cloud.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.cloud.core.ba.CloudOSSBDSchemeRuntime;
import net.ibizsys.central.cloud.core.dataentity.DataEntityRuntime;
import net.ibizsys.central.cloud.core.eai.SysAIAgentRuntime;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.spring.configuration.NacosServiceHubSetting;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.IConfigListener;
import net.ibizsys.central.cloud.core.util.IRTCodeUtils;
import net.ibizsys.central.cloud.core.util.RTCodeUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.cloud.core.util.domain.V2DeploySystem;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.ModelRTScriptBase;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.KeyValueUtils;

public class ServiceSystemRuntime extends ServiceSystemRuntimeBase implements IServiceSystemRuntime {

	private static final Log log = LogFactory.getLog(ServiceSystemRuntime.class);
	
	private static final Object EMPTY = new Object();
	
	private Map<Class<?>, Object> sysUtilRuntimeCacheMap = new HashMap<>();
	
	private boolean bEnableServiceHubAPI = true;
	
	private String strDataFlowSystemId = null;
	
	//private boolean bEnableExtension = false;
	
	private IRTCodeUtils iRTCodeUtils = null;
	
	private V2DeploySystem v2DeploySystem = null;
	
	private String strSystemExtensionConfigId = null;
	
	private String strExtensionSessionId = null;
	
	private IConfigListener systemExtensionConfigListener = new IConfigListener() {

		@Override
		public Executor getExecutor() {
			return null;
		}

		@Override
		public void receiveConfigInfo(String configInfo) {
			try {
				reloadSystemExtension(configInfo);
			} catch (Exception ex) {
				log.error(ex);
			}
		}
	};
	
	@Override
	public boolean isEnableRTCodeMode() {
		return ServiceHub.getInstance().isEnableRTCodeMode();
	}
	
	@Override
	public boolean isEnableProdMode() {
		return ServiceHub.getInstance().isEnableProdMode();
	}
	
	@Override
	protected void prepareSysSFPluginRuntimes() throws Exception {
		if(this.getRTCodeUtils(true) == null) {
			this.prepareRTCodeUtils();
			this.getRTCodeUtils(false);
		}
		
		super.prepareSysSFPluginRuntimes();
		
		if(isEnableRTCodeMode()) {
			//判断是否预载运行时对象
//			File groovySourceFolder = new File( String.format("%1$s%2$sgroovy", this.getPSSystemService().getPSModelFolderPath(), File.separator));
//			if(groovySourceFolder.exists()) {
//				java.util.List<IPSSysSFPlugin> psSysSFPluginList = RTCodeUtils.buildPSSysSFPlugins(this.getPSSystemService(), groovySourceFolder);
//				if(!ObjectUtils.isEmpty(psSysSFPluginList)) {
//
//					Map<IPSSysSFPlugin, Throwable> taskRetMap = new LinkedHashMap<IPSSysSFPlugin, Throwable>();
//					List<CompletableFuture<?>> taskList = new ArrayList<CompletableFuture<?>>();
//					for (IPSSysSFPlugin iPSSysSFPlugin : psSysSFPluginList) {
//						CompletableFuture<Void> task = CompletableFuture.runAsync(new Runnable() {
//							@Override
//							public void run() {
//								try {
//									registerPSSysSFPlugin(iPSSysSFPlugin);
//								} catch (Throwable ex) {
//									log.error(String.format("注册后台插件[%1$s]发生异常，%2$s", iPSSysSFPlugin.getName(), ex.getMessage()), ex);
//									taskRetMap.put(iPSSysSFPlugin, ex);
//								}
//							}
//						});
//						taskList.add(task);
//					}
//
//					try {
//						CompletableFuture.allOf(taskList.toArray(new CompletableFuture<?>[taskList.size()])).get();
//					} catch (Exception ex) {
//						throw new Exception(String.format("准备后台插件发生异常，%1$s", ex.getMessage()), ex);
//					}
//					
//					if(taskRetMap.size()>0) {
//						for(java.util.Map.Entry<IPSSysSFPlugin, Throwable> entry : taskRetMap.entrySet()) {
//							throw new Exception(String.format("注册后台插件[%1$s]发生异常，%2$s", entry.getKey().getName(), entry.getValue().getMessage()), entry.getValue());
//						}
//					}
//				}
//			}
			
		}
	}
	
	
	@Override
	protected IDataEntityRuntime createDataEntityRuntime(IPSDataEntity iPSDataEntity) {
		if(isEnableRTCodeMode() && iPSDataEntity.getPSSysSFPlugin()==null) {
			String strRTObjectName = null;
			try {
				strRTObjectName = this.getRTCodeUtils(false).getRTObjectName(iPSDataEntity);
			}
			catch (Exception ex) {
				throw new SystemRuntimeException(this, String.format("计算实体[%1$s]运行时对象名称发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()), ex);
			}
			if(StringUtils.hasLength(strRTObjectName)) {
				RuntimeObjectFactory.getInstance().registerObjectIf(IDataEntityRuntime.class, strRTObjectName, strRTObjectName);
				IDataEntityRuntime iDataEntityRuntime = RuntimeObjectFactory.getInstance().getObject(IDataEntityRuntime.class, strRTObjectName);
				if(iDataEntityRuntime!=null) {
					log.info(String.format("实体[%1$s]使用运行时对象[%2$s]",iPSDataEntity.getName(), iDataEntityRuntime.getClass().getName()));
					this.autowareObject(iDataEntityRuntime);
					return iDataEntityRuntime;
				}
			}
//			ISysSFPluginRuntime iSysSFPluginRuntime = this.getSysSFPluginRuntime(strRTObjectName, true);
//			if(iSysSFPluginRuntime != null) {
//				try {
//					IDataEntityRuntime iDataEntityRuntime = iSysSFPluginRuntime.getRuntimeObject(IDataEntityRuntime.class, true);
//					log.debug(String.format("实体[%1$s]使用运行时对象[%2$s]",iPSDataEntity.getName(), strRTObjectName));
//					return iDataEntityRuntime;
//				}
//				catch (Exception ex) {
//					throw new SystemRuntimeException(this, String.format("建立实体[%1$s]运行时对象[%2$s]发生异常，%3$s", iPSDataEntity.getName(), strRTObjectName, ex.getMessage()), ex);
//				}
//			}
//			else {
//				log.warn(String.format("实体[%1$s]默认运行时对象[%2$s]不存在，忽略RT代码模式",iPSDataEntity.getName(), strRTObjectName));
//			}
		}
		return super.createDataEntityRuntime(iPSDataEntity);
	}
	
	
	
	@Override
	protected void onInit() throws Exception {
		
		Object value = this.getSystemRuntimeSetting().getParam(PARAM_V2DEPLOYSYSTEM);
		if(value instanceof V2DeploySystem) {
			this.v2DeploySystem = (V2DeploySystem)value;
		}
		
		super.onInit();
		
		//从启用接口配置读取是否忽略默认服务总线接口
		String strEnableAPIs = this.getSystemRuntimeSetting().getEnableAPIs();
		if(StringUtils.hasLength(strEnableAPIs)) {
			Map<String, String> enableAPIMap = new HashMap<String, String>();
			String[] apis = strEnableAPIs.toLowerCase().split("[;]");
			for(String api : apis) {
				enableAPIMap.put(api, "");
			}
			if(enableAPIMap.containsKey(PARAM_ENABLEAPIS_NOSERVICEHUB)) {
				this.setEnableServiceHubAPI(false);
			}
		}
		
		this.strDataFlowSystemId = this.getSystemRuntimeSetting().getParam(PARAM_DATAFLOWSYSTEMID, this.getServiceId());
	
	//	this.bEnableExtension = this.getSystemRuntimeSetting().getParam(PARAM_EXTENSION, false);
	}
	
	@Override
	protected void onStart() throws Exception {
		super.onStart();
		
		//获取配置
		
		this.reloadSystemExtension(null);
	}
	
	@Override
	protected IDataEntityRuntime createDefaultDataEntityRuntime() {
		return new DataEntityRuntime();
	}
	
	@Override
	public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode) {
		return this.getSysUtilRuntime(cls, bTryMode, false);
	}
	
	@Override
	public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
		T t = (T)this.sysUtilRuntimeCacheMap.get(cls);
		if(t != null) {
			if(t != EMPTY) {
				return t;
			}
			else {
				if(bTryMode) {
					return null;
				}
				//必须模式，需要重新获取
			}
		}
		t = this.onGetSysUtilRuntime(cls, bTryMode, bSystemOnly);
		if(t != null) {
			this.sysUtilRuntimeCacheMap.put(cls, t);
		}
		else {
			this.sysUtilRuntimeCacheMap.put(cls, EMPTY);
		}
		
		return t;
	}
	
	protected <T> T onGetSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
		if(bSystemOnly) {
			return super.getSysUtilRuntime(cls, bTryMode);
		}
		else {
			T t = super.getSysUtilRuntime(cls, true);
			if(t != null) {
				return t;
			}
			
			return ServiceHub.getInstance().getSysUtilRuntime(null, cls, bTryMode);
		}
	}


	
	@Override
	public AppData invokeGetAppData(String strSystemTag, String strOrgId, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
		return this.onInvokeGetAppData(strSystemTag, strOrgId, objTag);
	}
	
	
	protected AppData onInvokeGetAppData(String strSystemTag, String strOrgId, Object objTag) {
		return getSystemAccessManager().getAppData(strSystemTag, strOrgId);
	}
	
	@Override
	public AppData invokeGetAppData(String strDCSystemTag, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
		return this.onInvokeGetAppData(strDCSystemTag, objTag);
	}
	
	
	protected AppData onInvokeGetAppData(String strDCSystemTag, Object objTag) {
		return getSystemAccessManager().getAppData(strDCSystemTag);
	}
	
	
	@Override
	public net.ibizsys.central.cloud.core.security.ISystemAccessManager getSystemAccessManager() {
		return (net.ibizsys.central.cloud.core.security.ISystemAccessManager)super.getSystemAccessManager();
	}

	@Override
	public boolean isEnableServiceHubAPI() {
		return this.bEnableServiceHubAPI;
	}
	
	protected void setEnableServiceHubAPI(boolean bEnableServiceHubAPI) {
		this.bEnableServiceHubAPI = bEnableServiceHubAPI;
	}
	
	
	@Override
	protected ISysFileUtilRuntime registerDefaultSysFileUtilRuntime() throws Exception {
		return (ISysOSSUtilRuntime)this.getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
		//return super.registerDefaultSysFileUtilRuntime();
	}
	
	
	@Override
	public void shutdown() {
		try {
			this.fireSystemEvent(SYSTEMEVENT_SHUTDOWN, null);
			onShutdown();
		}
		catch (Exception ex) {
			throw new SystemRuntimeException(this, String.format("关闭系统发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	protected void onShutdown() throws Exception{
		
		try {
			String strSystemExtensionConfigId = this.strSystemExtensionConfigId;
			this.strSystemExtensionConfigId = null;
			this.strExtensionSessionId = null;
			if(StringUtils.hasLength(strSystemExtensionConfigId)) {
				ServiceHub.getInstance().removeConfigListener(strSystemExtensionConfigId, systemExtensionConfigListener);
			}
		}
		catch (Throwable ex) {
			log.error(String.format("移除系统扩展配置监控发生移除，%1$s", ex.getMessage()), ex);
		}
		
		
		
		super.onShutdown();
	}
	
	@Override
	protected void prepareDefaultSysBDSchemeRuntime() throws Exception {
		super.prepareDefaultSysBDSchemeRuntime();
		if(this.getDefaultSysBDSchemeRuntime()!=null) {
			return;
		}
		
		IPSSysBDScheme iPSSysBDScheme = SysBDSchemeRuntime.getDefaultPSSysBDScheme(this.getSystemRuntimeContext());
		ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getRuntimeObject(ISysBDSchemeRuntime.class, CloudOSSBDSchemeRuntime.BDTYPE_CLOUDOSS);
		if (iSysBDSchemeRuntime == null) {
			return;
		}

		try {
			iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
		} catch (Exception ex) {
			throw new SystemRuntimeException(this, String.format("初始化大数据体系[%1$s]运行时对象发生异常，%2$s", iPSSysBDScheme.getName(), ex.getMessage()), ex);
		}

		this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
	}
	
	@Override
	public ISysDataSyncAgentRuntime createSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
		if(iPSSysDataSyncAgent.getPSSysSFPlugin() == null) {
			if("CloudAIAgent".equalsIgnoreCase(iPSSysDataSyncAgent.getCodeName()) && "USER".equalsIgnoreCase(iPSSysDataSyncAgent.getAgentType())) {
				return new SysAIAgentRuntime();
			}
		}
		
		return super.createSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
	}

	@Override
	public <T> T createModelRTScript(Object owner, String strScriptCode, Class<? extends ModelRTScriptBase> cls) {
		// TODO Auto-generated method stub
		return super.createModelRTScript(owner, strScriptCode, cls);
	}
	
	@Override
	public String getDataFlowSystemId() {
		return this.strDataFlowSystemId;
	}
	
	@Override
	public V2DeploySystem getV2DeploySystem() {
		return this.v2DeploySystem;
	}
	
	@Override
	public boolean isEnableExtension() {
		//return this.getV2DeploySystem() != null && StringUtils.hasLength(this.getV2DeploySystem().getOssFile());
		return this.getV2DeploySystem() != null;
	}
	
	@Override
	public String getExtensionId() {
		return this.getV2DeploySystem() != null ? this.getV2DeploySystem().getSystemExtensionId() : null;
	}
	
	@Override
	public String getExtensionSessionId() {
		return this.strExtensionSessionId;
	}
	
//	@Override
//	public boolean isEnableExtension() {
//		return this.bEnableExtension;
//	}

	@Override
	public IRTCodeUtils getRTCodeUtils() {
		try {
			return this.getRTCodeUtils(false);
		} catch (Exception ex) {
			throw new SystemRuntimeException(this, ex.getMessage(), ex);
		}
	}
	
	protected IRTCodeUtils getRTCodeUtils(boolean bTryMode) throws Exception {
		if(this.iRTCodeUtils != null || bTryMode) {
			return this.iRTCodeUtils;
		}
		throw new Exception("RT代码辅助功能对象无效");
	}
	
	protected void setRTCodeUtils(IRTCodeUtils iRTCodeUtils) {
		this.iRTCodeUtils = iRTCodeUtils;
	}
	
	protected void prepareRTCodeUtils() throws Exception {
		this.setRTCodeUtils(new RTCodeUtils(this.getSystemRuntimeContext()));
	}
	
	protected void reloadSystemExtension(String configInfo) throws Exception {
		if(this.getV2DeploySystem() == null) {
			return;
		}
		
		try {
			String strSystemExtensionConfigId = this.strSystemExtensionConfigId;
			this.strSystemExtensionConfigId = null;
			this.strExtensionSessionId = null;
			if(StringUtils.hasLength(strSystemExtensionConfigId)) {
				ServiceHub.getInstance().removeConfigListener(strSystemExtensionConfigId, systemExtensionConfigListener);
			}
		}
		catch (Throwable ex) {
			log.error(String.format("移除系统扩展配置监控发生移除，%1$s", ex.getMessage()), ex);
		}
		
		
		String strSystemExtensionId = this.getV2DeploySystem().getSystemExtensionId();
		if(StringUtils.hasLength(strSystemExtensionId)) {
			String strSystemExtensionConfigId = String.format("%1$s%2$s", NacosServiceHubSetting.DATAID_SYSTEMEXTENSION_PREFIX, strSystemExtensionId);
			if(!StringUtils.hasLength(configInfo)) {
				configInfo = ServiceHub.getInstance().getConfig(strSystemExtensionConfigId);
			}
			
			ServiceHub.getInstance().addConfigListener(strSystemExtensionConfigId, systemExtensionConfigListener);
			this.strSystemExtensionConfigId = strSystemExtensionConfigId;
			this.strExtensionSessionId = KeyValueUtils.genUniqueId(this.getDeploySystemId(), strSystemExtensionId, configInfo);
		}
		
		ISysExtensionUtilRuntime iSysExtensionUtilRuntime = this.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
		
		if(iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
			((IHubSysExtensionUtilRuntime)iSysExtensionUtilRuntime).reloadExtension(this, this.getV2DeploySystem().getSystemExtensionId());
		}
		else {
			iSysExtensionUtilRuntime.reloadExtension(this.getV2DeploySystem().getSystemExtensionId());
		}
	}
}
