package net.ibizsys.central.cloud.core.sysutil;

import java.security.PublicKey;
import java.util.Date;
import java.util.function.Function;

import org.apache.commons.logging.LogFactory;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClock;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;

public class JWTSysUAAUtilRuntime extends SysUAAUtilRuntimeBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(JWTSysUAAUtilRuntime.class);
	
	/**
	 * cn.ibizlab.util.security
	 */

	private Clock clock = DefaultClock.INSTANCE;

	// @Value("${ibiz.jwt.secret:ibzsecret}")
	private String secret;



	protected String getSecret() {
		return secret;
	}

	protected void setSecret(String secret) {
		this.secret = secret;
	}



	protected Clock getClock() {
		return clock;
	}

	protected void setClock(Clock clock) {
		this.clock = clock;
	}


	@Override
	protected boolean onValidateToken(String token, IAuthenticationUser iAuthenticationUser) throws Throwable {
		
		String strUserName = this.getUsernameFromToken(token);
		if(!strUserName.contentEquals(iAuthenticationUser.getUsername())) {
			return false;
		}
		
		final Date expiration = getExpirationDateFromToken(token);
	    return !expiration.before(clock.now());
	}

	@Override
	protected String onGetUsernameFromToken(String token) throws Throwable {
		 return getClaimFromToken(token, Claims::getSubject);
	}

	@Override
	protected Date onGetExpirationDateFromToken(String token) throws Throwable {
		return getClaimFromToken(token, Claims::getExpiration);
	}
	

	protected <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) throws Throwable {
        final Claims claims = getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

	protected Claims getAllClaimsFromToken(String token) throws Throwable{
        PublicKey publicKey = getPublicKey(getPublicKeyString());
        return Jwts.parser()
                .setSigningKey(publicKey)
                .parseClaimsJws(token)
                .getBody();
    }
	
}
