package net.ibizsys.central.cloud.core.spring.rt.util;

import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.ITransactionalUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import javax.annotation.PostConstruct;

@Component
public class TransactionalUtil implements ITransactionalUtil {

    @Autowired
    PlatformTransactionManager platformTransactionManager;

    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_MANDATORY = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_MANDATORY);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_NESTED = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_NESTED);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_NEVER = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_NEVER);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_NOT_SUPPORTED = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_NOT_SUPPORTED);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_REQUIRED = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_REQUIRED);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_REQUIRED_NEW = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
    private final static DefaultTransactionDefinition TRANSACTIONDEFINITION_SUPPORTS = new DefaultTransactionDefinition(TransactionDefinition.PROPAGATION_SUPPORTS);

    @PostConstruct
    public void postConstruct() {
        ActionSessionManager.setTransactionalUtil(this);
    }

    @Override
    public Object mandatory(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_MANDATORY);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object nested(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_NESTED);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object never(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_NEVER);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object not_supported(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_NOT_SUPPORTED);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object required(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_REQUIRED);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object required_new(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_REQUIRED_NEW);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public Object supports(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_SUPPORTS);
            Object obj = iAction.execute(args);
            platformTransactionManager.commit(transactionStatus);
            return obj;
        } catch (Throwable e) {
            if (transactionStatus != null)
                platformTransactionManager.rollback(transactionStatus);
            throw e;
        }
    }

    @Override
    public void commit() throws Throwable {
//        TransactionStatus transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_REQUIRED);
//        platformTransactionManager.commit(transactionStatus);
    }

    @Override
    public void rollback() throws Throwable {
//        TransactionStatus transactionStatus = platformTransactionManager.getTransaction(TRANSACTIONDEFINITION_REQUIRED);
//        platformTransactionManager.rollback(transactionStatus);
    }
}