package net.ibizsys.central.cloud.core.spring.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.runtime.security.IUserContext;

@RestController()
@RequestMapping("")
@ConditionalOnProperty(prefix = "ibiz.servicehub", name = "extensiongateway", havingValue = "true", matchIfMissing=true)
public class ExtensionGatewayRestController {

	private static final Log log = LogFactory.getLog(ExtensionGatewayRestController.class);

	@Autowired
	IServiceHub systemGateway;

	@RequestMapping(method = RequestMethod.GET, value = { "/{id}/extension/dynamodelapi/{model}", "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}",
			"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}",
			"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
	public ResponseEntity<Object> invokeDynaModelAPIGetMethod(@PathVariable("id") String id, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "key", required = false) String key
			, @PathVariable(name = "method", required = false) String method, HttpServletRequest req, HttpServletResponse response) {
		return ResponseEntity.ok(invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength(method)?method:"GET", null, req, response));
	}
	
	@RequestMapping(method = RequestMethod.GET, value = { "/{id}/extension/dynamodelapi/{model}/fetch{method}"
			,"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/fetch{method}"
			,"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/fetch{method}"
	})
	public ResponseEntity<?> invokeDynaModelAPIFetchMethod(@PathVariable("id") String id, @PathVariable(name = "pmodel", required = false) String pmodel, @PathVariable(name = "pkey", required = false) String pkey
			, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "method", required = true) String method, HttpServletRequest req, HttpServletResponse response) {
		Object ret = invokeDynaModelAPI(id, pmodel, pkey, model, null, "fetch"+method, null, req, response);
		if(ret instanceof Page) {
			return RestUtils.sendBackPage((Page)ret);
		}
		return ResponseEntity.ok(ret);
	}
	
	@RequestMapping(method = RequestMethod.POST, value = { "/{id}/extension/dynamodelapi/{model}/fetch{method}"
			,"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/fetch{method}"
			,"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/fetch{method}"
	})
	public ResponseEntity<?> invokeDynaModelAPIFetchMethod(@PathVariable("id") String id, @PathVariable(name = "pmodel", required = false) String pmodel, @PathVariable(name = "pkey", required = false) String pkey
			, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "method", required = true) String method, @RequestBody(required = false) Object body, HttpServletRequest req, HttpServletResponse response) {
		Object ret = invokeDynaModelAPI(id, pmodel, pkey, model, null, "fetch"+method, body, req, response);
		if(ret instanceof Page) {
			return RestUtils.sendBackPage((Page)ret);
		}
		return ResponseEntity.ok(ret);
	}
	
	
	@RequestMapping(method = RequestMethod.POST, value = { "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
	public ResponseEntity<Object> invokeDynaModelAPIPostMethod(@PathVariable("id") String id, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "key", required = false) String key
			, @PathVariable(name = "method", required = false) String method
			, @RequestBody(required = false) Object body
			, HttpServletRequest req, HttpServletResponse response) {
		return ResponseEntity.ok(invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength(method)?method:"CREATE", body, req, response));
	}
	
	@RequestMapping(method = RequestMethod.PUT, value = { "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
	public ResponseEntity<Object> invokeDynaModelAPIPutMethod(@PathVariable("id") String id, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "key", required = false) String key
			, @PathVariable(name = "method", required = false) String method
			, @RequestBody(required = false) Object body
			, HttpServletRequest req, HttpServletResponse response) {
		return ResponseEntity.ok(invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength(method)?method:"UPDATE", body, req, response));
	}
	
	@RequestMapping(method = RequestMethod.DELETE, value = { "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}"
			,"/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
	public ResponseEntity<Object> invokeDynaModelAPIDeleteMethod(@PathVariable("id") String id, @PathVariable(name = "model", required = true) String model
			, @PathVariable(name = "key", required = false) String key
			, @PathVariable(name = "method", required = false) String method
			, HttpServletRequest req, HttpServletResponse response) {
		return ResponseEntity.ok(invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength(method)?method:"REMOVE", null, req, response));
	}
	
	protected Object invokeDynaModelAPI(String id, String pmodel, String pkey, String model
			, String key
			, String method
			, Object body
			, HttpServletRequest req, HttpServletResponse response) {
		
		if(EmployeeContext.getCurrentMust().isSuperuser()) {
			throw new RuntimeException("必须系统管理员才能进行此操作");
		}
		
		ISystemRuntime iSystemRuntime = systemGateway.getSystemRuntime(id);
		ISysExtensionUtilRuntime iSysExtensionUtilRuntime = iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
		if(body==null) {
			body = RestUtils.queryString2Map(req.getQueryString());
		}
		
		if(iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime) {
			return ((IHubSysExtensionUtilRuntime)iSysExtensionUtilRuntime).invokeDynaModelAPI(iSystemRuntime, pmodel, pkey, model, method, key, body);
		}
		else {
			return iSysExtensionUtilRuntime.invokeDynaModelAPI(pmodel, pkey, model, method, key, body);
		}
	}

}
