package net.ibizsys.central.cloud.core.dataentity;

import java.io.InputStream;
import java.util.Map;

import net.ibizsys.central.cloud.core.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.cloud.core.util.domain.V2ImportSchema;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.IEntity;

public interface IDataEntityRuntime extends net.ibizsys.central.dataentity.IDataEntityRuntime {

	
	/* (non-Javadoc)
	 * @see net.ibizsys.central.dataentity.IDataEntityRuntime#getDEWFRuntime(net.ibizsys.model.dataentity.wf.IPSDEWF)
	 */
	IDEWFRuntime getDEWFRuntime(IPSDEWF iPSDEWF);
	
	
	/* (non-Javadoc)
	 * @see net.ibizsys.central.dataentity.IDataEntityRuntime#getDefaultDEWFRuntime()
	 */
	IDEWFRuntime getDefaultDEWFRuntime();
	
	
	/**
	 * 获取代理的实体服务对象
	 * @param cls
	 * @return
	 */
	<T> T getProxyDEService(Class<?> cls);
	
	
	/**
	 * 导入数据
	 * @param strImportTag 导入标记
	 * @param baseEntity
	 * @param inputStream 数据流
	 * @param v2ImportSchema 导入数据体系
	 * @param bTestPriv 是否测试权限
	 * @param parentDataEntityRuntime
	 * @param strParentKey 
	 * @return 错误信息
	 * @throws Throwable
	 */
	Map<Integer, EntityError> importData(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable;
	
	
	/**
	 * 导入数据2
	 * @param strImportTag 导入标记
	 * @param baseEntity
	 * @param inputStream 数据流
	 * @param v2ImportSchema 导入数据体系
	 * @param bTestPriv 是否测试权限
	 * @param parentDataEntityRuntime
	 * @param strParentKey 
	 * @return 错误信息
	 * @throws Throwable
	 */
	ImportDataResult importData2(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable;
	
	
	
}
