package net.ibizsys.central.cloud.core.util.groovy;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.RTCodeUtils;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.runtime.security.IUserContext;

public class SystemRTGroovyContext extends net.ibizsys.central.util.groovy.SystemRTGroovyContext implements ISystemRTGroovyContext{

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(SystemRTGroovyContext.class);
	
	private Map<String, String> modelRuntimeTagMap = new HashMap<String, String>();
	
	public SystemRTGroovyContext(ISystemRuntimeContext systemRuntimeContext) {
		super(systemRuntimeContext);
		
		prepareModelRuntimeTagMap();
	}

	protected void prepareModelRuntimeTagMap() {
		java.util.List<IPSDataEntity> psDataEntityList = this.getSystemRuntime().getPSSystem().getAllPSDataEntities();
		if(!ObjectUtils.isEmpty(psDataEntityList)) {
			for(IPSDataEntity iPSDataEntity : psDataEntityList) {
				try {
					String strDEServiceObjectName = RTCodeUtils.getInstance().getDEServiceObjectName(iPSDataEntity);
					if(StringUtils.hasLength(strDEServiceObjectName)) {
						String strKey = String.format("%1$s|%2$s", MODELTYPE_DESERVICE, strDEServiceObjectName);
						modelRuntimeTagMap.put(strKey, PSModelUtils.calcUniqueTag(iPSDataEntity.getPSSystemModule(), iPSDataEntity.getName()));
					}
				}
				catch (Exception ex) {
					log.error(ex);
				}
			}
		}
	}
	
	@Override
	public IUserContext user() {
		return EmployeeContext.getCurrentMust();
	}
	
	@Override
	public Object getModelRuntime(Class<?> theClass, String tag) {
		
		if (IDEService.class.isAssignableFrom(theClass)) {
			if(theClass.isInterface()) {
				String strKey = String.format("%1$s|%2$s", MODELTYPE_DESERVICE, theClass.getCanonicalName());
				String strTag = modelRuntimeTagMap.get(strKey);
				if(StringUtils.hasLength(strTag)) {
					return getModelRuntime(MODELTYPE_DESERVICE, strTag);
				}
			}
			return getModelRuntime(MODELTYPE_DESERVICE, tag);
		}
		
		return super.getModelRuntime(theClass, tag);
	}
}
