package net.ibizsys.central.cloud.core.sysutil;

import java.util.List;

import net.ibizsys.central.sysutil.ISysUtilRuntime;

/**
 * 系统云端日志功能组件运行时接口
 * @author lionlau
 *
 */
public interface ISysCloudLogUtilRuntime extends ISysUtilRuntime,ISysUtilContainerOnly{

	
	/**
	 * 进行常规日志操作
	 * @param list
	 */
	void logs(List<net.ibizsys.runtime.util.domain.Log> list);
	 
	 
	
	/**
	 * 发送控制台信息
	 * @param list
	 */
	void sendConsoleMessages(List<net.ibizsys.runtime.util.domain.Log> list);
	 
	
	/**
	 * 发送控制台信息
	 * @param strConsoleId
	 * @param strConsoleSender
	 * @param strInfo
	 */
	void sendConsoleMessage(String strConsoleId, String strConsoleSender, String strInfo);
	
	
	/**
	 * 发送控制台信息
	 * @param strConsoleId
	 * @param strConsoleSender
	 * @param bAppendTime
	 * @param nLogLevel
	 * @param strInfo
	 */
	void sendConsoleMessage(String strConsoleId, String strConsoleSender, boolean bAppendTime, int nLogLevel, String strLogCat, String strInfo);
}
