package net.ibizsys.central.cloud.core.security;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import net.ibizsys.central.cloud.core.util.domain.AppData;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuthenticationInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String token;
	private AppData appdata;
	private int expirein = 0;

	public AuthenticationInfo() {

	}

	public AuthenticationInfo(String token, int expirein, AppData appdata) {
		this.token = token;
		this.appdata = appdata;
		this.expirein = expirein;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public AppData getAppdata() {
		return appdata;
	}

	public void setAppdata(AppData appdata) {
		this.appdata = appdata;
	}

	public int getExpirein() {
		return this.expirein;
	}

	public void setExpirein(int nExpirein) {
		this.expirein = nExpirein;
	}

}
