package net.ibizsys.central.cloud.core;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.cloud.core.ba.CloudOSSBDSchemeRuntime;
import net.ibizsys.central.cloud.core.dataentity.DataEntityRuntime;
import net.ibizsys.central.cloud.core.eai.SysAIAgentRuntime;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.util.RTCodeUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;

public class ServiceSystemRuntime extends ServiceSystemRuntimeBase implements IServiceSystemRuntime {

	private static final Log log = LogFactory.getLog(ServiceSystemRuntime.class);
	
	private static final Object EMPTY = new Object();
	
	private Map<Class<?>, Object> sysUtilRuntimeCacheMap = new HashMap<>();
	
	private boolean bEnableServiceHubAPI = true;
	
	@Override
	public boolean isEnableRTCodeMode() {
		return ServiceHub.getInstance().isEnableRTCodeMode();
	}
	
	@Override
	public boolean isEnableProdMode() {
		return ServiceHub.getInstance().isEnableProdMode();
	}
	
	@Override
	protected void prepareSysSFPluginRuntimes() throws Exception {
		super.prepareSysSFPluginRuntimes();
		
		if(isEnableRTCodeMode()) {
			//判断是否预载运行时对象
//			File groovySourceFolder = new File( String.format("%1$s%2$sgroovy", this.getPSSystemService().getPSModelFolderPath(), File.separator));
//			if(groovySourceFolder.exists()) {
//				java.util.List<IPSSysSFPlugin> psSysSFPluginList = RTCodeUtils.buildPSSysSFPlugins(this.getPSSystemService(), groovySourceFolder);
//				if(!ObjectUtils.isEmpty(psSysSFPluginList)) {
//
//					Map<IPSSysSFPlugin, Throwable> taskRetMap = new LinkedHashMap<IPSSysSFPlugin, Throwable>();
//					List<CompletableFuture<?>> taskList = new ArrayList<CompletableFuture<?>>();
//					for (IPSSysSFPlugin iPSSysSFPlugin : psSysSFPluginList) {
//						CompletableFuture<Void> task = CompletableFuture.runAsync(new Runnable() {
//							@Override
//							public void run() {
//								try {
//									registerPSSysSFPlugin(iPSSysSFPlugin);
//								} catch (Throwable ex) {
//									log.error(String.format("注册后台插件[%1$s]发生异常，%2$s", iPSSysSFPlugin.getName(), ex.getMessage()), ex);
//									taskRetMap.put(iPSSysSFPlugin, ex);
//								}
//							}
//						});
//						taskList.add(task);
//					}
//
//					try {
//						CompletableFuture.allOf(taskList.toArray(new CompletableFuture<?>[taskList.size()])).get();
//					} catch (Exception ex) {
//						throw new Exception(String.format("准备后台插件发生异常，%1$s", ex.getMessage()), ex);
//					}
//					
//					if(taskRetMap.size()>0) {
//						for(java.util.Map.Entry<IPSSysSFPlugin, Throwable> entry : taskRetMap.entrySet()) {
//							throw new Exception(String.format("注册后台插件[%1$s]发生异常，%2$s", entry.getKey().getName(), entry.getValue().getMessage()), entry.getValue());
//						}
//					}
//				}
//			}
			
		}
	}
	
	
	@Override
	protected IDataEntityRuntime createDataEntityRuntime(IPSDataEntity iPSDataEntity) {
		if(isEnableRTCodeMode() && iPSDataEntity.getPSSysSFPlugin()==null) {
			String strRTObjectName = null;
			try {
				strRTObjectName = RTCodeUtils.getInstance().getRTObjectName(iPSDataEntity);
			}
			catch (Exception ex) {
				throw new SystemRuntimeException(this, String.format("计算实体[%1$s]运行时对象名称发生异常，%2$s", iPSDataEntity.getName(), ex.getMessage()), ex);
			}
			if(StringUtils.hasLength(strRTObjectName)) {
				RuntimeObjectFactory.getInstance().registerObjectIf(IDataEntityRuntime.class, strRTObjectName, strRTObjectName);
				IDataEntityRuntime iDataEntityRuntime = RuntimeObjectFactory.getInstance().getObject(IDataEntityRuntime.class, strRTObjectName);
				if(iDataEntityRuntime!=null) {
					log.debug(String.format("实体[%1$s]使用运行时对象[%2$s]",iPSDataEntity.getName(), iDataEntityRuntime.getClass().getName()));
					this.autowareObject(iDataEntityRuntime);
					return iDataEntityRuntime;
				}
			}
//			ISysSFPluginRuntime iSysSFPluginRuntime = this.getSysSFPluginRuntime(strRTObjectName, true);
//			if(iSysSFPluginRuntime != null) {
//				try {
//					IDataEntityRuntime iDataEntityRuntime = iSysSFPluginRuntime.getRuntimeObject(IDataEntityRuntime.class, true);
//					log.debug(String.format("实体[%1$s]使用运行时对象[%2$s]",iPSDataEntity.getName(), strRTObjectName));
//					return iDataEntityRuntime;
//				}
//				catch (Exception ex) {
//					throw new SystemRuntimeException(this, String.format("建立实体[%1$s]运行时对象[%2$s]发生异常，%3$s", iPSDataEntity.getName(), strRTObjectName, ex.getMessage()), ex);
//				}
//			}
//			else {
//				log.warn(String.format("实体[%1$s]默认运行时对象[%2$s]不存在，忽略RT代码模式",iPSDataEntity.getName(), strRTObjectName));
//			}
		}
		return super.createDataEntityRuntime(iPSDataEntity);
	}
	
	
	
	@Override
	protected void onInit() throws Exception {
		
		super.onInit();
		
		//从启用接口配置读取是否忽略默认服务总线接口
		String strEnableAPIs = this.getSystemRuntimeSetting().getEnableAPIs();
		if(StringUtils.hasLength(strEnableAPIs)) {
			Map<String, String> enableAPIMap = new HashMap<String, String>();
			String[] apis = strEnableAPIs.toLowerCase().split("[;]");
			for(String api : apis) {
				enableAPIMap.put(api, "");
			}
			if(enableAPIMap.containsKey(PARAM_ENABLEAPIS_NOSERVICEHUB)) {
				this.setEnableServiceHubAPI(false);
			}
		}
		
		
	}
	
	@Override
	protected IDataEntityRuntime createDefaultDataEntityRuntime() {
		return new DataEntityRuntime();
	}
	
	@Override
	public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode) {
		return this.getSysUtilRuntime(cls, bTryMode, false);
	}
	
	@Override
	public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
		T t = (T)this.sysUtilRuntimeCacheMap.get(cls);
		if(t != null) {
			if(t != EMPTY) {
				return t;
			}
			else {
				if(bTryMode) {
					return null;
				}
				//必须模式，需要重新获取
			}
		}
		t = this.onGetSysUtilRuntime(cls, bTryMode, bSystemOnly);
		if(t != null) {
			this.sysUtilRuntimeCacheMap.put(cls, t);
		}
		else {
			this.sysUtilRuntimeCacheMap.put(cls, EMPTY);
		}
		
		return t;
	}
	
	protected <T> T onGetSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
		if(bSystemOnly) {
			return super.getSysUtilRuntime(cls, bTryMode);
		}
		else {
			T t = super.getSysUtilRuntime(cls, true);
			if(t != null) {
				return t;
			}
			
			return ServiceHub.getInstance().getSysUtilRuntime(null, cls, bTryMode);
		}
	}


	
	@Override
	public AppData invokeGetAppData(String strSystemTag, String strOrgId, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
		return this.onInvokeGetAppData(strSystemTag, strOrgId, objTag);
	}
	
	
	protected AppData onInvokeGetAppData(String strSystemTag, String strOrgId, Object objTag) {
		return getSystemAccessManager().getAppData(strSystemTag, strOrgId);
	}
	
	
	@Override
	public net.ibizsys.central.cloud.core.security.ISystemAccessManager getSystemAccessManager() {
		return (net.ibizsys.central.cloud.core.security.ISystemAccessManager)super.getSystemAccessManager();
	}

	@Override
	public boolean isEnableServiceHubAPI() {
		return this.bEnableServiceHubAPI;
	}
	
	protected void setEnableServiceHubAPI(boolean bEnableServiceHubAPI) {
		this.bEnableServiceHubAPI = bEnableServiceHubAPI;
	}
	
	
	@Override
	protected ISysFileUtilRuntime registerDefaultSysFileUtilRuntime() throws Exception {
		return (ISysOSSUtilRuntime)this.getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
		//return super.registerDefaultSysFileUtilRuntime();
	}
	
	
	@Override
	public void shutdown() {
		try {
			this.fireSystemEvent(SYSTEMEVENT_SHUTDOWN, null);
			onShutdown();
		}
		catch (Exception ex) {
			throw new SystemRuntimeException(this, String.format("关闭系统发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	protected void onShutdown() throws Exception{
		
		super.onShutdown();
	}
	
	@Override
	protected void prepareDefaultSysBDSchemeRuntime() throws Exception {
		super.prepareDefaultSysBDSchemeRuntime();
		if(this.getDefaultSysBDSchemeRuntime()!=null) {
			return;
		}
		
		IPSSysBDScheme iPSSysBDScheme = SysBDSchemeRuntime.getDefaultPSSysBDScheme(this.getSystemRuntimeContext());
		ISysBDSchemeRuntime iSysBDSchemeRuntime = this.getRuntimeObject(ISysBDSchemeRuntime.class, CloudOSSBDSchemeRuntime.BDTYPE_CLOUDOSS);
		if (iSysBDSchemeRuntime == null) {
			return;
		}

		try {
			iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
		} catch (Exception ex) {
			throw new SystemRuntimeException(this, String.format("初始化大数据体系[%1$s]运行时对象发生异常，%2$s", iPSSysBDScheme.getName(), ex.getMessage()), ex);
		}

		this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
	}
	
	@Override
	public ISysDataSyncAgentRuntime createSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
		if(iPSSysDataSyncAgent.getPSSysSFPlugin() == null) {
			if("CloudAIAgent".equalsIgnoreCase(iPSSysDataSyncAgent.getCodeName()) && "USER".equalsIgnoreCase(iPSSysDataSyncAgent.getAgentType())) {
				return new SysAIAgentRuntime();
			}
		}
		
		return super.createSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
	}

	
}
