package net.ibizsys.central.cloud.core;

import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.ISystemAccessManager;
import net.ibizsys.central.cloud.core.util.domain.AppData;

public interface IServiceSystemRuntime extends ISystemRuntime {

	/**
	 * 系统事件：系统关闭
	 */
	public final static String SYSTEMEVENT_SHUTDOWN = "SHUTDOWN";
	
	
	/**
	 * 参数：启用的服务接口，忽略服务总线默认接口
	 */
	public final static String PARAM_ENABLEAPIS_NOSERVICEHUB = "-noservicehub";
	
	
	
	/**
	 * 获取系统访问管理对象
	 */
	ISystemAccessManager getSystemAccessManager();
	
	
	/**
	 * 获取系统功能运行时
	 * @param cls
	 * @param bTryMode
	 * @param bSystemOnly 仅从当前系统获取
	 * @return
	 */
	<T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly);
	
	
	
	/**
	 * 调用获取应用数据
	 * @param strSystemTag
	 * @param strOrgId
	 * @param iAuthenticationUser
	 * @param objTag
	 * @return
	 * @throws Throwable
	 */
	AppData invokeGetAppData(String strSystemTag, String strOrgId, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable;
	
	
	
	
	/**
	 * 是否启用默认的服务总线系统接口
	 * @return
	 */
	boolean isEnableServiceHubAPI();
	
	
	
	/**
	 * 关闭系统，执行释放
	 */
	void shutdown();
	
	
	
	/**
	 * 是否启用运行时代码模式
	 * @return
	 */
	boolean isEnableRTCodeMode();
	
	
	
	/**
	 * 是否启用生产模式
	 * @return
	 */
	boolean isEnableProdMode();
}
