package net.ibizsys.central.cloud.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums.SFPluginType;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.IPSDataEntityObject;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.res.PSSysSFPluginImpl;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.util.JsonUtils;

/**
 * Cloud调试器Utils
 * @author lionlau
 *
 */
public class RTCodeUtils {

	public static List<IPSSysSFPlugin> buildPSSysSFPlugins(IPSSystemService iPSSystemService, File folder) throws Exception{
		List<IPSSysSFPlugin> list = new ArrayList<IPSSysSFPlugin>();
		
		Map<String, File> fileMap = new HashMap<String, File>();
		fillGroovySourceFileMap("", folder, fileMap);
		
		for(java.util.Map.Entry<String, File> entry : fileMap.entrySet()) {
			
			ObjectNode objectNode = JsonUtils.createObjectNode();
			objectNode.put(PSSysSFPluginImpl.ATTR_GETID, entry.getKey());
			objectNode.put(PSSysSFPluginImpl.ATTR_GETNAME, entry.getValue().getName());
			objectNode.put(PSSysSFPluginImpl.ATTR_GETPLUGINTYPE, SFPluginType.USER.value);
			objectNode.put(PSSysSFPluginImpl.ATTR_ISRUNTIMEOBJECT, true);
			objectNode.put(PSSysSFPluginImpl.ATTR_GETRTOBJECTNAME, entry.getKey());
			objectNode.put(PSSysSFPluginImpl.ATTR_GETRTOBJECTSOURCE, 1);
			objectNode.put(PSSysSFPluginImpl.ATTR_ISTRYMODE, true);
			//objectNode.put(PSSysSFPluginImpl.ATTR_ISLAZYMODE, true);
			objectNode.put(PSSysSFPluginImpl.ATTR_GETTEMPLCODE, FileUtils.readFileToString(entry.getValue(), "UTF-8"));
			
			IPSSysSFPlugin iPSSysSFPlugin = iPSSystemService.createAndInitPSModelObject((IPSModelObjectRuntime)iPSSystemService.getPSSystem(), IPSSysSFPlugin.class, objectNode);
			list.add(iPSSysSFPlugin);
		}
		return list;
	}
	
	private static void fillGroovySourceFileMap(String strPackage, File folder, Map<String, File> fileMap) throws Exception{
		
		if(StringUtils.hasLength(strPackage)) {
			strPackage += ".";
		}
		
		File[] files = folder.listFiles();
		if(files == null) {
			return;
		}
		for(File file:files) {
			if(file.isDirectory()) {
				fillGroovySourceFileMap(strPackage + file.getName(), file, fileMap);
			}
			else {
				String[] items = file.getName().split("[.]");
				if(items.length == 2) {
					if("groovy".equals(items[1])) {
						fileMap.put(strPackage + items[0], file);
					}
				}
			}
		}
	}
	
	
	public static String getRTObjectName(IPSDataEntity iPSDataEntity) throws Exception{
		if(!StringUtils.hasLength(iPSDataEntity.getCodeName())) {
			throw new Exception("实体代码标识无效");
		}
		if(!StringUtils.hasLength(iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
			throw new Exception("系统模块代码标识无效");
		}
		
		String strPKGCodeName = getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
		return String.format("%1$s.%2$s.dataentity.%3$sDERuntime", strPKGCodeName, iPSDataEntity.getPSSystemModuleMust().getCodeName().toLowerCase(), StringUtils.capitalize(iPSDataEntity.getCodeName()));
	}
	
	public static String getRTObjectName(IPSDELogic iPSDELogic) throws Exception{
		if(!StringUtils.hasLength(iPSDELogic.getCodeName())) {
			throw new Exception("实体逻辑标识无效");
		}
		
		String strPKGCodeName = getPKGCodeName(iPSDELogic);
		return String.format("%1$s.logic.%2$sDELogicRuntime", strPKGCodeName, StringUtils.capitalize(iPSDELogic.getCodeName()));
	}
	
	
	public static String getPKGCodeName(IPSDataEntityObject iIPSDataEntityObject) throws Exception{
		IPSDataEntity iPSDataEntity = iIPSDataEntityObject.getParentPSModelObject(IPSDataEntity.class);
		if(!StringUtils.hasLength(iPSDataEntity.getCodeName())) {
			throw new Exception("实体代码标识无效");
		}
		if(!StringUtils.hasLength(iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
			throw new Exception("系统模块代码标识无效");
		}
		
		String strPKGCodeName = getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
		return String.format("%1$s.%2$s.dataentity.%3$s", strPKGCodeName, iPSDataEntity.getPSSystemModuleMust().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase());
	}
	
	
	public static String getPKGCodeName(IPSSystem self) throws Exception{
		if(self.getDefaultPSSysSFPub()==null) {
			throw new Exception("系统未定义默认发布对象");
		}
		
		if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getCodeName())) {
			throw new Exception("默认发布对象未定义代码标识");
		}
		
		if(!StringUtils.hasLength(self.getDefaultPSSysSFPub().getPKGCodeName())) {
			return self.getDefaultPSSysSFPub().getCodeName().toLowerCase();
		}
		else {
			return String.format("%1$s.%2$s", self.getDefaultPSSysSFPub().getPKGCodeName(), self.getDefaultPSSysSFPub().getCodeName().toLowerCase());
		}
	}
	
	public static String getPKGCodeName(IPSSystemModule iPSSystemModule) throws Exception{
		if(StringUtils.hasLength(iPSSystemModule.getPKGCodeName())) {
			return iPSSystemModule.getPKGCodeName();
		}
		
		IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
		if(iPSSysModelGroup != null) {
			if(StringUtils.hasLength(iPSSysModelGroup.getPKGCodeName())) {
				return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), iPSSysModelGroup.getCodeName().toLowerCase());
			}
		}
		
		return getPKGCodeName(iPSSystemModule.getParentPSModelObject(IPSSystem.class));
	}
}
