package net.ibizsys.central.cloud.core.spring.rt;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.PostConstruct;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.zaxxer.hikari.HikariDataSource;

import net.ibizsys.central.cloud.core.IServiceHubSetting;
import net.ibizsys.central.cloud.core.ServiceHubBase;
import net.ibizsys.central.cloud.core.database.ISysDBSchemeSyncAdapter;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIDocAdapter;
import net.ibizsys.central.cloud.core.util.domain.DataSource;
import net.ibizsys.runtime.util.DBTypes;
import net.ibizsys.runtime.util.EntityUtils;

@Component("ServiceHub")
public class ServiceHub extends ServiceHubBase implements ApplicationContextAware,ApplicationRunner/*, SmartLifecycle*/{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(ServiceHub.class);
	
	@Autowired
	IServiceHubSetting iServiceHubSetting;
	
	@Autowired
	RequestMappingHandlerMapping requestMappingHandlerMapping;
	
	@Autowired(required=false)
	ISysServiceAPIDocAdapter sysServiceAPIDocAdapter = null;
	
	@Autowired(required=false)
	ISysDBSchemeSyncAdapter sysDBSchemeSyncAdapter = null;

	@Autowired 
	NacosDiscoveryProperties nacosDiscoveryProperties;
	
	@Autowired 
	ServerProperties serverProperties;
	
	@Autowired(required=false)
	javax.sql.DataSource dataSource = null;

	private ConfigurableApplicationContext ctx;
    
	private final AtomicBoolean initialized = new AtomicBoolean(false);
	
    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (ConfigurableApplicationContext) ctx;
    }
    
	@PostConstruct
	public void postConstruct() {
		this.setServiceHubSetting(iServiceHubSetting);
		this.setDefaultDataSource(dataSource);
		this.setRequestMappingHandlerMapping(requestMappingHandlerMapping);
		this.setSysServiceAPIDocAdapter(sysServiceAPIDocAdapter);
		this.setSysDBSchemeSyncAdapter(sysDBSchemeSyncAdapter);
		onPostConstruct();
	}


	protected javax.sql.DataSource registerDataSource(DataSource ds) throws Exception{
		HikariDataSource dataSource = new HikariDataSource();
		
		EntityUtils.copyTo(ds, dataSource);
		
		//进一步设置参数
		if(!StringUtils.hasLength(dataSource.getPoolName())) {
			dataSource.setPoolName(ds.getDataSourceId());
		}
		
		if(StringUtils.hasLength(ds.getDriverClassName())) {
			dataSource.setDriverClassName(ds.getDriverClassName());
		}
		else {
			if(StringUtils.hasLength(ds.getDBType())) {
				String strDriverClassName = DBTypes.getDriverClassName(ds.getDBType());
				if(StringUtils.hasLength(strDriverClassName)) {
					log.debug(String.format("数据源[%1$s]类型[%2$s]匹配驱动[%3$s]", ds.getDataSourceId(), ds.getDBType(), strDriverClassName));
					dataSource.setDriverClassName(strDriverClassName);
				}
			}
		}
		
        dataSource.setJdbcUrl(ds.getJdbcUrl());
        dataSource.setUsername(ds.getUsername());
        dataSource.setPassword(ds.getPassword());
       
        Connection connection = dataSource.getConnection();
        ctx.getBeanFactory().registerSingleton("dynadatasource_"+ds.getDataSourceId(), dataSource);
        try {
        	connection.close();
        }
        catch(Exception ex) {
        	log.error(ex);
        }
        this.setDataSource(ds.getDataSourceId(), dataSource);
        
        return dataSource;
	}



	@Override
	public void run(ApplicationArguments args) throws Exception {
		this.install();
	}



//
//
//	@Override
//	  public void stop(Runnable callback) {
//	    callback.run();
//	  }
//
//	  @Override
//	  public void start() {
//	    if (initialized.compareAndSet(false, true)) {
//	    	this.install();
//	    }
//	  }
//
//	  @Override
//	  public void stop() {
//	  
//	  }
//
//	  @Override
//	  public boolean isRunning() {
//	    return initialized.get();
//	  }
//
//	  @Override
//	  public int getPhase() {
//	    return Integer.MAX_VALUE - 1;
//	  }






	
}
