package net.ibizsys.central.cloud.core.service;

import org.springframework.util.StringUtils;

import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.service.SysServiceAPILevels;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import net.ibizsys.runtime.util.Errors;
import net.ibizsys.runtime.util.domain.File;

/**
 * Cloud体系服务接口运行时对象
 * 
 * @author lionlau
 *
 */
public class SysServiceAPIRuntime extends net.ibizsys.central.service.SysServiceAPIRuntime implements ISysServiceAPIRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysServiceAPIRuntime.class);

	private int nAPILevel = SysServiceAPILevels.USER;
	private String strBaseUrl = null;

	@Override
	protected void onInit() throws Exception {

		setAPILevel(this.getPSSysServiceAPI().getAPILevel());
		if (this.getAPILevel() < SysServiceAPILevels.CORE || this.getAPILevel() > SysServiceAPILevels.USER) {
			log.warn(String.format("无法识别的接口访问级别[%1$s]", this.getAPILevel()));
		}
		
		if(!StringUtils.hasLength(this.getBaseUrl())) {
			prepareBaseUrl();
		}
		super.onInit();
	}

	@Override
	public int getAPILevel() {
		return this.nAPILevel;
	}

	protected void setAPILevel(int nAPILevel) {
		this.nAPILevel = nAPILevel;
	}
	
	protected void prepareBaseUrl() throws Exception{
		this.setBaseUrl(String.format("/%1$s/%2$s", this.getSystemRuntime().getServiceId(), this.getPSSysServiceAPI().getServiceCodeName()).toLowerCase());
	}

	@Override
	public void registerMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
		this.onRegisterMapping(iSysServiceAPIRequestMappingAdapter);
	}
	
	protected void onRegisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
		iSysServiceAPIRequestMappingAdapter.registerMapping(this);
	}
	
	@Override
	public void unregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
		this.onUnregisterMapping(iSysServiceAPIRequestMappingAdapter);
	}
	
	protected void onUnregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
		iSysServiceAPIRequestMappingAdapter.unregisterMapping(this);
	}
	

	@Override
	public Object invokeDEMethod(String strScope, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEMethod(strScope, strDataEntityName, strMethodName, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEMethod(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEMethod(strScope, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
	}

	@Override
	public Object invokeDEImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEImportData2(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
	}

	@Override
	public Object invokeDEAsyncImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEAsyncImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
	}

	@Override
	public Object invokeDEAsyncImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEAsyncImportData2(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
	}

	@Override
	public Object invokeDEGetImportTemplate(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEGetImportTemplate(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objTag);
	}

	@Override
	public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, objTag);
	}

	@Override
	public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEAsyncExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEAsyncExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEPrintData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEPrintData(strScope, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEWFStart(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEWFStart(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEWFCancel(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEWFCancel(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
	}

	@Override
	public Object invokeDEDownloadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEDownloadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
	}

	@Override
	public Object invokeDEUploadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		testAccessUser();
		return super.invokeDEUploadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
	}

	/**
	 * 判断访问用户
	 * 
	 * @throws Throwable
	 */
	protected void testAccessUser() throws Throwable {

		if (this.getAPILevel() == SysServiceAPILevels.CORE) {
			return;
		}

		if (this.getAPILevel() == SysServiceAPILevels.CLOUDADMIN) {
			if (AuthenticationUser.getCurrentMust().getSuperuser() != 1) {
				throw new SysServiceAPIRuntimeException(this, String.format("仅允许平台管理员访问"), Errors.ACCESSDENY);
			}
			return;
		}

		IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
		if (this.getAPILevel() == SysServiceAPILevels.DCADMIN) {
			if (!iEmployeeContext.isSuperuser()) {
				throw new SysServiceAPIRuntimeException(this, String.format("仅允许机构管理员访问"), Errors.ACCESSDENY);
			}
			return;
		}

		// throw new SysServiceAPIRuntimeException(this,
		// String.format("无法识别的接口级别[%1$s]", this.getAPILevel()),
		// Errors.ACCESSDENY);
	}

	@Override
	public String getBaseUrl() {
		return this.strBaseUrl;
	}
	
	
	protected void setBaseUrl(String strBaseUrl) {
		this.strBaseUrl = strBaseUrl;
	}
	
	
	
}
