package net.ibizsys.central.cloud.core.service;

public interface ISysServiceAPIRuntime extends net.ibizsys.central.service.ISysServiceAPIRuntime {

	/**
	 * 反馈头部参数：自定义提示消息
	 */
	public final static String HEADER_MESSAGE = "x-message";
	
	/**
	 * 反馈头部参数：当前页码
	 */
	public final static String HEADER_PAGE = "x-page";
	
	/**
	 * 反馈头部参数：每页记录数
	 */
	public final static String HEADER_PERPAGE = "x-per-page";
	
	/**
	 * 反馈头部参数：总记录数
	 */
	public final static String HEADER_TOTAL = "x-total";
	

	
	/**
	 * 注册服务接口映射
	 * @param iSysServiceAPIRequestMappingAdapter
	 * @throws Exception
	 */
	void registerMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception;
	
	
	
	/**
	 * 注销服务接口映射
	 * @param iSysServiceAPIRequestMappingAdapter
	 * @throws Exception
	 */
	void unregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception;
	
	
	
	
	/**
	 * 获取基础服务路径
	 * @return
	 */
	String getBaseUrl();
	
	
}
