package net.ibizsys.central.cloud.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ObjectUtils;

import net.ibizsys.central.Version;
import net.ibizsys.central.cloud.core.dataentity.security.DataEntityAccessManager;
import net.ibizsys.central.cloud.core.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.cloud.core.sysutil.ISysUAAUtilRuntime;
import net.ibizsys.central.cloud.core.util.SysLogicTags;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.security.ISysUserRoleRuntime;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.script.IScriptEntity;

public class SystemAccessManager extends net.ibizsys.central.security.SystemAccessManager implements ISystemAccessManager {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SystemAccessManager.class);

	private ISysUAAUtilRuntime iSysUAAUtilRuntime = null;
	private ISysLogicRuntime fillAppDataSysLogicRuntime = null;
	private boolean bCalcFillAppDataSysLogicRuntime = false;
	private Map<String, Object> appDataCtxMap = null;
	private Map<String, Object> appDataMap = null;

	@Override
	protected void onInit() throws Exception {

		super.onInit();

		this.appDataCtxMap = this.getSystemRuntime().getSystemRuntimeSetting().getParams("appdatactx", null);
		this.appDataMap = this.getSystemRuntime().getSystemRuntimeSetting().getParams("appdata", null);
	}

	protected Map<String, Object> getAppDataCtxMap() {
		return this.appDataCtxMap;
	}

	protected Map<String, Object> getAppDataMap() {
		return this.appDataMap;
	}

	protected ISysUAAUtilRuntime getSysUAAUtilRuntime() {
		if (this.iSysUAAUtilRuntime == null) {
			this.iSysUAAUtilRuntime = this.getSystemRuntime().getSysUtilRuntime(ISysUAAUtilRuntime.class, false);
		}
		return this.iSysUAAUtilRuntime;
	}

	@Override
	protected ISysUserRoleRuntime createSysUserRoleRuntime(IPSSysUserRole iPSSysUserRole) {
		return new SysUserRoleRuntime();
	}

	@Override
	public IDataEntityAccessManager createDataEntityAccessManager(IDataEntityRuntime iDataEntityRuntime) {
		return new DataEntityAccessManager();
	}

	@Override
	public AppData getAppData(String strSystemTag, String strOrgId) {
		try {
			return onGetAppData(strSystemTag, strOrgId);
		} catch (Throwable ex) {
			throw new SystemRuntimeException(this.getSystemRuntime(), String.format("获取当前用户应用数据发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	protected AppData onGetAppData(String strSystemTag, String strOrgId) throws Throwable {
		AppData appData = this.getSysUAAUtilRuntime().getAppData(strSystemTag, strOrgId);

		appData.set("version", Version.toVersionString());

		// 构造上下文身份
		IEmployeeContext iEmployeeContext = this.getSysUAAUtilRuntime().getEmployeeContext(strSystemTag, strOrgId, true);
		// 进行权限合成
		Collection<? extends GrantedAuthority> grantedAuthorities = iEmployeeContext.getAuthorities();

		if (AuthenticationUser.getCurrentMust().getSuperuser() == 1 || iEmployeeContext.isSuperuser()) {
			appData.set("enablepermissionvalid", false);
		} else {
			appData.set("enablepermissionvalid", true);
			Set<String> uniRes = new HashSet<>();
			appData.set("unires", uniRes);

			// 重新计算资源集合（后续需要调整算法）
			if (!ObjectUtils.isEmpty(grantedAuthorities)) {
				for (GrantedAuthority grantedAuthority : grantedAuthorities) {
					if (grantedAuthority instanceof UAAUniResAuthority) {
						uniRes.add(grantedAuthority.getAuthority());
						continue;
					}
				}
			}
		}

		final Map<String, Object> data = getAppDataMap();
		if (data != null) {
			appData.putAll(data);
		}

		/**
		 * 填充预置应用上下文
		 */
		final Map<String, Object> ctx = this.getAppDataCtxMap();
		if (ctx != null) {
			if (appData.getContext() == null) {
				appData.setContext(new Entity());
			}
			appData.getContext().putAll(ctx);
		}

		// 进一步添加应用数据
		this.onFillAppData(appData);
		
//		ISysLogicRuntime iSysLogicRuntime = getFillAppDataSysLogicRuntime();
//		if (iSysLogicRuntime != null) {
//			try {
//				IScriptEntity appScriptEntity = this.getSystemRuntime().createScriptEntity(appData);
//				IScriptEntity ctxScriptEntity = this.getSystemRuntime().createScriptEntity(appData.getContext());
//
//				iSysLogicRuntime.execute(appScriptEntity, ctxScriptEntity);
//			} catch (Throwable ex) {
//				throw new SystemRuntimeException(this.getSystemRuntime(), String.format("附加填充上下文逻辑发生异常，%1$s", ex.getMessage()), ex);
//			}
//		}
		
		

		return appData;
	}

	/**
	 * 进一步添加应用数据
	 * @param appData
	 * @throws Throwable
	 */
	protected void onFillAppData(AppData appData) throws Throwable {
		
		ISysLogicRuntime iSysLogicRuntime = getFillAppDataSysLogicRuntime();
		if (iSysLogicRuntime != null) {
			try {
				IScriptEntity appScriptEntity = this.getSystemRuntime().createScriptEntity(appData);
				IScriptEntity ctxScriptEntity = this.getSystemRuntime().createScriptEntity(appData.getContext());

				iSysLogicRuntime.execute(appScriptEntity, ctxScriptEntity);
			} catch (Throwable ex) {
				throw new SystemRuntimeException(this.getSystemRuntime(), String.format("附加填充上下文逻辑发生异常，%1$s", ex.getMessage()), ex);
			}
		}
	}

	protected ISysLogicRuntime getFillAppDataSysLogicRuntime() {
		if (!bCalcFillAppDataSysLogicRuntime) {
			this.fillAppDataSysLogicRuntime = onGetFillAppDataSysLogicRuntime();
			bCalcFillAppDataSysLogicRuntime = true;
		}
		return this.fillAppDataSysLogicRuntime;
	}

	protected ISysLogicRuntime onGetFillAppDataSysLogicRuntime() {
		IPSSysLogic iPSSysLogic = this.getSystemRuntimeContext().getSystemRuntime().getPSSysLogic(SysLogicTags.FILLAPPDATA);
		if (iPSSysLogic != null) {
			return this.getSystemRuntimeContext().getSystemRuntime().getSysLogicRuntime(iPSSysLogic);
		}
		return null;
	}

	@Override
	public List<ISysUserRoleRuntime> getSysUserRoleRuntimes(IUserContext iUserContext) {
		IEmployeeContext iEmployeeContext = (IEmployeeContext) iUserContext;
		List<ISysUserRoleRuntime> assignSysUserRoleRuntimeList = new ArrayList<>();
		if (ObjectUtils.isEmpty(iEmployeeContext.getAuthorities())) {
			return assignSysUserRoleRuntimeList;
		}

		for (GrantedAuthority ga : iEmployeeContext.getAuthorities()) {
			if (ga instanceof UAARoleAuthority) {
				ISysUserRoleRuntime iSysUserRoleRuntime = this.getSysUserRoleRuntime(ga.getAuthority(), true);
				if (iSysUserRoleRuntime != null) {
					assignSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
				}
			}
		}
		return assignSysUserRoleRuntimeList;
	}
}
