package net.ibizsys.central.cloud.core.dataentity.security.dr;


import java.util.ArrayList;
import java.util.List;

import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.dr.DataEntityDRProviderBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeCond;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.SearchCustomCond;


public class DataSetDRProvider extends DataEntityDRProviderBase {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DataSetDRProvider.class);
	
    @Override
    public boolean support(IPSDEUserRole iPSDEUserRole) {
        if (iPSDEUserRole.getPSDEDataSet() != null) {
            return true;
        }
        return false;
    }

    @Override
    public List<ISearchCond> getDRSearchConds(IDataEntityRuntime iDataEntityRuntime, IPSDEUserRole iPSDEUserRole, String action) {
        List<ISearchCond> searchConds = new ArrayList<>();
        IPSDEDataSet iPSDEDataSet = iPSDEUserRole.getPSDEDataSetMust();
        String strDBType = iDataEntityRuntime.getSysDBSchemeRuntime().getDBType();
        if (iPSDEDataSet.getPSDEDataQueries() == null) {
            throw new DataEntityRuntimeException(iDataEntityRuntime,
                    String.format("无法获取[%s]集合[%s]的查询模型", iDataEntityRuntime.getName(), iPSDEDataSet.getName()));
        }
        List<IPSDEDataQuery> iPSDEDataQueries = iPSDEDataSet.getPSDEDataQueries();
        for (IPSDEDataQuery ipsdeDataQuery : iPSDEDataQueries) {
            List<IPSDEDataQueryCode> iPSDEDataQueryCodes = ipsdeDataQuery.getAllPSDEDataQueryCodes();
            if (iPSDEDataQueryCodes != null) {
                for (IPSDEDataQueryCode iPSDEDataQueryCode : iPSDEDataQueryCodes) {
                    if (strDBType.equals(iPSDEDataQueryCode.getDBType())) {
                        List<IPSDEDataQueryCodeCond> iPSDEDataQueryCodeConds = iPSDEDataQueryCode.getPSDEDataQueryCodeConds();
                        if (iPSDEDataQueryCodeConds != null) {
                            String strCustomCond = "";
                            for (int i = 0; i < iPSDEDataQueryCodeConds.size(); i++) {
                                IPSDEDataQueryCodeCond psdeDataQueryCodeCond = iPSDEDataQueryCodeConds.get(i);
                                if (i > 0)
                                    strCustomCond += " AND ";
                                strCustomCond += psdeDataQueryCodeCond.getCustomCond();
                            }
                            SearchCustomCond customCond = new SearchCustomCond();
                            customCond.setCustomCond(strCustomCond);
                            searchConds.add(customCond);
                        }
                        break;
                    }
                }
            }
        }
        return searchConds;
    }


}
