package net.ibizsys.central.cloud.core.dataentity.report;

import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.report.DEReportRuntime;

public abstract class DEReportRuntimeBase extends DEReportRuntime  implements IDEReportRuntime{

	@Override
	public Object executeAction(String strAction, Object objBody, String strKey, Object objTag) {
		try {
			return this.onExecuteAction(strAction, objBody, strKey, objTag);
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this.getDataEntityRuntime(), this, String.format("执行操作[%1$s]发生异常，%2$s", strAction, ex.getMessage()), ex);
		}
	}

	protected Object onExecuteAction(String strAction, Object objBody, String strKey, Object objTag) throws Throwable {
		throw new Exception(String.format("无法识别的操作[%1$s]", strAction));
	}
}
