package net.ibizsys.central.cloud.core.dataentity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.util.StringUtils;

import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.cloud.core.util.RTCodeUtils;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRQueryCountCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.defield.DEFDataTypes;
import net.ibizsys.runtime.dataentity.logic.IDELogicRuntime;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.KeyValueUtils;

/**
 * @author lionlau
 *
 */
public class DataEntityRuntime extends net.ibizsys.central.dataentity.DataEntityRuntime implements IDataEntityRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DataEntityRuntime.class);

	private boolean bEnableRTCodeMode = false;
	
	@Override
	protected void onInit() throws Exception {
		if(this.getSystemRuntime() instanceof IServiceSystemRuntime) {
			bEnableRTCodeMode = ((IServiceSystemRuntime)this.getSystemRuntime()).isEnableRTCodeMode();
    	}
		super.onInit();
	}
	
  //  private static DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();


//    @Override
//    protected IUserContext getUserContext() {
//        return AuthenticationUser.getAuthenticationUser();
//    }

    @Override
    public boolean fillEntityKeyValue(IEntityBase objEntity) {
    	
    	if(DataTypeUtils.isNumberDataType(this.getKeyPSDEField().getStdDataType())) {
    		String strDEFType = this.getKeyPSDEField().getDataType();
    		if (DEFDataTypes.ACID.equals(strDEFType)) {
                this.resetFieldValue(objEntity, this.getKeyPSDEField());
            } else {
            	this.setFieldValue(objEntity, this.getKeyPSDEField(), getNumberId());
            }
            return false;
    	}
//    	if (DEFDataTypes.ACID.equals(strDEFType) || DEFDataTypes.BIGINT.equals(strDEFType)
//                || DEFDataTypes.BIGDECIMAL.equals(strDEFType)) {
//            if (DEFDataTypes.ACID.equals(this.getKeyPSDEField().getDataType()) && this.getSysDBSchemeRuntime().getDBType().equals(DBTypes.MYSQL5)) {
//                this.resetFieldValue(objEntity, this.getKeyPSDEField());
//            } else {
//            	this.setFieldValue(objEntity, this.getKeyPSDEField(), getNumberId());
//            }
//            return false;
//        }
        return super.fillEntityKeyValue(objEntity);
    }
    
    protected Object getNumberId() {
    	String strTableName = this.getTableName();
    	return KeyValueUtils.genNumberId(String.format("%1$s|%2$s", this.getSystemRuntime().getDeploySystemId(), StringUtils.hasLength(strTableName)?strTableName:this.getId()));
    }


    @Override
    public void setSearchCustomCondition(ISearchContextBase iSearchContextBase, String strCustomCondition) {
        Pattern bracketPattern = Pattern.compile("\\[(.*?)]");
        Matcher matcher = bracketPattern.matcher(strCustomCondition);
        if (matcher.find()) {
            ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
            SearchContextDTO.addSearchPredefinedCond(iSearchContextDTO, strCustomCondition, null);
            return;
        }
        super.setSearchCustomCondition(iSearchContextBase, strCustomCondition);
    }

//    @Override
//    public IDEPrintRuntime createDEPrintRuntime(IPSDEPrint iPSDEPrint) {
//        try {
//            IDEPrintRuntime iDEPrintRuntime = SpringContextHolder.getBean(String.format("%s_DEPRINT_%s", this.getName(), iPSDEPrint.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导入模式[%s]使用[%s]进行导入处理", this.getName(), iPSDEPrint.getCodeName().toUpperCase(), iPSDEPrint.getClass()));
//            return iDEPrintRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        Assert.notNull(iPSDEPrint, "实体打印模型对象无效");
//        if (DEReportTypes.JR.equals(iPSDEPrint.getReportType())) {
//            return new R8DEJRPrintRuntime();
//        }
//        return super.createDEPrintRuntime(iPSDEPrint);
//    }
//
//    @Override
//    public IDEDataImportRuntime createDEDataImportRuntime(IPSDEDataImport iPSDEDataImport) {
//        try {
//            IDEDataImportRuntime iDEDataImportRuntime = SpringContextHolder.getBean(String.format("%s_DEDATAIMPORT_%s", this.getName(), iPSDEDataImport.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导入模式[%s]使用[%s]进行导入处理", this.getName(), iPSDEDataImport.getCodeName().toUpperCase(), iDEDataImportRuntime.getClass()));
//            return iDEDataImportRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导入模式[%s]处理，使用默认导入处理", this.getName(), iPSDEDataImport.getCodeName().toUpperCase()));
//        return super.createDEDataImportRuntime(iPSDEDataImport);
//    }


//    @Override
//    protected IDEDataImportRuntime createDefaultDEDataImportRuntime() {
//        return new R8DEDataImportRuntime();
//    }
//
//    @Override
//    public IDEDataExportRuntime createDEDataExportRuntime(IPSDEDataExport iPSDEDataExport) {
//        try {
//            IDEDataExportRuntime iDEDataExportRuntime = SpringContextHolder.getBean(String.format("%s_DEDATAEXPORT_%s", this.getName(), iPSDEDataExport.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]导出模式[%s]使用[%s]进行导出处理", this.getName(), iPSDEDataExport.getCodeName().toUpperCase(), iDEDataExportRuntime.getClass()));
//            return iDEDataExportRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导出模式[%s]处理，使用默认导出处理", this.getName(), iPSDEDataExport.getCodeName().toUpperCase()));
//        return super.createDEDataExportRuntime(iPSDEDataExport);
//    }
//
//    @Override
//    protected IDEDataExportRuntime createDefaultDEDataExportRuntime() {
//        return new R8DEDataExportRuntime();
//    }
//
//    @Override
//    public IDENotifyRuntime createDENotifyRuntime(IPSDENotify iPSDENotify) {
//        try {
//            IDENotifyRuntime iDENotifyRuntime = SpringContextHolder.getBean(String.format("%s_DENOTIFY_%s", this.getName(), iPSDENotify.getCodeName().toUpperCase()));
//            log.debug(String.format("[%s]实体通知模式[%s]使用[%s]进行导入处理", this.getName(), iPSDENotify.getCodeName().toUpperCase(), iDENotifyRuntime.getClass()));
//            return iDENotifyRuntime;
//        } catch (NoSuchBeanDefinitionException e) {
//
//        }
//        log.debug(String.format("[%s]未指定导入模式[%s]处理，使用默认导入处理", this.getName(), iPSDENotify.getCodeName().toUpperCase()));
//        return new R8DENotifyRuntime();
//    }

    @Override
    protected boolean checkFieldQueryCountCondition(Object objValue, IEntityBase arg0, IPSDEFVRQueryCountCondition iPSDEFVRQueryCountCondition, IPSDEField iPSDEField) throws Throwable {
        String strRuleInfo = iPSDEFVRQueryCountCondition.getRuleInfo();
        IPSDEDataQuery iPSDEDataQuery = iPSDEFVRQueryCountCondition.getPSDEDataQuery();
        ISearchContextDTO searchContext = this.createSearchContext();
        searchContext.setCount(true);
        //设置上下文
        EntityBase datacontext = (EntityBase) arg0;
        if (datacontext != null) {
            searchContext.set("datacontext", datacontext.any());
        }
        searchContext.set("sessioncontext",  ActionSessionManager.getUserContextMust().getSessionParams());
        java.util.List result = this.selectDataQuery(iPSDEDataQuery, searchContext);

        Integer nMinValue = iPSDEFVRQueryCountCondition.getMinValue();
        Integer nMaxValue = iPSDEFVRQueryCountCondition.getMaxValue();
        boolean bIncMinValue = iPSDEFVRQueryCountCondition.isIncludeMinValue();
        boolean bIncMaxValue = iPSDEFVRQueryCountCondition.isIncludeMaxValue();
        boolean bTryMode = !iPSDEFVRQueryCountCondition.isKeyCond();
        int nSize = result.size();
        if (nMinValue != null) {
            if (bIncMinValue) {
                if (nSize < nMinValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else {
                if (nSize <= nMinValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            }
        }

        if (nMaxValue != null) {
            if (bIncMaxValue) {
                if (nSize > nMaxValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else {
                if (nSize >= nMaxValue) {
                    if (bTryMode)
                        return false;
                    throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            }
        }

        return true;
    }
    
    @Override
    public IDEWFRuntime getDefaultDEWFRuntime() {
    	return (IDEWFRuntime)super.getDefaultDEWFRuntime();
    }
    
    @Override
    public IDEWFRuntime getDEWFRuntime(IPSDEWF iPSDEWF) {
    	return (IDEWFRuntime)super.getDEWFRuntime(iPSDEWF);
    }
    
    
    @Override
    public IDELogicRuntime createDELogicRuntime(IPSDELogic iPSDELogic) {
    	if(isEnableRTCodeMode() && iPSDELogic.getPSSysSFPlugin()==null) {
    		String strRTObjectName = null;
			try {
				strRTObjectName = RTCodeUtils.getRTObjectName(iPSDELogic);
			}
			catch (Exception ex) {
				throw new DataEntityRuntimeException(this, String.format("计算实体逻辑[%1$s]运行时对象名称发生异常，%2$s", iPSDELogic.getName(), ex.getMessage()), ex);
			}
			ISysSFPluginRuntime iSysSFPluginRuntime = this.getSystemRuntime().getSysSFPluginRuntime(strRTObjectName, true);
			if(iSysSFPluginRuntime != null) {
				try {
					IDELogicRuntime iDELogicRuntime = iSysSFPluginRuntime.getRuntimeObject(IDELogicRuntime.class, true);
					log.debug(String.format("实体逻辑[%1$s]使用运行时对象[%2$s]",iPSDELogic.getName(), strRTObjectName));
					return iDELogicRuntime;
				}
				catch (Exception ex) {
					throw new DataEntityRuntimeException(this, String.format("建立实体逻辑[%1$s]运行时对象[%2$s]发生异常，%3$s", iPSDELogic.getName(), strRTObjectName, ex.getMessage()), ex);
				}
			}
    	}
    	return super.createDELogicRuntime(iPSDELogic);
    }
    
    /**
     * 实体是否启用运行时代码模式
     * @return
     */
    public boolean isEnableRTCodeMode() {
    	return this.bEnableRTCodeMode;
    }
}
