package net.ibizsys.central.cloud.core.codelist;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.ObjectUtils;

import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.cloud.core.sysutil.ISysConfUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.CodeItem;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.codelist.PSCodeItemImpl;
import net.ibizsys.runtime.util.JsonUtils;

/**
 * 来自Cloud体系的代码表运行时对象
 * @author lionlau
 *
 */
public class CloudCodeListRuntime extends net.ibizsys.runtime.codelist.PredefinedCodeListRuntime{

	
	@Override
	public List<IPSCodeItem> getPSCodeItems() {
		List<IPSCodeItem> psCodeItemList = new ArrayList<IPSCodeItem>();
		//获取系统配置组件
		ISysConfUtilRuntime iSysConfUtilRuntime = this.getSystemRuntime().getSysUtilRuntime(ISysConfUtilRuntime.class, false);
		//CodeList codeList =	iSysConfUtilRuntime.getCodeList(this.getPSCodeList().getCodeListTag(), false);
		CodeList codeList =	iSysConfUtilRuntime.getCodeList(this.getPSCodeList().getCodeName(), false);
		if(!ObjectUtils.isEmpty(codeList.getItems())) {
			for(CodeItem codeItem : codeList.getItems()) {
				ObjectNode itemNode = this.getPSCodeItemNode(codeItem);
				 IPSCodeItem iPSCodeItem = this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime) this.getPSCodeList(),
	                        IPSCodeItem.class, itemNode);
	             psCodeItemList.add(iPSCodeItem);
			}
		}
		return psCodeItemList;
	}
	
	
	
	 /**
     * 代码表层级关系
     *
     * @param codeItem
     * @return
     */
    public ObjectNode getPSCodeItemNode(CodeItem codeItem) {
        ObjectNode objNode = JsonUtils.createObjectNode();
        objNode.put(PSCodeItemImpl.ATTR_GETID, String.valueOf(codeItem.getValue()));
        objNode.put(PSCodeItemImpl.ATTR_GETNAME, String.valueOf(codeItem.getText()));
        objNode.put(PSCodeItemImpl.ATTR_GETVALUE, String.valueOf(codeItem.getValue()));
        objNode.put(PSCodeItemImpl.ATTR_GETTEXT, String.valueOf(codeItem.getText()));
//        if (!ObjectUtils.isEmpty(codeItem.getChildren())) {
//            ArrayNode childINodes = MAPPER.createArrayNode();
//            for (CodeItem child : codeItem.getChildren()) {
//                ObjectNode childNode = genPSCodeItem(child);
//                childINodes.add(childNode);
//            }
//            objNode.put(PSCodeItemImpl.ATTR_GETPSCODEITEMS, childINodes);
//        }
        return objNode;
    }
	
}
