package net.ibizsys.central.cloud.core.cloudutil.client;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;

public interface ICloudPortalClient {

	@RequestMapping(method = RequestMethod.POST, value = "/portal/asyncaction")
	PortalAsyncAction createAsyncAction(@RequestBody PortalAsyncAction action);

	
	@RequestMapping(method = RequestMethod.POST, value = "/portal/asyncaction/{id}/execute")
	PortalAsyncAction executeAsyncAction(@PathVariable("id") String id, @RequestBody PortalAsyncAction action);

	
	@RequestMapping(method = RequestMethod.POST, value = "/portal/asyncaction/{id}/error")
	PortalAsyncAction errorAsyncAction(@PathVariable("id") String id, @RequestBody PortalAsyncAction action);
	
	
	@RequestMapping(method = RequestMethod.POST, value = "/portal/asyncaction/{id}/finish")
	PortalAsyncAction finishAsyncAction(@PathVariable("id") String id, @RequestBody PortalAsyncAction action);
	
	
	@RequestMapping(method = RequestMethod.GET, value = "/portal/asyncaction/{id}")
	PortalAsyncAction getAsyncAction(@PathVariable("id") String id);
}
