package net.ibizsys.central.cloud.core.cloudutil;

import java.util.List;
import java.util.Map;

import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalMessage;

/**
 * Cloud门户功能运行时对象接口
 * @author lionlau
 *
 */
public interface ICloudPortalUtilRuntime extends ICloudUtilRuntime{

	/**
	 * 配置参数：MQTT IP 地址
	 */
	public final static String PARAM_MQTTIP = "mqttip";

	/**
	 * 配置参数：MQTT 端口
	 */
	public final static String PARAM_MQTTPORT = "mqttport";
	
	/**
	 * 配置参数：MQTT WebSocket端口
	 */
	public final static String PARAM_MQTTWSPORT = "mqttwsport";
	
	
	/**
	 * 配置参数：打开数据过期
	 */
	public final static String PARAM_OPENDATATIMEOUT = "opendatatimeout";
	
	
	/**
	 * 配置参数：通知代理对象参数集合，指定系统应用集成代理
	 */
	public final static String PARAM_INFORMAGENT = "INFORMAGENT";
	
	

	
	/**
	 * 打开数据操作：查看
	 */
	final public static String OPENDATAACTION_VIEW = "VIEW";
	
	/**
	 * 打开数据操作：编辑
	 */
	final public static String OPENDATAACTION_EDIT = "EDIT";
	
	
	/**
	 * 打开数据操作：已经执行更新操作
	 */
	final public static String OPENDATAACTION_UPDATE = "UPDATE";
	
	
	/**
	 * 打开数据操作：已经执行关闭操作
	 */
	final public static String OPENDATAACTION_CLOSE = "CLOSE";
	
	
	
	/**
	 * 门户通知代理代码标识
	 */
	public final static String PORTALINFORMAGENT_CODENAME = "PortalInformAgent";
	
	
	/**
	 * 向应用门户登记打开数据操作
	 * @param entity
	 * @param key
	 * @param action
	 * @return
	 */
	List<PortalMessage> markOpenData(String entity, String key, String action);


	/**
	 * 向应用门户发送待办刷新操作
	 * @return
	 */
	void refreshTodo();

	/**
	 * 建立异步作业
	 * @param params
	 * @return
	 */
	PortalAsyncAction createAsyncAction(Map params);
	
	
	
	/**
	 * 执行异步作业
	 * @param strId
	 * @param params
	 * @return
	 */
	PortalAsyncAction executeAsyncAction(String strId, Map params);
	
	/**
	 * 标记异步作业执行错误
	 * @param strId
	 * @param params
	 * @return
	 */
	PortalAsyncAction errorAsyncAction(String strId, Map params);
	
	
	/**
	 * 标记异步作业执行完成
	 * @param strId
	 * @param params
	 * @return
	 */
	PortalAsyncAction finishAsyncAction(String strId, Map params);
	
	
	/**
	 * 获取异步作业执行
	 * @param strId
	 * @return
	 */
	PortalAsyncAction getAsyncAction(String strId);
	
	 
}
