package net.ibizsys.central.cloud.core;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.fasterxml.jackson.databind.node.ObjectNode;

import groovy.lang.GroovySystem;
import net.ibizsys.central.ISystemLogAdapter;
import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.backend.ISysBackendTaskRuntime;
import net.ibizsys.central.cloud.core.app.IProxyAppRuntime;
import net.ibizsys.central.cloud.core.app.IServletAppRuntime;
import net.ibizsys.central.cloud.core.ba.CloudOSSBDSchemeRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudPortalClient;
import net.ibizsys.central.cloud.core.dataentity.security.dr.DataSetDRProvider;
import net.ibizsys.central.cloud.core.dataentity.security.dr.DeptDRProvider;
import net.ibizsys.central.cloud.core.dataentity.security.dr.OrgDRProvider;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.SystemAccessManager;
import net.ibizsys.central.cloud.core.service.SysServiceAPIRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudLogUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUAAUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.groovy.MetaClassCreationHandle;
import net.ibizsys.central.cloud.core.util.groovy.SystemRTGroovyContext;
import net.ibizsys.central.dataentity.security.dr.IDataEntityDRProvider;
import net.ibizsys.central.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.util.groovy.ISystemRTGroovyContext;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.res.PSSysUtilImpl;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.dataexport.IDEDataExportRuntime;
import net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysUtilRuntime;
import net.ibizsys.runtime.res.SysDataSyncAgentTypes;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.wf.IWFRoleRuntime;

public abstract class ServiceSystemRuntimeBase extends net.ibizsys.central.SystemRuntime {

	private static final Log log = LogFactory.getLog(ServiceSystemRuntimeBase.class);
	
	
	
	static {
		
		registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, SysDataSyncAgentTypes.KAFKA, "net.ibizsys.central.plugin.kafka.eai.KafkaEAIAgentRuntime");
		registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, SysDataSyncAgentTypes.RABBITMQ, "net.ibizsys.central.plugin.rabbitmq.eai.RabbitMQEAIAgentRuntime");
		registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, SysDataSyncAgentTypes.ACTIVEMQ, "net.ibizsys.central.plugin.activemq.eai.ActiveMQEAIAgentRuntime");
		registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, SysDataSyncAgentTypes.MQTT, "net.ibizsys.central.plugin.eai.MqttEAIAgentRuntime");
		
		registerRuntimeObjectIf(ISubSysServiceAPIRuntime.class, null, "net.ibizsys.central.plugin.cloud.service.CloudServiceClientRuntime");
		registerRuntimeObjectIf(IWebClient.class, null, "net.ibizsys.central.plugin.spring.service.client.WebFluxClient");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:CACHE", "net.ibizsys.central.plugin.redis.sysutil.SysRedisUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:UAA", "net.ibizsys.central.cloud.core.sysutil.JWTSysUAAUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:CLOUDCLIENT", "net.ibizsys.central.plugin.cloud.sysutil.SysCloudClientUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:OSS", "net.ibizsys.central.plugin.cloud.sysutil.SysOSSUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:WF", "net.ibizsys.central.plugin.cloud.sysutil.SysWFUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:CLOUDLOG", "net.ibizsys.central.plugin.cloud.sysutil.SysCloudLogUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:CONF", "net.ibizsys.central.plugin.cloud.sysutil.SysConfUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:UNISTATE", "net.ibizsys.central.plugin.zk.sysutil.SysZooKeeperUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:NOTIFY", "net.ibizsys.central.plugin.cloud.sysutil.SysNotifyUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:DEVOPS", "net.ibizsys.central.plugin.cloud.sysutil.SysDevOpsUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:AI", "net.ibizsys.central.plugin.cloud.sysutil.SysAIUtilRuntime");
		registerRuntimeObjectIf(ISysUtilRuntime.class, "USER:PORTAL", "net.ibizsys.central.plugin.cloud.sysutil.SysPortalUtilRuntime");
		
		registerRuntimeObjectIf(ICodeListRuntime.class, "DYNAMIC:RUNTIME", "net.ibizsys.central.cloud.core.codelist.CloudCodeListRuntime");
		registerRuntimeObjectIf(ICodeListRuntime.class, "DYNAMIC:OPERATOR", "net.ibizsys.central.cloud.core.codelist.OperatorCodeListRuntime");
		
		
		registerRuntimeObjectIf(ISysBackendTaskRuntime.class, "PREDEFINED:WFCALLBACK", "net.ibizsys.central.cloud.core.backend.SysWFCallbackBackendTaskRuntime");

		registerRuntimeObjectIf(IDataEntityDRProvider.class, "DATASET", new DataSetDRProvider());
		registerRuntimeObjectIf(IDataEntityDRProvider.class, "ORG", new DeptDRProvider());
		registerRuntimeObjectIf(IDataEntityDRProvider.class, "DEPT", new OrgDRProvider());
		registerRuntimeObjectIf(ISystemPersistentAdapter.class, null, SystemPersistentAdapter.class.getCanonicalName());
		registerRuntimeObjectIf(IDEWFRuntime.class, null, "net.ibizsys.central.cloud.core.dataentity.wf.DEWFRuntime");
		registerRuntimeObjectIf(IDEDataImportRuntime.class, null, "net.ibizsys.central.plugin.poi.dataentity.dataimport.POIDEDataImportRuntime");
		registerRuntimeObjectIf(IDEDataExportRuntime.class, null, "net.ibizsys.central.plugin.poi.dataentity.dataexport.POIDEDataExportRuntime");
		
		
		registerRuntimeObjectIf(ISysBDSchemeRuntime.class, CloudOSSBDSchemeRuntime.BDTYPE_CLOUDOSS, CloudOSSBDSchemeRuntime.class.getCanonicalName());
		
		
		//registerRuntimeObject(IRestExceptionHandler.class, null, new RestExceptionHandler());
		GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle(new MetaClassCreationHandle());
	}

	
	static ThreadPoolExecutor globalWorkThreadPoolExecutor = null;
	private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
	//private ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = null;
	
	protected static void setGlobalWorkThreadPoolExecutor(ThreadPoolExecutor globalWorkThreadPoolExecutor) {
		ServiceSystemRuntimeBase.globalWorkThreadPoolExecutor = globalWorkThreadPoolExecutor;
	}
	
	protected static ThreadPoolExecutor getGlobalWorkThreadPoolExecutor() {
		return ServiceSystemRuntimeBase.globalWorkThreadPoolExecutor;
	}
	
	@Override
	public IWebClient createWebClient(Object data) {
		IWebClient iWebClient = this.getRuntimeObject(GLOBALPLUGIN_WEBCLIENT, IWebClient.class, true, true);
		if(iWebClient != null) {
			return iWebClient;
		}
		
		iWebClient = getRuntimeObject(IWebClient.class, null);
		if(iWebClient != null) {
			return iWebClient;
		}
		
		throw new SystemRuntimeException(this, String.format("无法建立WebClient对象"));
	}
	
	
	@Override
	public IWFRoleRuntime createWFRoleRuntime(IPSWFRole iPSWFRole) {
		// TODO Auto-generated method stub
		return super.createWFRoleRuntime(iPSWFRole);
	}
	
	@Override
	protected ISysServiceAPIRuntime createDefaultSysServiceAPIRuntime() {
		return new SysServiceAPIRuntime();
	}
	
	
	@Override
	protected ISystemAccessManager createDefaultSystemAccessManager() {
		return new SystemAccessManager();
	}
	
	@Override
	protected void onStart() throws Exception {
		super.onStart();
		
		ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = this.getSysUtilRuntime(ISysCloudLogUtilRuntime.class, true);
		if(iSysCloudLogUtilRuntime == null) {
			this.prepareSysCloudLogUtilRuntime();
		}
	}
	
	
	@Override
	public ISysCacheUtilRuntime getSysCacheUtilRuntime(boolean bTryMode) {
		ISysCacheUtilRuntime iSysCacheUtilRuntime = super.getSysCacheUtilRuntime(true);
		if(iSysCacheUtilRuntime != null) {
			return iSysCacheUtilRuntime;
		}
		return this.getSysUtilRuntime(ISysCacheUtilRuntime.class, bTryMode);
	}
	
	
	protected void prepareSysCloudLogUtilRuntime() throws Exception{
		ObjectNode objectNode = JsonUtils.createObjectNode();
		objectNode.put(PSSysUtilImpl.ATTR_GETID, "CLOUDLOG");
		objectNode.put(PSSysUtilImpl.ATTR_GETNAME, "Cloud日志模块");
		objectNode.put(PSSysUtilImpl.ATTR_GETUTILTYPE, "USER");
		objectNode.put(PSSysUtilImpl.ATTR_GETUTILTAG, "CLOUDLOG");
		objectNode.put(PSSysUtilImpl.ATTR_GETCODENAME, "CLOUDLOG");
		
		IPSSysUtil iPSSysUtil = (IPSSysUtil) getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime) this.getPSSystem(), IPSSysUtil.class, objectNode);
//		ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = (ISysCloudLogUtilRuntime)this.createSysUtilRuntime(iPSSysUtil);
//		iSysCloudLogUtilRuntime.init(this.getSystemRuntimeContext(), iPSSysUtil);
//		iSysCloudLogUtilRuntime.install();
		
		ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = (ISysCloudLogUtilRuntime)this.registerPSSysUtil(iPSSysUtil);
		if(!iSysCloudLogUtilRuntime.isInstalled()) {
			iSysCloudLogUtilRuntime.install();
		}
		
	}
	
	
	
	@Override
	protected ISystemLogAdapter createDefaultSystemLogAdapter() {
		return new SystemLogAdapter();
	}
	
	@Override
	public void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData) {
		if(!StringUtils.hasLength(strAddress)) {
			
			/**
			 * 实际的远端地址
			 */
			RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
			if(requestAttributes instanceof ServletRequestAttributes) {
				HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
				strAddress = httpServletRequest.getHeader(ISysUAAUtilRuntime.HEADER_REALIP);
				if(!StringUtils.hasLength(strAddress)) {
					strAddress = httpServletRequest.getRemoteAddr();
				}	
			}
		}
		super.logAudit(nLogLevel, strCat, strInfo, strPersonId, strAddress, objData);
	}
	
	
	protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
		ThreadPoolExecutor threadPoolExecutor = getGlobalWorkThreadPoolExecutor();
		if(threadPoolExecutor != null) {
			return threadPoolExecutor;
		}
		else {
			return super.createWorkThreadPoolExecutor();
		}
	}
	
	
	@Override
	protected void shutdownWorkThreadPoolExecutor() {
		//super.shutdownWorkThreadPoolExecutor();
		ThreadPoolExecutor threadPoolExecutor = getGlobalWorkThreadPoolExecutor();
		if(threadPoolExecutor != null) {
			//return threadPoolExecutor;
		}
		else {
			super.shutdownWorkThreadPoolExecutor();
		}
	}
	

	@Override
	public IUserContext createDefaultUserContext() {
		
		return super.createDefaultUserContext();
	}
	
	
	@Override
	protected void onInit() throws Exception {
		super.onInit();

	}
	
	protected boolean isEnableServletApp() {
		return ServiceHub.getInstance().isEnableServletApp();
	}
	
	protected boolean isEnableProxyApp() {
		return ServiceHub.getInstance().isEnableProxyApp();
	}
	
	@Override
	protected boolean isEnableAppGateway() {
		if(!super.isEnableAppGateway()) {
			return isEnableServletApp() || isEnableProxyApp();
		}
		return true;
	}
	
	@Override
	protected IApplicationRuntime createApplicationRuntime(IPSApplication iPSApplication) {
		if(!super.isEnableAppGateway()) {
			if(iPSApplication.getPSSysSFPlugin() == null) {
				return null;
			}
			IApplicationRuntime iApplicationRuntime = super.createApplicationRuntime(iPSApplication);
			if(this.isEnableServletApp()) {
				if(iApplicationRuntime instanceof IServletAppRuntime) {
					return iApplicationRuntime;
				}
			}
			if(this.isEnableProxyApp()) {
				if(iApplicationRuntime instanceof IProxyAppRuntime) {
					return iApplicationRuntime;
				}
			}
			return null;
		}
		
		return super.createApplicationRuntime(iPSApplication);
		
		
		
	}
	
	
	@Override
	public Object asyncExecute(IAction iAction, Object[] args, Object actionTag) throws Throwable {
		
		//建立异步作业
		String strName = "异步作业";
		if(iAction instanceof INamedAction) {
			strName = ((INamedAction)iAction).getName();
		}
		
		
		ICloudPortalClient iCloudPortalClient = getSysCloudClientUtilRuntime().getServiceClient(ICloudUtilRuntime.CLOUDSERVICEURL_PORTAL, ICloudPortalClient.class);
		
		PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
		portalAsyncAction.setAsyncAcitonName(strName);
		if(actionTag != null) {
			if(actionTag instanceof Map) {
				portalAsyncAction.putAll((Map)actionTag);
			}
			else
				if(actionTag instanceof IEntity) {
					IEntity iEntity = (IEntity)actionTag;
					iEntity.copyTo(portalAsyncAction);
				}
		}
		
		try {
			portalAsyncAction = iCloudPortalClient.createAsyncAction(portalAsyncAction);
		}
		catch (Throwable ex) {
			throw new SystemRuntimeException(this, String.format("建立门户异步作业发生异常，%1$s",  ex.getMessage()), ex);
		}
		
		String strAsyncActionId = portalAsyncAction.getAsyncAcitonId();
		this.threadRun(new Runnable() {
			@Override
			public void run() {
				try {
					onAsyncExecute(iAction, args, strAsyncActionId);
				}
				catch (Throwable ex) {
					log.error(ex);
				}
			}
		});
		
		
		return portalAsyncAction;
	}
	
	protected void onAsyncExecute(IAction iAction, Object[] args, String strAsyncActionId) throws Throwable {
		
		ICloudPortalClient iCloudPortalClient = getSysCloudClientUtilRuntime().getServiceClient(ICloudUtilRuntime.CLOUDSERVICEURL_PORTAL, ICloudPortalClient.class);
		
		//开启会话
		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(EmployeeContext.getCurrent());
		}

		
		ActionSession actionSession = ActionSessionManager.getCurrentSession();
		String strWorkTag = KeyValueUtils.genUniqueId();
		
		actionSession.setActionParam(strWorkTag, "1");
		
		threadRun(new Runnable() {
			@Override
			public void run() {

				String strLastActionStep = actionSession.getActionStep();
				double fLastCompletionRate = actionSession.getCompletionRate();
				
				while(true) {
					Object objValue = actionSession.getActionParam(strWorkTag);
					if(ObjectUtils.isEmpty(objValue)) {
						break;
					}
					
					String strActionStep = actionSession.getActionStep();
					double fCompletionRate = actionSession.getCompletionRate();
					//判断差异
					
					if(DataTypeUtils.compare(strLastActionStep, strActionStep)!=0
							|| fLastCompletionRate != fCompletionRate) {
						//执行任务更新
						strLastActionStep = strActionStep;
						fLastCompletionRate = fCompletionRate;
						
						PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
						portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
						portalAsyncAction.setStepInfo(strLastActionStep);
						portalAsyncAction.set("completionrate", fLastCompletionRate);
						
						try {
							portalAsyncAction = iCloudPortalClient.executeAsyncAction(strAsyncActionId, portalAsyncAction);
						}
						catch (Throwable ex) {
							log.error(String.format("执行门户异步作业发生异常，%1$s",  ex.getMessage()), ex);
						}
					}
					
					try {
						Thread.sleep(200);
					} catch (InterruptedException ex) {
						log.error(ex);
					}
				}
			}
		});
		
		
		try {
			PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
			portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
			//开始执行
			try {
				iCloudPortalClient.executeAsyncAction(strAsyncActionId, portalAsyncAction);
			}
			catch (Throwable ex) {
				log.error(String.format("执行门户异步作业发生异常，%1$s",  ex.getMessage()), ex);
			}
			
			Object objRet = iAction.execute(args);
			//移除线程参数
			actionSession.removeActionParam(strWorkTag);
			
			if(objRet != null) {
				String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objRet);
				portalAsyncAction.setActionResult(strResult);
			}
			
			Object objDownloadRUrl= actionSession.getActionParam(PortalAsyncAction.FIELD_ASYNCRESULTDOWNLOADURL);
			if(objDownloadRUrl != null) {
				String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objDownloadRUrl);
				portalAsyncAction.setAsyncResultDownloadUrl(strResult);
			}
			
			try {
				iCloudPortalClient.finishAsyncAction(strAsyncActionId, portalAsyncAction);
			}
			catch (Throwable ex) {
				throw new Exception(String.format("完成门户异步作业发生异常，%1$s",  ex.getMessage()), ex);
			}

			if (bOpenActionSession) {
				ActionSessionManager.closeSession(true);
			}
			
		} catch (Throwable ex) {
			actionSession.removeActionParam(strWorkTag);
			
			if (bOpenActionSession) {
				ActionSessionManager.closeSession(false);
			}
			
			PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
			portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
			portalAsyncAction.setActionResult(ex.getMessage());
			try {
				iCloudPortalClient.errorAsyncAction(strAsyncActionId, portalAsyncAction);
			}
			catch (Throwable ex2) {
				log.error(String.format("执行门户异步作业发生异常，%1$s",  ex2.getMessage()), ex2);
			}
			
			throw ex;
		}																																																																																																																																																																																																					
		finally {
			
		}
	}
	
	public ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
		if(this.iSysCloudClientUtilRuntime == null){
			this.iSysCloudClientUtilRuntime = this.getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
		}
		return this.iSysCloudClientUtilRuntime;
	}

	
	@Override
	protected ISystemRTGroovyContext createSystemRTGroovyContext() {
		return new SystemRTGroovyContext(this.getSystemRuntimeContext());
	}
	
}
