/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.conf.core.cloudutil;

import java.util.ArrayList;
import java.util.Collection;
import net.ibizsys.central.cloud.core.cloudutil.CloudUtilRuntimeBase;
import net.ibizsys.central.cloud.core.cloudutil.ICloudConfUtilRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.CodeItem;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.central.cloud.core.util.domain.Config;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class CloudConfUtilRuntimeBase
extends CloudUtilRuntimeBase
implements ICloudConfUtilRuntime {
    private static final Log log = LogFactory.getLog(CloudConfUtilRuntimeBase.class);

    public String getLogicName() {
        return String.format("Cloud\u4f53\u7cfbConf\u529f\u80fd\u7ec4\u4ef6[%1$s]", this.getName());
    }

    public Config getConfig(final String strConfigType, final String strTargetType, final boolean bTryMode) {
        return (Config)this.executeAction("\u83b7\u53d6\u914d\u7f6e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudConfUtilRuntimeBase.this.onGetConfig(strConfigType, strTargetType, bTryMode);
            }
        }, null, Config.class);
    }

    protected Config onGetConfig(String strConfigType, String strTargetType, boolean bTryMode) throws Throwable {
        return this.getCloudSaaSUtilRuntime().getConfig(strConfigType, strTargetType, bTryMode);
    }

    public Config saveConfig(final String strConfigType, final String strTargetType, final Object objConfig) {
        return (Config)this.executeAction("\u4fdd\u5b58\u914d\u7f6e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudConfUtilRuntimeBase.this.onSaveConfig(strConfigType, strTargetType, objConfig);
            }
        }, null, Config.class);
    }

    protected Config onSaveConfig(String strConfigType, String strTargetType, Object objConfig) throws Throwable {
        return this.getCloudSaaSUtilRuntime().saveConfig(strConfigType, strTargetType, objConfig);
    }

    public void removeConfig(final String strConfigType, final String strTargetType) {
        this.executeAction("\u79fb\u9664\u914d\u7f6e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                CloudConfUtilRuntimeBase.this.onRemoveConfig(strConfigType, strTargetType);
                return null;
            }
        }, null, Object.class);
    }

    protected void onRemoveConfig(String strConfigType, String strTargetType) throws Throwable {
        this.getCloudSaaSUtilRuntime().removeConfig(strConfigType, strTargetType);
    }

    public CodeList getCodeList(final String strCodeListTag, final boolean bTryMode) {
        return (CodeList)this.executeAction("\u83b7\u53d6\u4ee3\u7801\u8868", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudConfUtilRuntimeBase.this.onGetCodeList(strCodeListTag, bTryMode);
            }
        }, null, CodeList.class);
    }

    protected CodeList onGetCodeList(String strCodeListTag, boolean bTryMode) throws Throwable {
        if ("SYSOPERATOR".equalsIgnoreCase(strCodeListTag)) {
            Collection employees = this.getCloudSaaSUtilRuntime().getEmployeesByOrg(EmployeeContext.getCurrentMust().getOrgid());
            CodeList codeList = new CodeList();
            codeList.setCode(strCodeListTag);
            if (!ObjectUtils.isEmpty((Object)employees)) {
                int nMaxSize = 1000;
                ArrayList<CodeItem> codeItems = new ArrayList<CodeItem>();
                for (Employee employee : employees) {
                    CodeItem codeItem = new CodeItem();
                    codeItem.setValue(employee.getUserId());
                    codeItem.setText(employee.getPersonName());
                    codeItem.setIconClass(employee.getAvatar());
                    codeItems.add(codeItem);
                    if (--nMaxSize != 0) continue;
                    break;
                }
                codeList.setItems(codeItems);
            }
            return codeList;
        }
        return this.getCloudSaaSUtilRuntime().getCodeList(strCodeListTag, bTryMode);
    }

    public CodeList getCodeList(final String strCodeListTag, final boolean bTryMode, final Integer maxSize) {
        return (CodeList)this.executeAction("\u83b7\u53d6\u4ee3\u7801\u8868", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return CloudConfUtilRuntimeBase.this.onGetCodeList(strCodeListTag, bTryMode, maxSize);
            }
        }, null, CodeList.class);
    }

    protected CodeList onGetCodeList(String strCodeListTag, boolean bTryMode, Integer maxSize) throws Throwable {
        if ("SYSOPERATOR".equalsIgnoreCase(strCodeListTag)) {
            Collection employees = this.getCloudSaaSUtilRuntime().getEmployeesByOrg(EmployeeContext.getCurrentMust().getOrgid());
            CodeList codeList = new CodeList();
            codeList.setCode(strCodeListTag);
            if (!ObjectUtils.isEmpty((Object)employees)) {
                int nMaxSize = maxSize;
                ArrayList<CodeItem> codeItems = new ArrayList<CodeItem>();
                for (Employee employee : employees) {
                    CodeItem codeItem = new CodeItem();
                    codeItem.setValue(employee.getUserId());
                    codeItem.setText(employee.getPersonName());
                    codeItem.setIconUrl(employee.getUserIcon());
                    codeItems.add(codeItem);
                    if (--nMaxSize != 0) continue;
                    break;
                }
                codeList.setItems(codeItems);
            }
            return codeList;
        }
        return this.getCloudSaaSUtilRuntime().getCodeList(strCodeListTag, bTryMode, maxSize);
    }
}

