/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.conf.core.spring.controller;

import javax.annotation.PostConstruct;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.conf.core.IConfUtilSystemRuntime;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.cloudutil.ICloudConfUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.central.cloud.core.util.domain.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class ConfRestController {
    private static final Log log = LogFactory.getLog(ConfRestController.class);
    @Autowired
    IServiceHub iServiceHub;
    @Autowired(required=false)
    private ICloudConfUtilRuntime iCloudConfUtilRuntime = null;

    @PostConstruct
    protected void postConstruct() {
        log.debug((Object)String.format("Cloud\u914d\u7f6e\u670d\u52a1\u5df2\u7ecf\u542f\u52a8", new Object[0]));
        this.iServiceHub.registerNamingService("ibizcloud-conf");
    }

    protected ICloudConfUtilRuntime getCloudConfUtilRuntime() {
        if (this.iCloudConfUtilRuntime == null) {
            try {
                this.iCloudConfUtilRuntime = (ICloudConfUtilRuntime)this.iServiceHub.getCloudUtilRuntime(IConfUtilSystemRuntime.class, ICloudConfUtilRuntime.class, false);
            }
            catch (Throwable ex) {
                log.debug((Object)String.format("\u672a\u6307\u5b9aCloud\u670d\u52a1\u914d\u7f6e\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
                throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u672a\u6307\u5b9aCloud\u670d\u52a1\u914d\u7f6e\u529f\u80fd\u6a21\u5757", new Object[0]), ex);
            }
        }
        return this.iCloudConfUtilRuntime;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/configs/{configType}/{targetType}"})
    public ResponseEntity<Boolean> saveConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType, @RequestBody(required=false) Object cfg) {
        if (!ObjectUtils.isEmpty((Object)cfg)) {
            this.getCloudConfUtilRuntime().saveConfig(configType, targetType, cfg);
        } else {
            this.getCloudConfUtilRuntime().removeConfig(configType, targetType);
        }
        return ResponseEntity.ok((Object)true);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/{configType}/{targetType}"})
    public ResponseEntity<Object> getConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType) {
        Config config = this.getCloudConfUtilRuntime().getConfig(configType, targetType, true);
        if (config == null) {
            return ResponseEntity.ok(null);
        }
        return ResponseEntity.ok((Object)config.getCfg());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/share/{id}"})
    public ResponseEntity<Object> getShareConfig(@PathVariable(value="id") String id) {
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/configs/share/{configType}/{targetType}"})
    public ResponseEntity<String> shareConfig(@PathVariable(value="configType") String configType, @PathVariable(value="targetType") String targetType) {
        return null;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/dictionaries/codelist/{code}", "/dictionarys/codelist/{code}"})
    public ResponseEntity<CodeList> getCodeList(@PathVariable(value="code") String code, @RequestParam(name="trymode", required=false, defaultValue="false") String trymode, @RequestParam(name="size", required=false) Integer maxSize) {
        boolean bTryMode = trymode.equalsIgnoreCase("true");
        CodeList codeList = ObjectUtils.isEmpty((Object)maxSize) ? this.getCloudConfUtilRuntime().getCodeList(code, bTryMode) : this.getCloudConfUtilRuntime().getCodeList(code, bTryMode, maxSize);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)codeList);
    }
}

