/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.ai.langchain.chatchat.addin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.ibizsys.central.cloud.ai.core.addin.AIAccessAgentBase;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.ChatMessageRole;
import net.ibizsys.central.cloud.core.util.domain.CompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.CompletionResult;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ChatchatAIAccessAgent
extends AIAccessAgentBase {
    private static final Log log = LogFactory.getLog(ChatchatAIAccessAgent.class);
    private IWebClient aiService = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getAIService(true) == null) {
            this.prepareAIService();
            if (this.getAIService(true) == null) {
                throw new Exception(String.format("AI\u670d\u52a1\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            }
        }
    }

    protected void runAuthTimer() {
    }

    protected IWebClient getAIService() {
        return this.getAIService(false);
    }

    protected IWebClient getAIService(boolean bTryMode) {
        if (this.aiService != null || bTryMode) {
            return this.aiService;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getContext().getCloudAIUtilRuntime().getSystemRuntime(), (IModelRuntime)this.getContext().getCloudAIUtilRuntime(), "\u672a\u6307\u5b9aAI\u670d\u52a1\u5bf9\u8c61");
    }

    protected void setAIService(IWebClient aiService) {
        this.aiService = aiService;
    }

    protected void prepareAIService() throws Exception {
        if (!StringUtils.hasLength((String)this.getAgentData().getServiceUrl())) {
            throw new Exception("\u672a\u6307\u5b9a\u670d\u52a1\u8def\u5f84");
        }
        IWebClient iWebClient = this.getSystemRuntime().createWebClient((Object)this.getAgentData().getServiceUrl());
        iWebClient.init(this.getSystemRuntime(), this.getAgentData().getServiceUrl(), null);
        this.setAIService(iWebClient);
    }

    public String getName() {
        return "LANGCHAIN_CHATCHAT";
    }

    protected ChatCompletionResult onChatCompletion(ChatCompletionRequest chatCompletionRequest) throws Throwable {
        String strQuery = null;
        ArrayList historyList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
            for (int i = 0; i < chatCompletionRequest.getMessages().size() - 1; ++i) {
                ChatMessage message = (ChatMessage)chatCompletionRequest.getMessages().get(i);
                if (!StringUtils.hasLength((String)message.getRole())) continue;
                LinkedHashMap<String, String> history = new LinkedHashMap<String, String>();
                history.put("role", message.getRole().toLowerCase());
                history.put("content", message.getContent());
                historyList.add(history);
            }
            ChatMessage lastMessage = (ChatMessage)chatCompletionRequest.getMessages().get(chatCompletionRequest.getMessages().size() - 1);
            strQuery = lastMessage.getContent();
        }
        if (!StringUtils.hasLength(strQuery)) {
            throw new Exception("\u672a\u4f20\u5165\u67e5\u8be2\u5185\u5bb9");
        }
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("query", strQuery);
        body.put("history", historyList);
        body.put("stream", false);
        body.put("model_name", "bc2-13b-chat");
        body.put("temperature", 0.7);
        IWebClientRep rep = this.getAIService().post("/chat/chat", null, body);
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setRole(ChatMessageRole.ASSISTANT.getValue());
        chatMessage.setContent((String)rep.getBody());
        ArrayList<ChatMessage> retMessageList = new ArrayList<ChatMessage>();
        retMessageList.add(chatMessage);
        ChatCompletionResult chatCompletionResult = new ChatCompletionResult();
        chatCompletionResult.setChoices(retMessageList);
        return chatCompletionResult;
    }

    protected CompletionResult onCompletion(CompletionRequest completionRequest) throws Throwable {
        return null;
    }
}

