/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.ai.baichuanai.addin;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.ai.core.addin.AIAccessAgentBase2;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.ChatMessageRole;
import net.ibizsys.central.cloud.core.util.domain.CompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.CompletionResult;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BaichuanAIAccessAgent
extends AIAccessAgentBase2 {
    private static final Log log = LogFactory.getLog(BaichuanAIAccessAgent.class);

    protected void onInit() throws Exception {
        super.onInit();
    }

    protected void runAuthTimer() {
    }

    public String getName() {
        return "BAICHUAN";
    }

    protected ChatCompletionResult onChatCompletion(ChatCompletionRequest chatCompletionRequest) throws Throwable {
        ArrayList historyList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)chatCompletionRequest.getMessages())) {
            for (int i = 0; i < chatCompletionRequest.getMessages().size(); ++i) {
                ChatMessage message = (ChatMessage)chatCompletionRequest.getMessages().get(i);
                if (!StringUtils.hasLength((String)message.getRole())) continue;
                LinkedHashMap<String, String> history = new LinkedHashMap<String, String>();
                history.put("role", message.getRole().toLowerCase());
                if (message.getRole().equalsIgnoreCase(ChatMessageRole.SYSTEM.getValue())) {
                    history.put("role", ChatMessageRole.USER.getValue().toLowerCase());
                }
                history.put("content", message.getContent());
                historyList.add(history);
            }
        }
        if (ObjectUtils.isEmpty(historyList)) {
            throw new Exception("\u672a\u4f20\u5165\u67e5\u8be2\u5185\u5bb9");
        }
        boolean bStream = true;
        String strServiceUrl = bStream ? String.format("%1$s/v1/stream/chat", this.getAgentData().getServiceUrl()) : String.format("%1$s/v1/chat", this.getAgentData().getServiceUrl());
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            ActionSession actionSession = ActionSessionManager.getCurrentSession();
            HttpPost request = new HttpPost(strServiceUrl);
            long nTime = System.currentTimeMillis() / 1000L;
            request.addHeader("Content-Type", "application/json");
            request.setHeader("Authorization", "Bearer " + this.getAgentData().getAccessKey());
            request.setHeader("X-BC-Timestamp", Long.toString(nTime));
            request.setHeader("X-BC-Sign-Algo", "MD5");
            LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
            body.put("messages", historyList);
            body.put("model", "Baichuan2-53B");
            LinkedHashMap<String, Float> parameters = new LinkedHashMap<String, Float>();
            if (chatCompletionRequest.getTemperature() != null) {
                parameters.put("temperature", chatCompletionRequest.getTemperature());
            }
            if (parameters.size() > 0) {
                body.put("parameters", parameters);
            }
            String strBody = JsonUtils.toString(body);
            String strSignature = KeyValueUtils.genMD5Ex((String)(this.getAgentData().getSecretKey() + strBody + Long.toString(nTime)));
            request.setHeader("X-BC-Signature", strSignature);
            StringEntity entity = new StringEntity(strBody, ContentType.APPLICATION_JSON.getMimeType(), "UTF-8");
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Throwable throwable2;
                ArrayList<ChatMessage> retMessageList = new ArrayList<ChatMessage>();
                HttpEntity responseEntity = response.getEntity();
                if (bStream) {
                    throwable2 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseEntity.getContent()));){
                        String line;
                        StringBuilder sb = new StringBuilder();
                        String strRole = null;
                        String strFinishReason = null;
                        while ((line = reader.readLine()) != null) {
                            if (!StringUtils.hasLength((String)line)) continue;
                            Map ret = JsonUtils.asMap((Object)line);
                            Object code = ret.get("code");
                            if (DataTypeUtils.getIntegerValue(code, (Integer)-1) == 0) {
                                Object messages;
                                Object data = ret.get("data");
                                if (data instanceof Map && (messages = ((Map)data).get("messages")) instanceof List) {
                                    List list = (List)messages;
                                    for (Object message : list) {
                                        if (!(message instanceof Map)) continue;
                                        Map map = (Map)message;
                                        strRole = (String)map.get("role");
                                        String strContent = (String)map.get("content");
                                        strFinishReason = (String)map.get("finish_reason");
                                        if (!StringUtils.isEmpty((Object)strRole) && !StringUtils.isEmpty((Object)strContent)) {
                                            sb.append(strContent);
                                            if (actionSession == null) continue;
                                            actionSession.updateActionStep(strContent, sb.toString());
                                            continue;
                                        }
                                        log.error((Object)String.format("\u8fd4\u56de\u5185\u5bb9\u65e0\u6548", new Object[0]));
                                    }
                                }
                            } else {
                                throw new Exception(String.format("\u8bf7\u6c42\u53d1\u751f\u9519\u8bef\uff0c%1$s", ret.get("msg")));
                            }
                            if (!StringUtils.hasLength(strFinishReason)) continue;
                            break;
                        }
                        String strContent = sb.toString();
                        if (!StringUtils.isEmpty(strRole) && !StringUtils.isEmpty((Object)strContent)) {
                            ChatMessage chatMessage = new ChatMessage();
                            chatMessage.setRole(strRole.toUpperCase());
                            chatMessage.setContent(sb.toString());
                            retMessageList.add(chatMessage);
                        }
                        log.error((Object)String.format("\u8fd4\u56de\u5185\u5bb9\u65e0\u6548", new Object[0]));
                    }
                    catch (Throwable sb) {
                        throwable2 = sb;
                        throw sb;
                    }
                } else {
                    String responseBody = EntityUtils.toString((HttpEntity)responseEntity);
                    Map ret = JsonUtils.asMap((Object)responseBody);
                    Object code = ret.get("code");
                    if (DataTypeUtils.getIntegerValue(code, (Integer)-1) == 0) {
                        Object messages;
                        Object data = ret.get("data");
                        if (data instanceof Map && (messages = ((Map)data).get("messages")) instanceof List) {
                            List list = (List)messages;
                            for (Object message : list) {
                                if (!(message instanceof Map)) continue;
                                Map map = (Map)message;
                                String strRole = (String)map.get("role");
                                String strContent = (String)map.get("content");
                                if (StringUtils.isEmpty((Object)strRole) || StringUtils.isEmpty((Object)strContent)) {
                                    log.error((Object)String.format("\u8fd4\u56de\u5185\u5bb9\u65e0\u6548", new Object[0]));
                                    continue;
                                }
                                ChatMessage chatMessage = new ChatMessage();
                                chatMessage.setRole(strRole.toUpperCase());
                                chatMessage.setContent(strContent);
                                retMessageList.add(chatMessage);
                            }
                        }
                    } else {
                        throw new Exception(String.format("\u8bf7\u6c42\u53d1\u751f\u9519\u8bef\uff0c%1$s", ret.get("msg")));
                    }
                }
                if (ObjectUtils.isEmpty(retMessageList)) {
                    throw new Exception(String.format("\u672a\u8fd4\u56de\u4efb\u4f55\u5185\u5bb9", new Object[0]));
                }
                ChatCompletionResult chatCompletionResult = new ChatCompletionResult();
                chatCompletionResult.setChoices(retMessageList);
                throwable2 = chatCompletionResult;
                return throwable2;
            }
            try {
                throw new Exception(String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", response.getStatusLine().getStatusCode()));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    protected CompletionResult onCompletion(CompletionRequest completionRequest) throws Throwable {
        return null;
    }
}

