/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class PSModelServiceSession {
    private static final Log log = LogFactory.getLog(PSModelServiceSession.class);
    public static final String PARAM_URL = "url";
    public static final String PARAM_BEARER = "bearer";
    public static final String PARAM_PSDEVSLNSYSID = "psdevslnsysid";
    public static final String PARAM_ACCESSTOKENURL = "accesstokenurl";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_IMPORTMODE = "importmode";
    private static ThreadLocal<PSModelServiceSession> current = new ThreadLocal();
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private String strServiceUrl = null;
    private String strAccessTokenUrl = null;
    private String strPSDevSlnSysId = null;
    private String strBearer = null;
    private boolean bImportMode = true;
    private String strUserName = null;
    private String strPassword = null;

    public static PSModelServiceSession getCurrent() throws Exception {
        return PSModelServiceSession.getCurrent(false);
    }

    public static void setCurrent(PSModelServiceSession psModelServiceSession) {
        current.set(psModelServiceSession);
    }

    public static PSModelServiceSession getCurrent(boolean bTry) throws Exception {
        PSModelServiceSession psModelServiceSession = current.get();
        if (psModelServiceSession == null && !bTry) {
            throw new Exception("\u5f53\u524d\u672a\u6253\u5f00\u6a21\u578b\u670d\u52a1\u4f1a\u8bdd");
        }
        return psModelServiceSession;
    }

    public static PSModelServiceSession open() throws Exception {
        return PSModelServiceSession.open(true);
    }

    public static PSModelServiceSession open(boolean bMustCreate) throws Exception {
        PSModelServiceSession psModelServiceSession = current.get();
        if (psModelServiceSession != null && bMustCreate) {
            throw new Exception("\u5f53\u524d\u5df2\u6253\u5f00\u6a21\u578b\u670d\u52a1\u4f1a\u8bdd");
        }
        psModelServiceSession = new PSModelServiceSession();
        current.set(psModelServiceSession);
        return psModelServiceSession;
    }

    public static PSModelServiceSession open(Map<String, Object> params) throws Exception {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.open(true);
        String strUrl = DataTypeUtils.getStringValue(params.get(PARAM_URL), null);
        String strBearer = DataTypeUtils.getStringValue(params.get(PARAM_BEARER), null);
        String strPSDevSlnSysId = DataTypeUtils.getStringValue(params.get(PARAM_PSDEVSLNSYSID), null);
        String strAccessTokenUrl = DataTypeUtils.getStringValue(params.get(PARAM_ACCESSTOKENURL), null);
        String strUserName = DataTypeUtils.getStringValue(params.get(PARAM_USERNAME), null);
        String strPassword = DataTypeUtils.getStringValue(params.get(PARAM_PASSWORD), null);
        boolean bImportMode = DataTypeUtils.getBooleanValue(params.get(PARAM_IMPORTMODE), false);
        psModelServiceSession.setServiceUrl(strUrl);
        psModelServiceSession.setBearer(strBearer);
        psModelServiceSession.setPSDevSlnSysId(strPSDevSlnSysId);
        psModelServiceSession.setImportMode(bImportMode);
        if (!StringUtils.hasLength((String)strBearer)) {
            psModelServiceSession.setAccessTokenUrl(strAccessTokenUrl);
            psModelServiceSession.setUserName(strUserName);
            psModelServiceSession.setPassword(strPassword);
        }
        return psModelServiceSession;
    }

    public static void close(boolean bCommit) {
        PSModelServiceSession psModelServiceSession = current.get();
        if (psModelServiceSession == null) {
            return;
        }
        if (bCommit) {
            psModelServiceSession.commit();
        } else {
            psModelServiceSession.rollback();
        }
        current.set(null);
    }

    public void commit() {
    }

    public void rollback() {
    }

    public PSModelServiceSession setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
        return this;
    }

    public PSModelServiceSession setAccessTokenUrl(String strAccessTokenUrl) {
        this.strAccessTokenUrl = strAccessTokenUrl;
        return this;
    }

    public PSModelServiceSession setPSDevSlnSysId(String strPSDevSlnSysId) {
        this.strPSDevSlnSysId = strPSDevSlnSysId;
        return this;
    }

    public PSModelServiceSession setBearer(String strBearer) {
        this.strBearer = strBearer;
        return this;
    }

    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    public String getAccessTokenUrl() {
        return this.strAccessTokenUrl;
    }

    public String getPSDevSlnSysId() {
        return this.strPSDevSlnSysId;
    }

    public String getBearer() {
        return this.strBearer;
    }

    public PSModelServiceSession setImportMode(boolean bImportMode) {
        this.bImportMode = bImportMode;
        return this;
    }

    public boolean isImportMode() {
        return this.bImportMode;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public PSModelServiceSession setUserName(String strUserName) {
        this.strUserName = strUserName;
        return this;
    }

    public String getPassword() {
        return this.strPassword;
    }

    public PSModelServiceSession setPassword(String strPassword) {
        this.strPassword = strPassword;
        return this;
    }

    public Object getAttribute(String strName) {
        return this.attributeMap.get(strName);
    }

    public PSModelServiceSession setAttribute(String strName, Object objValue) {
        this.attributeMap.put(strName, objValue);
        return this;
    }
}

