package net.ibizsys.centralstudio.dto;

import java.math.BigDecimal;
import java.sql.Timestamp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * <B>PSAPPMENU</B>应用菜单 模型传输对象
 * <P>
 * 应用菜单模型，定义应用菜单部件的界面及处理逻辑。应用菜单包含多类型、多层级的菜单项模型。应用菜单及菜单项都支持布局定义，除了传统的菜单样式，还支持卡片视图等样式
 */
public class PSAppMenuDTO extends net.ibizsys.centralstudio.util.PSModelDTOBase {

    public PSAppMenuDTO(){
    }      

    /**
     * <B>APPMENUSTYLE</B>&nbsp;应用菜单样式，指定应用菜单的内置样式
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.AppMenuStyle} 
     */
    public final static String FIELD_APPMENUSTYLE = "appmenustyle";

    /**
     * 设置 应用菜单样式，详细说明：{@link #FIELD_APPMENUSTYLE}
     * 
     * @param appMenuStyle
     * 
     */
    @JsonProperty(FIELD_APPMENUSTYLE)
    public void setAppMenuStyle(String appMenuStyle){
        this.set(FIELD_APPMENUSTYLE, appMenuStyle);
    }
    
    /**
     * 获取 应用菜单样式  
     * @return
     */
    @JsonIgnore
    public String getAppMenuStyle(){
        Object objValue = this.get(FIELD_APPMENUSTYLE);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 应用菜单样式 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isAppMenuStyleDirty(){
        if(this.contains(FIELD_APPMENUSTYLE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 应用菜单样式
     */
    @JsonIgnore
    public void resetAppMenuStyle(){
        this.reset(FIELD_APPMENUSTYLE);
    }

    /**
     * 设置 应用菜单样式，详细说明：{@link #FIELD_APPMENUSTYLE}
     * <P>
     * 等同 {@link #setAppMenuStyle}
     * @param appMenuStyle
     */
    @JsonIgnore
    public PSAppMenuDTO appmenustyle(String appMenuStyle){
        this.setAppMenuStyle(appMenuStyle);
        return this;
    }

     /**
     * 设置 应用菜单样式，详细说明：{@link #FIELD_APPMENUSTYLE}
     * <P>
     * 等同 {@link #setAppMenuStyle}
     * @param appMenuStyle
     */
    @JsonIgnore
    public PSAppMenuDTO appmenustyle(net.ibizsys.model.PSModelEnums.AppMenuStyle appMenuStyle){
        if(appMenuStyle == null){
            this.setAppMenuStyle(null);
        }
        else{
            this.setAppMenuStyle(appMenuStyle.value);
        }
        return this;
    }

    /**
     * <B>CODENAME</B>&nbsp;代码标识，指定应用菜单的代码标识，需要在所在的前端应用中具有唯一性
     * <P>
     * 字符串：最大长度 100，由字母、数字、下划线组成，且开始必须为字母
     */
    public final static String FIELD_CODENAME = "codename";

    /**
     * 设置 代码标识，详细说明：{@link #FIELD_CODENAME}
     * 
     * @param codeName
     * 
     */
    @JsonProperty(FIELD_CODENAME)
    public void setCodeName(String codeName){
        this.set(FIELD_CODENAME, codeName);
    }
    
    /**
     * 获取 代码标识  
     * @return
     */
    @JsonIgnore
    public String getCodeName(){
        Object objValue = this.get(FIELD_CODENAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 代码标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCodeNameDirty(){
        if(this.contains(FIELD_CODENAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 代码标识
     */
    @JsonIgnore
    public void resetCodeName(){
        this.reset(FIELD_CODENAME);
    }

    /**
     * 设置 代码标识，详细说明：{@link #FIELD_CODENAME}
     * <P>
     * 等同 {@link #setCodeName}
     * @param codeName
     */
    @JsonIgnore
    public PSAppMenuDTO codename(String codeName){
        this.setCodeName(codeName);
        return this;
    }

    /**
     * <B>CREATEDATE</B>&nbsp;建立时间
     */
    public final static String FIELD_CREATEDATE = "createdate";

    /**
     * 设置 建立时间
     * 
     * @param createDate
     * 
     */
    @JsonProperty(FIELD_CREATEDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    public void setCreateDate(Timestamp createDate){
        this.set(FIELD_CREATEDATE, createDate);
    }
    
    /**
     * 获取 建立时间  
     * @return
     */
    @JsonIgnore
    public Timestamp getCreateDate(){
        Object objValue = this.get(FIELD_CREATEDATE);
        if(objValue==null){
            return null;
        }
        return (Timestamp)objValue;
    }

    /**
     * 判断 建立时间 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCreateDateDirty(){
        if(this.contains(FIELD_CREATEDATE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 建立时间
     */
    @JsonIgnore
    public void resetCreateDate(){
        this.reset(FIELD_CREATEDATE);
    }

    /**
     * 设置 建立时间
     * <P>
     * 等同 {@link #setCreateDate}
     * @param createDate
     */
    @JsonIgnore
    public PSAppMenuDTO createdate(Timestamp createDate){
        this.setCreateDate(createDate);
        return this;
    }

    /**
     * <B>CREATEMAN</B>&nbsp;建立人
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_CREATEMAN = "createman";

    /**
     * 设置 建立人
     * 
     * @param createMan
     * 
     */
    @JsonProperty(FIELD_CREATEMAN)
    public void setCreateMan(String createMan){
        this.set(FIELD_CREATEMAN, createMan);
    }
    
    /**
     * 获取 建立人  
     * @return
     */
    @JsonIgnore
    public String getCreateMan(){
        Object objValue = this.get(FIELD_CREATEMAN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 建立人 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCreateManDirty(){
        if(this.contains(FIELD_CREATEMAN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 建立人
     */
    @JsonIgnore
    public void resetCreateMan(){
        this.reset(FIELD_CREATEMAN);
    }

    /**
     * 设置 建立人
     * <P>
     * 等同 {@link #setCreateMan}
     * @param createMan
     */
    @JsonIgnore
    public PSAppMenuDTO createman(String createMan){
        this.setCreateMan(createMan);
        return this;
    }

    /**
     * <B>CUSTOMIZEDFLAG</B>&nbsp;支持自定义，指定应用菜单是否支持自定义，未定义时为【否】
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.YesNo} 
     */
    public final static String FIELD_CUSTOMIZEDFLAG = "customizedflag";

    /**
     * 设置 支持自定义，详细说明：{@link #FIELD_CUSTOMIZEDFLAG}
     * 
     * @param customizedFlag
     * 
     */
    @JsonProperty(FIELD_CUSTOMIZEDFLAG)
    public void setCustomizedFlag(Integer customizedFlag){
        this.set(FIELD_CUSTOMIZEDFLAG, customizedFlag);
    }
    
    /**
     * 获取 支持自定义  
     * @return
     */
    @JsonIgnore
    public Integer getCustomizedFlag(){
        Object objValue = this.get(FIELD_CUSTOMIZEDFLAG);
        if(objValue==null){
            return null;
        }
        return (Integer)objValue;
    }

    /**
     * 判断 支持自定义 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isCustomizedFlagDirty(){
        if(this.contains(FIELD_CUSTOMIZEDFLAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 支持自定义
     */
    @JsonIgnore
    public void resetCustomizedFlag(){
        this.reset(FIELD_CUSTOMIZEDFLAG);
    }

    /**
     * 设置 支持自定义，详细说明：{@link #FIELD_CUSTOMIZEDFLAG}
     * <P>
     * 等同 {@link #setCustomizedFlag}
     * @param customizedFlag
     */
    @JsonIgnore
    public PSAppMenuDTO customizedflag(Integer customizedFlag){
        this.setCustomizedFlag(customizedFlag);
        return this;
    }

     /**
     * 设置 支持自定义，详细说明：{@link #FIELD_CUSTOMIZEDFLAG}
     * <P>
     * 等同 {@link #setCustomizedFlag}
     * @param customizedFlag
     */
    @JsonIgnore
    public PSAppMenuDTO customizedflag(Boolean customizedFlag){
        if(customizedFlag == null){
            this.setCustomizedFlag(null);
        }
        else{
            this.setCustomizedFlag(customizedFlag?BOOLEAN_TRUE:BOOLEAN_FALSE);
        }
        return this;
    }

    /**
     * <B>FLEXALIGN</B>&nbsp;Flex横轴对齐，应用菜单部件布局模式为【Flex布局】时指定横轴对齐方式
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.FlexAlign} 
     */
    public final static String FIELD_FLEXALIGN = "flexalign";

    /**
     * 设置 Flex横轴对齐，详细说明：{@link #FIELD_FLEXALIGN}
     * 
     * @param flexAlign
     * 
     */
    @JsonProperty(FIELD_FLEXALIGN)
    public void setFlexAlign(String flexAlign){
        this.set(FIELD_FLEXALIGN, flexAlign);
    }
    
    /**
     * 获取 Flex横轴对齐  
     * @return
     */
    @JsonIgnore
    public String getFlexAlign(){
        Object objValue = this.get(FIELD_FLEXALIGN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 Flex横轴对齐 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isFlexAlignDirty(){
        if(this.contains(FIELD_FLEXALIGN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 Flex横轴对齐
     */
    @JsonIgnore
    public void resetFlexAlign(){
        this.reset(FIELD_FLEXALIGN);
    }

    /**
     * 设置 Flex横轴对齐，详细说明：{@link #FIELD_FLEXALIGN}
     * <P>
     * 等同 {@link #setFlexAlign}
     * @param flexAlign
     */
    @JsonIgnore
    public PSAppMenuDTO flexalign(String flexAlign){
        this.setFlexAlign(flexAlign);
        return this;
    }

     /**
     * 设置 Flex横轴对齐，详细说明：{@link #FIELD_FLEXALIGN}
     * <P>
     * 等同 {@link #setFlexAlign}
     * @param flexAlign
     */
    @JsonIgnore
    public PSAppMenuDTO flexalign(net.ibizsys.model.PSModelEnums.FlexAlign flexAlign){
        if(flexAlign == null){
            this.setFlexAlign(null);
        }
        else{
            this.setFlexAlign(flexAlign.value);
        }
        return this;
    }

    /**
     * <B>FLEXDIR</B>&nbsp;Flex布局方向，应用菜单部件布局模式为【Flex布局】时指定布局方向
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.FlexLayoutDir} 
     */
    public final static String FIELD_FLEXDIR = "flexdir";

    /**
     * 设置 Flex布局方向，详细说明：{@link #FIELD_FLEXDIR}
     * 
     * @param flexDir
     * 
     */
    @JsonProperty(FIELD_FLEXDIR)
    public void setFlexDir(String flexDir){
        this.set(FIELD_FLEXDIR, flexDir);
    }
    
    /**
     * 获取 Flex布局方向  
     * @return
     */
    @JsonIgnore
    public String getFlexDir(){
        Object objValue = this.get(FIELD_FLEXDIR);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 Flex布局方向 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isFlexDirDirty(){
        if(this.contains(FIELD_FLEXDIR)){
            return true;
        }
        return false;
    }

    /**
     * 重置 Flex布局方向
     */
    @JsonIgnore
    public void resetFlexDir(){
        this.reset(FIELD_FLEXDIR);
    }

    /**
     * 设置 Flex布局方向，详细说明：{@link #FIELD_FLEXDIR}
     * <P>
     * 等同 {@link #setFlexDir}
     * @param flexDir
     */
    @JsonIgnore
    public PSAppMenuDTO flexdir(String flexDir){
        this.setFlexDir(flexDir);
        return this;
    }

     /**
     * 设置 Flex布局方向，详细说明：{@link #FIELD_FLEXDIR}
     * <P>
     * 等同 {@link #setFlexDir}
     * @param flexDir
     */
    @JsonIgnore
    public PSAppMenuDTO flexdir(net.ibizsys.model.PSModelEnums.FlexLayoutDir flexDir){
        if(flexDir == null){
            this.setFlexDir(null);
        }
        else{
            this.setFlexDir(flexDir.value);
        }
        return this;
    }

    /**
     * <B>FLEXVALIGN</B>&nbsp;Flex纵轴对齐，应用菜单部件布局模式为【Flex布局】时指定纵轴对齐方式
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.FlexVAlign} 
     */
    public final static String FIELD_FLEXVALIGN = "flexvalign";

    /**
     * 设置 Flex纵轴对齐，详细说明：{@link #FIELD_FLEXVALIGN}
     * 
     * @param flexVAlign
     * 
     */
    @JsonProperty(FIELD_FLEXVALIGN)
    public void setFlexVAlign(String flexVAlign){
        this.set(FIELD_FLEXVALIGN, flexVAlign);
    }
    
    /**
     * 获取 Flex纵轴对齐  
     * @return
     */
    @JsonIgnore
    public String getFlexVAlign(){
        Object objValue = this.get(FIELD_FLEXVALIGN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 Flex纵轴对齐 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isFlexVAlignDirty(){
        if(this.contains(FIELD_FLEXVALIGN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 Flex纵轴对齐
     */
    @JsonIgnore
    public void resetFlexVAlign(){
        this.reset(FIELD_FLEXVALIGN);
    }

    /**
     * 设置 Flex纵轴对齐，详细说明：{@link #FIELD_FLEXVALIGN}
     * <P>
     * 等同 {@link #setFlexVAlign}
     * @param flexVAlign
     */
    @JsonIgnore
    public PSAppMenuDTO flexvalign(String flexVAlign){
        this.setFlexVAlign(flexVAlign);
        return this;
    }

     /**
     * 设置 Flex纵轴对齐，详细说明：{@link #FIELD_FLEXVALIGN}
     * <P>
     * 等同 {@link #setFlexVAlign}
     * @param flexVAlign
     */
    @JsonIgnore
    public PSAppMenuDTO flexvalign(net.ibizsys.model.PSModelEnums.FlexVAlign flexVAlign){
        if(flexVAlign == null){
            this.setFlexVAlign(null);
        }
        else{
            this.setFlexVAlign(flexVAlign.value);
        }
        return this;
    }

    /**
     * <B>FROMOBJID</B>&nbsp;源标识
     * <P>
     * 字符串：最大长度 100
     */
    public final static String FIELD_FROMOBJID = "fromobjid";

    /**
     * 设置 源标识
     * 
     * @param fromObjId
     * 
     */
    @JsonProperty(FIELD_FROMOBJID)
    public void setFromObjId(String fromObjId){
        this.set(FIELD_FROMOBJID, fromObjId);
    }
    
    /**
     * 获取 源标识  
     * @return
     */
    @JsonIgnore
    public String getFromObjId(){
        Object objValue = this.get(FIELD_FROMOBJID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 源标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isFromObjIdDirty(){
        if(this.contains(FIELD_FROMOBJID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 源标识
     */
    @JsonIgnore
    public void resetFromObjId(){
        this.reset(FIELD_FROMOBJID);
    }

    /**
     * 设置 源标识
     * <P>
     * 等同 {@link #setFromObjId}
     * @param fromObjId
     */
    @JsonIgnore
    public PSAppMenuDTO fromobjid(String fromObjId){
        this.setFromObjId(fromObjId);
        return this;
    }

    /**
     * <B>ICONALIGN</B>&nbsp;默认图标位置
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.ButtonIconAlign} 
     */
    public final static String FIELD_ICONALIGN = "iconalign";

    /**
     * 设置 默认图标位置
     * 
     * @param iconAlign
     * 
     */
    @JsonProperty(FIELD_ICONALIGN)
    public void setIconAlign(String iconAlign){
        this.set(FIELD_ICONALIGN, iconAlign);
    }
    
    /**
     * 获取 默认图标位置  
     * @return
     */
    @JsonIgnore
    public String getIconAlign(){
        Object objValue = this.get(FIELD_ICONALIGN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 默认图标位置 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isIconAlignDirty(){
        if(this.contains(FIELD_ICONALIGN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 默认图标位置
     */
    @JsonIgnore
    public void resetIconAlign(){
        this.reset(FIELD_ICONALIGN);
    }

    /**
     * 设置 默认图标位置
     * <P>
     * 等同 {@link #setIconAlign}
     * @param iconAlign
     */
    @JsonIgnore
    public PSAppMenuDTO iconalign(String iconAlign){
        this.setIconAlign(iconAlign);
        return this;
    }

     /**
     * 设置 默认图标位置
     * <P>
     * 等同 {@link #setIconAlign}
     * @param iconAlign
     */
    @JsonIgnore
    public PSAppMenuDTO iconalign(net.ibizsys.model.PSModelEnums.ButtonIconAlign iconAlign){
        if(iconAlign == null){
            this.setIconAlign(null);
        }
        else{
            this.setIconAlign(iconAlign.value);
        }
        return this;
    }

    /**
     * <B>JSMODEL</B>&nbsp;Json模型
     */
    public final static String FIELD_JSMODEL = "jsmodel";

    /**
     * 设置 Json模型
     * 
     * @param jSModel
     * 
     */
    @JsonProperty(FIELD_JSMODEL)
    public void setJSModel(String jSModel){
        this.set(FIELD_JSMODEL, jSModel);
    }
    
    /**
     * 获取 Json模型  
     * @return
     */
    @JsonIgnore
    public String getJSModel(){
        Object objValue = this.get(FIELD_JSMODEL);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 Json模型 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isJSModelDirty(){
        if(this.contains(FIELD_JSMODEL)){
            return true;
        }
        return false;
    }

    /**
     * 重置 Json模型
     */
    @JsonIgnore
    public void resetJSModel(){
        this.reset(FIELD_JSMODEL);
    }

    /**
     * 设置 Json模型
     * <P>
     * 等同 {@link #setJSModel}
     * @param jSModel
     */
    @JsonIgnore
    public PSAppMenuDTO jsmodel(String jSModel){
        this.setJSModel(jSModel);
        return this;
    }

    /**
     * <B>LAYOUTMODE</B>&nbsp;布局模式，指定应用菜单容器的布局模式，未定义时使用前端应用使用模板的默认布局模式
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.LayoutMode} 
     */
    public final static String FIELD_LAYOUTMODE = "layoutmode";

    /**
     * 设置 布局模式，详细说明：{@link #FIELD_LAYOUTMODE}
     * 
     * @param layoutMode
     * 
     */
    @JsonProperty(FIELD_LAYOUTMODE)
    public void setLayoutMode(String layoutMode){
        this.set(FIELD_LAYOUTMODE, layoutMode);
    }
    
    /**
     * 获取 布局模式  
     * @return
     */
    @JsonIgnore
    public String getLayoutMode(){
        Object objValue = this.get(FIELD_LAYOUTMODE);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 布局模式 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isLayoutModeDirty(){
        if(this.contains(FIELD_LAYOUTMODE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 布局模式
     */
    @JsonIgnore
    public void resetLayoutMode(){
        this.reset(FIELD_LAYOUTMODE);
    }

    /**
     * 设置 布局模式，详细说明：{@link #FIELD_LAYOUTMODE}
     * <P>
     * 等同 {@link #setLayoutMode}
     * @param layoutMode
     */
    @JsonIgnore
    public PSAppMenuDTO layoutmode(String layoutMode){
        this.setLayoutMode(layoutMode);
        return this;
    }

     /**
     * 设置 布局模式，详细说明：{@link #FIELD_LAYOUTMODE}
     * <P>
     * 等同 {@link #setLayoutMode}
     * @param layoutMode
     */
    @JsonIgnore
    public PSAppMenuDTO layoutmode(net.ibizsys.model.PSModelEnums.LayoutMode layoutMode){
        if(layoutMode == null){
            this.setLayoutMode(null);
        }
        else{
            this.setLayoutMode(layoutMode.value);
        }
        return this;
    }

    /**
     * <B>LOGICNAME</B>&nbsp;中文名称，指定应用菜单的逻辑名称
     * <P>
     * 字符串：最大长度 100
     */
    public final static String FIELD_LOGICNAME = "logicname";

    /**
     * 设置 中文名称，详细说明：{@link #FIELD_LOGICNAME}
     * 
     * @param logicName
     * 
     */
    @JsonProperty(FIELD_LOGICNAME)
    public void setLogicName(String logicName){
        this.set(FIELD_LOGICNAME, logicName);
    }
    
    /**
     * 获取 中文名称  
     * @return
     */
    @JsonIgnore
    public String getLogicName(){
        Object objValue = this.get(FIELD_LOGICNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 中文名称 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isLogicNameDirty(){
        if(this.contains(FIELD_LOGICNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 中文名称
     */
    @JsonIgnore
    public void resetLogicName(){
        this.reset(FIELD_LOGICNAME);
    }

    /**
     * 设置 中文名称，详细说明：{@link #FIELD_LOGICNAME}
     * <P>
     * 等同 {@link #setLogicName}
     * @param logicName
     */
    @JsonIgnore
    public PSAppMenuDTO logicname(String logicName){
        this.setLogicName(logicName);
        return this;
    }

    /**
     * <B>MEMO</B>&nbsp;备注
     * <P>
     * 字符串：最大长度 2000
     */
    public final static String FIELD_MEMO = "memo";

    /**
     * 设置 备注
     * 
     * @param memo
     * 
     */
    @JsonProperty(FIELD_MEMO)
    public void setMemo(String memo){
        this.set(FIELD_MEMO, memo);
    }
    
    /**
     * 获取 备注  
     * @return
     */
    @JsonIgnore
    public String getMemo(){
        Object objValue = this.get(FIELD_MEMO);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 备注 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isMemoDirty(){
        if(this.contains(FIELD_MEMO)){
            return true;
        }
        return false;
    }

    /**
     * 重置 备注
     */
    @JsonIgnore
    public void resetMemo(){
        this.reset(FIELD_MEMO);
    }

    /**
     * 设置 备注
     * <P>
     * 等同 {@link #setMemo}
     * @param memo
     */
    @JsonIgnore
    public PSAppMenuDTO memo(String memo){
        this.setMemo(memo);
        return this;
    }

    /**
     * <B>MENUSN</B>&nbsp;菜单编号，指定应用菜单的编号
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_MENUSN = "menusn";

    /**
     * 设置 菜单编号，详细说明：{@link #FIELD_MENUSN}
     * 
     * @param menuSN
     * 
     */
    @JsonProperty(FIELD_MENUSN)
    public void setMenuSN(String menuSN){
        this.set(FIELD_MENUSN, menuSN);
    }
    
    /**
     * 获取 菜单编号  
     * @return
     */
    @JsonIgnore
    public String getMenuSN(){
        Object objValue = this.get(FIELD_MENUSN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 菜单编号 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isMenuSNDirty(){
        if(this.contains(FIELD_MENUSN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 菜单编号
     */
    @JsonIgnore
    public void resetMenuSN(){
        this.reset(FIELD_MENUSN);
    }

    /**
     * 设置 菜单编号，详细说明：{@link #FIELD_MENUSN}
     * <P>
     * 等同 {@link #setMenuSN}
     * @param menuSN
     */
    @JsonIgnore
    public PSAppMenuDTO menusn(String menuSN){
        this.setMenuSN(menuSN);
        return this;
    }

    /**
     * <B>OWNERID</B>&nbsp;所有着标识
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_OWNERID = "ownerid";

    /**
     * 设置 所有着标识
     * 
     * @param ownerId
     * 
     */
    @JsonProperty(FIELD_OWNERID)
    public void setOwnerId(String ownerId){
        this.set(FIELD_OWNERID, ownerId);
    }
    
    /**
     * 获取 所有着标识  
     * @return
     */
    @JsonIgnore
    public String getOwnerId(){
        Object objValue = this.get(FIELD_OWNERID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 所有着标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isOwnerIdDirty(){
        if(this.contains(FIELD_OWNERID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 所有着标识
     */
    @JsonIgnore
    public void resetOwnerId(){
        this.reset(FIELD_OWNERID);
    }

    /**
     * 设置 所有着标识
     * <P>
     * 等同 {@link #setOwnerId}
     * @param ownerId
     */
    @JsonIgnore
    public PSAppMenuDTO ownerid(String ownerId){
        this.setOwnerId(ownerId);
        return this;
    }

    /**
     * <B>OWNERTAG</B>&nbsp;所有者标记
     * <P>
     * 字符串：最大长度 20
     */
    public final static String FIELD_OWNERTAG = "ownertag";

    /**
     * 设置 所有者标记
     * 
     * @param ownerTag
     * 
     */
    @JsonProperty(FIELD_OWNERTAG)
    public void setOwnerTag(String ownerTag){
        this.set(FIELD_OWNERTAG, ownerTag);
    }
    
    /**
     * 获取 所有者标记  
     * @return
     */
    @JsonIgnore
    public String getOwnerTag(){
        Object objValue = this.get(FIELD_OWNERTAG);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 所有者标记 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isOwnerTagDirty(){
        if(this.contains(FIELD_OWNERTAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 所有者标记
     */
    @JsonIgnore
    public void resetOwnerTag(){
        this.reset(FIELD_OWNERTAG);
    }

    /**
     * 设置 所有者标记
     * <P>
     * 等同 {@link #setOwnerTag}
     * @param ownerTag
     */
    @JsonIgnore
    public PSAppMenuDTO ownertag(String ownerTag){
        this.setOwnerTag(ownerTag);
        return this;
    }

    /**
     * <B>OWNERTYPE</B>&nbsp;所有着类型
     * <P>
     * 字符串：最大长度 40
     */
    public final static String FIELD_OWNERTYPE = "ownertype";

    /**
     * 设置 所有着类型
     * 
     * @param ownerType
     * 
     */
    @JsonProperty(FIELD_OWNERTYPE)
    public void setOwnerType(String ownerType){
        this.set(FIELD_OWNERTYPE, ownerType);
    }
    
    /**
     * 获取 所有着类型  
     * @return
     */
    @JsonIgnore
    public String getOwnerType(){
        Object objValue = this.get(FIELD_OWNERTYPE);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 所有着类型 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isOwnerTypeDirty(){
        if(this.contains(FIELD_OWNERTYPE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 所有着类型
     */
    @JsonIgnore
    public void resetOwnerType(){
        this.reset(FIELD_OWNERTYPE);
    }

    /**
     * 设置 所有着类型
     * <P>
     * 等同 {@link #setOwnerType}
     * @param ownerType
     */
    @JsonIgnore
    public PSAppMenuDTO ownertype(String ownerType){
        this.setOwnerType(ownerType);
        return this;
    }

    /**
     * <B>PSAPPMENUID</B>&nbsp;云应用菜单标识
     * <P>
     * 字符串：最大长度 100
     */
    public final static String FIELD_PSAPPMENUID = "psappmenuid";

    /**
     * 设置 云应用菜单标识
     * 
     * @param pSAppMenuId
     * 
     */
    @JsonProperty(FIELD_PSAPPMENUID)
    public void setPSAppMenuId(String pSAppMenuId){
        this.set(FIELD_PSAPPMENUID, pSAppMenuId);
    }
    
    /**
     * 获取 云应用菜单标识  
     * @return
     */
    @JsonIgnore
    public String getPSAppMenuId(){
        Object objValue = this.get(FIELD_PSAPPMENUID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 云应用菜单标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSAppMenuIdDirty(){
        if(this.contains(FIELD_PSAPPMENUID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 云应用菜单标识
     */
    @JsonIgnore
    public void resetPSAppMenuId(){
        this.reset(FIELD_PSAPPMENUID);
    }

    /**
     * 设置 云应用菜单标识
     * <P>
     * 等同 {@link #setPSAppMenuId}
     * @param pSAppMenuId
     */
    @JsonIgnore
    public PSAppMenuDTO psappmenuid(String pSAppMenuId){
        this.setPSAppMenuId(pSAppMenuId);
        return this;
    }

    /**
     * <B>PSAPPMENUNAME</B>&nbsp;应用菜单标识，指定应用菜单的标识，需在所属前端应用中具备唯一性
     * <P>
     * 字符串：最大长度 200，由字母、数字、下划线组成，且开始必须为字母
     */
    public final static String FIELD_PSAPPMENUNAME = "psappmenuname";

    /**
     * 设置 应用菜单标识，详细说明：{@link #FIELD_PSAPPMENUNAME}
     * 
     * @param pSAppMenuName
     * 
     */
    @JsonProperty(FIELD_PSAPPMENUNAME)
    public void setPSAppMenuName(String pSAppMenuName){
        this.set(FIELD_PSAPPMENUNAME, pSAppMenuName);
    }
    
    /**
     * 获取 应用菜单标识  
     * @return
     */
    @JsonIgnore
    public String getPSAppMenuName(){
        Object objValue = this.get(FIELD_PSAPPMENUNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 应用菜单标识 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSAppMenuNameDirty(){
        if(this.contains(FIELD_PSAPPMENUNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 应用菜单标识
     */
    @JsonIgnore
    public void resetPSAppMenuName(){
        this.reset(FIELD_PSAPPMENUNAME);
    }

    /**
     * 设置 应用菜单标识，详细说明：{@link #FIELD_PSAPPMENUNAME}
     * <P>
     * 等同 {@link #setPSAppMenuName}
     * @param pSAppMenuName
     */
    @JsonIgnore
    public PSAppMenuDTO psappmenuname(String pSAppMenuName){
        this.setPSAppMenuName(pSAppMenuName);
        return this;
    }

    @JsonIgnore
    public String getName(){
        return this.getPSAppMenuName();
    }

    @JsonIgnore
    public void setName(String strName){
        this.setPSAppMenuName(strName);
    }

    @JsonIgnore
    public PSAppMenuDTO name(String strName){
        this.setPSAppMenuName(strName);
        return this;
    }

    /**
     * <B>PSSYSAPPID</B>&nbsp;前端应用，指定应用菜单所属的前端应用
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSSysAppDTO} 
     */
    public final static String FIELD_PSSYSAPPID = "pssysappid";

    /**
     * 设置 前端应用，详细说明：{@link #FIELD_PSSYSAPPID}
     * 
     * @param pSSysAppId
     * 
     */
    @JsonProperty(FIELD_PSSYSAPPID)
    public void setPSSysAppId(String pSSysAppId){
        this.set(FIELD_PSSYSAPPID, pSSysAppId);
    }
    
    /**
     * 获取 前端应用  
     * @return
     */
    @JsonIgnore
    public String getPSSysAppId(){
        Object objValue = this.get(FIELD_PSSYSAPPID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 前端应用 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysAppIdDirty(){
        if(this.contains(FIELD_PSSYSAPPID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 前端应用
     */
    @JsonIgnore
    public void resetPSSysAppId(){
        this.reset(FIELD_PSSYSAPPID);
    }

    /**
     * 设置 前端应用，详细说明：{@link #FIELD_PSSYSAPPID}
     * <P>
     * 等同 {@link #setPSSysAppId}
     * @param pSSysAppId
     */
    @JsonIgnore
    public PSAppMenuDTO pssysappid(String pSSysAppId){
        this.setPSSysAppId(pSSysAppId);
        return this;
    }

    /**
     * 设置 前端应用，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPSSysAppId}
     * @param pSSysApp 引用对象
     */
    @JsonIgnore
    public PSAppMenuDTO pssysappid(PSSysAppDTO pSSysApp){
        if(pSSysApp == null){
            this.setPSSysAppId(null);
            this.setPSSysAppName(null);
        }
        else{
            this.setPSSysAppId(pSSysApp.getPSSysAppId());
            this.setPSSysAppName(pSSysApp.getPSSysAppName());
        }
        return this;
    }

    /**
     * <B>PSSYSAPPNAME</B>&nbsp;前端应用，指定应用菜单所属的前端应用
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PSSYSAPPID}
     */
    public final static String FIELD_PSSYSAPPNAME = "pssysappname";

    /**
     * 设置 前端应用，详细说明：{@link #FIELD_PSSYSAPPNAME}
     * 
     * @param pSSysAppName
     * 
     */
    @JsonProperty(FIELD_PSSYSAPPNAME)
    public void setPSSysAppName(String pSSysAppName){
        this.set(FIELD_PSSYSAPPNAME, pSSysAppName);
    }
    
    /**
     * 获取 前端应用  
     * @return
     */
    @JsonIgnore
    public String getPSSysAppName(){
        Object objValue = this.get(FIELD_PSSYSAPPNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 前端应用 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysAppNameDirty(){
        if(this.contains(FIELD_PSSYSAPPNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 前端应用
     */
    @JsonIgnore
    public void resetPSSysAppName(){
        this.reset(FIELD_PSSYSAPPNAME);
    }

    /**
     * 设置 前端应用，详细说明：{@link #FIELD_PSSYSAPPNAME}
     * <P>
     * 等同 {@link #setPSSysAppName}
     * @param pSSysAppName
     */
    @JsonIgnore
    public PSAppMenuDTO pssysappname(String pSSysAppName){
        this.setPSSysAppName(pSSysAppName);
        return this;
    }

    /**
     * <B>PSSYSCOUNTERID</B>&nbsp;系统计数器，指定应用菜单相关的系统计数器
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSSysCounterDTO} 
     */
    public final static String FIELD_PSSYSCOUNTERID = "pssyscounterid";

    /**
     * 设置 系统计数器，详细说明：{@link #FIELD_PSSYSCOUNTERID}
     * 
     * @param pSSysCounterId
     * 
     */
    @JsonProperty(FIELD_PSSYSCOUNTERID)
    public void setPSSysCounterId(String pSSysCounterId){
        this.set(FIELD_PSSYSCOUNTERID, pSSysCounterId);
    }
    
    /**
     * 获取 系统计数器  
     * @return
     */
    @JsonIgnore
    public String getPSSysCounterId(){
        Object objValue = this.get(FIELD_PSSYSCOUNTERID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统计数器 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysCounterIdDirty(){
        if(this.contains(FIELD_PSSYSCOUNTERID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统计数器
     */
    @JsonIgnore
    public void resetPSSysCounterId(){
        this.reset(FIELD_PSSYSCOUNTERID);
    }

    /**
     * 设置 系统计数器，详细说明：{@link #FIELD_PSSYSCOUNTERID}
     * <P>
     * 等同 {@link #setPSSysCounterId}
     * @param pSSysCounterId
     */
    @JsonIgnore
    public PSAppMenuDTO pssyscounterid(String pSSysCounterId){
        this.setPSSysCounterId(pSSysCounterId);
        return this;
    }

    /**
     * 设置 系统计数器，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPSSysCounterId}
     * @param pSSysCounter 引用对象
     */
    @JsonIgnore
    public PSAppMenuDTO pssyscounterid(PSSysCounterDTO pSSysCounter){
        if(pSSysCounter == null){
            this.setPSSysCounterId(null);
            this.setPSSysCounterName(null);
        }
        else{
            this.setPSSysCounterId(pSSysCounter.getPSSysCounterId());
            this.setPSSysCounterName(pSSysCounter.getPSSysCounterName());
        }
        return this;
    }

    /**
     * <B>PSSYSCOUNTERNAME</B>&nbsp;系统计数器，指定应用菜单相关的系统计数器
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PSSYSCOUNTERID}
     */
    public final static String FIELD_PSSYSCOUNTERNAME = "pssyscountername";

    /**
     * 设置 系统计数器，详细说明：{@link #FIELD_PSSYSCOUNTERNAME}
     * 
     * @param pSSysCounterName
     * 
     */
    @JsonProperty(FIELD_PSSYSCOUNTERNAME)
    public void setPSSysCounterName(String pSSysCounterName){
        this.set(FIELD_PSSYSCOUNTERNAME, pSSysCounterName);
    }
    
    /**
     * 获取 系统计数器  
     * @return
     */
    @JsonIgnore
    public String getPSSysCounterName(){
        Object objValue = this.get(FIELD_PSSYSCOUNTERNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 系统计数器 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysCounterNameDirty(){
        if(this.contains(FIELD_PSSYSCOUNTERNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 系统计数器
     */
    @JsonIgnore
    public void resetPSSysCounterName(){
        this.reset(FIELD_PSSYSCOUNTERNAME);
    }

    /**
     * 设置 系统计数器，详细说明：{@link #FIELD_PSSYSCOUNTERNAME}
     * <P>
     * 等同 {@link #setPSSysCounterName}
     * @param pSSysCounterName
     */
    @JsonIgnore
    public PSAppMenuDTO pssyscountername(String pSSysCounterName){
        this.setPSSysCounterName(pSSysCounterName);
        return this;
    }

    /**
     * <B>PSSYSPFPLUGINID</B>&nbsp;前端扩展插件，指定应用菜单使用的前端模板扩展插件，使用插件类型【应用菜单绘制插件】
     * <P>
     * 引用连接属性：对象&nbsp;{@link net.ibizsys.centralstudio.dto.PSSysPFPluginDTO} 
     */
    public final static String FIELD_PSSYSPFPLUGINID = "pssyspfpluginid";

    /**
     * 设置 前端扩展插件，详细说明：{@link #FIELD_PSSYSPFPLUGINID}
     * 
     * @param pSSysPFPluginId
     * 
     */
    @JsonProperty(FIELD_PSSYSPFPLUGINID)
    public void setPSSysPFPluginId(String pSSysPFPluginId){
        this.set(FIELD_PSSYSPFPLUGINID, pSSysPFPluginId);
    }
    
    /**
     * 获取 前端扩展插件  
     * @return
     */
    @JsonIgnore
    public String getPSSysPFPluginId(){
        Object objValue = this.get(FIELD_PSSYSPFPLUGINID);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 前端扩展插件 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysPFPluginIdDirty(){
        if(this.contains(FIELD_PSSYSPFPLUGINID)){
            return true;
        }
        return false;
    }

    /**
     * 重置 前端扩展插件
     */
    @JsonIgnore
    public void resetPSSysPFPluginId(){
        this.reset(FIELD_PSSYSPFPLUGINID);
    }

    /**
     * 设置 前端扩展插件，详细说明：{@link #FIELD_PSSYSPFPLUGINID}
     * <P>
     * 等同 {@link #setPSSysPFPluginId}
     * @param pSSysPFPluginId
     */
    @JsonIgnore
    public PSAppMenuDTO pssyspfpluginid(String pSSysPFPluginId){
        this.setPSSysPFPluginId(pSSysPFPluginId);
        return this;
    }

    /**
     * 设置 前端扩展插件，包括引用对象的其它关系属性
     * <P>
     * 等同 {@link #setPSSysPFPluginId}
     * @param pSSysPFPlugin 引用对象
     */
    @JsonIgnore
    public PSAppMenuDTO pssyspfpluginid(PSSysPFPluginDTO pSSysPFPlugin){
        if(pSSysPFPlugin == null){
            this.setPSSysPFPluginId(null);
            this.setPSSysPFPluginName(null);
        }
        else{
            this.setPSSysPFPluginId(pSSysPFPlugin.getPSSysPFPluginId());
            this.setPSSysPFPluginName(pSSysPFPlugin.getPSSysPFPluginName());
        }
        return this;
    }

    /**
     * <B>PSSYSPFPLUGINNAME</B>&nbsp;前端扩展插件，指定应用菜单使用的前端模板扩展插件，使用插件类型【应用菜单绘制插件】
     * <P>
     * 引用附加属性：连接&nbsp;{@link #FIELD_PSSYSPFPLUGINID}
     */
    public final static String FIELD_PSSYSPFPLUGINNAME = "pssyspfpluginname";

    /**
     * 设置 前端扩展插件，详细说明：{@link #FIELD_PSSYSPFPLUGINNAME}
     * 
     * @param pSSysPFPluginName
     * 
     */
    @JsonProperty(FIELD_PSSYSPFPLUGINNAME)
    public void setPSSysPFPluginName(String pSSysPFPluginName){
        this.set(FIELD_PSSYSPFPLUGINNAME, pSSysPFPluginName);
    }
    
    /**
     * 获取 前端扩展插件  
     * @return
     */
    @JsonIgnore
    public String getPSSysPFPluginName(){
        Object objValue = this.get(FIELD_PSSYSPFPLUGINNAME);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 前端扩展插件 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPSSysPFPluginNameDirty(){
        if(this.contains(FIELD_PSSYSPFPLUGINNAME)){
            return true;
        }
        return false;
    }

    /**
     * 重置 前端扩展插件
     */
    @JsonIgnore
    public void resetPSSysPFPluginName(){
        this.reset(FIELD_PSSYSPFPLUGINNAME);
    }

    /**
     * 设置 前端扩展插件，详细说明：{@link #FIELD_PSSYSPFPLUGINNAME}
     * <P>
     * 等同 {@link #setPSSysPFPluginName}
     * @param pSSysPFPluginName
     */
    @JsonIgnore
    public PSAppMenuDTO pssyspfpluginname(String pSSysPFPluginName){
        this.setPSSysPFPluginName(pSSysPFPluginName);
        return this;
    }

    /**
     * <B>PUBLICFLAG</B>&nbsp;公共菜单
     * <P>
     * 值参考&nbsp;{@link net.ibizsys.model.PSModelEnums.YesNo} 
     */
    public final static String FIELD_PUBLICFLAG = "publicflag";

    /**
     * 设置 公共菜单
     * 
     * @param publicFlag
     * 
     */
    @JsonProperty(FIELD_PUBLICFLAG)
    public void setPublicFlag(Integer publicFlag){
        this.set(FIELD_PUBLICFLAG, publicFlag);
    }
    
    /**
     * 获取 公共菜单  
     * @return
     */
    @JsonIgnore
    public Integer getPublicFlag(){
        Object objValue = this.get(FIELD_PUBLICFLAG);
        if(objValue==null){
            return null;
        }
        return (Integer)objValue;
    }

    /**
     * 判断 公共菜单 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isPublicFlagDirty(){
        if(this.contains(FIELD_PUBLICFLAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 公共菜单
     */
    @JsonIgnore
    public void resetPublicFlag(){
        this.reset(FIELD_PUBLICFLAG);
    }

    /**
     * 设置 公共菜单
     * <P>
     * 等同 {@link #setPublicFlag}
     * @param publicFlag
     */
    @JsonIgnore
    public PSAppMenuDTO publicflag(Integer publicFlag){
        this.setPublicFlag(publicFlag);
        return this;
    }

     /**
     * 设置 公共菜单
     * <P>
     * 等同 {@link #setPublicFlag}
     * @param publicFlag
     */
    @JsonIgnore
    public PSAppMenuDTO publicflag(Boolean publicFlag){
        if(publicFlag == null){
            this.setPublicFlag(null);
        }
        else{
            this.setPublicFlag(publicFlag?BOOLEAN_TRUE:BOOLEAN_FALSE);
        }
        return this;
    }

    /**
     * <B>UPDATEDATE</B>&nbsp;更新时间
     */
    public final static String FIELD_UPDATEDATE = "updatedate";

    /**
     * 设置 更新时间
     * 
     * @param updateDate
     * 
     */
    @JsonProperty(FIELD_UPDATEDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    public void setUpdateDate(Timestamp updateDate){
        this.set(FIELD_UPDATEDATE, updateDate);
    }
    
    /**
     * 获取 更新时间  
     * @return
     */
    @JsonIgnore
    public Timestamp getUpdateDate(){
        Object objValue = this.get(FIELD_UPDATEDATE);
        if(objValue==null){
            return null;
        }
        return (Timestamp)objValue;
    }

    /**
     * 判断 更新时间 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUpdateDateDirty(){
        if(this.contains(FIELD_UPDATEDATE)){
            return true;
        }
        return false;
    }

    /**
     * 重置 更新时间
     */
    @JsonIgnore
    public void resetUpdateDate(){
        this.reset(FIELD_UPDATEDATE);
    }

    /**
     * 设置 更新时间
     * <P>
     * 等同 {@link #setUpdateDate}
     * @param updateDate
     */
    @JsonIgnore
    public PSAppMenuDTO updatedate(Timestamp updateDate){
        this.setUpdateDate(updateDate);
        return this;
    }

    /**
     * <B>UPDATEMAN</B>&nbsp;更新人
     * <P>
     * 字符串：最大长度 60
     */
    public final static String FIELD_UPDATEMAN = "updateman";

    /**
     * 设置 更新人
     * 
     * @param updateMan
     * 
     */
    @JsonProperty(FIELD_UPDATEMAN)
    public void setUpdateMan(String updateMan){
        this.set(FIELD_UPDATEMAN, updateMan);
    }
    
    /**
     * 获取 更新人  
     * @return
     */
    @JsonIgnore
    public String getUpdateMan(){
        Object objValue = this.get(FIELD_UPDATEMAN);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 更新人 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUpdateManDirty(){
        if(this.contains(FIELD_UPDATEMAN)){
            return true;
        }
        return false;
    }

    /**
     * 重置 更新人
     */
    @JsonIgnore
    public void resetUpdateMan(){
        this.reset(FIELD_UPDATEMAN);
    }

    /**
     * 设置 更新人
     * <P>
     * 等同 {@link #setUpdateMan}
     * @param updateMan
     */
    @JsonIgnore
    public PSAppMenuDTO updateman(String updateMan){
        this.setUpdateMan(updateMan);
        return this;
    }

    /**
     * <B>USERPARAMS</B>&nbsp;自定义参数
     * <P>
     * 字符串：最大长度 2000
     */
    public final static String FIELD_USERPARAMS = "userparams";

    /**
     * 设置 自定义参数
     * 
     * @param userParams
     * 
     */
    @JsonProperty(FIELD_USERPARAMS)
    public void setUserParams(String userParams){
        this.set(FIELD_USERPARAMS, userParams);
    }
    
    /**
     * 获取 自定义参数  
     * @return
     */
    @JsonIgnore
    public String getUserParams(){
        Object objValue = this.get(FIELD_USERPARAMS);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 自定义参数 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserParamsDirty(){
        if(this.contains(FIELD_USERPARAMS)){
            return true;
        }
        return false;
    }

    /**
     * 重置 自定义参数
     */
    @JsonIgnore
    public void resetUserParams(){
        this.reset(FIELD_USERPARAMS);
    }

    /**
     * 设置 自定义参数
     * <P>
     * 等同 {@link #setUserParams}
     * @param userParams
     */
    @JsonIgnore
    public PSAppMenuDTO userparams(String userParams){
        this.setUserParams(userParams);
        return this;
    }

    /**
     * <B>USERTAG</B>&nbsp;用户标记
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_USERTAG = "usertag";

    /**
     * 设置 用户标记
     * 
     * @param userTag
     * 
     */
    @JsonProperty(FIELD_USERTAG)
    public void setUserTag(String userTag){
        this.set(FIELD_USERTAG, userTag);
    }
    
    /**
     * 获取 用户标记  
     * @return
     */
    @JsonIgnore
    public String getUserTag(){
        Object objValue = this.get(FIELD_USERTAG);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTagDirty(){
        if(this.contains(FIELD_USERTAG)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记
     */
    @JsonIgnore
    public void resetUserTag(){
        this.reset(FIELD_USERTAG);
    }

    /**
     * 设置 用户标记
     * <P>
     * 等同 {@link #setUserTag}
     * @param userTag
     */
    @JsonIgnore
    public PSAppMenuDTO usertag(String userTag){
        this.setUserTag(userTag);
        return this;
    }

    /**
     * <B>USERTAG2</B>&nbsp;用户标记2
     * <P>
     * 字符串：最大长度 200
     */
    public final static String FIELD_USERTAG2 = "usertag2";

    /**
     * 设置 用户标记2
     * 
     * @param userTag2
     * 
     */
    @JsonProperty(FIELD_USERTAG2)
    public void setUserTag2(String userTag2){
        this.set(FIELD_USERTAG2, userTag2);
    }
    
    /**
     * 获取 用户标记2  
     * @return
     */
    @JsonIgnore
    public String getUserTag2(){
        Object objValue = this.get(FIELD_USERTAG2);
        if(objValue==null){
            return null;
        }
        return (String)objValue;
    }

    /**
     * 判断 用户标记2 是否指定值，包括空值
     * @return
     */
    @JsonIgnore
    public boolean isUserTag2Dirty(){
        if(this.contains(FIELD_USERTAG2)){
            return true;
        }
        return false;
    }

    /**
     * 重置 用户标记2
     */
    @JsonIgnore
    public void resetUserTag2(){
        this.reset(FIELD_USERTAG2);
    }

    /**
     * 设置 用户标记2
     * <P>
     * 等同 {@link #setUserTag2}
     * @param userTag2
     */
    @JsonIgnore
    public PSAppMenuDTO usertag2(String userTag2){
        this.setUserTag2(userTag2);
        return this;
    }

    @JsonIgnore
    @Override
    public String getSrfkey(){
        return this.getPSAppMenuId();
    }

    @JsonIgnore
    public void setSrfkey(String strValue){
        this.setPSAppMenuId(strValue);
    }

    @JsonIgnore
    public String getId(){
        return this.getPSAppMenuId();
    }

    @JsonIgnore
    public void setId(String strValue){
        this.setPSAppMenuId(strValue);
    }

    @JsonIgnore
    public PSAppMenuDTO id(String strValue){
        this.setPSAppMenuId(strValue);
        return this;
    }


    /**
     *  应用菜单项 成员集合
     */
    public final static String FIELD_PSAPPMENUITEMS = "psappmenuitems";

    private java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuItemDTO> psappmenuitems;

    /**
     * 获取 应用菜单项 成员集合
     * @return
     */
    @JsonProperty(FIELD_PSAPPMENUITEMS)
    public java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuItemDTO> getPSAppMenuItems(){
        return this.psappmenuitems;
    }

    /**
     * 设置 应用菜单项 成员集合  
     * @param psappmenuitems
     */
    @JsonProperty(FIELD_PSAPPMENUITEMS)
    public void setPSAppMenuItems(java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuItemDTO> psappmenuitems){
        this.psappmenuitems = psappmenuitems;
    }

    /**
     * 获取 应用菜单项 成员集合，不存在时建立集合对象
     * @return
     */
    @JsonIgnore
    public java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuItemDTO> getPSAppMenuItemsIf(){
        if(this.psappmenuitems == null){
            this.psappmenuitems = new java.util.ArrayList<net.ibizsys.centralstudio.dto.PSAppMenuItemDTO>();          
        }
        return this.psappmenuitems;
    }


    /**
     *  应用菜单逻辑 成员集合
     */
    public final static String FIELD_PSAPPMENULOGICS = "psappmenulogics";

    private java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuLogicDTO> psappmenulogics;

    /**
     * 获取 应用菜单逻辑 成员集合
     * @return
     */
    @JsonProperty(FIELD_PSAPPMENULOGICS)
    public java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuLogicDTO> getPSAppMenuLogics(){
        return this.psappmenulogics;
    }

    /**
     * 设置 应用菜单逻辑 成员集合  
     * @param psappmenulogics
     */
    @JsonProperty(FIELD_PSAPPMENULOGICS)
    public void setPSAppMenuLogics(java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuLogicDTO> psappmenulogics){
        this.psappmenulogics = psappmenulogics;
    }

    /**
     * 获取 应用菜单逻辑 成员集合，不存在时建立集合对象
     * @return
     */
    @JsonIgnore
    public java.util.List<net.ibizsys.centralstudio.dto.PSAppMenuLogicDTO> getPSAppMenuLogicsIf(){
        if(this.psappmenulogics == null){
            this.psappmenulogics = new java.util.ArrayList<net.ibizsys.centralstudio.dto.PSAppMenuLogicDTO>();          
        }
        return this.psappmenulogics;
    }

    @Override
    public void copyTo(net.ibizsys.centralstudio.util.IEntity iEntity){
        if(iEntity instanceof PSAppMenuDTO){
            PSAppMenuDTO dto = (PSAppMenuDTO)iEntity;
            dto.setPSAppMenuItems(this.getPSAppMenuItems());
            dto.setPSAppMenuLogics(this.getPSAppMenuLogics());
        }
        super.copyTo(iEntity);
    }
}
