/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.KeyValueUtils;
import net.ibizsys.centralstudio.util.PSModelImporterBase;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public abstract class PSRTModelExporterBase
extends PSModelImporterBase {
    private static final Log log = LogFactory.getLog(PSRTModelExporterBase.class);
    public static final String SYSPARAM_PSRTMODEL = "psrtmodel";

    @Override
    protected void onRun(Map sysMap, Map paramMap, Map argMap) throws Throwable {
        Object psrtmodel = sysMap.get(SYSPARAM_PSRTMODEL);
        Map psrtmodelMap = null;
        if (psrtmodel instanceof Map) {
            psrtmodelMap = (Map)psrtmodel;
        }
        if (psrtmodelMap == null) {
            throw new Exception("\u672a\u6307\u5b9a\u8fd0\u884c\u65f6\u6a21\u578b\u914d\u7f6e");
        }
        IPSSystemService iPSSystemService = this.getPSRTModelService(psrtmodelMap);
        this.onRun(iPSSystemService, sysMap, paramMap, argMap);
    }

    protected void onRun(IPSSystemService iPSSystemService, Map sysMap, Map paramMap, Map argMap) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    protected String onGetPSSysDevBKTaskName(Map paramMap) {
        return String.format("\u6a21\u578b\u5bfc\u51fa\u4efb\u52a1", new Object[0]);
    }

    protected IPSSystemService getPSRTModelService(Map psrtmodelMap) throws Exception {
        String strRTModelUrl = DataTypeUtils.getStringValue(psrtmodelMap.get("url"), null);
        String strBranch = DataTypeUtils.getStringValue(psrtmodelMap.get("branch"), "master");
        String strGitUserName = DataTypeUtils.getStringValue(psrtmodelMap.get("username"), null);
        String strGitPassword = DataTypeUtils.getStringValue(psrtmodelMap.get("password"), null);
        if (!StringUtils.hasLength((String)strRTModelUrl)) {
            throw new Exception("\u672a\u6307\u5b9a\u8fd0\u884c\u65f6\u6a21\u578b\u4ed3\u5e93\u8def\u5f84");
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u5f00\u59cb\u4e0b\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b[%1$s]", strRTModelUrl));
        String strPath = String.format("%1$s%2$s%3$s", File.createTempFile("folder", ".txt").getParent(), File.separator, KeyValueUtils.genUniqueId());
        File folder = new File(strPath);
        folder.mkdirs();
        try {
            CloneCommand cloneCommand = Git.cloneRepository().setURI(strRTModelUrl).setDirectory(folder).setBranch(strBranch);
            if (StringUtils.hasLength((String)strGitUserName)) {
                if (StringUtils.hasLength((String)strGitPassword)) {
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, strGitPassword));
                } else {
                    cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(strGitUserName, ""));
                }
            }
            cloneCommand.call();
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u83b7\u53d6\u8fd0\u884c\u65f6\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        this.updateCurrentPSSysDevBKTask(20000, String.format("\u7ed3\u675f\u4e0b\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b", new Object[0]));
        String strModelPath = "";
        File modelFile = new File(String.format("%1$s%2$sibizmodel.yaml", strPath, File.separator));
        if (modelFile.exists()) {
            try {
                String strModelFolder;
                Yaml yaml = new Yaml();
                Map config = (Map)yaml.loadAs((InputStream)new FileInputStream(modelFile), Map.class);
                if (config != null && StringUtils.hasLength((String)(strModelFolder = (String)config.get("modelfolder")))) {
                    strModelPath = strPath + File.separator + strModelFolder;
                }
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u52a0\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b\u914d\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if (!StringUtils.hasLength((String)strModelPath)) {
            strModelPath = strPath;
        }
        IPSSystemService iPSSystemService = null;
        try {
            iPSSystemService = this.getPSSystemService(strModelPath);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u52a0\u8f7d\u8fd0\u884c\u65f6\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        return iPSSystemService;
    }

    @Override
    protected IPSSystemService getPSSystemService(String strModelPath) throws Throwable {
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strModelPath);
        psModelServiceImpl.getPSSystem();
        return psModelServiceImpl;
    }
}

