/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.centralstudio.util.IPSModelDTO;
import net.ibizsys.centralstudio.util.ISearchContext;
import net.ibizsys.centralstudio.util.PSModelDTO;
import net.ibizsys.centralstudio.util.PSModelSearchContextDTO;
import net.ibizsys.centralstudio.util.PSModelServiceSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public abstract class PSModelServiceUtilsBase {
    private static final Log log = LogFactory.getLog(PSModelServiceUtilsBase.class);
    protected static ObjectMapper MAPPER = new ObjectMapper();
    private static WebClient webClient = null;
    public static final int LIST_SIZE = 200;
    private Map<String, Object> params = new HashMap<String, Object>();
    private static final ThreadLocal<Deque<String>> psSysDevBKTaskIdThreadLocal = new ThreadLocal<Deque<String>>(){

        @Override
        protected Deque<String> initialValue() {
            return new ArrayDeque<String>();
        }
    };

    protected WebClient getWebClient() {
        if (webClient == null) {
            webClient = WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build();
        }
        return webClient;
    }

    protected <T> void executeCreate(String strModelName, String strPath, Class<T> cls, IPSModelDTO iPSModelDTO) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        try {
            iPSModelDTO.reset("createdate");
            iPSModelDTO.reset("createman");
            iPSModelDTO.reset("updatedate");
            iPSModelDTO.reset("updateman");
            Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().post().uri(String.format("%1$s/%2$s", psModelServiceSession.getServiceUrl(), strPath), new Object[0])).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)})).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()})).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"})).bodyValue((Object)iPSModelDTO).retrieve().bodyToMono(cls);
            Object t = mono.block();
            iPSModelDTO.resetAll();
            ((IPSModelDTO)t).copyTo(iPSModelDTO);
            log.debug((Object)String.format("\u5efa\u7acb\u5bf9\u8c61[%1$s]", strModelName));
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }

    protected void executeCreate(String strModelName, String strPath, List<? extends IPSModelDTO> psModelDTOList) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        boolean bBreak = false;
        int nIndex = 0;
        do {
            IPSModelDTO iPSModelDTO;
            List<? extends IPSModelDTO> list = null;
            if (psModelDTOList.size() <= 200) {
                list = psModelDTOList;
                bBreak = true;
            } else {
                list = new ArrayList<IPSModelDTO>();
                for (int i = 0; i < 200; ++i) {
                    int nCurIndex = nIndex * 200 + i;
                    if (nCurIndex >= psModelDTOList.size()) {
                        bBreak = true;
                        break;
                    }
                    iPSModelDTO = psModelDTOList.get(nCurIndex);
                    list.add(iPSModelDTO);
                }
            }
            ++nIndex;
            try {
                Iterator<? extends IPSModelDTO> i = list.iterator();
                while (i.hasNext()) {
                    IPSModelDTO item;
                    iPSModelDTO = item = i.next();
                    iPSModelDTO.reset("createdate");
                    iPSModelDTO.reset("createman");
                    iPSModelDTO.reset("updatedate");
                    iPSModelDTO.reset("updateman");
                }
                Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().post().uri(String.format("%1$s/%2$s/batch", psModelServiceSession.getServiceUrl(), strPath), new Object[0])).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)})).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()})).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"})).bodyValue(list).retrieve().bodyToMono(String.class);
                mono.block();
                log.debug((Object)String.format("\u5efa\u7acb\u5bf9\u8c61[%1$s]", strModelName));
            }
            catch (WebClientResponseException ex) {
                ObjectNode objNode;
                String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
                if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                    String strMessage = objNode.get("message").asText();
                    throw new Exception(strMessage, ex);
                }
                throw ex;
            }
        } while (!bBreak);
    }

    protected <T> void executeUpdate(String strModelName, String strPath, Class<T> cls, IPSModelDTO iPSModelDTO) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        try {
            iPSModelDTO.reset("createdate");
            iPSModelDTO.reset("createman");
            iPSModelDTO.reset("updatedate");
            iPSModelDTO.reset("updateman");
            Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().put().uri(String.format("%1$s/%2$s/{1}", psModelServiceSession.getServiceUrl(), strPath), new Object[]{iPSModelDTO.getSrfkey()})).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)})).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()})).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"})).bodyValue((Object)iPSModelDTO).retrieve().bodyToMono(cls);
            Object t = mono.block();
            iPSModelDTO.resetAll();
            ((IPSModelDTO)t).copyTo(iPSModelDTO);
            log.debug((Object)String.format("\u66f4\u65b0\u5bf9\u8c61[%1$s]", strModelName));
        }
        catch (WebClientResponseException ex) {
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError)) {
                ObjectNode objNode = (ObjectNode)MAPPER.readTree(strError);
                if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0) {
                    String strMessage = objNode.get("message").asText();
                    throw new Exception(strMessage, ex);
                }
            }
            throw ex;
        }
    }

    protected void executeUpdate(String strModelName, String strPath, List<? extends IPSModelDTO> psModelDTOList) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        boolean bBreak = false;
        int nIndex = 0;
        do {
            IPSModelDTO iPSModelDTO;
            List<? extends IPSModelDTO> list = null;
            if (psModelDTOList.size() <= 200) {
                list = psModelDTOList;
                bBreak = true;
            } else {
                list = new ArrayList<IPSModelDTO>();
                for (int i = 0; i < 200; ++i) {
                    int nCurIndex = nIndex * 200 + i;
                    if (nCurIndex >= psModelDTOList.size()) {
                        bBreak = true;
                        break;
                    }
                    iPSModelDTO = psModelDTOList.get(nCurIndex);
                    list.add(iPSModelDTO);
                }
            }
            ++nIndex;
            try {
                Iterator<? extends IPSModelDTO> i = list.iterator();
                while (i.hasNext()) {
                    IPSModelDTO item;
                    iPSModelDTO = item = i.next();
                    iPSModelDTO.reset("createdate");
                    iPSModelDTO.reset("createman");
                    iPSModelDTO.reset("updatedate");
                    iPSModelDTO.reset("updateman");
                }
                Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().put().uri(String.format("%1$s/%2$s/batch", psModelServiceSession.getServiceUrl(), strPath), new Object[0])).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)})).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()})).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"})).bodyValue(list).retrieve().bodyToMono(String.class);
                mono.block();
                log.debug((Object)String.format("\u66f4\u65b0\u5bf9\u8c61[%1$s]", strModelName));
            }
            catch (WebClientResponseException ex) {
                ObjectNode objNode;
                String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
                if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                    String strMessage = objNode.get("message").asText();
                    throw new Exception(strMessage, ex);
                }
                throw ex;
            }
        } while (!bBreak);
    }

    protected <T> T executeGet(String strModelName, String strPath, Class<T> cls, String strKey, boolean bTryMode) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        try {
            Mono mono = this.getWebClient().get().uri(String.format("%1$s/%2$s/{1}", psModelServiceSession.getServiceUrl(), strPath), new Object[]{strKey}).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)}).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()}).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"}).retrieve().bodyToMono(cls);
            return (T)mono.block();
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            if (bTryMode && ex.getRawStatusCode() == HttpStatus.NOT_FOUND.value()) {
                return null;
            }
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }

    protected boolean executeRemove(String strModelName, String strPath, String strKey, boolean bTryMode) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        try {
            Mono mono = this.getWebClient().delete().uri(String.format("%1$s/%2$s/{1}", psModelServiceSession.getServiceUrl(), strPath), new Object[]{strKey}).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)}).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()}).header("srfimportmode", new String[]{psModelServiceSession.isImportMode() ? "1" : "0"}).retrieve().bodyToMono(String.class);
            mono.block();
            return true;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            if (bTryMode && ex.getRawStatusCode() == HttpStatus.NOT_FOUND.value()) {
                return false;
            }
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }

    protected <T> Page<T> executeFetchDefault(String strModelName, String strPath, Class<T> cls, ISearchContext iSearchContext) throws Throwable {
        PSModelServiceSession psModelServiceSession = PSModelServiceSession.getCurrent();
        try {
            Mono mono;
            ResponseEntity responseEntity;
            List list;
            Iterator orders;
            LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
            if (iSearchContext.any() != null) {
                queryMap.putAll(iSearchContext.any());
            }
            if (iSearchContext.getPageable() != null) {
                queryMap.put("size", iSearchContext.getPageable().getPageSize());
                queryMap.put("page", iSearchContext.getPageable().getPageNumber());
            }
            if (iSearchContext.getPageSort() != null && iSearchContext.getPageSort() != Sort.unsorted() && (orders = iSearchContext.getPageSort().iterator()) != null && orders.hasNext()) {
                Sort.Order order = (Sort.Order)orders.next();
                if (order.isAscending()) {
                    queryMap.put("sort", String.format("%1$s,asc", order.getProperty().toUpperCase()));
                } else {
                    queryMap.put("sort", String.format("%1$s,desc", order.getProperty().toUpperCase()));
                }
            }
            if ((list = (responseEntity = (ResponseEntity)(mono = this.getWebClient().get().uri(String.format("%1$s/%2$s/fetchdefault?%3$s", psModelServiceSession.getServiceUrl(), strPath, PSModelServiceUtilsBase.getUrlParamsByMap(queryMap)), new Object[0]).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(psModelServiceSession)}).header("psdevslnsys", new String[]{psModelServiceSession.getPSDevSlnSysId()}).header("srfimportmode", new String[]{"1"}).retrieve().toEntityList(cls)).block()).getHeaders().get((Object)"x-total")) != null && list.size() > 0) {
                return new PageImpl((List)responseEntity.getBody(), iSearchContext.getPageable(), (long)Integer.valueOf((String)list.get(0)).intValue());
            }
            return new PageImpl((List)responseEntity.getBody());
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }

    protected <T> List<T> executeFetchDefaultAll(String strModelName, String strPath, Class<T> cls, PSModelSearchContextDTO psModelSearchContextDTO) throws Throwable {
        psModelSearchContextDTO.setSize(1000);
        ArrayList list = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            psModelSearchContextDTO.setPage(i);
            Page<T> page = this.executeFetchDefault(strModelName, strPath, cls, psModelSearchContextDTO);
            list.addAll(page.getContent());
            if (page.getContent().size() < psModelSearchContextDTO.getSize()) break;
        }
        return list;
    }

    public String beginPSSysDevBKTask(String strTaskName) throws Throwable {
        PSModelDTO psModelDTO = new PSModelDTO();
        psModelDTO.set("pssysdevbktaskname", strTaskName);
        psModelDTO.set("tasktype", "IBIZCENTRAL");
        psModelDTO.set("taskstate", 10);
        this.executeCreate("PSSYSDEVBKTASK", "pssysdevbktasks", PSModelDTO.class, psModelDTO);
        String strPSSysDevBKTaskId = (String)psModelDTO.get("pssysdevbktaskid");
        this.pushPSSysDevBKTaskId(strPSSysDevBKTaskId);
        return strPSSysDevBKTaskId;
    }

    public void updateCurrentPSSysDevBKTask(int nLogLevel, String strTaskInfo) {
        String strFullTaskInfo = null;
        switch (nLogLevel) {
            case 10000: {
                strFullTaskInfo = String.format("[DEBUG] %1$s", strTaskInfo);
                break;
            }
            case 40000: {
                strFullTaskInfo = String.format("[ERROR] %1$s", strTaskInfo);
                break;
            }
            case 50000: {
                strFullTaskInfo = String.format("[FATAL] %1$s", strTaskInfo);
                break;
            }
            case 20000: {
                strFullTaskInfo = String.format("[INFO] %1$s", strTaskInfo);
                break;
            }
            case 5000: {
                strFullTaskInfo = String.format("[TRACE] %1$s", strTaskInfo);
                break;
            }
            case 30000: {
                strFullTaskInfo = String.format("[WARN] %1$s", strTaskInfo);
                break;
            }
            default: {
                strFullTaskInfo = strTaskInfo;
            }
        }
        this.updateCurrentPSSysDevBKTask(strFullTaskInfo);
    }

    public void updateCurrentPSSysDevBKTask(String strTaskInfo) {
        try {
            String strPSSysDevBKTaskId = this.peekPSSysDevBKTaskId();
            if (!StringUtils.hasLength((String)strPSSysDevBKTaskId)) {
                log.warn((Object)String.format("\u4e0a\u4e0b\u6587\u672a\u5b9a\u4e49\u7cfb\u7edf\u540e\u53f0\u5f00\u53d1\u4efb\u52a1\u6807\u8bc6", new Object[0]));
                return;
            }
            this.updatePSSysDevBKTask(strPSSysDevBKTaskId, strTaskInfo);
        }
        catch (Throwable ex) {
            log.error((Object)ex);
        }
    }

    public void updatePSSysDevBKTask(String strTaskId, String strTaskInfo) throws Throwable {
        PSModelDTO psModelDTO = new PSModelDTO();
        psModelDTO.set("pssysdevbktaskid", strTaskId);
        psModelDTO.set("tasktype", "IBIZCENTRAL");
        psModelDTO.set("taskstate", 20);
        psModelDTO.set("resultinfo", strTaskInfo);
        psModelDTO.setSrfKey(strTaskId);
        this.executeUpdate("PSSYSDEVBKTASK", "pssysdevbktasks", PSModelDTO.class, psModelDTO);
    }

    public void errorCurrentPSSysDevBKTask(String strTaskInfo) {
        try {
            String strPSSysDevBKTaskId = this.pollPSSysDevBKTaskId();
            if (!StringUtils.hasLength((String)strPSSysDevBKTaskId)) {
                throw new Exception(String.format("\u4e0a\u4e0b\u6587\u672a\u5b9a\u4e49\u7cfb\u7edf\u540e\u53f0\u5f00\u53d1\u4efb\u52a1\u6807\u8bc6", new Object[0]));
            }
            this.errorPSSysDevBKTask(strPSSysDevBKTaskId, strTaskInfo);
        }
        catch (Throwable ex) {
            log.error((Object)ex);
        }
    }

    public void errorPSSysDevBKTask(String strTaskId, String strTaskInfo) throws Throwable {
        PSModelDTO psModelDTO = new PSModelDTO();
        psModelDTO.set("pssysdevbktaskid", strTaskId);
        psModelDTO.set("tasktype", "IBIZCENTRAL");
        psModelDTO.set("taskstate", 40);
        psModelDTO.set("resultinfo", strTaskInfo);
        psModelDTO.setSrfKey(strTaskId);
        this.executeUpdate("PSSYSDEVBKTASK", "pssysdevbktasks", PSModelDTO.class, psModelDTO);
    }

    public void finishCurrentPSSysDevBKTask() {
        this.finishCurrentPSSysDevBKTask(null);
    }

    public void finishCurrentPSSysDevBKTask(String strTaskInfo) {
        try {
            String strPSSysDevBKTaskId = this.pollPSSysDevBKTaskId();
            if (!StringUtils.hasLength((String)strPSSysDevBKTaskId)) {
                throw new Exception(String.format("\u4e0a\u4e0b\u6587\u672a\u5b9a\u4e49\u7cfb\u7edf\u540e\u53f0\u5f00\u53d1\u4efb\u52a1\u6807\u8bc6", new Object[0]));
            }
            this.finishPSSysDevBKTask(strPSSysDevBKTaskId, strTaskInfo);
        }
        catch (Throwable ex) {
            log.error((Object)ex);
        }
    }

    public void finishPSSysDevBKTask(String strTaskId, String strTaskInfo) throws Throwable {
        PSModelDTO psModelDTO = new PSModelDTO();
        psModelDTO.set("pssysdevbktaskid", strTaskId);
        psModelDTO.set("tasktype", "IBIZCENTRAL");
        psModelDTO.set("taskstate", 30);
        psModelDTO.set("resultinfo", strTaskInfo);
        psModelDTO.setSrfKey(strTaskId);
        this.executeUpdate("PSSYSDEVBKTASK", "pssysdevbktasks", PSModelDTO.class, psModelDTO);
    }

    private String peekPSSysDevBKTaskId() {
        return psSysDevBKTaskIdThreadLocal.get().peek();
    }

    private void pushPSSysDevBKTaskId(String strPSSysDevBKTaskId) {
        psSysDevBKTaskIdThreadLocal.get().push(strPSSysDevBKTaskId);
    }

    private String pollPSSysDevBKTaskId() {
        Deque<String> deque = psSysDevBKTaskIdThreadLocal.get();
        String strPSSysDevBKTaskId = deque.poll();
        if (deque.isEmpty()) {
            psSysDevBKTaskIdThreadLocal.remove();
        }
        return strPSSysDevBKTaskId;
    }

    public static String getUrlParamsByMap(Map<String, Object> map) throws Exception {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean bFirst = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sb.append("&");
            }
            if (entry.getValue() instanceof String) {
                sb.append(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    protected String getAuthorizationBearer(PSModelServiceSession psModelServiceSession) throws Throwable {
        String strBearer = psModelServiceSession.getBearer();
        if (StringUtils.hasLength((String)strBearer)) {
            return strBearer;
        }
        try {
            LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>();
            bodyMap.put("loginname", psModelServiceSession.getUserName());
            bodyMap.put("password", psModelServiceSession.getPassword());
            Mono mono = ((WebClient.RequestBodySpec)this.getWebClient().post().uri(psModelServiceSession.getAccessTokenUrl(), new Object[0])).bodyValue(bodyMap).retrieve().bodyToMono(Map.class);
            Map t = (Map)mono.block();
            String strToken = (String)t.get("token");
            psModelServiceSession.setBearer(strToken);
            return strToken;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)MAPPER.readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }
}

