package net.ibizsys.centralstudio.util;

import java.util.List;
import org.springframework.data.domain.Page;

import net.ibizsys.centralstudio.dto.*;
import net.ibizsys.centralstudio.filter.*;

public class PSModelServiceUtils extends PSModelServiceUtilsBase  {

	private static PSModelServiceUtils instance = null;
	
	public static PSModelServiceUtils getInstance() {
		if(PSModelServiceUtils.instance == null){
			PSModelServiceUtils.instance = new PSModelServiceUtils();
		}
		return PSModelServiceUtils.instance;
	}

	public static void setInstance(PSModelServiceUtils instance) {
		PSModelServiceUtils.instance = instance;
	}

    /**
     * 建立 系统模块 [PSMODULE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSModule(PSModuleDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSMODULE, "psmodules", PSModuleDTO.class, dto);
	}

    /**
     * 批建立 系统模块 [PSMODULE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSModules(List<PSModuleDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSMODULE, "psmodules", dtoList);
	}

    /**
     * 更新 系统模块 [PSMODULE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSModule(PSModuleDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSMODULE, "psmodules", PSModuleDTO.class, dto);
	}

    /**
     * 批更新 系统模块 [PSMODULE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSModules(List<PSModuleDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSMODULE, "psmodules", dtoList);
	}

    /**
     * 获取 系统模块 [PSMODULE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSModuleDTO getPSModule(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSMODULE, "psmodules", PSModuleDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统模块 [PSMODULE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSModuleDTO> searchPSModules(PSModuleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSMODULE, "psmodules", PSModuleDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统模块 [PSMODULE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSModuleDTO> searchAllPSModules(PSModuleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSMODULE, "psmodules", PSModuleDTO.class, iSearchContext);
	}

    /**
     * 建立 实体 [PSDATAENTITY]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDataEntity(PSDataEntityDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDATAENTITY, "psdataentities", PSDataEntityDTO.class, dto);
	}

    /**
     * 批建立 实体 [PSDATAENTITY]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDataEntities(List<PSDataEntityDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDATAENTITY, "psdataentities", dtoList);
	}

    /**
     * 更新 实体 [PSDATAENTITY]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDataEntity(PSDataEntityDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDATAENTITY, "psdataentities", PSDataEntityDTO.class, dto);
	}

    /**
     * 批更新 实体 [PSDATAENTITY]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDataEntities(List<PSDataEntityDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDATAENTITY, "psdataentities", dtoList);
	}

    /**
     * 获取 实体 [PSDATAENTITY]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDataEntityDTO getPSDataEntity(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDATAENTITY, "psdataentities", PSDataEntityDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体 [PSDATAENTITY]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDataEntityDTO> searchPSDataEntities(PSDataEntityFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDATAENTITY, "psdataentities", PSDataEntityDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体 [PSDATAENTITY]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDataEntityDTO> searchAllPSDataEntities(PSDataEntityFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDATAENTITY, "psdataentities", PSDataEntityDTO.class, iSearchContext);
	}

    /**
     * 建立 实体属性 [PSDEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEField(PSDEFieldDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEFIELD, "psdefields", PSDEFieldDTO.class, dto);
	}

    /**
     * 批建立 实体属性 [PSDEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEFields(List<PSDEFieldDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEFIELD, "psdefields", dtoList);
	}

    /**
     * 更新 实体属性 [PSDEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEField(PSDEFieldDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEFIELD, "psdefields", PSDEFieldDTO.class, dto);
	}

    /**
     * 批更新 实体属性 [PSDEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEFields(List<PSDEFieldDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEFIELD, "psdefields", dtoList);
	}

    /**
     * 获取 实体属性 [PSDEFIELD]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEFieldDTO getPSDEField(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEFIELD, "psdefields", PSDEFieldDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体属性 [PSDEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEFieldDTO> searchPSDEFields(PSDEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEFIELD, "psdefields", PSDEFieldDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体属性 [PSDEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEFieldDTO> searchAllPSDEFields(PSDEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEFIELD, "psdefields", PSDEFieldDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系 [PSDER]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDER(PSDERDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDER, "psders", PSDERDTO.class, dto);
	}

    /**
     * 批建立 实体关系 [PSDER]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDERs(List<PSDERDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDER, "psders", dtoList);
	}

    /**
     * 更新 实体关系 [PSDER]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDER(PSDERDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDER, "psders", PSDERDTO.class, dto);
	}

    /**
     * 批更新 实体关系 [PSDER]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDERs(List<PSDERDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDER, "psders", dtoList);
	}

    /**
     * 获取 实体关系 [PSDER]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDERDTO getPSDER(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDER, "psders", PSDERDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系 [PSDER]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDERDTO> searchPSDERs(PSDERFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDER, "psders", PSDERDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系 [PSDER]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDERDTO> searchAllPSDERs(PSDERFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDER, "psders", PSDERDTO.class, iSearchContext);
	}

    /**
     * 建立 应用界面主题 [PSAPPUITHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSAppUITheme(PSAppUIThemeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSAPPUITHEME, "psappuithemes", PSAppUIThemeDTO.class, dto);
	}

    /**
     * 批建立 应用界面主题 [PSAPPUITHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSAppUIThemes(List<PSAppUIThemeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSAPPUITHEME, "psappuithemes", dtoList);
	}

    /**
     * 更新 应用界面主题 [PSAPPUITHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSAppUITheme(PSAppUIThemeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSAPPUITHEME, "psappuithemes", PSAppUIThemeDTO.class, dto);
	}

    /**
     * 批更新 应用界面主题 [PSAPPUITHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSAppUIThemes(List<PSAppUIThemeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSAPPUITHEME, "psappuithemes", dtoList);
	}

    /**
     * 获取 应用界面主题 [PSAPPUITHEME]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSAppUIThemeDTO getPSAppUITheme(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSAPPUITHEME, "psappuithemes", PSAppUIThemeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 应用界面主题 [PSAPPUITHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSAppUIThemeDTO> searchPSAppUIThemes(PSAppUIThemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSAPPUITHEME, "psappuithemes", PSAppUIThemeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 应用界面主题 [PSAPPUITHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSAppUIThemeDTO> searchAllPSAppUIThemes(PSAppUIThemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSAPPUITHEME, "psappuithemes", PSAppUIThemeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统代码表项 [PSCODEITEM]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSCodeItem(PSCodeItemDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSCODEITEM, "pscodeitems", PSCodeItemDTO.class, dto);
	}

    /**
     * 批建立 系统代码表项 [PSCODEITEM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSCodeItems(List<PSCodeItemDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSCODEITEM, "pscodeitems", dtoList);
	}

    /**
     * 更新 系统代码表项 [PSCODEITEM]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSCodeItem(PSCodeItemDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSCODEITEM, "pscodeitems", PSCodeItemDTO.class, dto);
	}

    /**
     * 批更新 系统代码表项 [PSCODEITEM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSCodeItems(List<PSCodeItemDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSCODEITEM, "pscodeitems", dtoList);
	}

    /**
     * 获取 系统代码表项 [PSCODEITEM]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSCodeItemDTO getPSCodeItem(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSCODEITEM, "pscodeitems", PSCodeItemDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统代码表项 [PSCODEITEM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSCodeItemDTO> searchPSCodeItems(PSCodeItemFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSCODEITEM, "pscodeitems", PSCodeItemDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统代码表项 [PSCODEITEM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSCodeItemDTO> searchAllPSCodeItems(PSCodeItemFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSCODEITEM, "pscodeitems", PSCodeItemDTO.class, iSearchContext);
	}

    /**
     * 建立 系统代码表 [PSCODELIST]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSCodeList(PSCodeListDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSCODELIST, "pscodelists", PSCodeListDTO.class, dto);
	}

    /**
     * 批建立 系统代码表 [PSCODELIST]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSCodeLists(List<PSCodeListDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSCODELIST, "pscodelists", dtoList);
	}

    /**
     * 更新 系统代码表 [PSCODELIST]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSCodeList(PSCodeListDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSCODELIST, "pscodelists", PSCodeListDTO.class, dto);
	}

    /**
     * 批更新 系统代码表 [PSCODELIST]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSCodeLists(List<PSCodeListDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSCODELIST, "pscodelists", dtoList);
	}

    /**
     * 获取 系统代码表 [PSCODELIST]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSCodeListDTO getPSCodeList(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSCODELIST, "pscodelists", PSCodeListDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统代码表 [PSCODELIST]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSCodeListDTO> searchPSCodeLists(PSCodeListFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSCODELIST, "pscodelists", PSCodeListDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统代码表 [PSCODELIST]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSCodeListDTO> searchAllPSCodeLists(PSCodeListFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSCODELIST, "pscodelists", PSCodeListDTO.class, iSearchContext);
	}

    /**
     * 建立 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSCtrlLogicGroup(PSCtrlLogicGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", PSCtrlLogicGroupDTO.class, dto);
	}

    /**
     * 批建立 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSCtrlLogicGroups(List<PSCtrlLogicGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", dtoList);
	}

    /**
     * 更新 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSCtrlLogicGroup(PSCtrlLogicGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", PSCtrlLogicGroupDTO.class, dto);
	}

    /**
     * 批更新 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSCtrlLogicGroups(List<PSCtrlLogicGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", dtoList);
	}

    /**
     * 获取 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSCtrlLogicGroupDTO getPSCtrlLogicGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", PSCtrlLogicGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSCtrlLogicGroupDTO> searchPSCtrlLogicGroups(PSCtrlLogicGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", PSCtrlLogicGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 部件逻辑组 [PSCTRLLOGICGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSCtrlLogicGroupDTO> searchAllPSCtrlLogicGroups(PSCtrlLogicGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSCTRLLOGICGROUP, "psctrllogicgroups", PSCtrlLogicGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 部件消息 [PSCTRLMSG]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSCtrlMsg(PSCtrlMsgDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSCTRLMSG, "psctrlmsgs", PSCtrlMsgDTO.class, dto);
	}

    /**
     * 批建立 部件消息 [PSCTRLMSG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSCtrlMsgs(List<PSCtrlMsgDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSCTRLMSG, "psctrlmsgs", dtoList);
	}

    /**
     * 更新 部件消息 [PSCTRLMSG]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSCtrlMsg(PSCtrlMsgDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSCTRLMSG, "psctrlmsgs", PSCtrlMsgDTO.class, dto);
	}

    /**
     * 批更新 部件消息 [PSCTRLMSG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSCtrlMsgs(List<PSCtrlMsgDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSCTRLMSG, "psctrlmsgs", dtoList);
	}

    /**
     * 获取 部件消息 [PSCTRLMSG]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSCtrlMsgDTO getPSCtrlMsg(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSCTRLMSG, "psctrlmsgs", PSCtrlMsgDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 部件消息 [PSCTRLMSG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSCtrlMsgDTO> searchPSCtrlMsgs(PSCtrlMsgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSCTRLMSG, "psctrlmsgs", PSCtrlMsgDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 部件消息 [PSCTRLMSG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSCtrlMsgDTO> searchAllPSCtrlMsgs(PSCtrlMsgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSCTRLMSG, "psctrlmsgs", PSCtrlMsgDTO.class, iSearchContext);
	}

    /**
     * 建立 实体行为 [PSDEACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEAction(PSDEActionDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEACTION, "psdeactions", PSDEActionDTO.class, dto);
	}

    /**
     * 批建立 实体行为 [PSDEACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEActions(List<PSDEActionDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEACTION, "psdeactions", dtoList);
	}

    /**
     * 更新 实体行为 [PSDEACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEAction(PSDEActionDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEACTION, "psdeactions", PSDEActionDTO.class, dto);
	}

    /**
     * 批更新 实体行为 [PSDEACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEActions(List<PSDEActionDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEACTION, "psdeactions", dtoList);
	}

    /**
     * 获取 实体行为 [PSDEACTION]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEActionDTO getPSDEAction(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEACTION, "psdeactions", PSDEActionDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体行为 [PSDEACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEActionDTO> searchPSDEActions(PSDEActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEACTION, "psdeactions", PSDEActionDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体行为 [PSDEACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEActionDTO> searchAllPSDEActions(PSDEActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEACTION, "psdeactions", PSDEActionDTO.class, iSearchContext);
	}

    /**
     * 建立 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEActionLogic(PSDEActionLogicDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", PSDEActionLogicDTO.class, dto);
	}

    /**
     * 批建立 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEActionLogics(List<PSDEActionLogicDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", dtoList);
	}

    /**
     * 更新 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEActionLogic(PSDEActionLogicDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", PSDEActionLogicDTO.class, dto);
	}

    /**
     * 批更新 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEActionLogics(List<PSDEActionLogicDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", dtoList);
	}

    /**
     * 获取 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEActionLogicDTO getPSDEActionLogic(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", PSDEActionLogicDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEActionLogicDTO> searchPSDEActionLogics(PSDEActionLogicFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", PSDEActionLogicDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体行为逻辑 [PSDEACTIONLOGIC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEActionLogicDTO> searchAllPSDEActionLogics(PSDEActionLogicFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEACTIONLOGIC, "psdeactionlogics", PSDEActionLogicDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据库配置 [PSDEDBCFG]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDBCfg(PSDEDBCfgDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDBCFG, "psdedbcfgs", PSDEDBCfgDTO.class, dto);
	}

    /**
     * 批建立 实体数据库配置 [PSDEDBCFG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDBCfgs(List<PSDEDBCfgDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDBCFG, "psdedbcfgs", dtoList);
	}

    /**
     * 更新 实体数据库配置 [PSDEDBCFG]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDBCfg(PSDEDBCfgDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDBCFG, "psdedbcfgs", PSDEDBCfgDTO.class, dto);
	}

    /**
     * 批更新 实体数据库配置 [PSDEDBCFG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDBCfgs(List<PSDEDBCfgDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDBCFG, "psdedbcfgs", dtoList);
	}

    /**
     * 获取 实体数据库配置 [PSDEDBCFG]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDBCfgDTO getPSDEDBCfg(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDBCFG, "psdedbcfgs", PSDEDBCfgDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据库配置 [PSDEDBCFG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDBCfgDTO> searchPSDEDBCfgs(PSDEDBCfgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDBCFG, "psdedbcfgs", PSDEDBCfgDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据库配置 [PSDEDBCFG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDBCfgDTO> searchAllPSDEDBCfgs(PSDEDBCfgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDBCFG, "psdedbcfgs", PSDEDBCfgDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据库索引 [PSDEDBINDEX]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDBIndex(PSDEDBIndexDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDBINDEX, "psdedbindices", PSDEDBIndexDTO.class, dto);
	}

    /**
     * 批建立 实体数据库索引 [PSDEDBINDEX]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDBIndices(List<PSDEDBIndexDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDBINDEX, "psdedbindices", dtoList);
	}

    /**
     * 更新 实体数据库索引 [PSDEDBINDEX]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDBIndex(PSDEDBIndexDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDBINDEX, "psdedbindices", PSDEDBIndexDTO.class, dto);
	}

    /**
     * 批更新 实体数据库索引 [PSDEDBINDEX]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDBIndices(List<PSDEDBIndexDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDBINDEX, "psdedbindices", dtoList);
	}

    /**
     * 获取 实体数据库索引 [PSDEDBINDEX]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDBIndexDTO getPSDEDBIndex(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDBINDEX, "psdedbindices", PSDEDBIndexDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据库索引 [PSDEDBINDEX]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDBIndexDTO> searchPSDEDBIndices(PSDEDBIndexFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDBINDEX, "psdedbindices", PSDEDBIndexDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据库索引 [PSDEDBINDEX]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDBIndexDTO> searchAllPSDEDBIndices(PSDEDBIndexFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDBINDEX, "psdedbindices", PSDEDBIndexDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据查询代码 [PSDEDQCODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDQCode(PSDEDQCodeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODE, "psdedqcodes", PSDEDQCodeDTO.class, dto);
	}

    /**
     * 批建立 实体数据查询代码 [PSDEDQCODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDQCodes(List<PSDEDQCodeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODE, "psdedqcodes", dtoList);
	}

    /**
     * 更新 实体数据查询代码 [PSDEDQCODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDQCode(PSDEDQCodeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODE, "psdedqcodes", PSDEDQCodeDTO.class, dto);
	}

    /**
     * 批更新 实体数据查询代码 [PSDEDQCODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDQCodes(List<PSDEDQCodeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODE, "psdedqcodes", dtoList);
	}

    /**
     * 获取 实体数据查询代码 [PSDEDQCODE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDQCodeDTO getPSDEDQCode(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDQCODE, "psdedqcodes", PSDEDQCodeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据查询代码 [PSDEDQCODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDQCodeDTO> searchPSDEDQCodes(PSDEDQCodeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDQCODE, "psdedqcodes", PSDEDQCodeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据查询代码 [PSDEDQCODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDQCodeDTO> searchAllPSDEDQCodes(PSDEDQCodeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDQCODE, "psdedqcodes", PSDEDQCodeDTO.class, iSearchContext);
	}

    /**
     * 建立 实体查询代码条件 [PSDEDQCODECOND]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDQCodeCond(PSDEDQCodeCondDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODECOND, "psdedqcodeconds", PSDEDQCodeCondDTO.class, dto);
	}

    /**
     * 批建立 实体查询代码条件 [PSDEDQCODECOND]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDQCodeConds(List<PSDEDQCodeCondDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODECOND, "psdedqcodeconds", dtoList);
	}

    /**
     * 更新 实体查询代码条件 [PSDEDQCODECOND]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDQCodeCond(PSDEDQCodeCondDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODECOND, "psdedqcodeconds", PSDEDQCodeCondDTO.class, dto);
	}

    /**
     * 批更新 实体查询代码条件 [PSDEDQCODECOND]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDQCodeConds(List<PSDEDQCodeCondDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODECOND, "psdedqcodeconds", dtoList);
	}

    /**
     * 获取 实体查询代码条件 [PSDEDQCODECOND]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDQCodeCondDTO getPSDEDQCodeCond(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDQCODECOND, "psdedqcodeconds", PSDEDQCodeCondDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体查询代码条件 [PSDEDQCODECOND]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDQCodeCondDTO> searchPSDEDQCodeConds(PSDEDQCodeCondFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDQCODECOND, "psdedqcodeconds", PSDEDQCodeCondDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体查询代码条件 [PSDEDQCODECOND]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDQCodeCondDTO> searchAllPSDEDQCodeConds(PSDEDQCodeCondFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDQCODECOND, "psdedqcodeconds", PSDEDQCodeCondDTO.class, iSearchContext);
	}

    /**
     * 建立 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDQCodeExp(PSDEDQCodeExpDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", PSDEDQCodeExpDTO.class, dto);
	}

    /**
     * 批建立 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDQCodeExps(List<PSDEDQCodeExpDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", dtoList);
	}

    /**
     * 更新 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDQCodeExp(PSDEDQCodeExpDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", PSDEDQCodeExpDTO.class, dto);
	}

    /**
     * 批更新 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDQCodeExps(List<PSDEDQCodeExpDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", dtoList);
	}

    /**
     * 获取 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDQCodeExpDTO getPSDEDQCodeExp(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", PSDEDQCodeExpDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDQCodeExpDTO> searchPSDEDQCodeExps(PSDEDQCodeExpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", PSDEDQCodeExpDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体查询代码表达式 [PSDEDQCODEEXP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDQCodeExpDTO> searchAllPSDEDQCodeExps(PSDEDQCodeExpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDQCODEEXP, "psdedqcodeexps", PSDEDQCodeExpDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系界面分组 [PSDEDRGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDRGroup(PSDEDRGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDRGROUP, "psdedrgroups", PSDEDRGroupDTO.class, dto);
	}

    /**
     * 批建立 实体关系界面分组 [PSDEDRGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDRGroups(List<PSDEDRGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDRGROUP, "psdedrgroups", dtoList);
	}

    /**
     * 更新 实体关系界面分组 [PSDEDRGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDRGroup(PSDEDRGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDRGROUP, "psdedrgroups", PSDEDRGroupDTO.class, dto);
	}

    /**
     * 批更新 实体关系界面分组 [PSDEDRGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDRGroups(List<PSDEDRGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDRGROUP, "psdedrgroups", dtoList);
	}

    /**
     * 获取 实体关系界面分组 [PSDEDRGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDRGroupDTO getPSDEDRGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDRGROUP, "psdedrgroups", PSDEDRGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系界面分组 [PSDEDRGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDRGroupDTO> searchPSDEDRGroups(PSDEDRGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDRGROUP, "psdedrgroups", PSDEDRGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系界面分组 [PSDEDRGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDRGroupDTO> searchAllPSDEDRGroups(PSDEDRGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDRGROUP, "psdedrgroups", PSDEDRGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系界面 [PSDEDRITEM]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDRItem(PSDEDRItemDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDRITEM, "psdedritems", PSDEDRItemDTO.class, dto);
	}

    /**
     * 批建立 实体关系界面 [PSDEDRITEM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDRItems(List<PSDEDRItemDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDRITEM, "psdedritems", dtoList);
	}

    /**
     * 更新 实体关系界面 [PSDEDRITEM]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDRItem(PSDEDRItemDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDRITEM, "psdedritems", PSDEDRItemDTO.class, dto);
	}

    /**
     * 批更新 实体关系界面 [PSDEDRITEM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDRItems(List<PSDEDRItemDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDRITEM, "psdedritems", dtoList);
	}

    /**
     * 获取 实体关系界面 [PSDEDRITEM]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDRItemDTO getPSDEDRItem(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDRITEM, "psdedritems", PSDEDRItemDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系界面 [PSDEDRITEM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDRItemDTO> searchPSDEDRItems(PSDEDRItemFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDRITEM, "psdedritems", PSDEDRItemDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系界面 [PSDEDRITEM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDRItemDTO> searchAllPSDEDRItems(PSDEDRItemFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDRITEM, "psdedritems", PSDEDRItemDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据导出 [PSDEDATAEXP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataExp(PSDEDataExpDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAEXP, "psdedataexps", PSDEDataExpDTO.class, dto);
	}

    /**
     * 批建立 实体数据导出 [PSDEDATAEXP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataExps(List<PSDEDataExpDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAEXP, "psdedataexps", dtoList);
	}

    /**
     * 更新 实体数据导出 [PSDEDATAEXP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataExp(PSDEDataExpDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAEXP, "psdedataexps", PSDEDataExpDTO.class, dto);
	}

    /**
     * 批更新 实体数据导出 [PSDEDATAEXP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataExps(List<PSDEDataExpDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAEXP, "psdedataexps", dtoList);
	}

    /**
     * 获取 实体数据导出 [PSDEDATAEXP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataExpDTO getPSDEDataExp(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATAEXP, "psdedataexps", PSDEDataExpDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据导出 [PSDEDATAEXP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataExpDTO> searchPSDEDataExps(PSDEDataExpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATAEXP, "psdedataexps", PSDEDataExpDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据导出 [PSDEDATAEXP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataExpDTO> searchAllPSDEDataExps(PSDEDataExpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATAEXP, "psdedataexps", PSDEDataExpDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据导入 [PSDEDATAIMP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataImp(PSDEDataImpDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAIMP, "psdedataimps", PSDEDataImpDTO.class, dto);
	}

    /**
     * 批建立 实体数据导入 [PSDEDATAIMP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataImps(List<PSDEDataImpDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAIMP, "psdedataimps", dtoList);
	}

    /**
     * 更新 实体数据导入 [PSDEDATAIMP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataImp(PSDEDataImpDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAIMP, "psdedataimps", PSDEDataImpDTO.class, dto);
	}

    /**
     * 批更新 实体数据导入 [PSDEDATAIMP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataImps(List<PSDEDataImpDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAIMP, "psdedataimps", dtoList);
	}

    /**
     * 获取 实体数据导入 [PSDEDATAIMP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataImpDTO getPSDEDataImp(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATAIMP, "psdedataimps", PSDEDataImpDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据导入 [PSDEDATAIMP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataImpDTO> searchPSDEDataImps(PSDEDataImpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATAIMP, "psdedataimps", PSDEDataImpDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据导入 [PSDEDATAIMP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataImpDTO> searchAllPSDEDataImps(PSDEDataImpFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATAIMP, "psdedataimps", PSDEDataImpDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据查询 [PSDEDATAQUERY]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataQuery(PSDEDataQueryDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAQUERY, "psdedataqueries", PSDEDataQueryDTO.class, dto);
	}

    /**
     * 批建立 实体数据查询 [PSDEDATAQUERY]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataQueries(List<PSDEDataQueryDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATAQUERY, "psdedataqueries", dtoList);
	}

    /**
     * 更新 实体数据查询 [PSDEDATAQUERY]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataQuery(PSDEDataQueryDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAQUERY, "psdedataqueries", PSDEDataQueryDTO.class, dto);
	}

    /**
     * 批更新 实体数据查询 [PSDEDATAQUERY]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataQueries(List<PSDEDataQueryDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATAQUERY, "psdedataqueries", dtoList);
	}

    /**
     * 获取 实体数据查询 [PSDEDATAQUERY]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataQueryDTO getPSDEDataQuery(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATAQUERY, "psdedataqueries", PSDEDataQueryDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据查询 [PSDEDATAQUERY]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataQueryDTO> searchPSDEDataQueries(PSDEDataQueryFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATAQUERY, "psdedataqueries", PSDEDataQueryDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据查询 [PSDEDATAQUERY]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataQueryDTO> searchAllPSDEDataQueries(PSDEDataQueryFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATAQUERY, "psdedataqueries", PSDEDataQueryDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系界面组 [PSDEDATARELATION]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataRelation(PSDEDataRelationDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATARELATION, "psdedatarelations", PSDEDataRelationDTO.class, dto);
	}

    /**
     * 批建立 实体关系界面组 [PSDEDATARELATION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataRelations(List<PSDEDataRelationDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATARELATION, "psdedatarelations", dtoList);
	}

    /**
     * 更新 实体关系界面组 [PSDEDATARELATION]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataRelation(PSDEDataRelationDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATARELATION, "psdedatarelations", PSDEDataRelationDTO.class, dto);
	}

    /**
     * 批更新 实体关系界面组 [PSDEDATARELATION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataRelations(List<PSDEDataRelationDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATARELATION, "psdedatarelations", dtoList);
	}

    /**
     * 获取 实体关系界面组 [PSDEDATARELATION]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataRelationDTO getPSDEDataRelation(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATARELATION, "psdedatarelations", PSDEDataRelationDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系界面组 [PSDEDATARELATION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataRelationDTO> searchPSDEDataRelations(PSDEDataRelationFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATARELATION, "psdedatarelations", PSDEDataRelationDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系界面组 [PSDEDATARELATION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataRelationDTO> searchAllPSDEDataRelations(PSDEDataRelationFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATARELATION, "psdedatarelations", PSDEDataRelationDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据集合 [PSDEDATASET]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataSet(PSDEDataSetDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATASET, "psdedatasets", PSDEDataSetDTO.class, dto);
	}

    /**
     * 批建立 实体数据集合 [PSDEDATASET]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataSets(List<PSDEDataSetDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATASET, "psdedatasets", dtoList);
	}

    /**
     * 更新 实体数据集合 [PSDEDATASET]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataSet(PSDEDataSetDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATASET, "psdedatasets", PSDEDataSetDTO.class, dto);
	}

    /**
     * 批更新 实体数据集合 [PSDEDATASET]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataSets(List<PSDEDataSetDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATASET, "psdedatasets", dtoList);
	}

    /**
     * 获取 实体数据集合 [PSDEDATASET]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataSetDTO getPSDEDataSet(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATASET, "psdedatasets", PSDEDataSetDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据集合 [PSDEDATASET]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataSetDTO> searchPSDEDataSets(PSDEDataSetFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATASET, "psdedatasets", PSDEDataSetDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据集合 [PSDEDATASET]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataSetDTO> searchAllPSDEDataSets(PSDEDataSetFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATASET, "psdedatasets", PSDEDataSetDTO.class, iSearchContext);
	}

    /**
     * 建立 实体数据同步 [PSDEDATASYNC]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEDataSync(PSDEDataSyncDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEDATASYNC, "psdedatasyncs", PSDEDataSyncDTO.class, dto);
	}

    /**
     * 批建立 实体数据同步 [PSDEDATASYNC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEDataSyncs(List<PSDEDataSyncDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEDATASYNC, "psdedatasyncs", dtoList);
	}

    /**
     * 更新 实体数据同步 [PSDEDATASYNC]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEDataSync(PSDEDataSyncDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATASYNC, "psdedatasyncs", PSDEDataSyncDTO.class, dto);
	}

    /**
     * 批更新 实体数据同步 [PSDEDATASYNC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEDataSyncs(List<PSDEDataSyncDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEDATASYNC, "psdedatasyncs", dtoList);
	}

    /**
     * 获取 实体数据同步 [PSDEDATASYNC]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEDataSyncDTO getPSDEDataSync(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEDATASYNC, "psdedatasyncs", PSDEDataSyncDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体数据同步 [PSDEDATASYNC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEDataSyncDTO> searchPSDEDataSyncs(PSDEDataSyncFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEDATASYNC, "psdedatasyncs", PSDEDataSyncDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体数据同步 [PSDEDATASYNC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEDataSyncDTO> searchAllPSDEDataSyncs(PSDEDataSyncFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEDATASYNC, "psdedatasyncs", PSDEDataSyncDTO.class, iSearchContext);
	}

    /**
     * 建立 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEFInputTip(PSDEFInputTipDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEFINPUTTIP, "psdefinputtips", PSDEFInputTipDTO.class, dto);
	}

    /**
     * 批建立 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEFInputTips(List<PSDEFInputTipDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEFINPUTTIP, "psdefinputtips", dtoList);
	}

    /**
     * 更新 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEFInputTip(PSDEFInputTipDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEFINPUTTIP, "psdefinputtips", PSDEFInputTipDTO.class, dto);
	}

    /**
     * 批更新 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEFInputTips(List<PSDEFInputTipDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEFINPUTTIP, "psdefinputtips", dtoList);
	}

    /**
     * 获取 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEFInputTipDTO getPSDEFInputTip(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEFINPUTTIP, "psdefinputtips", PSDEFInputTipDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEFInputTipDTO> searchPSDEFInputTips(PSDEFInputTipFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEFINPUTTIP, "psdefinputtips", PSDEFInputTipDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体属性输入提示 [PSDEFINPUTTIP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEFInputTipDTO> searchAllPSDEFInputTips(PSDEFInputTipFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEFINPUTTIP, "psdefinputtips", PSDEFInputTipDTO.class, iSearchContext);
	}

    /**
     * 建立 实体属性界面配置 [PSDEFUIMODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEFUIMode(PSDEFUIModeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEFUIMODE, "psdefuimodes", PSDEFUIModeDTO.class, dto);
	}

    /**
     * 批建立 实体属性界面配置 [PSDEFUIMODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEFUIModes(List<PSDEFUIModeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEFUIMODE, "psdefuimodes", dtoList);
	}

    /**
     * 更新 实体属性界面配置 [PSDEFUIMODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEFUIMode(PSDEFUIModeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEFUIMODE, "psdefuimodes", PSDEFUIModeDTO.class, dto);
	}

    /**
     * 批更新 实体属性界面配置 [PSDEFUIMODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEFUIModes(List<PSDEFUIModeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEFUIMODE, "psdefuimodes", dtoList);
	}

    /**
     * 获取 实体属性界面配置 [PSDEFUIMODE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEFUIModeDTO getPSDEFUIMode(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEFUIMODE, "psdefuimodes", PSDEFUIModeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体属性界面配置 [PSDEFUIMODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEFUIModeDTO> searchPSDEFUIModes(PSDEFUIModeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEFUIMODE, "psdefuimodes", PSDEFUIModeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体属性界面配置 [PSDEFUIMODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEFUIModeDTO> searchAllPSDEFUIModes(PSDEFUIModeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEFUIMODE, "psdefuimodes", PSDEFUIModeDTO.class, iSearchContext);
	}

    /**
     * 建立 实体属性值规则 [PSDEFVALUERULE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEFValueRule(PSDEFValueRuleDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEFVALUERULE, "psdefvaluerules", PSDEFValueRuleDTO.class, dto);
	}

    /**
     * 批建立 实体属性值规则 [PSDEFVALUERULE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEFValueRules(List<PSDEFValueRuleDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEFVALUERULE, "psdefvaluerules", dtoList);
	}

    /**
     * 更新 实体属性值规则 [PSDEFVALUERULE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEFValueRule(PSDEFValueRuleDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEFVALUERULE, "psdefvaluerules", PSDEFValueRuleDTO.class, dto);
	}

    /**
     * 批更新 实体属性值规则 [PSDEFVALUERULE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEFValueRules(List<PSDEFValueRuleDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEFVALUERULE, "psdefvaluerules", dtoList);
	}

    /**
     * 获取 实体属性值规则 [PSDEFVALUERULE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEFValueRuleDTO getPSDEFValueRule(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEFVALUERULE, "psdefvaluerules", PSDEFValueRuleDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体属性值规则 [PSDEFVALUERULE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEFValueRuleDTO> searchPSDEFValueRules(PSDEFValueRuleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEFVALUERULE, "psdefvaluerules", PSDEFValueRuleDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体属性值规则 [PSDEFVALUERULE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEFValueRuleDTO> searchAllPSDEFValueRules(PSDEFValueRuleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEFVALUERULE, "psdefvaluerules", PSDEFValueRuleDTO.class, iSearchContext);
	}

    /**
     * 建立 实体表单 [PSDEFORM]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEForm(PSDEFormDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEFORM, "psdeforms", PSDEFormDTO.class, dto);
	}

    /**
     * 批建立 实体表单 [PSDEFORM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEForms(List<PSDEFormDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEFORM, "psdeforms", dtoList);
	}

    /**
     * 更新 实体表单 [PSDEFORM]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEForm(PSDEFormDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEFORM, "psdeforms", PSDEFormDTO.class, dto);
	}

    /**
     * 批更新 实体表单 [PSDEFORM]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEForms(List<PSDEFormDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEFORM, "psdeforms", dtoList);
	}

    /**
     * 获取 实体表单 [PSDEFORM]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEFormDTO getPSDEForm(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEFORM, "psdeforms", PSDEFormDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体表单 [PSDEFORM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEFormDTO> searchPSDEForms(PSDEFormFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEFORM, "psdeforms", PSDEFormDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体表单 [PSDEFORM]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEFormDTO> searchAllPSDEForms(PSDEFormFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEFORM, "psdeforms", PSDEFormDTO.class, iSearchContext);
	}

    /**
     * 建立 实体处理逻辑 [PSDELOGIC]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDELogic(PSDELogicDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDELOGIC, "psdelogics", PSDELogicDTO.class, dto);
	}

    /**
     * 批建立 实体处理逻辑 [PSDELOGIC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDELogics(List<PSDELogicDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDELOGIC, "psdelogics", dtoList);
	}

    /**
     * 更新 实体处理逻辑 [PSDELOGIC]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDELogic(PSDELogicDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDELOGIC, "psdelogics", PSDELogicDTO.class, dto);
	}

    /**
     * 批更新 实体处理逻辑 [PSDELOGIC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDELogics(List<PSDELogicDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDELOGIC, "psdelogics", dtoList);
	}

    /**
     * 获取 实体处理逻辑 [PSDELOGIC]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDELogicDTO getPSDELogic(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDELOGIC, "psdelogics", PSDELogicDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体处理逻辑 [PSDELOGIC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDELogicDTO> searchPSDELogics(PSDELogicFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDELOGIC, "psdelogics", PSDELogicDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体处理逻辑 [PSDELOGIC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDELogicDTO> searchAllPSDELogics(PSDELogicFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDELOGIC, "psdelogics", PSDELogicDTO.class, iSearchContext);
	}

    /**
     * 建立 实体映射 [PSDEMAP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEMap(PSDEMapDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEMAP, "psdemaps", PSDEMapDTO.class, dto);
	}

    /**
     * 批建立 实体映射 [PSDEMAP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEMaps(List<PSDEMapDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEMAP, "psdemaps", dtoList);
	}

    /**
     * 更新 实体映射 [PSDEMAP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEMap(PSDEMapDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAP, "psdemaps", PSDEMapDTO.class, dto);
	}

    /**
     * 批更新 实体映射 [PSDEMAP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEMaps(List<PSDEMapDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAP, "psdemaps", dtoList);
	}

    /**
     * 获取 实体映射 [PSDEMAP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEMapDTO getPSDEMap(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEMAP, "psdemaps", PSDEMapDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体映射 [PSDEMAP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEMapDTO> searchPSDEMaps(PSDEMapFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEMAP, "psdemaps", PSDEMapDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体映射 [PSDEMAP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEMapDTO> searchAllPSDEMaps(PSDEMapFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEMAP, "psdemaps", PSDEMapDTO.class, iSearchContext);
	}

    /**
     * 建立 实体映射行为 [PSDEMAPACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEMapAction(PSDEMapActionDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPACTION, "psdemapactions", PSDEMapActionDTO.class, dto);
	}

    /**
     * 批建立 实体映射行为 [PSDEMAPACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEMapActions(List<PSDEMapActionDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPACTION, "psdemapactions", dtoList);
	}

    /**
     * 更新 实体映射行为 [PSDEMAPACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEMapAction(PSDEMapActionDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPACTION, "psdemapactions", PSDEMapActionDTO.class, dto);
	}

    /**
     * 批更新 实体映射行为 [PSDEMAPACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEMapActions(List<PSDEMapActionDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPACTION, "psdemapactions", dtoList);
	}

    /**
     * 获取 实体映射行为 [PSDEMAPACTION]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEMapActionDTO getPSDEMapAction(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEMAPACTION, "psdemapactions", PSDEMapActionDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体映射行为 [PSDEMAPACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEMapActionDTO> searchPSDEMapActions(PSDEMapActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEMAPACTION, "psdemapactions", PSDEMapActionDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体映射行为 [PSDEMAPACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEMapActionDTO> searchAllPSDEMapActions(PSDEMapActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEMAPACTION, "psdemapactions", PSDEMapActionDTO.class, iSearchContext);
	}

    /**
     * 建立 实体映射查询 [PSDEMAPDQ]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEMapDQ(PSDEMapDQDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDQ, "psdemapdqs", PSDEMapDQDTO.class, dto);
	}

    /**
     * 批建立 实体映射查询 [PSDEMAPDQ]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEMapDQs(List<PSDEMapDQDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDQ, "psdemapdqs", dtoList);
	}

    /**
     * 更新 实体映射查询 [PSDEMAPDQ]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEMapDQ(PSDEMapDQDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDQ, "psdemapdqs", PSDEMapDQDTO.class, dto);
	}

    /**
     * 批更新 实体映射查询 [PSDEMAPDQ]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEMapDQs(List<PSDEMapDQDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDQ, "psdemapdqs", dtoList);
	}

    /**
     * 获取 实体映射查询 [PSDEMAPDQ]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEMapDQDTO getPSDEMapDQ(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEMAPDQ, "psdemapdqs", PSDEMapDQDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体映射查询 [PSDEMAPDQ]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEMapDQDTO> searchPSDEMapDQs(PSDEMapDQFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEMAPDQ, "psdemapdqs", PSDEMapDQDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体映射查询 [PSDEMAPDQ]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEMapDQDTO> searchAllPSDEMapDQs(PSDEMapDQFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEMAPDQ, "psdemapdqs", PSDEMapDQDTO.class, iSearchContext);
	}

    /**
     * 建立 实体映射数据集合 [PSDEMAPDS]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEMapDS(PSDEMapDSDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDS, "psdemapds", PSDEMapDSDTO.class, dto);
	}

    /**
     * 批建立 实体映射数据集合 [PSDEMAPDS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEMapDs(List<PSDEMapDSDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDS, "psdemapds", dtoList);
	}

    /**
     * 更新 实体映射数据集合 [PSDEMAPDS]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEMapDS(PSDEMapDSDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDS, "psdemapds", PSDEMapDSDTO.class, dto);
	}

    /**
     * 批更新 实体映射数据集合 [PSDEMAPDS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEMapDs(List<PSDEMapDSDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDS, "psdemapds", dtoList);
	}

    /**
     * 获取 实体映射数据集合 [PSDEMAPDS]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEMapDSDTO getPSDEMapDS(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEMAPDS, "psdemapds", PSDEMapDSDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体映射数据集合 [PSDEMAPDS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEMapDSDTO> searchPSDEMapDs(PSDEMapDSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEMAPDS, "psdemapds", PSDEMapDSDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体映射数据集合 [PSDEMAPDS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEMapDSDTO> searchAllPSDEMapDs(PSDEMapDSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEMAPDS, "psdemapds", PSDEMapDSDTO.class, iSearchContext);
	}

    /**
     * 建立 实体映射属性 [PSDEMAPDETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEMapDetail(PSDEMapDetailDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDETAIL, "psdemapdetails", PSDEMapDetailDTO.class, dto);
	}

    /**
     * 批建立 实体映射属性 [PSDEMAPDETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEMapDetails(List<PSDEMapDetailDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEMAPDETAIL, "psdemapdetails", dtoList);
	}

    /**
     * 更新 实体映射属性 [PSDEMAPDETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEMapDetail(PSDEMapDetailDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDETAIL, "psdemapdetails", PSDEMapDetailDTO.class, dto);
	}

    /**
     * 批更新 实体映射属性 [PSDEMAPDETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEMapDetails(List<PSDEMapDetailDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEMAPDETAIL, "psdemapdetails", dtoList);
	}

    /**
     * 获取 实体映射属性 [PSDEMAPDETAIL]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEMapDetailDTO getPSDEMapDetail(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEMAPDETAIL, "psdemapdetails", PSDEMapDetailDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体映射属性 [PSDEMAPDETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEMapDetailDTO> searchPSDEMapDetails(PSDEMapDetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEMAPDETAIL, "psdemapdetails", PSDEMapDetailDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体映射属性 [PSDEMAPDETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEMapDetailDTO> searchAllPSDEMapDetails(PSDEMapDetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEMAPDETAIL, "psdemapdetails", PSDEMapDetailDTO.class, iSearchContext);
	}

    /**
     * 建立 实体操作标识 [PSDEOPPRIV]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEOPPriv(PSDEOPPrivDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEOPPRIV, "psdeopprivs", PSDEOPPrivDTO.class, dto);
	}

    /**
     * 批建立 实体操作标识 [PSDEOPPRIV]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEOPPrivs(List<PSDEOPPrivDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEOPPRIV, "psdeopprivs", dtoList);
	}

    /**
     * 更新 实体操作标识 [PSDEOPPRIV]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEOPPriv(PSDEOPPrivDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEOPPRIV, "psdeopprivs", PSDEOPPrivDTO.class, dto);
	}

    /**
     * 批更新 实体操作标识 [PSDEOPPRIV]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEOPPrivs(List<PSDEOPPrivDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEOPPRIV, "psdeopprivs", dtoList);
	}

    /**
     * 获取 实体操作标识 [PSDEOPPRIV]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEOPPrivDTO getPSDEOPPriv(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEOPPRIV, "psdeopprivs", PSDEOPPrivDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体操作标识 [PSDEOPPRIV]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEOPPrivDTO> searchPSDEOPPrivs(PSDEOPPrivFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEOPPRIV, "psdeopprivs", PSDEOPPrivDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体操作标识 [PSDEOPPRIV]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEOPPrivDTO> searchAllPSDEOPPrivs(PSDEOPPrivFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEOPPRIV, "psdeopprivs", PSDEOPPrivDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系属性映射 [PSDERDEFMAP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDERDEFMap(PSDERDEFMapDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDERDEFMAP, "psderdefmaps", PSDERDEFMapDTO.class, dto);
	}

    /**
     * 批建立 实体关系属性映射 [PSDERDEFMAP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDERDEFMaps(List<PSDERDEFMapDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDERDEFMAP, "psderdefmaps", dtoList);
	}

    /**
     * 更新 实体关系属性映射 [PSDERDEFMAP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDERDEFMap(PSDERDEFMapDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDERDEFMAP, "psderdefmaps", PSDERDEFMapDTO.class, dto);
	}

    /**
     * 批更新 实体关系属性映射 [PSDERDEFMAP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDERDEFMaps(List<PSDERDEFMapDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDERDEFMAP, "psderdefmaps", dtoList);
	}

    /**
     * 获取 实体关系属性映射 [PSDERDEFMAP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDERDEFMapDTO getPSDERDEFMap(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDERDEFMAP, "psderdefmaps", PSDERDEFMapDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系属性映射 [PSDERDEFMAP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDERDEFMapDTO> searchPSDERDEFMaps(PSDERDEFMapFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDERDEFMAP, "psderdefmaps", PSDERDEFMapDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系属性映射 [PSDERDEFMAP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDERDEFMapDTO> searchAllPSDERDEFMaps(PSDERDEFMapFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDERDEFMAP, "psderdefmaps", PSDERDEFMapDTO.class, iSearchContext);
	}

    /**
     * 建立 实体关系组 [PSDERGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDERGroup(PSDERGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDERGROUP, "psdergroups", PSDERGroupDTO.class, dto);
	}

    /**
     * 批建立 实体关系组 [PSDERGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDERGroups(List<PSDERGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDERGROUP, "psdergroups", dtoList);
	}

    /**
     * 更新 实体关系组 [PSDERGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDERGroup(PSDERGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDERGROUP, "psdergroups", PSDERGroupDTO.class, dto);
	}

    /**
     * 批更新 实体关系组 [PSDERGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDERGroups(List<PSDERGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDERGROUP, "psdergroups", dtoList);
	}

    /**
     * 获取 实体关系组 [PSDERGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDERGroupDTO getPSDERGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDERGROUP, "psdergroups", PSDERGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体关系组 [PSDERGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDERGroupDTO> searchPSDERGroups(PSDERGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDERGROUP, "psdergroups", PSDERGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体关系组 [PSDERGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDERGroupDTO> searchAllPSDERGroups(PSDERGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDERGROUP, "psdergroups", PSDERGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 实体服务接口成员 [PSDESADETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDESADetail(PSDESADetailDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDESADETAIL, "psdesadetails", PSDESADetailDTO.class, dto);
	}

    /**
     * 批建立 实体服务接口成员 [PSDESADETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDESADetails(List<PSDESADetailDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDESADETAIL, "psdesadetails", dtoList);
	}

    /**
     * 更新 实体服务接口成员 [PSDESADETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDESADetail(PSDESADetailDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDESADETAIL, "psdesadetails", PSDESADetailDTO.class, dto);
	}

    /**
     * 批更新 实体服务接口成员 [PSDESADETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDESADetails(List<PSDESADetailDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDESADETAIL, "psdesadetails", dtoList);
	}

    /**
     * 获取 实体服务接口成员 [PSDESADETAIL]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDESADetailDTO getPSDESADetail(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDESADETAIL, "psdesadetails", PSDESADetailDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体服务接口成员 [PSDESADETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDESADetailDTO> searchPSDESADetails(PSDESADetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDESADETAIL, "psdesadetails", PSDESADetailDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体服务接口成员 [PSDESADETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDESADetailDTO> searchAllPSDESADetails(PSDESADetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDESADETAIL, "psdesadetails", PSDESADetailDTO.class, iSearchContext);
	}

    /**
     * 建立 实体服务接口关系 [PSDESARS]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDESARS(PSDESARSDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDESARS, "psdesars", PSDESARSDTO.class, dto);
	}

    /**
     * 批建立 实体服务接口关系 [PSDESARS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDESARs(List<PSDESARSDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDESARS, "psdesars", dtoList);
	}

    /**
     * 更新 实体服务接口关系 [PSDESARS]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDESARS(PSDESARSDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDESARS, "psdesars", PSDESARSDTO.class, dto);
	}

    /**
     * 批更新 实体服务接口关系 [PSDESARS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDESARs(List<PSDESARSDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDESARS, "psdesars", dtoList);
	}

    /**
     * 获取 实体服务接口关系 [PSDESARS]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDESARSDTO getPSDESARS(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDESARS, "psdesars", PSDESARSDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体服务接口关系 [PSDESARS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDESARSDTO> searchPSDESARs(PSDESARSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDESARS, "psdesars", PSDESARSDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体服务接口关系 [PSDESARS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDESARSDTO> searchAllPSDESARs(PSDESARSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDESARS, "psdesars", PSDESARSDTO.class, iSearchContext);
	}

    /**
     * 建立 实体示例数据 [PSDESAMPLEDATA]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDESampleData(PSDESampleDataDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDESAMPLEDATA, "psdesampledata", PSDESampleDataDTO.class, dto);
	}

    /**
     * 批建立 实体示例数据 [PSDESAMPLEDATA]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDESampleData(List<PSDESampleDataDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDESAMPLEDATA, "psdesampledata", dtoList);
	}

    /**
     * 更新 实体示例数据 [PSDESAMPLEDATA]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDESampleData(PSDESampleDataDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDESAMPLEDATA, "psdesampledata", PSDESampleDataDTO.class, dto);
	}

    /**
     * 批更新 实体示例数据 [PSDESAMPLEDATA]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDESampleData(List<PSDESampleDataDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDESAMPLEDATA, "psdesampledata", dtoList);
	}

    /**
     * 获取 实体示例数据 [PSDESAMPLEDATA]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDESampleDataDTO getPSDESampleData(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDESAMPLEDATA, "psdesampledata", PSDESampleDataDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体示例数据 [PSDESAMPLEDATA]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDESampleDataDTO> searchPSDESampleData(PSDESampleDataFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDESAMPLEDATA, "psdesampledata", PSDESampleDataDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体示例数据 [PSDESAMPLEDATA]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDESampleDataDTO> searchAllPSDESampleData(PSDESampleDataFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDESAMPLEDATA, "psdesampledata", PSDESampleDataDTO.class, iSearchContext);
	}

    /**
     * 建立 实体服务接口 [PSDESERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEServiceAPI(PSDEServiceAPIDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDESERVICEAPI, "psdeserviceapis", PSDEServiceAPIDTO.class, dto);
	}

    /**
     * 批建立 实体服务接口 [PSDESERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEServiceAPIs(List<PSDEServiceAPIDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDESERVICEAPI, "psdeserviceapis", dtoList);
	}

    /**
     * 更新 实体服务接口 [PSDESERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEServiceAPI(PSDEServiceAPIDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDESERVICEAPI, "psdeserviceapis", PSDEServiceAPIDTO.class, dto);
	}

    /**
     * 批更新 实体服务接口 [PSDESERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEServiceAPIs(List<PSDEServiceAPIDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDESERVICEAPI, "psdeserviceapis", dtoList);
	}

    /**
     * 获取 实体服务接口 [PSDESERVICEAPI]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEServiceAPIDTO getPSDEServiceAPI(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDESERVICEAPI, "psdeserviceapis", PSDEServiceAPIDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体服务接口 [PSDESERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEServiceAPIDTO> searchPSDEServiceAPIs(PSDEServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDESERVICEAPI, "psdeserviceapis", PSDEServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体服务接口 [PSDESERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEServiceAPIDTO> searchAllPSDEServiceAPIs(PSDEServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDESERVICEAPI, "psdeserviceapis", PSDEServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 建立 实体界面行为组 [PSDEUAGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEUAGroup(PSDEUAGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEUAGROUP, "psdeuagroups", PSDEUAGroupDTO.class, dto);
	}

    /**
     * 批建立 实体界面行为组 [PSDEUAGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEUAGroups(List<PSDEUAGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEUAGROUP, "psdeuagroups", dtoList);
	}

    /**
     * 更新 实体界面行为组 [PSDEUAGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEUAGroup(PSDEUAGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEUAGROUP, "psdeuagroups", PSDEUAGroupDTO.class, dto);
	}

    /**
     * 批更新 实体界面行为组 [PSDEUAGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEUAGroups(List<PSDEUAGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEUAGROUP, "psdeuagroups", dtoList);
	}

    /**
     * 获取 实体界面行为组 [PSDEUAGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEUAGroupDTO getPSDEUAGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEUAGROUP, "psdeuagroups", PSDEUAGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体界面行为组 [PSDEUAGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEUAGroupDTO> searchPSDEUAGroups(PSDEUAGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEUAGROUP, "psdeuagroups", PSDEUAGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体界面行为组 [PSDEUAGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEUAGroupDTO> searchAllPSDEUAGroups(PSDEUAGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEUAGROUP, "psdeuagroups", PSDEUAGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 实体界面行为 [PSDEUIACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEUIAction(PSDEUIActionDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEUIACTION, "psdeuiactions", PSDEUIActionDTO.class, dto);
	}

    /**
     * 批建立 实体界面行为 [PSDEUIACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEUIActions(List<PSDEUIActionDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEUIACTION, "psdeuiactions", dtoList);
	}

    /**
     * 更新 实体界面行为 [PSDEUIACTION]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEUIAction(PSDEUIActionDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEUIACTION, "psdeuiactions", PSDEUIActionDTO.class, dto);
	}

    /**
     * 批更新 实体界面行为 [PSDEUIACTION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEUIActions(List<PSDEUIActionDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEUIACTION, "psdeuiactions", dtoList);
	}

    /**
     * 获取 实体界面行为 [PSDEUIACTION]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEUIActionDTO getPSDEUIAction(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEUIACTION, "psdeuiactions", PSDEUIActionDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体界面行为 [PSDEUIACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEUIActionDTO> searchPSDEUIActions(PSDEUIActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEUIACTION, "psdeuiactions", PSDEUIActionDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体界面行为 [PSDEUIACTION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEUIActionDTO> searchAllPSDEUIActions(PSDEUIActionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEUIACTION, "psdeuiactions", PSDEUIActionDTO.class, iSearchContext);
	}

    /**
     * 建立 实体属性值规则组 [PSDEVRGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEVRGroup(PSDEVRGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEVRGROUP, "psdevrgroups", PSDEVRGroupDTO.class, dto);
	}

    /**
     * 批建立 实体属性值规则组 [PSDEVRGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEVRGroups(List<PSDEVRGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEVRGROUP, "psdevrgroups", dtoList);
	}

    /**
     * 更新 实体属性值规则组 [PSDEVRGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEVRGroup(PSDEVRGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEVRGROUP, "psdevrgroups", PSDEVRGroupDTO.class, dto);
	}

    /**
     * 批更新 实体属性值规则组 [PSDEVRGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEVRGroups(List<PSDEVRGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEVRGROUP, "psdevrgroups", dtoList);
	}

    /**
     * 获取 实体属性值规则组 [PSDEVRGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEVRGroupDTO getPSDEVRGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEVRGROUP, "psdevrgroups", PSDEVRGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体属性值规则组 [PSDEVRGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEVRGroupDTO> searchPSDEVRGroups(PSDEVRGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEVRGROUP, "psdevrgroups", PSDEVRGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体属性值规则组 [PSDEVRGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEVRGroupDTO> searchAllPSDEVRGroups(PSDEVRGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEVRGROUP, "psdevrgroups", PSDEVRGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 实体视图 [PSDEVIEWBASE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSDEViewBase(PSDEViewBaseDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSDEVIEWBASE, "psdeviewbases", PSDEViewBaseDTO.class, dto);
	}

    /**
     * 批建立 实体视图 [PSDEVIEWBASE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSDEViewBases(List<PSDEViewBaseDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSDEVIEWBASE, "psdeviewbases", dtoList);
	}

    /**
     * 更新 实体视图 [PSDEVIEWBASE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSDEViewBase(PSDEViewBaseDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSDEVIEWBASE, "psdeviewbases", PSDEViewBaseDTO.class, dto);
	}

    /**
     * 批更新 实体视图 [PSDEVIEWBASE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSDEViewBases(List<PSDEViewBaseDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSDEVIEWBASE, "psdeviewbases", dtoList);
	}

    /**
     * 获取 实体视图 [PSDEVIEWBASE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSDEViewBaseDTO getPSDEViewBase(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSDEVIEWBASE, "psdeviewbases", PSDEViewBaseDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 实体视图 [PSDEVIEWBASE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSDEViewBaseDTO> searchPSDEViewBases(PSDEViewBaseFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSDEVIEWBASE, "psdeviewbases", PSDEViewBaseDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 实体视图 [PSDEVIEWBASE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSDEViewBaseDTO> searchAllPSDEViewBases(PSDEViewBaseFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSDEVIEWBASE, "psdeviewbases", PSDEViewBaseDTO.class, iSearchContext);
	}

    /**
     * 建立 语言资源 [PSLANGUAGERES]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSLanguageRes(PSLanguageResDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSLANGUAGERES, "pslanguageres", PSLanguageResDTO.class, dto);
	}

    /**
     * 批建立 语言资源 [PSLANGUAGERES]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSLanguageRes(List<PSLanguageResDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSLANGUAGERES, "pslanguageres", dtoList);
	}

    /**
     * 更新 语言资源 [PSLANGUAGERES]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSLanguageRes(PSLanguageResDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSLANGUAGERES, "pslanguageres", PSLanguageResDTO.class, dto);
	}

    /**
     * 批更新 语言资源 [PSLANGUAGERES]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSLanguageRes(List<PSLanguageResDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSLANGUAGERES, "pslanguageres", dtoList);
	}

    /**
     * 获取 语言资源 [PSLANGUAGERES]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSLanguageResDTO getPSLanguageRes(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSLANGUAGERES, "pslanguageres", PSLanguageResDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 语言资源 [PSLANGUAGERES]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSLanguageResDTO> searchPSLanguageRes(PSLanguageResFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSLANGUAGERES, "pslanguageres", PSLanguageResDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 语言资源 [PSLANGUAGERES]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSLanguageResDTO> searchAllPSLanguageRes(PSLanguageResFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSLANGUAGERES, "pslanguageres", PSLanguageResDTO.class, iSearchContext);
	}

    /**
     * 建立 模型运行配置 [PSMODELRTCFG]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSModelRTCfg(PSModelRTCfgDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSMODELRTCFG, "psmodelrtcfgs", PSModelRTCfgDTO.class, dto);
	}

    /**
     * 批建立 模型运行配置 [PSMODELRTCFG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSModelRTCfgs(List<PSModelRTCfgDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSMODELRTCFG, "psmodelrtcfgs", dtoList);
	}

    /**
     * 更新 模型运行配置 [PSMODELRTCFG]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSModelRTCfg(PSModelRTCfgDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSMODELRTCFG, "psmodelrtcfgs", PSModelRTCfgDTO.class, dto);
	}

    /**
     * 批更新 模型运行配置 [PSMODELRTCFG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSModelRTCfgs(List<PSModelRTCfgDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSMODELRTCFG, "psmodelrtcfgs", dtoList);
	}

    /**
     * 获取 模型运行配置 [PSMODELRTCFG]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSModelRTCfgDTO getPSModelRTCfg(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSMODELRTCFG, "psmodelrtcfgs", PSModelRTCfgDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 模型运行配置 [PSMODELRTCFG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSModelRTCfgDTO> searchPSModelRTCfgs(PSModelRTCfgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSMODELRTCFG, "psmodelrtcfgs", PSModelRTCfgDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 模型运行配置 [PSMODELRTCFG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSModelRTCfgDTO> searchAllPSModelRTCfgs(PSModelRTCfgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSMODELRTCFG, "psmodelrtcfgs", PSModelRTCfgDTO.class, iSearchContext);
	}

    /**
     * 建立 外部接口实体 [PSSUBSYSSADE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSubSysSADE(PSSubSysSADEDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADE, "pssubsyssades", PSSubSysSADEDTO.class, dto);
	}

    /**
     * 批建立 外部接口实体 [PSSUBSYSSADE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSubSysSADEs(List<PSSubSysSADEDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADE, "pssubsyssades", dtoList);
	}

    /**
     * 更新 外部接口实体 [PSSUBSYSSADE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSubSysSADE(PSSubSysSADEDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADE, "pssubsyssades", PSSubSysSADEDTO.class, dto);
	}

    /**
     * 批更新 外部接口实体 [PSSUBSYSSADE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSubSysSADEs(List<PSSubSysSADEDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADE, "pssubsyssades", dtoList);
	}

    /**
     * 获取 外部接口实体 [PSSUBSYSSADE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSubSysSADEDTO getPSSubSysSADE(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSUBSYSSADE, "pssubsyssades", PSSubSysSADEDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 外部接口实体 [PSSUBSYSSADE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSubSysSADEDTO> searchPSSubSysSADEs(PSSubSysSADEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSUBSYSSADE, "pssubsyssades", PSSubSysSADEDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 外部接口实体 [PSSUBSYSSADE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSubSysSADEDTO> searchAllPSSubSysSADEs(PSSubSysSADEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSUBSYSSADE, "pssubsyssades", PSSubSysSADEDTO.class, iSearchContext);
	}

    /**
     * 建立 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSubSysSADEField(PSSubSysSADEFieldDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", PSSubSysSADEFieldDTO.class, dto);
	}

    /**
     * 批建立 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSubSysSADEFields(List<PSSubSysSADEFieldDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", dtoList);
	}

    /**
     * 更新 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSubSysSADEField(PSSubSysSADEFieldDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", PSSubSysSADEFieldDTO.class, dto);
	}

    /**
     * 批更新 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSubSysSADEFields(List<PSSubSysSADEFieldDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", dtoList);
	}

    /**
     * 获取 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSubSysSADEFieldDTO getPSSubSysSADEField(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", PSSubSysSADEFieldDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSubSysSADEFieldDTO> searchPSSubSysSADEFields(PSSubSysSADEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", PSSubSysSADEFieldDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 外部接口实体属性 [PSSUBSYSSADEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSubSysSADEFieldDTO> searchAllPSSubSysSADEFields(PSSubSysSADEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSUBSYSSADEFIELD, "pssubsyssadefields", PSSubSysSADEFieldDTO.class, iSearchContext);
	}

    /**
     * 建立 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSubSysSADERS(PSSubSysSADERSDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADERS, "pssubsyssaders", PSSubSysSADERSDTO.class, dto);
	}

    /**
     * 批建立 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSubSysSADERs(List<PSSubSysSADERSDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADERS, "pssubsyssaders", dtoList);
	}

    /**
     * 更新 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSubSysSADERS(PSSubSysSADERSDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADERS, "pssubsyssaders", PSSubSysSADERSDTO.class, dto);
	}

    /**
     * 批更新 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSubSysSADERs(List<PSSubSysSADERSDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADERS, "pssubsyssaders", dtoList);
	}

    /**
     * 获取 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSubSysSADERSDTO getPSSubSysSADERS(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSUBSYSSADERS, "pssubsyssaders", PSSubSysSADERSDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSubSysSADERSDTO> searchPSSubSysSADERs(PSSubSysSADERSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSUBSYSSADERS, "pssubsyssaders", PSSubSysSADERSDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 外部接口实体关系 [PSSUBSYSSADERS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSubSysSADERSDTO> searchAllPSSubSysSADERs(PSSubSysSADERSFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSUBSYSSADERS, "pssubsyssaders", PSSubSysSADERSDTO.class, iSearchContext);
	}

    /**
     * 建立 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSubSysSADetail(PSSubSysSADetailDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", PSSubSysSADetailDTO.class, dto);
	}

    /**
     * 批建立 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSubSysSADetails(List<PSSubSysSADetailDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", dtoList);
	}

    /**
     * 更新 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSubSysSADetail(PSSubSysSADetailDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", PSSubSysSADetailDTO.class, dto);
	}

    /**
     * 批更新 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSubSysSADetails(List<PSSubSysSADetailDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", dtoList);
	}

    /**
     * 获取 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSubSysSADetailDTO getPSSubSysSADetail(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", PSSubSysSADetailDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSubSysSADetailDTO> searchPSSubSysSADetails(PSSubSysSADetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", PSSubSysSADetailDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 外部接口实体方法 [PSSUBSYSSADETAIL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSubSysSADetailDTO> searchAllPSSubSysSADetails(PSSubSysSADetailFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSUBSYSSADETAIL, "pssubsyssadetails", PSSubSysSADetailDTO.class, iSearchContext);
	}

    /**
     * 建立 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSubSysServiceAPI(PSSubSysServiceAPIDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", PSSubSysServiceAPIDTO.class, dto);
	}

    /**
     * 批建立 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSubSysServiceAPIs(List<PSSubSysServiceAPIDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", dtoList);
	}

    /**
     * 更新 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSubSysServiceAPI(PSSubSysServiceAPIDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", PSSubSysServiceAPIDTO.class, dto);
	}

    /**
     * 批更新 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSubSysServiceAPIs(List<PSSubSysServiceAPIDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", dtoList);
	}

    /**
     * 获取 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSubSysServiceAPIDTO getPSSubSysServiceAPI(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", PSSubSysServiceAPIDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSubSysServiceAPIDTO> searchPSSubSysServiceAPIs(PSSubSysServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", PSSubSysServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 外部服务接口 [PSSUBSYSSERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSubSysServiceAPIDTO> searchAllPSSubSysServiceAPIs(PSSubSysServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSUBSYSSERVICEAPI, "pssubsysserviceapis", PSSubSysServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 建立 系统内容分类 [PSSYSCONTENTCAT]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysContentCat(PSSysContentCatDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", PSSysContentCatDTO.class, dto);
	}

    /**
     * 批建立 系统内容分类 [PSSYSCONTENTCAT]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysContentCats(List<PSSysContentCatDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", dtoList);
	}

    /**
     * 更新 系统内容分类 [PSSYSCONTENTCAT]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysContentCat(PSSysContentCatDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", PSSysContentCatDTO.class, dto);
	}

    /**
     * 批更新 系统内容分类 [PSSYSCONTENTCAT]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysContentCats(List<PSSysContentCatDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", dtoList);
	}

    /**
     * 获取 系统内容分类 [PSSYSCONTENTCAT]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysContentCatDTO getPSSysContentCat(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", PSSysContentCatDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统内容分类 [PSSYSCONTENTCAT]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysContentCatDTO> searchPSSysContentCats(PSSysContentCatFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", PSSysContentCatDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统内容分类 [PSSYSCONTENTCAT]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysContentCatDTO> searchAllPSSysContentCats(PSSysContentCatFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSCONTENTCAT, "pssyscontentcats", PSSysContentCatDTO.class, iSearchContext);
	}

    /**
     * 建立 系统界面样式表 [PSSYSCSS]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysCss(PSSysCssDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSCSS, "pssyscsses", PSSysCssDTO.class, dto);
	}

    /**
     * 批建立 系统界面样式表 [PSSYSCSS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysCsses(List<PSSysCssDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSCSS, "pssyscsses", dtoList);
	}

    /**
     * 更新 系统界面样式表 [PSSYSCSS]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysCss(PSSysCssDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCSS, "pssyscsses", PSSysCssDTO.class, dto);
	}

    /**
     * 批更新 系统界面样式表 [PSSYSCSS]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysCsses(List<PSSysCssDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCSS, "pssyscsses", dtoList);
	}

    /**
     * 获取 系统界面样式表 [PSSYSCSS]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysCssDTO getPSSysCss(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSCSS, "pssyscsses", PSSysCssDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统界面样式表 [PSSYSCSS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysCssDTO> searchPSSysCsses(PSSysCssFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSCSS, "pssyscsses", PSSysCssDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统界面样式表 [PSSYSCSS]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysCssDTO> searchAllPSSysCsses(PSSysCssFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSCSS, "pssyscsses", PSSysCssDTO.class, iSearchContext);
	}

    /**
     * 建立 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysCssCat(PSSysCssCatDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSCSSCAT, "pssyscsscats", PSSysCssCatDTO.class, dto);
	}

    /**
     * 批建立 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysCssCats(List<PSSysCssCatDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSCSSCAT, "pssyscsscats", dtoList);
	}

    /**
     * 更新 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysCssCat(PSSysCssCatDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCSSCAT, "pssyscsscats", PSSysCssCatDTO.class, dto);
	}

    /**
     * 批更新 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysCssCats(List<PSSysCssCatDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSCSSCAT, "pssyscsscats", dtoList);
	}

    /**
     * 获取 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysCssCatDTO getPSSysCssCat(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSCSSCAT, "pssyscsscats", PSSysCssCatDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysCssCatDTO> searchPSSysCssCats(PSSysCssCatFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSCSSCAT, "pssyscsscats", PSSysCssCatDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统界面样式表分类 [PSSYSCSSCAT]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysCssCatDTO> searchAllPSSysCssCats(PSSysCssCatFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSCSSCAT, "pssyscsscats", PSSysCssCatDTO.class, iSearchContext);
	}

    /**
     * 建立 数据库列 [PSSYSDBCOLUMN]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysDBColumn(PSSysDBColumnDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", PSSysDBColumnDTO.class, dto);
	}

    /**
     * 批建立 数据库列 [PSSYSDBCOLUMN]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysDBColumns(List<PSSysDBColumnDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", dtoList);
	}

    /**
     * 更新 数据库列 [PSSYSDBCOLUMN]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysDBColumn(PSSysDBColumnDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", PSSysDBColumnDTO.class, dto);
	}

    /**
     * 批更新 数据库列 [PSSYSDBCOLUMN]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysDBColumns(List<PSSysDBColumnDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", dtoList);
	}

    /**
     * 获取 数据库列 [PSSYSDBCOLUMN]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysDBColumnDTO getPSSysDBColumn(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", PSSysDBColumnDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 数据库列 [PSSYSDBCOLUMN]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysDBColumnDTO> searchPSSysDBColumns(PSSysDBColumnFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", PSSysDBColumnDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 数据库列 [PSSYSDBCOLUMN]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysDBColumnDTO> searchAllPSSysDBColumns(PSSysDBColumnFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSDBCOLUMN, "pssysdbcolumns", PSSysDBColumnDTO.class, iSearchContext);
	}

    /**
     * 建立 系统数据库体系 [PSSYSDBSCHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysDBScheme(PSSysDBSchemeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBSCHEME, "pssysdbschemes", PSSysDBSchemeDTO.class, dto);
	}

    /**
     * 批建立 系统数据库体系 [PSSYSDBSCHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysDBSchemes(List<PSSysDBSchemeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBSCHEME, "pssysdbschemes", dtoList);
	}

    /**
     * 更新 系统数据库体系 [PSSYSDBSCHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysDBScheme(PSSysDBSchemeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBSCHEME, "pssysdbschemes", PSSysDBSchemeDTO.class, dto);
	}

    /**
     * 批更新 系统数据库体系 [PSSYSDBSCHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysDBSchemes(List<PSSysDBSchemeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBSCHEME, "pssysdbschemes", dtoList);
	}

    /**
     * 获取 系统数据库体系 [PSSYSDBSCHEME]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysDBSchemeDTO getPSSysDBScheme(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSDBSCHEME, "pssysdbschemes", PSSysDBSchemeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统数据库体系 [PSSYSDBSCHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysDBSchemeDTO> searchPSSysDBSchemes(PSSysDBSchemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSDBSCHEME, "pssysdbschemes", PSSysDBSchemeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统数据库体系 [PSSYSDBSCHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysDBSchemeDTO> searchAllPSSysDBSchemes(PSSysDBSchemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSDBSCHEME, "pssysdbschemes", PSSysDBSchemeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统数据库表 [PSSYSDBTABLE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysDBTable(PSSysDBTableDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBTABLE, "pssysdbtables", PSSysDBTableDTO.class, dto);
	}

    /**
     * 批建立 系统数据库表 [PSSYSDBTABLE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysDBTables(List<PSSysDBTableDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSDBTABLE, "pssysdbtables", dtoList);
	}

    /**
     * 更新 系统数据库表 [PSSYSDBTABLE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysDBTable(PSSysDBTableDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBTABLE, "pssysdbtables", PSSysDBTableDTO.class, dto);
	}

    /**
     * 批更新 系统数据库表 [PSSYSDBTABLE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysDBTables(List<PSSysDBTableDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDBTABLE, "pssysdbtables", dtoList);
	}

    /**
     * 获取 系统数据库表 [PSSYSDBTABLE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysDBTableDTO getPSSysDBTable(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSDBTABLE, "pssysdbtables", PSSysDBTableDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统数据库表 [PSSYSDBTABLE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysDBTableDTO> searchPSSysDBTables(PSSysDBTableFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSDBTABLE, "pssysdbtables", PSSysDBTableDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统数据库表 [PSSYSDBTABLE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysDBTableDTO> searchAllPSSysDBTables(PSSysDBTableFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSDBTABLE, "pssysdbtables", PSSysDBTableDTO.class, iSearchContext);
	}

    /**
     * 建立 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysDEFType(PSSysDEFTypeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSDEFTYPE, "pssysdeftypes", PSSysDEFTypeDTO.class, dto);
	}

    /**
     * 批建立 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysDEFTypes(List<PSSysDEFTypeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSDEFTYPE, "pssysdeftypes", dtoList);
	}

    /**
     * 更新 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysDEFType(PSSysDEFTypeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDEFTYPE, "pssysdeftypes", PSSysDEFTypeDTO.class, dto);
	}

    /**
     * 批更新 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysDEFTypes(List<PSSysDEFTypeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDEFTYPE, "pssysdeftypes", dtoList);
	}

    /**
     * 获取 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysDEFTypeDTO getPSSysDEFType(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSDEFTYPE, "pssysdeftypes", PSSysDEFTypeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysDEFTypeDTO> searchPSSysDEFTypes(PSSysDEFTypeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSDEFTYPE, "pssysdeftypes", PSSysDEFTypeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统属性类型逻辑 [PSSYSDEFTYPE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysDEFTypeDTO> searchAllPSSysDEFTypes(PSSysDEFTypeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSDEFTYPE, "pssysdeftypes", PSSysDEFTypeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysDELogicNode(PSSysDELogicNodeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", PSSysDELogicNodeDTO.class, dto);
	}

    /**
     * 批建立 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysDELogicNodes(List<PSSysDELogicNodeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", dtoList);
	}

    /**
     * 更新 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysDELogicNode(PSSysDELogicNodeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", PSSysDELogicNodeDTO.class, dto);
	}

    /**
     * 批更新 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysDELogicNodes(List<PSSysDELogicNodeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", dtoList);
	}

    /**
     * 获取 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysDELogicNodeDTO getPSSysDELogicNode(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", PSSysDELogicNodeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysDELogicNodeDTO> searchPSSysDELogicNodes(PSSysDELogicNodeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", PSSysDELogicNodeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统处理逻辑 [PSSYSDELOGICNODE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysDELogicNodeDTO> searchAllPSSysDELogicNodes(PSSysDELogicNodeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSDELOGICNODE, "pssysdelogicnodes", PSSysDELogicNodeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统图片资源 [PSSYSIMAGE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysImage(PSSysImageDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSIMAGE, "pssysimages", PSSysImageDTO.class, dto);
	}

    /**
     * 批建立 系统图片资源 [PSSYSIMAGE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysImages(List<PSSysImageDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSIMAGE, "pssysimages", dtoList);
	}

    /**
     * 更新 系统图片资源 [PSSYSIMAGE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysImage(PSSysImageDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSIMAGE, "pssysimages", PSSysImageDTO.class, dto);
	}

    /**
     * 批更新 系统图片资源 [PSSYSIMAGE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysImages(List<PSSysImageDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSIMAGE, "pssysimages", dtoList);
	}

    /**
     * 获取 系统图片资源 [PSSYSIMAGE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysImageDTO getPSSysImage(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSIMAGE, "pssysimages", PSSysImageDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统图片资源 [PSSYSIMAGE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysImageDTO> searchPSSysImages(PSSysImageFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSIMAGE, "pssysimages", PSSysImageDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统图片资源 [PSSYSIMAGE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysImageDTO> searchAllPSSysImages(PSSysImageFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSIMAGE, "pssysimages", PSSysImageDTO.class, iSearchContext);
	}

    /**
     * 建立 系统模型组 [PSSYSMODELGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysModelGroup(PSSysModelGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", PSSysModelGroupDTO.class, dto);
	}

    /**
     * 批建立 系统模型组 [PSSYSMODELGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysModelGroups(List<PSSysModelGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", dtoList);
	}

    /**
     * 更新 系统模型组 [PSSYSMODELGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysModelGroup(PSSysModelGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", PSSysModelGroupDTO.class, dto);
	}

    /**
     * 批更新 系统模型组 [PSSYSMODELGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysModelGroups(List<PSSysModelGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", dtoList);
	}

    /**
     * 获取 系统模型组 [PSSYSMODELGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysModelGroupDTO getPSSysModelGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", PSSysModelGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统模型组 [PSSYSMODELGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysModelGroupDTO> searchPSSysModelGroups(PSSysModelGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", PSSysModelGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统模型组 [PSSYSMODELGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysModelGroupDTO> searchAllPSSysModelGroups(PSSysModelGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSMODELGROUP, "pssysmodelgroups", PSSysModelGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 系统消息队列 [PSSYSMSGQUEUE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysMsgQueue(PSSysMsgQueueDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", PSSysMsgQueueDTO.class, dto);
	}

    /**
     * 批建立 系统消息队列 [PSSYSMSGQUEUE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysMsgQueues(List<PSSysMsgQueueDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", dtoList);
	}

    /**
     * 更新 系统消息队列 [PSSYSMSGQUEUE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysMsgQueue(PSSysMsgQueueDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", PSSysMsgQueueDTO.class, dto);
	}

    /**
     * 批更新 系统消息队列 [PSSYSMSGQUEUE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysMsgQueues(List<PSSysMsgQueueDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", dtoList);
	}

    /**
     * 获取 系统消息队列 [PSSYSMSGQUEUE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysMsgQueueDTO getPSSysMsgQueue(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", PSSysMsgQueueDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统消息队列 [PSSYSMSGQUEUE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysMsgQueueDTO> searchPSSysMsgQueues(PSSysMsgQueueFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", PSSysMsgQueueDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统消息队列 [PSSYSMSGQUEUE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysMsgQueueDTO> searchAllPSSysMsgQueues(PSSysMsgQueueFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSMSGQUEUE, "pssysmsgqueues", PSSysMsgQueueDTO.class, iSearchContext);
	}

    /**
     * 建立 系统消息目标 [PSSYSMSGTARGET]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysMsgTarget(PSSysMsgTargetDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", PSSysMsgTargetDTO.class, dto);
	}

    /**
     * 批建立 系统消息目标 [PSSYSMSGTARGET]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysMsgTargets(List<PSSysMsgTargetDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", dtoList);
	}

    /**
     * 更新 系统消息目标 [PSSYSMSGTARGET]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysMsgTarget(PSSysMsgTargetDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", PSSysMsgTargetDTO.class, dto);
	}

    /**
     * 批更新 系统消息目标 [PSSYSMSGTARGET]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysMsgTargets(List<PSSysMsgTargetDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", dtoList);
	}

    /**
     * 获取 系统消息目标 [PSSYSMSGTARGET]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysMsgTargetDTO getPSSysMsgTarget(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", PSSysMsgTargetDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统消息目标 [PSSYSMSGTARGET]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysMsgTargetDTO> searchPSSysMsgTargets(PSSysMsgTargetFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", PSSysMsgTargetDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统消息目标 [PSSYSMSGTARGET]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysMsgTargetDTO> searchAllPSSysMsgTargets(PSSysMsgTargetFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSMSGTARGET, "pssysmsgtargets", PSSysMsgTargetDTO.class, iSearchContext);
	}

    /**
     * 建立 系统消息模板 [PSSYSMSGTEMPL]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysMsgTempl(PSSysMsgTemplDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", PSSysMsgTemplDTO.class, dto);
	}

    /**
     * 批建立 系统消息模板 [PSSYSMSGTEMPL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysMsgTempls(List<PSSysMsgTemplDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", dtoList);
	}

    /**
     * 更新 系统消息模板 [PSSYSMSGTEMPL]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysMsgTempl(PSSysMsgTemplDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", PSSysMsgTemplDTO.class, dto);
	}

    /**
     * 批更新 系统消息模板 [PSSYSMSGTEMPL]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysMsgTempls(List<PSSysMsgTemplDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", dtoList);
	}

    /**
     * 获取 系统消息模板 [PSSYSMSGTEMPL]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysMsgTemplDTO getPSSysMsgTempl(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", PSSysMsgTemplDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统消息模板 [PSSYSMSGTEMPL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysMsgTemplDTO> searchPSSysMsgTempls(PSSysMsgTemplFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", PSSysMsgTemplDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统消息模板 [PSSYSMSGTEMPL]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysMsgTemplDTO> searchAllPSSysMsgTempls(PSSysMsgTemplFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSMSGTEMPL, "pssysmsgtempls", PSSysMsgTemplDTO.class, iSearchContext);
	}

    /**
     * 建立 系统引用 [PSSYSREF]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysRef(PSSysRefDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSREF, "pssysrefs", PSSysRefDTO.class, dto);
	}

    /**
     * 批建立 系统引用 [PSSYSREF]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysRefs(List<PSSysRefDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSREF, "pssysrefs", dtoList);
	}

    /**
     * 更新 系统引用 [PSSYSREF]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysRef(PSSysRefDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSREF, "pssysrefs", PSSysRefDTO.class, dto);
	}

    /**
     * 批更新 系统引用 [PSSYSREF]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysRefs(List<PSSysRefDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSREF, "pssysrefs", dtoList);
	}

    /**
     * 获取 系统引用 [PSSYSREF]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysRefDTO getPSSysRef(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSREF, "pssysrefs", PSSysRefDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统引用 [PSSYSREF]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysRefDTO> searchPSSysRefs(PSSysRefFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSREF, "pssysrefs", PSSysRefDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统引用 [PSSYSREF]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysRefDTO> searchAllPSSysRefs(PSSysRefFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSREF, "pssysrefs", PSSysRefDTO.class, iSearchContext);
	}

    /**
     * 建立 后台模板插件 [PSSYSSFPLUGIN]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSFPlugin(PSSysSFPluginDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", PSSysSFPluginDTO.class, dto);
	}

    /**
     * 批建立 后台模板插件 [PSSYSSFPLUGIN]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSFPlugins(List<PSSysSFPluginDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", dtoList);
	}

    /**
     * 更新 后台模板插件 [PSSYSSFPLUGIN]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSFPlugin(PSSysSFPluginDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", PSSysSFPluginDTO.class, dto);
	}

    /**
     * 批更新 后台模板插件 [PSSYSSFPLUGIN]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSFPlugins(List<PSSysSFPluginDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", dtoList);
	}

    /**
     * 获取 后台模板插件 [PSSYSSFPLUGIN]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSFPluginDTO getPSSysSFPlugin(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", PSSysSFPluginDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 后台模板插件 [PSSYSSFPLUGIN]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSFPluginDTO> searchPSSysSFPlugins(PSSysSFPluginFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", PSSysSFPluginDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 后台模板插件 [PSSYSSFPLUGIN]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSFPluginDTO> searchAllPSSysSFPlugins(PSSysSFPluginFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSFPLUGIN, "pssyssfplugins", PSSysSFPluginDTO.class, iSearchContext);
	}

    /**
     * 建立 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSampleValue(PSSysSampleValueDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", PSSysSampleValueDTO.class, dto);
	}

    /**
     * 批建立 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSampleValues(List<PSSysSampleValueDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", dtoList);
	}

    /**
     * 更新 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSampleValue(PSSysSampleValueDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", PSSysSampleValueDTO.class, dto);
	}

    /**
     * 批更新 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSampleValues(List<PSSysSampleValueDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", dtoList);
	}

    /**
     * 获取 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSampleValueDTO getPSSysSampleValue(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", PSSysSampleValueDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSampleValueDTO> searchPSSysSampleValues(PSSysSampleValueFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", PSSysSampleValueDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统示例值 [PSSYSSAMPLEVALUE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSampleValueDTO> searchAllPSSysSampleValues(PSSysSampleValueFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSAMPLEVALUE, "pssyssamplevalues", PSSysSampleValueDTO.class, iSearchContext);
	}

    /**
     * 建立 全文检索实体 [PSSYSSEARCHDE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSearchDE(PSSysSearchDEDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDE, "pssyssearchdes", PSSysSearchDEDTO.class, dto);
	}

    /**
     * 批建立 全文检索实体 [PSSYSSEARCHDE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSearchDEs(List<PSSysSearchDEDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDE, "pssyssearchdes", dtoList);
	}

    /**
     * 更新 全文检索实体 [PSSYSSEARCHDE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSearchDE(PSSysSearchDEDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDE, "pssyssearchdes", PSSysSearchDEDTO.class, dto);
	}

    /**
     * 批更新 全文检索实体 [PSSYSSEARCHDE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSearchDEs(List<PSSysSearchDEDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDE, "pssyssearchdes", dtoList);
	}

    /**
     * 获取 全文检索实体 [PSSYSSEARCHDE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSearchDEDTO getPSSysSearchDE(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSEARCHDE, "pssyssearchdes", PSSysSearchDEDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 全文检索实体 [PSSYSSEARCHDE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSearchDEDTO> searchPSSysSearchDEs(PSSysSearchDEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSEARCHDE, "pssyssearchdes", PSSysSearchDEDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 全文检索实体 [PSSYSSEARCHDE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSearchDEDTO> searchAllPSSysSearchDEs(PSSysSearchDEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSEARCHDE, "pssyssearchdes", PSSysSearchDEDTO.class, iSearchContext);
	}

    /**
     * 建立 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSearchDEField(PSSysSearchDEFieldDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", PSSysSearchDEFieldDTO.class, dto);
	}

    /**
     * 批建立 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSearchDEFields(List<PSSysSearchDEFieldDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", dtoList);
	}

    /**
     * 更新 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSearchDEField(PSSysSearchDEFieldDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", PSSysSearchDEFieldDTO.class, dto);
	}

    /**
     * 批更新 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSearchDEFields(List<PSSysSearchDEFieldDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", dtoList);
	}

    /**
     * 获取 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSearchDEFieldDTO getPSSysSearchDEField(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", PSSysSearchDEFieldDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSearchDEFieldDTO> searchPSSysSearchDEFields(PSSysSearchDEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", PSSysSearchDEFieldDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 全文检索实体属性 [PSSYSSEARCHDEFIELD]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSearchDEFieldDTO> searchAllPSSysSearchDEFields(PSSysSearchDEFieldFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSEARCHDEFIELD, "pssyssearchdefields", PSSysSearchDEFieldDTO.class, iSearchContext);
	}

    /**
     * 建立 全文检索文档 [PSSYSSEARCHDOC]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSearchDoc(PSSysSearchDocDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", PSSysSearchDocDTO.class, dto);
	}

    /**
     * 批建立 全文检索文档 [PSSYSSEARCHDOC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSearchDocs(List<PSSysSearchDocDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", dtoList);
	}

    /**
     * 更新 全文检索文档 [PSSYSSEARCHDOC]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSearchDoc(PSSysSearchDocDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", PSSysSearchDocDTO.class, dto);
	}

    /**
     * 批更新 全文检索文档 [PSSYSSEARCHDOC]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSearchDocs(List<PSSysSearchDocDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", dtoList);
	}

    /**
     * 获取 全文检索文档 [PSSYSSEARCHDOC]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSearchDocDTO getPSSysSearchDoc(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", PSSysSearchDocDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 全文检索文档 [PSSYSSEARCHDOC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSearchDocDTO> searchPSSysSearchDocs(PSSysSearchDocFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", PSSysSearchDocDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 全文检索文档 [PSSYSSEARCHDOC]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSearchDocDTO> searchAllPSSysSearchDocs(PSSysSearchDocFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSEARCHDOC, "pssyssearchdocs", PSSysSearchDocDTO.class, iSearchContext);
	}

    /**
     * 建立 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysSearchScheme(PSSysSearchSchemeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", PSSysSearchSchemeDTO.class, dto);
	}

    /**
     * 批建立 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysSearchSchemes(List<PSSysSearchSchemeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", dtoList);
	}

    /**
     * 更新 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysSearchScheme(PSSysSearchSchemeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", PSSysSearchSchemeDTO.class, dto);
	}

    /**
     * 批更新 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysSearchSchemes(List<PSSysSearchSchemeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", dtoList);
	}

    /**
     * 获取 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysSearchSchemeDTO getPSSysSearchScheme(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", PSSysSearchSchemeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysSearchSchemeDTO> searchPSSysSearchSchemes(PSSysSearchSchemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", PSSysSearchSchemeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统全文检索体系 [PSSYSSEARCHSCHEME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysSearchSchemeDTO> searchAllPSSysSearchSchemes(PSSysSearchSchemeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSEARCHSCHEME, "pssyssearchschemes", PSSysSearchSchemeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统服务接口 [PSSYSSERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysServiceAPI(PSSysServiceAPIDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", PSSysServiceAPIDTO.class, dto);
	}

    /**
     * 批建立 系统服务接口 [PSSYSSERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysServiceAPIs(List<PSSysServiceAPIDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", dtoList);
	}

    /**
     * 更新 系统服务接口 [PSSYSSERVICEAPI]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysServiceAPI(PSSysServiceAPIDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", PSSysServiceAPIDTO.class, dto);
	}

    /**
     * 批更新 系统服务接口 [PSSYSSERVICEAPI]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysServiceAPIs(List<PSSysServiceAPIDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", dtoList);
	}

    /**
     * 获取 系统服务接口 [PSSYSSERVICEAPI]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysServiceAPIDTO getPSSysServiceAPI(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", PSSysServiceAPIDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统服务接口 [PSSYSSERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysServiceAPIDTO> searchPSSysServiceAPIs(PSSysServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", PSSysServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统服务接口 [PSSYSSERVICEAPI]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysServiceAPIDTO> searchAllPSSysServiceAPIs(PSSysServiceAPIFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSSERVICEAPI, "pssysserviceapis", PSSysServiceAPIDTO.class, iSearchContext);
	}

    /**
     * 建立 系统自定义数据范围 [PSSYSUSERDR]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSSysUserDR(PSSysUserDRDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSSYSUSERDR, "pssysuserdrs", PSSysUserDRDTO.class, dto);
	}

    /**
     * 批建立 系统自定义数据范围 [PSSYSUSERDR]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSSysUserDRs(List<PSSysUserDRDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSSYSUSERDR, "pssysuserdrs", dtoList);
	}

    /**
     * 更新 系统自定义数据范围 [PSSYSUSERDR]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSSysUserDR(PSSysUserDRDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSSYSUSERDR, "pssysuserdrs", PSSysUserDRDTO.class, dto);
	}

    /**
     * 批更新 系统自定义数据范围 [PSSYSUSERDR]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSSysUserDRs(List<PSSysUserDRDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSSYSUSERDR, "pssysuserdrs", dtoList);
	}

    /**
     * 获取 系统自定义数据范围 [PSSYSUSERDR]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSSysUserDRDTO getPSSysUserDR(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSSYSUSERDR, "pssysuserdrs", PSSysUserDRDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统自定义数据范围 [PSSYSUSERDR]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSSysUserDRDTO> searchPSSysUserDRs(PSSysUserDRFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSSYSUSERDR, "pssysuserdrs", PSSysUserDRDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统自定义数据范围 [PSSYSUSERDR]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSSysUserDRDTO> searchAllPSSysUserDRs(PSSysUserDRFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSSYSUSERDR, "pssysuserdrs", PSSysUserDRDTO.class, iSearchContext);
	}

    /**
     * 建立 视图消息 [PSVIEWMSG]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSViewMsg(PSViewMsgDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSVIEWMSG, "psviewmsgs", PSViewMsgDTO.class, dto);
	}

    /**
     * 批建立 视图消息 [PSVIEWMSG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSViewMsgs(List<PSViewMsgDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSVIEWMSG, "psviewmsgs", dtoList);
	}

    /**
     * 更新 视图消息 [PSVIEWMSG]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSViewMsg(PSViewMsgDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSVIEWMSG, "psviewmsgs", PSViewMsgDTO.class, dto);
	}

    /**
     * 批更新 视图消息 [PSVIEWMSG]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSViewMsgs(List<PSViewMsgDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSVIEWMSG, "psviewmsgs", dtoList);
	}

    /**
     * 获取 视图消息 [PSVIEWMSG]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSViewMsgDTO getPSViewMsg(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSVIEWMSG, "psviewmsgs", PSViewMsgDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 视图消息 [PSVIEWMSG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSViewMsgDTO> searchPSViewMsgs(PSViewMsgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSVIEWMSG, "psviewmsgs", PSViewMsgDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 视图消息 [PSVIEWMSG]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSViewMsgDTO> searchAllPSViewMsgs(PSViewMsgFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSVIEWMSG, "psviewmsgs", PSViewMsgDTO.class, iSearchContext);
	}

    /**
     * 建立 视图消息组 [PSVIEWMSGGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSViewMsgGroup(PSViewMsgGroupDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", PSViewMsgGroupDTO.class, dto);
	}

    /**
     * 批建立 视图消息组 [PSVIEWMSGGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSViewMsgGroups(List<PSViewMsgGroupDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", dtoList);
	}

    /**
     * 更新 视图消息组 [PSVIEWMSGGROUP]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSViewMsgGroup(PSViewMsgGroupDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", PSViewMsgGroupDTO.class, dto);
	}

    /**
     * 批更新 视图消息组 [PSVIEWMSGGROUP]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSViewMsgGroups(List<PSViewMsgGroupDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", dtoList);
	}

    /**
     * 获取 视图消息组 [PSVIEWMSGGROUP]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSViewMsgGroupDTO getPSViewMsgGroup(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", PSViewMsgGroupDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 视图消息组 [PSVIEWMSGGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSViewMsgGroupDTO> searchPSViewMsgGroups(PSViewMsgGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", PSViewMsgGroupDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 视图消息组 [PSVIEWMSGGROUP]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSViewMsgGroupDTO> searchAllPSViewMsgGroups(PSViewMsgGroupFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSVIEWMSGGROUP, "psviewmsggroups", PSViewMsgGroupDTO.class, iSearchContext);
	}

    /**
     * 建立 工作流实体 [PSWFDE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSWFDE(PSWFDEDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSWFDE, "pswfdes", PSWFDEDTO.class, dto);
	}

    /**
     * 批建立 工作流实体 [PSWFDE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSWFDEs(List<PSWFDEDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSWFDE, "pswfdes", dtoList);
	}

    /**
     * 更新 工作流实体 [PSWFDE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSWFDE(PSWFDEDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSWFDE, "pswfdes", PSWFDEDTO.class, dto);
	}

    /**
     * 批更新 工作流实体 [PSWFDE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSWFDEs(List<PSWFDEDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSWFDE, "pswfdes", dtoList);
	}

    /**
     * 获取 工作流实体 [PSWFDE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSWFDEDTO getPSWFDE(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSWFDE, "pswfdes", PSWFDEDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 工作流实体 [PSWFDE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSWFDEDTO> searchPSWFDEs(PSWFDEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSWFDE, "pswfdes", PSWFDEDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 工作流实体 [PSWFDE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSWFDEDTO> searchAllPSWFDEs(PSWFDEFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSWFDE, "pswfdes", PSWFDEDTO.class, iSearchContext);
	}

    /**
     * 建立 工作流角色 [PSWFROLE]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSWFRole(PSWFRoleDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSWFROLE, "pswfroles", PSWFRoleDTO.class, dto);
	}

    /**
     * 批建立 工作流角色 [PSWFROLE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSWFRoles(List<PSWFRoleDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSWFROLE, "pswfroles", dtoList);
	}

    /**
     * 更新 工作流角色 [PSWFROLE]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSWFRole(PSWFRoleDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSWFROLE, "pswfroles", PSWFRoleDTO.class, dto);
	}

    /**
     * 批更新 工作流角色 [PSWFROLE]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSWFRoles(List<PSWFRoleDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSWFROLE, "pswfroles", dtoList);
	}

    /**
     * 获取 工作流角色 [PSWFROLE]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSWFRoleDTO getPSWFRole(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSWFROLE, "pswfroles", PSWFRoleDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 工作流角色 [PSWFROLE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSWFRoleDTO> searchPSWFRoles(PSWFRoleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSWFROLE, "pswfroles", PSWFRoleDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 工作流角色 [PSWFROLE]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSWFRoleDTO> searchAllPSWFRoles(PSWFRoleFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSWFROLE, "pswfroles", PSWFRoleDTO.class, iSearchContext);
	}

    /**
     * 建立 工作流版本 [PSWFVERSION]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSWFVersion(PSWFVersionDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSWFVERSION, "pswfversions", PSWFVersionDTO.class, dto);
	}

    /**
     * 批建立 工作流版本 [PSWFVERSION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSWFVersions(List<PSWFVersionDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSWFVERSION, "pswfversions", dtoList);
	}

    /**
     * 更新 工作流版本 [PSWFVERSION]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSWFVersion(PSWFVersionDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSWFVERSION, "pswfversions", PSWFVersionDTO.class, dto);
	}

    /**
     * 批更新 工作流版本 [PSWFVERSION]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSWFVersions(List<PSWFVersionDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSWFVERSION, "pswfversions", dtoList);
	}

    /**
     * 获取 工作流版本 [PSWFVERSION]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSWFVersionDTO getPSWFVersion(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSWFVERSION, "pswfversions", PSWFVersionDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 工作流版本 [PSWFVERSION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSWFVersionDTO> searchPSWFVersions(PSWFVersionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSWFVERSION, "pswfversions", PSWFVersionDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 工作流版本 [PSWFVERSION]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSWFVersionDTO> searchAllPSWFVersions(PSWFVersionFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSWFVERSION, "pswfversions", PSWFVersionDTO.class, iSearchContext);
	}

    /**
     * 建立 工作流工作时间 [PSWFWORKTIME]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSWFWorkTime(PSWFWorkTimeDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSWFWORKTIME, "pswfworktimes", PSWFWorkTimeDTO.class, dto);
	}

    /**
     * 批建立 工作流工作时间 [PSWFWORKTIME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSWFWorkTimes(List<PSWFWorkTimeDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSWFWORKTIME, "pswfworktimes", dtoList);
	}

    /**
     * 更新 工作流工作时间 [PSWFWORKTIME]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSWFWorkTime(PSWFWorkTimeDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSWFWORKTIME, "pswfworktimes", PSWFWorkTimeDTO.class, dto);
	}

    /**
     * 批更新 工作流工作时间 [PSWFWORKTIME]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSWFWorkTimes(List<PSWFWorkTimeDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSWFWORKTIME, "pswfworktimes", dtoList);
	}

    /**
     * 获取 工作流工作时间 [PSWFWORKTIME]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSWFWorkTimeDTO getPSWFWorkTime(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSWFWORKTIME, "pswfworktimes", PSWFWorkTimeDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 工作流工作时间 [PSWFWORKTIME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSWFWorkTimeDTO> searchPSWFWorkTimes(PSWFWorkTimeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSWFWORKTIME, "pswfworktimes", PSWFWorkTimeDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 工作流工作时间 [PSWFWORKTIME]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSWFWorkTimeDTO> searchAllPSWFWorkTimes(PSWFWorkTimeFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSWFWORKTIME, "pswfworktimes", PSWFWorkTimeDTO.class, iSearchContext);
	}

    /**
     * 建立 系统工作流 [PSWORKFLOW]
	 * @param dto
	 * @throws Throwable
	 */
	public void createPSWorkflow(PSWorkflowDTO dto) throws Throwable{
		this.executeCreate(PSModels.PSWORKFLOW, "psworkflows", PSWorkflowDTO.class, dto);
	}

    /**
     * 批建立 系统工作流 [PSWORKFLOW]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void createPSWorkflows(List<PSWorkflowDTO> dtoList) throws Throwable{
		this.executeCreate(PSModels.PSWORKFLOW, "psworkflows", dtoList);
	}

    /**
     * 更新 系统工作流 [PSWORKFLOW]
	 * @param dto
	 * @throws Throwable
	 */
	public void updatePSWorkflow(PSWorkflowDTO dto) throws Throwable{
		this.executeUpdate(PSModels.PSWORKFLOW, "psworkflows", PSWorkflowDTO.class, dto);
	}

    /**
     * 批更新 系统工作流 [PSWORKFLOW]
	 * @param dtoList
	 * @throws Throwable
	 */
	public void updatePSWorkflows(List<PSWorkflowDTO> dtoList) throws Throwable{
		this.executeUpdate(PSModels.PSWORKFLOW, "psworkflows", dtoList);
	}

    /**
     * 获取 系统工作流 [PSWORKFLOW]
	 * @param strKey
	 * @param bTryMode 尝试模式
	 * @return
	 * @throws Throwable
	 */
	public PSWorkflowDTO getPSWorkflow(String strKey, boolean bTryMode) throws Throwable{
		return this.executeGet(PSModels.PSWORKFLOW, "psworkflows", PSWorkflowDTO.class, strKey, bTryMode);
	}

    /**
     * 搜索指定分页数据 系统工作流 [PSWORKFLOW]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public Page<PSWorkflowDTO> searchPSWorkflows(PSWorkflowFilter iSearchContext) throws Throwable{
		return this.executeFetchDefault(PSModels.PSWORKFLOW, "psworkflows", PSWorkflowDTO.class, iSearchContext);
	}

    /**
     * 搜索全部数据 系统工作流 [PSWORKFLOW]
	 * @param iSearchContext
	 * @return
	 * @throws Throwable
	 */
	public List<PSWorkflowDTO> searchAllPSWorkflows(PSWorkflowFilter iSearchContext) throws Throwable{
		return this.executeFetchDefaultAll(PSModels.PSWORKFLOW, "psworkflows", PSWorkflowDTO.class, iSearchContext);
	}

}