/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import net.ibizsys.centralstudio.util.EntityBase;
import net.ibizsys.centralstudio.util.ISearchContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchContextBase
extends EntityBase
implements ISearchContext {
    @JsonIgnore
    private Pageable pageable = null;
    @JsonIgnore
    private Sort sort = null;
    @JsonIgnore
    private boolean bCount = true;

    @Override
    @JsonIgnore
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    @JsonIgnore
    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    @Override
    @JsonIgnore
    public Sort getPageSort() {
        return this.sort;
    }

    @Override
    @JsonIgnore
    public void setPageSort(Sort sort) {
        this.sort = sort;
    }

    @Override
    @JsonIgnore
    public boolean isCount() {
        return this.bCount;
    }

    @Override
    @JsonIgnore
    public void setCount(boolean bCount) {
        this.bCount = bCount;
    }

    @Override
    @JsonIgnore
    protected boolean isLowerCaseName() {
        return false;
    }

    @Override
    public void setPageable(int nPageNumber, int nPageSize) {
        this.setPageable((Pageable)PageRequest.of((int)nPageNumber, (int)nPageSize));
    }

    @Override
    public void setPageSort(String strSortInfo) {
        if (StringUtils.hasLength((String)strSortInfo)) {
            ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
            String[] items = strSortInfo.split("[,]");
            if (items.length == 1) {
                list.add(Sort.Order.asc((String)items[0]));
            } else if (items.length == 2) {
                if ("DESC".equalsIgnoreCase(items[1])) {
                    list.add(Sort.Order.desc((String)items[0]));
                } else {
                    list.add(Sort.Order.asc((String)items[0]));
                }
            }
            if (list.size() > 0) {
                this.setPageSort(Sort.by(list));
            }
        } else {
            this.setPageSort(Sort.unsorted());
        }
    }

    @Override
    public SearchContextBase setFieldCond(String strFieldName, String strCondOp, Object objValue) {
        block1: {
            if ("ISNULL".equals(strCondOp) || "ISNOTNULL".equals(strCondOp)) break block1;
            String strParamName = "";
            int nIndex = 1;
            do {
                strParamName = nIndex == 1 ? String.format("n_%1$s_%2$s", strFieldName, strCondOp).toLowerCase() : String.format("n_%1$s_%2$s_%3$s", strFieldName, strCondOp, nIndex).toLowerCase();
                ++nIndex;
            } while (this.contains(strParamName));
            this.set(strParamName, objValue);
        }
        return this;
    }

    @Override
    public SearchContextBase eq(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "EQ", objValue);
        return this;
    }

    @Override
    public SearchContextBase ne(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTEQ", objValue);
        return this;
    }

    @Override
    public SearchContextBase gt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GT", objValue);
        return this;
    }

    @Override
    public SearchContextBase gte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "GTANDEQ", objValue);
        return this;
    }

    @Override
    public SearchContextBase lt(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LT", objValue);
        return this;
    }

    @Override
    public SearchContextBase lte(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LTANDEQ", objValue);
        return this;
    }

    @Override
    public SearchContextBase like(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LIKE", objValue);
        return this;
    }

    @Override
    public SearchContextBase ll(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "LEFTLIKE", objValue);
        return this;
    }

    @Override
    public SearchContextBase rl(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "RIGHTLIKE", objValue);
        return this;
    }

    @Override
    public SearchContextBase nvl(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNULL", null);
        return this;
    }

    @Override
    public SearchContextBase nn(String strFieldName) {
        this.setFieldCond(strFieldName, "ISNOTNULL", null);
        return this;
    }

    @Override
    public SearchContextBase in(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "IN", objValue);
        return this;
    }

    @Override
    public SearchContextBase ni(String strFieldName, Object objValue) {
        this.setFieldCond(strFieldName, "NOTIN", objValue);
        return this;
    }

    @Override
    public SearchContextBase count(boolean bCount) {
        this.setCount(bCount);
        return this;
    }

    @Override
    public SearchContextBase sort(String strSortInfo) {
        this.setPageSort(strSortInfo);
        return this;
    }

    @Override
    public SearchContextBase all() {
        return this.limit(Integer.MAX_VALUE).count(false);
    }

    @Override
    public SearchContextBase limit(int nSize) {
        this.setPageable(0, nSize);
        return this;
    }

    @Override
    public SearchContextBase param(String strName, Object objValue) {
        this.set(strName, objValue);
        return this;
    }
}

