/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.centralstudio.dto.PSDEActionDTO;
import net.ibizsys.centralstudio.dto.PSDEDataSetDTO;
import net.ibizsys.centralstudio.dto.PSDEFieldDTO;
import net.ibizsys.centralstudio.dto.PSDEFormDTO;
import net.ibizsys.centralstudio.dto.PSDERDTO;
import net.ibizsys.centralstudio.dto.PSDEViewBaseDTO;
import net.ibizsys.centralstudio.dto.PSDataEntityDTO;
import net.ibizsys.centralstudio.dto.PSModuleDTO;
import net.ibizsys.centralstudio.dto.PSSysDELogicNodeDTO;
import net.ibizsys.centralstudio.dto.PSSysModelGroupDTO;
import net.ibizsys.centralstudio.dto.PSSysMsgTemplDTO;
import net.ibizsys.centralstudio.dto.PSSysRefDTO;
import net.ibizsys.centralstudio.dto.PSWFDEDTO;
import net.ibizsys.centralstudio.dto.PSWFRoleDTO;
import net.ibizsys.centralstudio.dto.PSWFWorkTimeDTO;
import net.ibizsys.centralstudio.dto.PSWorkflowDTO;
import net.ibizsys.centralstudio.filter.PSDEActionFilter;
import net.ibizsys.centralstudio.filter.PSDEDataSetFilter;
import net.ibizsys.centralstudio.filter.PSDEFieldFilter;
import net.ibizsys.centralstudio.filter.PSDEFormFilter;
import net.ibizsys.centralstudio.filter.PSDERFilter;
import net.ibizsys.centralstudio.filter.PSDEViewBaseFilter;
import net.ibizsys.centralstudio.filter.PSDataEntityFilter;
import net.ibizsys.centralstudio.filter.PSModuleFilter;
import net.ibizsys.centralstudio.filter.PSSysDELogicNodeFilter;
import net.ibizsys.centralstudio.filter.PSSysModelGroupFilter;
import net.ibizsys.centralstudio.filter.PSSysMsgTemplFilter;
import net.ibizsys.centralstudio.filter.PSSysRefFilter;
import net.ibizsys.centralstudio.filter.PSWFDEFilter;
import net.ibizsys.centralstudio.filter.PSWFRoleFilter;
import net.ibizsys.centralstudio.filter.PSWFWorkTimeFilter;
import net.ibizsys.centralstudio.filter.PSWorkflowFilter;
import net.ibizsys.centralstudio.util.PSModelServiceUtils;
import net.ibizsys.model.IPSModelData;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2ManyDataDEField;
import net.ibizsys.model.dataentity.defield.IPSOne2OneDataDEField;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSysRef;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.model.wf.IPSWFWorkTime;
import net.ibizsys.model.wf.IPSWorkflow;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSRTModelSyncUtils {
    private static final Log log = LogFactory.getLog(PSRTModelSyncUtils.class);
    private static PSRTModelSyncUtils instance = null;
    private Map<String, PSModuleDTO> globalPSModuleDTOMap = new HashMap<String, PSModuleDTO>();
    private Map<String, PSSysRefDTO> globalPSSysRefDTOMap = new HashMap<String, PSSysRefDTO>();
    private Map<String, PSSysModelGroupDTO> globalPSSysModelGroupDTOMap = new HashMap<String, PSSysModelGroupDTO>();
    private Map<String, PSDataEntityDTO> globalPSDataEntityDTOMap = new HashMap<String, PSDataEntityDTO>();
    private Map<String, PSDERDTO> globalPSDERDTOMap = new HashMap<String, PSDERDTO>();
    private Map<String, PSDEFieldDTO> globalPSDEFieldDTOMap = new HashMap<String, PSDEFieldDTO>();
    private Map<String, PSWorkflowDTO> globalPSWorkflowDTOMap = new HashMap<String, PSWorkflowDTO>();
    private Map<String, PSDEActionDTO> globalPSDEActionDTOMap = new HashMap<String, PSDEActionDTO>();
    private Map<String, PSDEDataSetDTO> globalPSDEDataSetDTOMap = new HashMap<String, PSDEDataSetDTO>();
    private Map<String, PSWFDEDTO> globalPSWFDEDTOMap = new HashMap<String, PSWFDEDTO>();
    private Map<String, PSDEFormDTO> globalPSDEFormDTOMap = new HashMap<String, PSDEFormDTO>();
    private Map<String, PSDEViewBaseDTO> globalPSDEViewBaseDTOMap = new HashMap<String, PSDEViewBaseDTO>();
    private Map<String, PSWFRoleDTO> globalPSWFRoleDTOMap = new HashMap<String, PSWFRoleDTO>();
    private Map<String, PSWFWorkTimeDTO> globalPSWFWorkTimeDTOMap = new HashMap<String, PSWFWorkTimeDTO>();
    private Map<String, PSSysMsgTemplDTO> globalPSSysMsgTemplDTOMap = new HashMap<String, PSSysMsgTemplDTO>();
    private Map<String, PSSysDELogicNodeDTO> globalPSSysDELogicNodeDTOMap = new HashMap<String, PSSysDELogicNodeDTO>();

    public static PSRTModelSyncUtils getInstance() {
        if (instance == null) {
            instance = new PSRTModelSyncUtils();
        }
        return instance;
    }

    public static void setInstance(PSRTModelSyncUtils instance) {
        PSRTModelSyncUtils.instance = instance;
    }

    public void sync(IPSSystem iPSSystem) throws Throwable {
        this.syncPSSysRefs(iPSSystem, false);
        this.syncPSSysModelGroups(iPSSystem, false);
        this.syncPSModules(iPSSystem, false);
        this.syncPSDataEntities(iPSSystem, false);
        this.syncPSDERs(iPSSystem, false);
        this.syncPSDEFields(iPSSystem, false);
        this.syncPSDEActions(iPSSystem, false);
        this.syncPSDEDataSets(iPSSystem, false);
        this.syncPSDEForms(iPSSystem, false);
        this.syncPSDEViewBases(iPSSystem, false);
        this.syncPSSysMsgTempls(iPSSystem, false);
        this.syncPSWorkflows(iPSSystem, false);
        this.syncPSWFDEs(iPSSystem, false);
        this.syncPSWFRoles(iPSSystem, false);
        this.syncPSWFWorkTimes(iPSSystem, false);
        this.syncPSSysDELogicNodes(iPSSystem, false);
    }

    protected void syncPSModules(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSModuleDTOMap.clear();
        PSModuleFilter psModelSearchContextDTO = new PSModuleFilter();
        List<PSModuleDTO> list = PSModelServiceUtils.getInstance().searchAllPSModules(psModelSearchContextDTO);
        HashMap<String, PSModuleDTO> psModuleDTOMap = new HashMap<String, PSModuleDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSModuleDTO psModuleDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psModuleDTO.getPSSysRefId()) ? String.format("PSSYSREF|%1$s|%2$s", psModuleDTO.getPSSysRefId(), psModuleDTO.getCodeName()) : (StringUtils.hasLength((String)psModuleDTO.getPSSysModelGroupId()) ? String.format("PSSYSMODELGROUP|%1$s|%2$s", psModuleDTO.getPSSysModelGroupId(), psModuleDTO.getCodeName()) : psModuleDTO.getCodeName());
                psModuleDTOMap.put(strTag, psModuleDTO);
            }
        }
        ArrayList<PSModuleDTO> psModuleDTOList = new ArrayList<PSModuleDTO>();
        List psSystemModules = iPSSystem.getAllPSSystemModules();
        if (psSystemModules != null) {
            for (IPSSystemModule iPSSystemModule : psSystemModules) {
                String strTag = null;
                strTag = iPSSystemModule.getPSSysRef() != null ? String.format("PSSYSREF|%1$s|%2$s", iPSSystemModule.getPSSysRef().getSysRefTag(), iPSSystemModule.getCodeName()) : (iPSSystemModule.getPSSysModelGroup() != null ? String.format("PSSYSMODELGROUP|%1$s|%2$s", iPSSystemModule.getPSSysModelGroup().getCodeName(), iPSSystemModule.getCodeName()) : iPSSystemModule.getCodeName());
                PSModuleDTO psModuleDTO = (PSModuleDTO)psModuleDTOMap.get(strTag);
                if (psModuleDTO != null) {
                    this.globalPSModuleDTOMap.put(iPSSystemModule.getId(), psModuleDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psModuleDTO = new PSModuleDTO();
                psModuleDTO.setPSModuleName(iPSSystemModule.getName());
                psModuleDTO.setCodeName(iPSSystemModule.getCodeName());
                if (iPSSystemModule.isSubSysModule()) {
                    psModuleDTO.setSubSysModule(1);
                } else {
                    psModuleDTO.setSubSysModule(0);
                }
                if (iPSSystemModule.getPSSysRef() != null) {
                    PSSysRefDTO psSysRefDTO = this.globalPSSysRefDTOMap.get(iPSSystemModule.getPSSysRef().getId());
                    if (psSysRefDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5f15\u7528[%1$s]\u6570\u636e\u5bf9\u8c61", iPSSystemModule.getPSSysRef().getId()));
                    }
                    psModuleDTO.setPSSysRefId(psSysRefDTO.getPSSysRefId());
                    psModuleDTO.setPSSysRefName(psSysRefDTO.getPSSysRefName());
                } else if (iPSSystemModule.getPSSysModelGroup() != null) {
                    PSSysModelGroupDTO psSysModelGroupDTO = this.globalPSSysModelGroupDTOMap.get(iPSSystemModule.getPSSysModelGroup().getId());
                    if (psSysModelGroupDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u578b\u7ec4[%1$s]\u6570\u636e\u5bf9\u8c61", iPSSystemModule.getPSSysModelGroup().getId()));
                    }
                    psModuleDTO.setPSSysModelGroupId(psSysModelGroupDTO.getPSSysModelGroupId());
                    psModuleDTO.setPSSysModelGroupName(psSysModelGroupDTO.getPSSysModelGroupName());
                }
                psModuleDTO.setSrfSystemFlag(1);
                psModuleDTOList.add(psModuleDTO);
            }
        }
        if (!bRefreshOnly && psModuleDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSModules(psModuleDTOList);
            this.syncPSModules(iPSSystem, true);
        }
    }

    protected void syncPSDataEntities(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDataEntityDTOMap.clear();
        PSDataEntityFilter psModelSearchContextDTO = new PSDataEntityFilter();
        List<PSDataEntityDTO> list = PSModelServiceUtils.getInstance().searchAllPSDataEntities(psModelSearchContextDTO);
        HashMap<String, PSDataEntityDTO> psDataEntityDTOMap = new HashMap<String, PSDataEntityDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDataEntityDTO psDataEntityDTO : list) {
                String strTag = String.format("PSMODULE|%1$s|%2$s", psDataEntityDTO.getPSModuleId(), psDataEntityDTO.getPSDataEntityName());
                psDataEntityDTOMap.put(strTag, psDataEntityDTO);
            }
        }
        ArrayList<PSDataEntityDTO> psDataEntityDTOList = new ArrayList<PSDataEntityDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                PSModuleDTO psModuleDTO = this.globalPSModuleDTOMap.get(iPSDataEntity.getPSSystemModuleMust().getId());
                if (psModuleDTO == null) {
                    throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getPSSystemModuleMust().getId()));
                }
                String strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSDataEntity.getName());
                PSDataEntityDTO psDataEntityDTO = (PSDataEntityDTO)psDataEntityDTOMap.get(strTag);
                if (psDataEntityDTO != null) {
                    this.globalPSDataEntityDTOMap.put(iPSDataEntity.getId(), psDataEntityDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psDataEntityDTO = new PSDataEntityDTO();
                psDataEntityDTO.setPSDataEntityName(iPSDataEntity.getName());
                psDataEntityDTO.setCodeName(iPSDataEntity.getCodeName());
                psDataEntityDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                psDataEntityDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                psDataEntityDTO.setDEType(iPSDataEntity.getDEType());
                psDataEntityDTO.setLogicName(iPSDataEntity.getLogicName());
                psDataEntityDTO.setSrfSystemFlag(1);
                psDataEntityDTOList.add(psDataEntityDTO);
            }
        }
        if (!bRefreshOnly && psDataEntityDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDataEntities(psDataEntityDTOList);
            this.syncPSDataEntities(iPSSystem, true);
        }
    }

    protected void syncPSDEFields(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDEFieldDTOMap.clear();
        HashMap<String, PSDEFieldDTO> psDEFieldDTOMap = new HashMap<String, PSDEFieldDTO>();
        PSDEFieldFilter psModelSearchContextDTO = new PSDEFieldFilter();
        List<PSDEFieldDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEFields(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDEFieldDTO psDEFieldDTO : list) {
                String strTag = String.format("%1$s|%2$s", psDEFieldDTO.getPSDEId(), psDEFieldDTO.getPSDEFieldName());
                if (psDEFieldDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u5c5e\u6027[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psDEFieldDTOMap.put(strTag, psDEFieldDTO);
            }
        }
        ArrayList<PSDEFieldDTO> psDEFieldDTOList = new ArrayList<PSDEFieldDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psDEFields = iPSDataEntity.getAllPSDEFields();
                if (psDEFields == null) continue;
                for (IPSDEField iPSDEField : psDEFields) {
                    PSDERDTO psDERDTO;
                    IPSDERBase iPSDER;
                    IPSLinkDEField iPSLinkDEField;
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSDEField.getName());
                    PSDEFieldDTO psDEFieldDTO = (PSDEFieldDTO)psDEFieldDTOMap.get(strTag);
                    if (psDEFieldDTO != null) {
                        this.globalPSDEFieldDTOMap.put(strTag, psDEFieldDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDEFieldDTO = new PSDEFieldDTO();
                    psDEFieldDTO.setPSDEFieldName(iPSDEField.getName());
                    psDEFieldDTO.setCodeName(iPSDEField.getCodeName());
                    psDEFieldDTO.setLogicName(iPSDEField.getLogicName());
                    psDEFieldDTO.setSrfSystemFlag(1);
                    psDEFieldDTO.setDEFType(iPSDEField.getDEFType());
                    psDEFieldDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psDEFieldDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psDEFieldDTO.setAllowEmpty(iPSDEField.isAllowEmpty() ? 1 : 0);
                    psDEFieldDTO.setPSDataTypeId(iPSDEField.getDataType());
                    psDEFieldDTO.setPSDataTypeName(PSModelEnums.DEFDataType.from((String)iPSDEField.getDataType()).text);
                    if (iPSDEField.isKeyDEField() && iPSDEField.isUniTagField()) {
                        psDEFieldDTO.setPKey(1);
                    } else if (iPSDEField.isUniTagField()) {
                        psDEFieldDTO.setPKey(2);
                    }
                    if (iPSDEField.isMajorDEField()) {
                        psDEFieldDTO.setMajorField(1);
                    }
                    if (iPSDEField instanceof IPSLinkDEField) {
                        iPSLinkDEField = (IPSLinkDEField)iPSDEField;
                        iPSDER = iPSLinkDEField.getPSDERMust();
                        psDERDTO = this.globalPSDERDTOMap.get(iPSDER.getId());
                        if (psDERDTO == null) {
                            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u5173\u7cfb[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDER.getId()));
                        }
                        psDEFieldDTO.setPSDERId(psDERDTO.getPSDERId());
                        psDEFieldDTO.setPSDERName(psDERDTO.getPSDERName());
                    } else if (iPSDEField instanceof IPSOne2ManyDataDEField) {
                        iPSLinkDEField = (IPSOne2ManyDataDEField)iPSDEField;
                        iPSDER = iPSLinkDEField.getPSDERMust();
                        psDERDTO = this.globalPSDERDTOMap.get(iPSDER.getId());
                        if (psDERDTO == null) {
                            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u5173\u7cfb[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDER.getId()));
                        }
                        psDEFieldDTO.setO2MPSDERId(psDERDTO.getPSDERId());
                        psDEFieldDTO.setO2MPSDERName(psDERDTO.getPSDERName());
                    } else if (iPSDEField instanceof IPSOne2OneDataDEField) {
                        iPSLinkDEField = (IPSOne2OneDataDEField)iPSDEField;
                        iPSDER = iPSLinkDEField.getPSDERMust();
                        psDERDTO = this.globalPSDERDTOMap.get(iPSDER.getId());
                        if (psDERDTO == null) {
                            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u5173\u7cfb[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDER.getId()));
                        }
                        psDEFieldDTO.setO2OPSDERId(psDERDTO.getPSDERId());
                        psDEFieldDTO.setO2OPSDERName(psDERDTO.getPSDERName());
                    }
                    psDEFieldDTOList.add(psDEFieldDTO);
                }
            }
        }
        if (!bRefreshOnly && psDEFieldDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDEFields(psDEFieldDTOList);
            this.syncPSDEFields(iPSSystem, true);
        }
    }

    protected void syncPSDEActions(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDEActionDTOMap.clear();
        HashMap<String, PSDEActionDTO> psDEActionDTOMap = new HashMap<String, PSDEActionDTO>();
        PSDEActionFilter psModelSearchContextDTO = new PSDEActionFilter();
        List<PSDEActionDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEActions(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDEActionDTO psDEActionDTO : list) {
                String strTag = String.format("%1$s|%2$s", psDEActionDTO.getPSDEId(), psDEActionDTO.getPSDEActionName());
                if (psDEActionDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u884c\u4e3a[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psDEActionDTOMap.put(strTag, psDEActionDTO);
            }
        }
        ArrayList<PSDEActionDTO> psDEActionDTOList = new ArrayList<PSDEActionDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psDEActions = iPSDataEntity.getAllPSDEActions();
                if (psDEActions == null) continue;
                for (IPSDEAction iPSDEAction : psDEActions) {
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSDEAction.getName());
                    PSDEActionDTO psDEActionDTO = (PSDEActionDTO)psDEActionDTOMap.get(strTag);
                    if (psDEActionDTO != null) {
                        this.globalPSDEActionDTOMap.put(iPSDEAction.getId(), psDEActionDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDEActionDTO = new PSDEActionDTO();
                    psDEActionDTO.setPSDEActionName(iPSDEAction.getName());
                    psDEActionDTO.setCodeName(iPSDEAction.getCodeName());
                    psDEActionDTO.setLogicName(iPSDEAction.getLogicName());
                    psDEActionDTO.setSrfSystemFlag(1);
                    psDEActionDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psDEActionDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psDEActionDTO.setActionType(PSModelEnums.DEActionType.BUILTIN.value);
                    psDEActionDTO.setActionMode(iPSDEAction.getActionMode());
                    psDEActionDTOList.add(psDEActionDTO);
                }
            }
        }
        if (!bRefreshOnly && psDEActionDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDEActions(psDEActionDTOList);
            this.syncPSDEActions(iPSSystem, true);
        }
    }

    protected void syncPSDEDataSets(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDEDataSetDTOMap.clear();
        HashMap<String, PSDEDataSetDTO> psDEDataSetDTOMap = new HashMap<String, PSDEDataSetDTO>();
        PSDEDataSetFilter psModelSearchContextDTO = new PSDEDataSetFilter();
        List<PSDEDataSetDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEDataSets(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDEDataSetDTO psDEDataSetDTO : list) {
                String strTag = String.format("%1$s|%2$s", psDEDataSetDTO.getPSDEId(), psDEDataSetDTO.getPSDEDataSetName());
                if (psDEDataSetDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u884c\u4e3a[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psDEDataSetDTOMap.put(strTag, psDEDataSetDTO);
            }
        }
        ArrayList<PSDEDataSetDTO> psDEDataSetDTOList = new ArrayList<PSDEDataSetDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psDEDataSets = iPSDataEntity.getAllPSDEDataSets();
                if (psDEDataSets == null) continue;
                for (IPSDEDataSet iPSDEDataSet : psDEDataSets) {
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSDEDataSet.getName());
                    PSDEDataSetDTO psDEDataSetDTO = (PSDEDataSetDTO)psDEDataSetDTOMap.get(strTag);
                    if (psDEDataSetDTO != null) {
                        this.globalPSDEDataSetDTOMap.put(iPSDEDataSet.getId(), psDEDataSetDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDEDataSetDTO = new PSDEDataSetDTO();
                    psDEDataSetDTO.setPSDEDataSetName(iPSDEDataSet.getName());
                    psDEDataSetDTO.setCodeName(iPSDEDataSet.getCodeName());
                    psDEDataSetDTO.setLogicName(iPSDEDataSet.getLogicName());
                    psDEDataSetDTO.setSrfSystemFlag(1);
                    psDEDataSetDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psDEDataSetDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psDEDataSetDTOList.add(psDEDataSetDTO);
                }
            }
        }
        if (!bRefreshOnly && psDEDataSetDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDEDataSets(psDEDataSetDTOList);
            this.syncPSDEDataSets(iPSSystem, true);
        }
    }

    protected void syncPSDEForms(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDEFormDTOMap.clear();
        HashMap<String, PSDEFormDTO> psDEFormDTOMap = new HashMap<String, PSDEFormDTO>();
        PSDEFormFilter psModelSearchContextDTO = new PSDEFormFilter();
        List<PSDEFormDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEForms(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDEFormDTO psDEFormDTO : list) {
                String strTag = String.format("%1$s|%2$s", psDEFormDTO.getPSDEId(), psDEFormDTO.getCodeName());
                if (psDEFormDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u8868\u5355[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psDEFormDTOMap.put(strTag, psDEFormDTO);
            }
        }
        ArrayList<PSDEFormDTO> psDEFormDTOList = new ArrayList<PSDEFormDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psModelDatas = iPSDataEntity.getAllPSModelDatas();
                if (psModelDatas == null) continue;
                for (IPSModelData iPSModelData : psModelDatas) {
                    if (!"PSDEFORM".equals(iPSModelData.getRealModelType())) continue;
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSModelData.getCodeName());
                    PSDEFormDTO psDEFormDTO = (PSDEFormDTO)psDEFormDTOMap.get(strTag);
                    if (psDEFormDTO != null) {
                        this.globalPSDEFormDTOMap.put(strTag, psDEFormDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDEFormDTO = new PSDEFormDTO();
                    psDEFormDTO.setPSDEFormName(iPSModelData.getName());
                    psDEFormDTO.setCodeName(iPSModelData.getCodeName());
                    psDEFormDTO.setSrfSystemFlag(1);
                    psDEFormDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psDEFormDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psDEFormDTO.setFormType(iPSModelData.getRealModelSubType());
                    psDEFormDTO.setFuncMode(iPSModelData.getModelTag());
                    psDEFormDTOList.add(psDEFormDTO);
                }
            }
        }
        if (!bRefreshOnly && psDEFormDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDEForms(psDEFormDTOList);
            this.syncPSDEForms(iPSSystem, true);
        }
    }

    protected void syncPSDEViewBases(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDEViewBaseDTOMap.clear();
        HashMap<String, PSDEViewBaseDTO> psDEViewBaseDTOMap = new HashMap<String, PSDEViewBaseDTO>();
        PSDEViewBaseFilter psModelSearchContextDTO = new PSDEViewBaseFilter();
        List<PSDEViewBaseDTO> list = PSModelServiceUtils.getInstance().searchAllPSDEViewBases(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDEViewBaseDTO psDEViewBaseDTO : list) {
                String strTag = String.format("%1$s|%2$s", psDEViewBaseDTO.getPSDEId(), psDEViewBaseDTO.getCodeName());
                if (psDEViewBaseDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u89c6\u56fe[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psDEViewBaseDTOMap.put(strTag, psDEViewBaseDTO);
            }
        }
        ArrayList<PSDEViewBaseDTO> psDEViewBaseDTOList = new ArrayList<PSDEViewBaseDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psModelDatas = iPSDataEntity.getAllPSModelDatas();
                if (psModelDatas == null) continue;
                for (IPSModelData iPSModelData : psModelDatas) {
                    if (!"PSDEVIEWBASE".equals(iPSModelData.getRealModelType())) continue;
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSModelData.getCodeName());
                    PSDEViewBaseDTO psDEViewBaseDTO = (PSDEViewBaseDTO)psDEViewBaseDTOMap.get(strTag);
                    if (psDEViewBaseDTO != null) {
                        this.globalPSDEViewBaseDTOMap.put(strTag, psDEViewBaseDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDEViewBaseDTO = new PSDEViewBaseDTO();
                    psDEViewBaseDTO.setPSDEViewBaseName(iPSModelData.getName());
                    psDEViewBaseDTO.setCodeName(iPSModelData.getCodeName());
                    psDEViewBaseDTO.setSrfSystemFlag(1);
                    psDEViewBaseDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psDEViewBaseDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psDEViewBaseDTO.setPSDEViewBaseType(iPSModelData.getRealModelSubType());
                    psDEViewBaseDTO.setPredefinedViewType(iPSModelData.getModelTag());
                    psDEViewBaseDTO.setPDVTParam(iPSModelData.getModelTag2());
                    psDEViewBaseDTOList.add(psDEViewBaseDTO);
                }
            }
        }
        if (!bRefreshOnly && psDEViewBaseDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDEViewBases(psDEViewBaseDTOList);
            this.syncPSDEViewBases(iPSSystem, true);
        }
    }

    protected void syncPSWFDEs(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSWFDEDTOMap.clear();
        HashMap<String, PSWFDEDTO> psWFDEDTOMap = new HashMap<String, PSWFDEDTO>();
        PSWFDEFilter psModelSearchContextDTO = new PSWFDEFilter();
        List<PSWFDEDTO> list = PSModelServiceUtils.getInstance().searchAllPSWFDEs(psModelSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (PSWFDEDTO psWFDEDTO : list) {
                String strTag = String.format("%1$s|%2$s", psWFDEDTO.getPSDEId(), psWFDEDTO.getPSWFId());
                if (psWFDEDTOMap.containsKey(strTag)) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u5de5\u4f5c\u6d41[%1$s]\u5df2\u7ecf\u5728\u5217\u8868\u4e2d", strTag));
                    continue;
                }
                psWFDEDTOMap.put(strTag, psWFDEDTO);
            }
        }
        ArrayList<PSWFDEDTO> psWFDEDTOList = new ArrayList<PSWFDEDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psWFDEs = iPSDataEntity.getAllPSDEWFs();
                if (psWFDEs == null) continue;
                for (IPSDEWF iPSWFDE : psWFDEs) {
                    PSDataEntityDTO psDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDataEntity.getId());
                    if (psDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDataEntity.getId()));
                    }
                    PSWorkflowDTO psWorkflowDTO = this.globalPSWorkflowDTOMap.get(iPSWFDE.getPSWorkflowMust().getId());
                    if (psWorkflowDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5de5\u4f5c\u6d41[%1$s]\u6570\u636e\u5bf9\u8c61", iPSWFDE.getPSWorkflowMust().getId()));
                    }
                    String strTag = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), psWorkflowDTO.getPSWorkflowId());
                    PSWFDEDTO psWFDEDTO = (PSWFDEDTO)psWFDEDTOMap.get(strTag);
                    if (psWFDEDTO != null) {
                        this.globalPSWFDEDTOMap.put(iPSWFDE.getId(), psWFDEDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psWFDEDTO = new PSWFDEDTO();
                    psWFDEDTO.setPSWFDEName(iPSWFDE.getName());
                    psWFDEDTO.setCodeName(iPSWFDE.getCodeName());
                    psWFDEDTO.setSrfSystemFlag(1);
                    psWFDEDTO.setPSDEId(psDataEntityDTO.getPSDataEntityId());
                    psWFDEDTO.setPSDEName(psDataEntityDTO.getPSDataEntityName());
                    psWFDEDTO.setPSWFId(psWorkflowDTO.getPSWorkflowId());
                    psWFDEDTO.setPSWFName(psWorkflowDTO.getPSWorkflowName());
                    String strTag2 = String.format("%1$s|%2$s", psDataEntityDTO.getPSDataEntityId(), iPSWFDE.getUDStatePSDEFieldMust().getName());
                    PSDEFieldDTO udStatePSDEFieldDTO = this.globalPSDEFieldDTOMap.get(strTag2);
                    if (udStatePSDEFieldDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u5c5e\u6027[%1$s]\u6570\u636e\u5bf9\u8c61", strTag2));
                    }
                    psWFDEDTO.setStatePSDEFId(udStatePSDEFieldDTO.getPSDEFieldId());
                    psWFDEDTO.setStatePSDEFName(udStatePSDEFieldDTO.getPSDEFieldName());
                    psWFDEDTOList.add(psWFDEDTO);
                }
            }
        }
        if (!bRefreshOnly && psWFDEDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSWFDEs(psWFDEDTOList);
            this.syncPSWFDEs(iPSSystem, true);
        }
    }

    protected void syncPSDERs(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSDERDTOMap.clear();
        PSDERFilter psModelSearchContextDTO = new PSDERFilter();
        List<PSDERDTO> list = PSModelServiceUtils.getInstance().searchAllPSDERs(psModelSearchContextDTO);
        HashMap<String, PSDERDTO> psDERDTOMap = new HashMap<String, PSDERDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSDERDTO psDERDTO : list) {
                String strTag = String.format("%1$s|%2$s|%3$s", psDERDTO.getDERType(), psDERDTO.getMajorPSDEId(), psDERDTO.getMinorPSDEId());
                psDERDTOMap.put(strTag, psDERDTO);
            }
        }
        ArrayList<PSDERDTO> psDERDTOList = new ArrayList<PSDERDTO>();
        List psDataEntities = iPSSystem.getAllPSDataEntities();
        if (psDataEntities != null) {
            for (IPSDataEntity iPSDataEntity : psDataEntities) {
                List psDERs = iPSDataEntity.getMinorPSDERs();
                if (psDERs == null) continue;
                for (IPSDERBase iPSDER : psDERs) {
                    PSDataEntityDTO majorPSDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDER.getMajorPSDataEntityMust().getId());
                    if (majorPSDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDER.getMajorPSDataEntityMust().getId()));
                    }
                    PSDataEntityDTO minorPSDataEntityDTO = this.globalPSDataEntityDTOMap.get(iPSDER.getMinorPSDataEntityMust().getId());
                    if (minorPSDataEntityDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u5b9e\u4f53[%1$s]\u6570\u636e\u5bf9\u8c61", iPSDER.getMinorPSDataEntityMust().getId()));
                    }
                    String strTag = String.format("%1$s|%2$s|%3$s", iPSDER.getDERType(), majorPSDataEntityDTO.getPSDataEntityId(), minorPSDataEntityDTO.getPSDataEntityId());
                    PSDERDTO psDERDTO = (PSDERDTO)psDERDTOMap.get(strTag);
                    if (psDERDTO != null) {
                        this.globalPSDERDTOMap.put(iPSDER.getId(), psDERDTO);
                        continue;
                    }
                    if (bRefreshOnly) continue;
                    psDERDTO = new PSDERDTO();
                    psDERDTO.setPSDERName(iPSDER.getName());
                    psDERDTO.setCodeName(iPSDER.getCodeName());
                    psDERDTO.setDERType(iPSDER.getDERType());
                    psDERDTO.setMajorPSDEId(majorPSDataEntityDTO.getPSDataEntityId());
                    psDERDTO.setMajorPSDEName(majorPSDataEntityDTO.getPSDataEntityName());
                    psDERDTO.setMinorPSDEId(minorPSDataEntityDTO.getPSDataEntityId());
                    psDERDTO.setMinorPSDEName(minorPSDataEntityDTO.getPSDataEntityName());
                    psDERDTO.setLogicName(iPSDER.getLogicName());
                    psDERDTO.setSrfSystemFlag(1);
                    psDERDTOList.add(psDERDTO);
                }
            }
        }
        if (!bRefreshOnly && psDERDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSDERs(psDERDTOList);
            this.syncPSDERs(iPSSystem, true);
        }
    }

    protected void syncPSSysRefs(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSSysRefDTOMap.clear();
        PSSysRefFilter psModelSearchContextDTO = new PSSysRefFilter();
        List<PSSysRefDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysRefs(psModelSearchContextDTO);
        HashMap<String, PSSysRefDTO> psSysRefDTOMap = new HashMap<String, PSSysRefDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSSysRefDTO psSysRefDTO : list) {
                psSysRefDTOMap.put(psSysRefDTO.getRealSysId(), psSysRefDTO);
            }
        }
        ArrayList<PSSysRefDTO> psSysRefDTOList = new ArrayList<PSSysRefDTO>();
        List psSysRefs = iPSSystem.getAllPSSysRefs();
        if (psSysRefs != null) {
            for (IPSSysRef iPSSysRef : psSysRefs) {
                if (!StringUtils.hasLength((String)iPSSysRef.getSysRefTag())) continue;
                PSSysRefDTO psSysRefDTO = (PSSysRefDTO)psSysRefDTOMap.get(iPSSysRef.getSysRefTag());
                if (psSysRefDTO != null) {
                    this.globalPSSysRefDTOMap.put(iPSSysRef.getId(), (PSSysRefDTO)psSysRefDTOMap.get(iPSSysRef.getSysRefTag()));
                    continue;
                }
                if (bRefreshOnly) continue;
                psSysRefDTO = new PSSysRefDTO();
                psSysRefDTO.setPSSysRefName(iPSSysRef.getName());
                psSysRefDTO.setSysRefType(iPSSysRef.getSysRefType());
                psSysRefDTO.setRealSysId(iPSSysRef.getSysRefTag());
                psSysRefDTO.setSrfSystemFlag(1);
                psSysRefDTOList.add(psSysRefDTO);
            }
        }
        if (!bRefreshOnly && psSysRefDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSSysRefs(psSysRefDTOList);
            this.syncPSSysRefs(iPSSystem, true);
        }
    }

    protected void syncPSSysModelGroups(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSSysModelGroupDTOMap.clear();
        PSSysModelGroupFilter psModelSearchContextDTO = new PSSysModelGroupFilter();
        List<PSSysModelGroupDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysModelGroups(psModelSearchContextDTO);
        HashMap<String, PSSysModelGroupDTO> psSysModelGroupDTOMap = new HashMap<String, PSSysModelGroupDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSSysModelGroupDTO psSysModelGroupDTO : list) {
                psSysModelGroupDTOMap.put(psSysModelGroupDTO.getCodeName(), psSysModelGroupDTO);
            }
        }
        ArrayList<PSSysModelGroupDTO> psSysModelGroupDTOList = new ArrayList<PSSysModelGroupDTO>();
        List psSysModelGroups = iPSSystem.getAllPSSysModelGroups();
        if (psSysModelGroups != null) {
            for (IPSSysModelGroup iPSSysModelGroup : psSysModelGroups) {
                if (!StringUtils.hasLength((String)iPSSysModelGroup.getCodeName())) continue;
                PSSysModelGroupDTO psSysModelGroupDTO = (PSSysModelGroupDTO)psSysModelGroupDTOMap.get(iPSSysModelGroup.getCodeName());
                if (psSysModelGroupDTO != null) {
                    this.globalPSSysModelGroupDTOMap.put(iPSSysModelGroup.getId(), (PSSysModelGroupDTO)psSysModelGroupDTOMap.get(iPSSysModelGroup.getCodeName()));
                    continue;
                }
                if (bRefreshOnly) continue;
                psSysModelGroupDTO = new PSSysModelGroupDTO();
                psSysModelGroupDTO.setPSSysModelGroupName(iPSSysModelGroup.getName());
                psSysModelGroupDTO.setCodeName(iPSSysModelGroup.getCodeName());
                psSysModelGroupDTO.setSrfSystemFlag(1);
                psSysModelGroupDTOList.add(psSysModelGroupDTO);
            }
        }
        if (!bRefreshOnly && psSysModelGroupDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSSysModelGroups(psSysModelGroupDTOList);
            this.syncPSSysModelGroups(iPSSystem, true);
        }
    }

    protected void syncPSWorkflows(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSWorkflowDTOMap.clear();
        PSWorkflowFilter psModelSearchContextDTO = new PSWorkflowFilter();
        List<PSWorkflowDTO> list = PSModelServiceUtils.getInstance().searchAllPSWorkflows(psModelSearchContextDTO);
        HashMap<String, PSWorkflowDTO> psWorkflowDTOMap = new HashMap<String, PSWorkflowDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSWorkflowDTO psWorkflowDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psWorkflowDTO.getPSModuleId()) ? String.format("PSMODULE|%1$s|%2$s", psWorkflowDTO.getPSModuleId(), psWorkflowDTO.getCodeName()) : psWorkflowDTO.getCodeName();
                psWorkflowDTOMap.put(strTag, psWorkflowDTO);
            }
        }
        ArrayList<PSWorkflowDTO> psWorkflowDTOList = new ArrayList<PSWorkflowDTO>();
        List psWorkflows = iPSSystem.getAllPSWorkflows();
        if (psWorkflows != null) {
            for (IPSWorkflow iPSWorkflow : psWorkflows) {
                String strTag = null;
                PSModuleDTO psModuleDTO = null;
                if (iPSWorkflow.getPSSystemModule() != null) {
                    psModuleDTO = this.globalPSModuleDTOMap.get(iPSWorkflow.getPSSystemModuleMust().getId());
                    if (psModuleDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSWorkflow.getPSSystemModuleMust().getId()));
                    }
                    strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSWorkflow.getCodeName());
                } else {
                    strTag = iPSWorkflow.getCodeName();
                }
                PSWorkflowDTO psWorkflowDTO = (PSWorkflowDTO)psWorkflowDTOMap.get(strTag);
                if (psWorkflowDTO != null) {
                    this.globalPSWorkflowDTOMap.put(iPSWorkflow.getId(), psWorkflowDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psWorkflowDTO = new PSWorkflowDTO();
                psWorkflowDTO.setPSWorkflowName(iPSWorkflow.getName());
                psWorkflowDTO.setCodeName(iPSWorkflow.getCodeName());
                if (psModuleDTO != null) {
                    psWorkflowDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                    psWorkflowDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                }
                psWorkflowDTO.setSrfSystemFlag(1);
                psWorkflowDTOList.add(psWorkflowDTO);
            }
        }
        if (!bRefreshOnly && psWorkflowDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSWorkflows(psWorkflowDTOList);
            this.syncPSWorkflows(iPSSystem, true);
        }
    }

    protected void syncPSWFRoles(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSWFRoleDTOMap.clear();
        PSWFRoleFilter psModelSearchContextDTO = new PSWFRoleFilter();
        List<PSWFRoleDTO> list = PSModelServiceUtils.getInstance().searchAllPSWFRoles(psModelSearchContextDTO);
        HashMap<String, PSWFRoleDTO> psWFRoleDTOMap = new HashMap<String, PSWFRoleDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSWFRoleDTO psWFRoleDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psWFRoleDTO.getPSModuleId()) ? String.format("PSMODULE|%1$s|%2$s", psWFRoleDTO.getPSModuleId(), psWFRoleDTO.getCodeName()) : psWFRoleDTO.getCodeName();
                psWFRoleDTOMap.put(strTag, psWFRoleDTO);
            }
        }
        ArrayList<PSWFRoleDTO> psWFRoleDTOList = new ArrayList<PSWFRoleDTO>();
        List psWFRoles = iPSSystem.getAllPSWFRoles();
        if (psWFRoles != null) {
            for (IPSWFRole iPSWFRole : psWFRoles) {
                String strTag = null;
                PSModuleDTO psModuleDTO = null;
                if (iPSWFRole.getPSSystemModule() != null) {
                    psModuleDTO = this.globalPSModuleDTOMap.get(iPSWFRole.getPSSystemModuleMust().getId());
                    if (psModuleDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSWFRole.getPSSystemModuleMust().getId()));
                    }
                    strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSWFRole.getCodeName());
                } else {
                    strTag = iPSWFRole.getCodeName();
                }
                PSWFRoleDTO psWFRoleDTO = (PSWFRoleDTO)psWFRoleDTOMap.get(strTag);
                if (psWFRoleDTO != null) {
                    this.globalPSWFRoleDTOMap.put(iPSWFRole.getId(), psWFRoleDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psWFRoleDTO = new PSWFRoleDTO();
                psWFRoleDTO.setPSWFRoleName(iPSWFRole.getName());
                psWFRoleDTO.setCodeName(iPSWFRole.getCodeName());
                psWFRoleDTO.setWFRoleType(iPSWFRole.getWFRoleType());
                psWFRoleDTO.setWFRoleSN(iPSWFRole.getWFRoleSN());
                if (psModuleDTO != null) {
                    psWFRoleDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                    psWFRoleDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                }
                psWFRoleDTO.setSrfSystemFlag(1);
                psWFRoleDTOList.add(psWFRoleDTO);
            }
        }
        if (!bRefreshOnly && psWFRoleDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSWFRoles(psWFRoleDTOList);
            this.syncPSWFRoles(iPSSystem, true);
        }
    }

    protected void syncPSWFWorkTimes(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSWFWorkTimeDTOMap.clear();
        PSWFWorkTimeFilter psModelSearchContextDTO = new PSWFWorkTimeFilter();
        List<PSWFWorkTimeDTO> list = PSModelServiceUtils.getInstance().searchAllPSWFWorkTimes(psModelSearchContextDTO);
        HashMap<String, PSWFWorkTimeDTO> psWFWorkTimeDTOMap = new HashMap<String, PSWFWorkTimeDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSWFWorkTimeDTO psWFWorkTimeDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psWFWorkTimeDTO.getPSModuleId()) ? String.format("PSMODULE|%1$s|%2$s", psWFWorkTimeDTO.getPSModuleId(), psWFWorkTimeDTO.getCodeName()) : psWFWorkTimeDTO.getCodeName();
                psWFWorkTimeDTOMap.put(strTag, psWFWorkTimeDTO);
            }
        }
        ArrayList<PSWFWorkTimeDTO> psWFWorkTimeDTOList = new ArrayList<PSWFWorkTimeDTO>();
        List psWFWorkTimes = iPSSystem.getAllPSWFWorkTimes();
        if (psWFWorkTimes != null) {
            for (IPSWFWorkTime iPSWFWorkTime : psWFWorkTimes) {
                String strTag = null;
                PSModuleDTO psModuleDTO = null;
                if (iPSWFWorkTime.getPSSystemModule() != null) {
                    psModuleDTO = this.globalPSModuleDTOMap.get(iPSWFWorkTime.getPSSystemModuleMust().getId());
                    if (psModuleDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSWFWorkTime.getPSSystemModuleMust().getId()));
                    }
                    strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSWFWorkTime.getCodeName());
                } else {
                    strTag = iPSWFWorkTime.getCodeName();
                }
                PSWFWorkTimeDTO psWFWorkTimeDTO = (PSWFWorkTimeDTO)psWFWorkTimeDTOMap.get(strTag);
                if (psWFWorkTimeDTO != null) {
                    this.globalPSWFWorkTimeDTOMap.put(iPSWFWorkTime.getId(), psWFWorkTimeDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psWFWorkTimeDTO = new PSWFWorkTimeDTO();
                psWFWorkTimeDTO.setPSWFWorkTimeName(iPSWFWorkTime.getName());
                psWFWorkTimeDTO.setCodeName(iPSWFWorkTime.getCodeName());
                psWFWorkTimeDTO.setWFWorktimeSN(iPSWFWorkTime.getWFWorkTimeSN());
                if (psModuleDTO != null) {
                    psWFWorkTimeDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                    psWFWorkTimeDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                }
                psWFWorkTimeDTO.setSrfSystemFlag(1);
                psWFWorkTimeDTOList.add(psWFWorkTimeDTO);
            }
        }
        if (!bRefreshOnly && psWFWorkTimeDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSWFWorkTimes(psWFWorkTimeDTOList);
            this.syncPSWFWorkTimes(iPSSystem, true);
        }
    }

    protected void syncPSSysMsgTempls(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSSysMsgTemplDTOMap.clear();
        PSSysMsgTemplFilter psModelSearchContextDTO = new PSSysMsgTemplFilter();
        List<PSSysMsgTemplDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysMsgTempls(psModelSearchContextDTO);
        HashMap<String, PSSysMsgTemplDTO> psSysMsgTemplDTOMap = new HashMap<String, PSSysMsgTemplDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSSysMsgTemplDTO psSysMsgTemplDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psSysMsgTemplDTO.getPSModuleId()) ? String.format("PSMODULE|%1$s|%2$s", psSysMsgTemplDTO.getPSModuleId(), psSysMsgTemplDTO.getCodeName()) : psSysMsgTemplDTO.getCodeName();
                psSysMsgTemplDTOMap.put(strTag, psSysMsgTemplDTO);
            }
        }
        ArrayList<PSSysMsgTemplDTO> psSysMsgTemplDTOList = new ArrayList<PSSysMsgTemplDTO>();
        List psSysMsgTempls = iPSSystem.getAllPSSysMsgTempls();
        if (psSysMsgTempls != null) {
            for (IPSSysMsgTempl iPSSysMsgTempl : psSysMsgTempls) {
                String strTag = null;
                PSModuleDTO psModuleDTO = null;
                if (iPSSysMsgTempl.getPSSystemModule() != null) {
                    psModuleDTO = this.globalPSModuleDTOMap.get(iPSSysMsgTempl.getPSSystemModuleMust().getId());
                    if (psModuleDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSSysMsgTempl.getPSSystemModuleMust().getId()));
                    }
                    strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSSysMsgTempl.getCodeName());
                } else {
                    strTag = iPSSysMsgTempl.getCodeName();
                }
                PSSysMsgTemplDTO psSysMsgTemplDTO = (PSSysMsgTemplDTO)psSysMsgTemplDTOMap.get(strTag);
                if (psSysMsgTemplDTO != null) {
                    this.globalPSSysMsgTemplDTOMap.put(iPSSysMsgTempl.getId(), psSysMsgTemplDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psSysMsgTemplDTO = new PSSysMsgTemplDTO();
                psSysMsgTemplDTO.setPSSysMsgTemplName(iPSSysMsgTempl.getName());
                psSysMsgTemplDTO.setCodeName(iPSSysMsgTempl.getCodeName());
                psSysMsgTemplDTO.setContentType(iPSSysMsgTempl.getContentType());
                psSysMsgTemplDTO.setContent(iPSSysMsgTempl.getContent());
                if (psModuleDTO != null) {
                    psSysMsgTemplDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                    psSysMsgTemplDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                }
                psSysMsgTemplDTO.setSrfSystemFlag(1);
                psSysMsgTemplDTOList.add(psSysMsgTemplDTO);
            }
        }
        if (!bRefreshOnly && psSysMsgTemplDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSSysMsgTempls(psSysMsgTemplDTOList);
            this.syncPSSysMsgTempls(iPSSystem, true);
        }
    }

    protected void syncPSSysDELogicNodes(IPSSystem iPSSystem, boolean bRefreshOnly) throws Throwable {
        this.globalPSSysDELogicNodeDTOMap.clear();
        PSSysDELogicNodeFilter psModelSearchContextDTO = new PSSysDELogicNodeFilter();
        List<PSSysDELogicNodeDTO> list = PSModelServiceUtils.getInstance().searchAllPSSysDELogicNodes(psModelSearchContextDTO);
        HashMap<String, PSSysDELogicNodeDTO> psSysDELogicNodeDTOMap = new HashMap<String, PSSysDELogicNodeDTO>();
        if (!ObjectUtils.isEmpty(list)) {
            for (PSSysDELogicNodeDTO psSysDELogicNodeDTO : list) {
                String strTag = null;
                strTag = StringUtils.hasLength((String)psSysDELogicNodeDTO.getPSModuleId()) ? String.format("PSMODULE|%1$s|%2$s", psSysDELogicNodeDTO.getPSModuleId(), psSysDELogicNodeDTO.getCodeName()) : psSysDELogicNodeDTO.getCodeName();
                psSysDELogicNodeDTOMap.put(strTag, psSysDELogicNodeDTO);
            }
        }
        ArrayList<PSSysDELogicNodeDTO> psSysDELogicNodeDTOList = new ArrayList<PSSysDELogicNodeDTO>();
        List psSysDELogicNodes = iPSSystem.getAllPSSysLogics();
        if (psSysDELogicNodes != null) {
            for (IPSSysLogic iPSSysDELogicNode : psSysDELogicNodes) {
                String strTag = null;
                PSModuleDTO psModuleDTO = null;
                if (iPSSysDELogicNode.getPSSystemModule() != null) {
                    psModuleDTO = this.globalPSModuleDTOMap.get(iPSSysDELogicNode.getPSSystemModuleMust().getId());
                    if (psModuleDTO == null) {
                        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u6a21\u5757[%1$s]\u6570\u636e\u5bf9\u8c61", iPSSysDELogicNode.getPSSystemModuleMust().getId()));
                    }
                    strTag = String.format("PSMODULE|%1$s|%2$s", psModuleDTO.getPSModuleId(), iPSSysDELogicNode.getCodeName());
                } else {
                    strTag = iPSSysDELogicNode.getCodeName();
                }
                PSSysDELogicNodeDTO psSysDELogicNodeDTO = (PSSysDELogicNodeDTO)psSysDELogicNodeDTOMap.get(strTag);
                if (psSysDELogicNodeDTO != null) {
                    this.globalPSSysDELogicNodeDTOMap.put(iPSSysDELogicNode.getId(), psSysDELogicNodeDTO);
                    continue;
                }
                if (bRefreshOnly) continue;
                psSysDELogicNodeDTO = new PSSysDELogicNodeDTO();
                psSysDELogicNodeDTO.setPSSysDELogicNodeName(iPSSysDELogicNode.getName());
                psSysDELogicNodeDTO.setCodeName(iPSSysDELogicNode.getCodeName());
                if (psModuleDTO != null) {
                    psSysDELogicNodeDTO.setPSModuleId(psModuleDTO.getPSModuleId());
                    psSysDELogicNodeDTO.setPSModuleName(psModuleDTO.getPSModuleName());
                }
                psSysDELogicNodeDTO.setSrfSystemFlag(1);
                psSysDELogicNodeDTOList.add(psSysDELogicNodeDTO);
            }
        }
        if (!bRefreshOnly && psSysDELogicNodeDTOList.size() > 0) {
            PSModelServiceUtils.getInstance().createPSSysDELogicNodes(psSysDELogicNodeDTOList);
            this.syncPSSysDELogicNodes(iPSSystem, true);
        }
    }
}

