/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.centralstudio.util.CentralServiceSession;
import net.ibizsys.centralstudio.util.ICentralEntityDTO;
import net.ibizsys.centralstudio.util.ISearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public abstract class CentralServiceImplBase {
    private static ExchangeFilterFunction exchangeFilterFunction = null;
    private static ObjectMapper mapper = null;
    private static Map<String, WebClient> webClientMap = new HashMap<String, WebClient>();

    public static void setExchangeFilterFunction(ExchangeFilterFunction exchangeFilterFunction) {
        CentralServiceImplBase.exchangeFilterFunction = exchangeFilterFunction;
    }

    public static ExchangeFilterFunction getExchangeFilterFunction() {
        return exchangeFilterFunction;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    public static void setMapper(ObjectMapper mapper) {
        CentralServiceImplBase.mapper = mapper;
    }

    protected WebClient getWebClient() {
        WebClient webClient = webClientMap.get(this.getServiceUrl());
        if (webClient != null) {
            return webClient;
        }
        webClient = StringUtils.hasLength((String)this.getServiceUrl()) ? (this.getServiceUrl().indexOf("lb://") == 0 ? WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).filter(CentralServiceImplBase.getExchangeFilterFunction()).baseUrl(this.getServiceUrl()).build() : WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).baseUrl(this.getServiceUrl()).build()) : WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build();
        webClientMap.put(this.getServiceUrl(), webClient);
        return webClient;
    }

    protected CentralServiceSession getSession() {
        try {
            return CentralServiceSession.getCurrent();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean containsContext(String strName) {
        try {
            return CentralServiceSession.getCurrent().containsContext(strName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String getServiceUrl() {
        try {
            return CentralServiceSession.getCurrent().getServiceUrl();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected <T> T executeGet(String strUri, Object objKey, Class<T> cls) throws Throwable {
        CentralServiceSession csServiceSession = CentralServiceSession.getCurrent();
        Object lastKey = csServiceSession.getContext("key");
        csServiceSession.setContext("key", this.getKey(objKey));
        try {
            Mono mono = this.getWebClient().get().uri(strUri, csServiceSession.getContextMap()).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(csServiceSession)}).header("srfsystemid", new String[]{csServiceSession.getSystemId()}).header("srforgid", new String[]{csServiceSession.getOrgId()}).retrieve().toEntity(cls);
            Object object = ((ResponseEntity)mono.block()).getBody();
            return (T)object;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)CentralServiceImplBase.getMapper().readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
        finally {
            csServiceSession.setContext("key", lastKey);
        }
    }

    protected <T> T executeDelete(String strUri, Object objKey, Class<T> cls) throws Throwable {
        CentralServiceSession csServiceSession = CentralServiceSession.getCurrent();
        Object lastKey = csServiceSession.getContext("key");
        csServiceSession.setContext("key", this.getKey(objKey));
        try {
            Mono mono = this.getWebClient().delete().uri(strUri, csServiceSession.getContextMap()).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(csServiceSession)}).header("srfsystemid", new String[]{csServiceSession.getSystemId()}).header("srforgid", new String[]{csServiceSession.getOrgId()}).retrieve().toEntity(cls);
            Object object = ((ResponseEntity)mono.block()).getBody();
            return (T)object;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)CentralServiceImplBase.getMapper().readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
        finally {
            csServiceSession.setContext("key", lastKey);
        }
    }

    protected <T> T executePost(String strUri, Object objBody, Class<T> cls) throws Throwable {
        CentralServiceSession csServiceSession = CentralServiceSession.getCurrent();
        Object lastKey = csServiceSession.getContext("key");
        csServiceSession.setContext("key", this.getKey(objBody));
        try {
            Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().post().uri(strUri, csServiceSession.getContextMap())).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(csServiceSession)})).header("srfsystemid", new String[]{csServiceSession.getSystemId()})).header("srforgid", new String[]{csServiceSession.getOrgId()})).bodyValue(objBody).retrieve().toEntity(cls);
            Object object = ((ResponseEntity)mono.block()).getBody();
            return (T)object;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)CentralServiceImplBase.getMapper().readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
        finally {
            csServiceSession.setContext("key", lastKey);
        }
    }

    protected <T> T executePut(String strUri, Object objBody, Class<T> cls) throws Throwable {
        CentralServiceSession csServiceSession = CentralServiceSession.getCurrent();
        Object lastKey = csServiceSession.getContext("key");
        csServiceSession.setContext("key", this.getKey(objBody));
        try {
            Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().put().uri(strUri, csServiceSession.getContextMap())).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(csServiceSession)})).header("srfsystemid", new String[]{csServiceSession.getSystemId()})).header("srforgid", new String[]{csServiceSession.getOrgId()})).bodyValue(objBody).retrieve().toEntity(cls);
            Object object = ((ResponseEntity)mono.block()).getBody();
            return (T)object;
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)CentralServiceImplBase.getMapper().readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
        finally {
            csServiceSession.setContext("key", lastKey);
        }
    }

    protected <T> Page<T> executeFetch(String strUri, ISearchContext iSearchContext, Class<T> cls) throws Throwable {
        CentralServiceSession csServiceSession = CentralServiceSession.getCurrent();
        try {
            Mono mono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getWebClient().post().uri(strUri, csServiceSession.getContextMap())).header("Authorization", new String[]{"Bearer " + this.getAuthorizationBearer(csServiceSession)})).header("srfsystemid", new String[]{csServiceSession.getSystemId()})).header("srforgid", new String[]{csServiceSession.getOrgId()})).bodyValue((Object)iSearchContext).retrieve().toEntityList(cls);
            ResponseEntity responseEntity = (ResponseEntity)mono.block();
            List list = responseEntity.getHeaders().get((Object)"x-total");
            if (list != null && list.size() > 0) {
                return new PageImpl((List)responseEntity.getBody(), iSearchContext.getPageable(), (long)Integer.valueOf((String)list.get(0)).intValue());
            }
            return new PageImpl((List)responseEntity.getBody());
        }
        catch (WebClientResponseException ex) {
            ObjectNode objNode;
            String strError = new String(ex.getResponseBodyAsByteArray(), "UTF-8");
            if (StringUtils.hasLength((String)strError) && strError.indexOf("{") == 0 && (objNode = (ObjectNode)CentralServiceImplBase.getMapper().readTree(strError)).get("message") != null) {
                String strMessage = objNode.get("message").asText();
                throw new Exception(strMessage, ex);
            }
            throw ex;
        }
    }

    protected Object getKey(Object arg) {
        if (arg instanceof List) {
            return StringUtils.collectionToDelimitedString((Collection)((List)arg), (String)";");
        }
        if (arg instanceof ICentralEntityDTO) {
            return ((ICentralEntityDTO)arg).getSrfkey();
        }
        return arg;
    }

    protected String getAuthorizationBearer(CentralServiceSession csServiceSession) throws Throwable {
        String strBearer = csServiceSession.getBearer();
        if (StringUtils.hasLength((String)strBearer)) {
            return strBearer;
        }
        return null;
    }
}

