/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.centralstudio.util;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.centralstudio.util.DataTypeUtils;
import net.ibizsys.centralstudio.util.IEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EntityBase
implements IEntity {
    public static final String DRAFTFLAG = "srfdraftflag";
    public static final String ORIGINKEY = "srforikey";
    public static final String LASTENTITY = "srflastentity";
    public static final String KEYSTATE = "srfkeystate";
    public static final String LASTUPDATEDATE = "srfupdatedate";
    public static final String IGNORECHECK = "srfignorecheck";
    public static final String IGNORECHECKKEY = "srfignorecheckkey";
    public static final String RET = "srfret";
    public static final String KEY = "srfkey";
    public static final int BOOLEAN_TRUE = 1;
    public static final int BOOLEAN_FALSE = 0;
    @JsonIgnore
    private boolean bMarkFullInfo = false;
    @JsonIgnore
    private Map<String, Object> paramMap = null;

    @Override
    public Object get(String strName) {
        if (!StringUtils.hasLength((String)strName)) {
            return null;
        }
        if (this.isLowerCaseName()) {
            strName = strName.toLowerCase();
        }
        if (this.paramMap != null) {
            return this.paramMap.get(strName);
        }
        return null;
    }

    @Override
    @JsonAnySetter
    public void set(String strName, Object objValue) {
        if (!StringUtils.hasLength((String)strName)) {
            return;
        }
        if (this.isLowerCaseName()) {
            strName = strName.toLowerCase();
        }
        if (this.paramMap == null) {
            this.paramMap = this.createAny();
        }
        this.paramMap.put(strName, objValue);
    }

    @Override
    public boolean contains(String strName) {
        if (!StringUtils.hasLength((String)strName)) {
            return false;
        }
        if (this.isLowerCaseName()) {
            strName = strName.toLowerCase();
        }
        if (this.paramMap != null) {
            return this.paramMap.containsKey(strName);
        }
        return false;
    }

    @Override
    public void reset(String strName) {
        if (!StringUtils.hasLength((String)strName)) {
            return;
        }
        if (this.isLowerCaseName()) {
            strName = strName.toLowerCase();
        }
        if (this.paramMap != null) {
            this.paramMap.remove(strName);
        }
    }

    @Override
    public void resetAll() {
        this.onResetAll();
    }

    protected void onResetAll() {
        this.paramMap = null;
    }

    @JsonIgnore
    protected boolean isLowerCaseName() {
        return true;
    }

    public static boolean hasDraftFlag(IEntity iEntity) {
        Object objValue = iEntity.get(DRAFTFLAG);
        return objValue != null;
    }

    public static void setDraft(IEntity iEntity, boolean bDraftFlag) {
        iEntity.set(DRAFTFLAG, bDraftFlag ? 1 : 0);
    }

    public static void setLastUpdateDate(IEntity iEntity, Timestamp timestamp) {
        String strLastDateStr = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", timestamp);
        iEntity.set(LASTUPDATEDATE, strLastDateStr);
    }

    public static void setIgnoreCheck(IEntity iEntity, boolean bIgnoreCheck) {
        iEntity.set(IGNORECHECK, bIgnoreCheck ? 1 : 0);
    }

    public static boolean isIgnoreCheck(IEntity iEntity) throws Exception {
        return DataTypeUtils.getIntegerValue(iEntity.get(IGNORECHECK), 0) == 1;
    }

    public static void setIgnoreCheckKey(IEntity iEntity, boolean bIgnoreCheckKey) {
        iEntity.set(IGNORECHECKKEY, bIgnoreCheckKey ? 1 : 0);
    }

    public static boolean isIgnoreCheckKey(IEntity iEntity) throws Exception {
        return DataTypeUtils.getIntegerValue(iEntity.get(IGNORECHECKKEY), 0) == 1;
    }

    public static Object getOriginKey(IEntity iEntity) {
        return iEntity.get(ORIGINKEY);
    }

    public static IEntity getLast(IEntity iEntity) {
        Object objValue = iEntity.get(LASTENTITY);
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof IEntity) {
            return (IEntity)objValue;
        }
        return null;
    }

    public static void setLast(IEntity iEntity, IEntity lastEntity) {
        if (lastEntity == null) {
            iEntity.reset(LASTENTITY);
        } else {
            iEntity.set(LASTENTITY, lastEntity);
        }
    }

    @Override
    public void copyTo(IEntity iEntity) {
        if (this.paramMap != null) {
            for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
                iEntity.set(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.paramMap;
    }

    @JsonIgnore
    protected void setAny(Map<String, Object> map) {
        this.setAny(map, false);
    }

    @JsonIgnore
    protected void setAny(Map<String, Object> map, boolean bCopyMode) {
        if (bCopyMode) {
            if (map == null) {
                this.paramMap = null;
            } else {
                this.paramMap = this.createAny();
                this.paramMap.putAll(map);
            }
        } else {
            this.paramMap = map;
        }
    }

    @JsonIgnore
    protected Map<String, Object> createAny() {
        return new HashMap<String, Object>();
    }

    @JsonIgnore
    public void putAll(Map<String, Object> map) {
        Assert.notNull(map, (String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }
}

