package net.ibizsys.centralstudio.filter;

import java.sql.Timestamp;
import net.ibizsys.centralstudio.util.Conditions;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 模型 PSDEFIELD 过滤器对象
 */
public class PSDEFieldFilter extends net.ibizsys.centralstudio.util.PSModelSearchContextDTO {

    public PSDEFieldFilter(){
    
    }      

    /**
     * 设置属性[业务标记]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter biztag__eq(String value){
        this.setFieldCond("biztag", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[数据库更新值模式]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dbvaluemode__eq(String value){
        this.setFieldCond("dbvaluemode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[数据库新建值模式]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dbvaluemode2__eq(String value){
        this.setFieldCond("dbvaluemode2", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[属性类型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter deftype__eq(Integer value){
        this.setFieldCond("deftype", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[关系属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter derpsdefid__eq(String value){
        this.setFieldCond("derpsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[关系属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter derpsdefname__eq(String value){
        this.setFieldCond("derpsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[关系属性]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter derpsdefname__like(String value){
        this.setFieldCond("derpsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[重复值检查]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dupcheckmode__eq(String value){
        this.setFieldCond("dupcheckmode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dupcheckpsdefid__eq(String value){
        this.setFieldCond("dupcheckpsdefid", Conditions.EQ, value);
        //属性名称与代码标识不一致，设置属性名称
        this.setFieldCond("dupchkpsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dupcheckpsdefname__eq(String value){
        this.setFieldCond("dupcheckpsdefname", Conditions.EQ, value);
        //属性名称与代码标识不一致，设置属性名称
        this.setFieldCond("dupchkpsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter dupcheckpsdefname__like(String value){
        this.setFieldCond("dupcheckpsdefname", Conditions.LIKE, value);
        //属性名称与代码标识不一致，设置属性名称
        this.setFieldCond("dupchkpsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[默认值类型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter defaultvaluetype__eq(String value){
        this.setFieldCond("defaultvaluetype", Conditions.EQ, value);
        //属性名称与代码标识不一致，设置属性名称
        this.setFieldCond("dvt", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[扩展模式]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter extendmode__eq(Integer value){
        this.setFieldCond("extendmode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[名称语言资源]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter lnpslanresid__eq(String value){
        this.setFieldCond("lnpslanresid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[名称语言资源]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter lnpslanresname__eq(String value){
        this.setFieldCond("lnpslanresname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[名称语言资源]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter lnpslanresname__like(String value){
        this.setFieldCond("lnpslanresname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[中文名称]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter logicname__like(String value){
        this.setFieldCond("logicname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[主信息属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter majorfield__eq(Integer value){
        this.setFieldCond("majorfield", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性2]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no2dupchkpsdefid__eq(String value){
        this.setFieldCond("no2dupchkpsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性2]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no2dupchkpsdefname__eq(String value){
        this.setFieldCond("no2dupchkpsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性2]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no2dupchkpsdefname__like(String value){
        this.setFieldCond("no2dupchkpsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[范围属性3]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no3dupchkpsdefid__eq(String value){
        this.setFieldCond("no3dupchkpsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性3]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no3dupchkpsdefname__eq(String value){
        this.setFieldCond("no3dupchkpsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[范围属性3]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter no3dupchkpsdefname__like(String value){
        this.setFieldCond("no3dupchkpsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[空值排序]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter nullvalorder__eq(String value){
        this.setFieldCond("nullvalorder", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[一对多关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2mpsderid__eq(String value){
        this.setFieldCond("o2mpsderid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[一对多关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2mpsdername__eq(String value){
        this.setFieldCond("o2mpsdername", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[一对多关系]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2mpsdername__like(String value){
        this.setFieldCond("o2mpsdername", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[一对一关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2opsderid__eq(String value){
        this.setFieldCond("o2opsderid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[一对一关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2opsdername__eq(String value){
        this.setFieldCond("o2opsdername", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[一对一关系]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter o2opsdername__like(String value){
        this.setFieldCond("o2opsdername", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[物理化属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter physicalfield__eq(Integer value){
        this.setFieldCond("physicalfield", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[主键属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pkey__eq(Integer value){
        this.setFieldCond("pkey", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统预置属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter predefinedtype__eq(String value){
        this.setFieldCond("predefinedtype", Conditions.EQ, value);
        //属性名称与代码标识不一致，设置属性名称
        this.setFieldCond("predefinetype", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统代码表]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pscodelistid__eq(String value){
        this.setFieldCond("pscodelistid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统代码表]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pscodelistname__eq(String value){
        this.setFieldCond("pscodelistname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统代码表]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pscodelistname__like(String value){
        this.setFieldCond("pscodelistname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[数据类型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdatatypeid__eq(String value){
        this.setFieldCond("psdatatypeid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[数据类型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdatatypename__eq(String value){
        this.setFieldCond("psdatatypename", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[数据类型]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdatatypename__like(String value){
        this.setFieldCond("psdatatypename", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[属性标识]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdefieldname__like(String value){
        this.setFieldCond("psdefieldname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[实体]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdeid__eq(String value){
        this.setFieldCond("psdeid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[实体]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdename__eq(String value){
        this.setFieldCond("psdename", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[实体]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdename__like(String value){
        this.setFieldCond("psdename", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[实体关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psderid__eq(String value){
        this.setFieldCond("psderid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[实体关系]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdername__eq(String value){
        this.setFieldCond("psdername", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[实体关系]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter psdername__like(String value){
        this.setFieldCond("psdername", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[外部接口实体属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssubsyssadefieldid__eq(String value){
        this.setFieldCond("pssubsyssadefieldid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[外部接口实体属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssubsyssadefieldname__eq(String value){
        this.setFieldCond("pssubsyssadefieldname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[外部接口实体属性]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssubsyssadefieldname__like(String value){
        this.setFieldCond("pssubsyssadefieldname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[系统示例值]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssamplevalueid__eq(String value){
        this.setFieldCond("pssyssamplevalueid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统示例值]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssamplevaluename__eq(String value){
        this.setFieldCond("pssyssamplevaluename", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统示例值]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssamplevaluename__like(String value){
        this.setFieldCond("pssyssamplevaluename", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[系统值序列]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssequenceid__eq(String value){
        this.setFieldCond("pssyssequenceid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统值序列]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssequencename__eq(String value){
        this.setFieldCond("pssyssequencename", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统值序列]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssyssequencename__like(String value){
        this.setFieldCond("pssyssequencename", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[系统转换器]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssystranslatorid__eq(String value){
        this.setFieldCond("pssystranslatorid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统转换器]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssystranslatorname__eq(String value){
        this.setFieldCond("pssystranslatorname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[系统转换器]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssystranslatorname__like(String value){
        this.setFieldCond("pssystranslatorname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[单位]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysunitid__eq(String value){
        this.setFieldCond("pssysunitid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[单位]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysunitname__eq(String value){
        this.setFieldCond("pssysunitname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[单位]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysunitname__like(String value){
        this.setFieldCond("pssysunitname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[值规则]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysvalueruleid__eq(String value){
        this.setFieldCond("pssysvalueruleid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[基础值规则]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysvaluerulename__eq(String value){
        this.setFieldCond("pssysvaluerulename", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[基础值规则]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter pssysvaluerulename__like(String value){
        this.setFieldCond("pssysvaluerulename", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[引用动态模型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter refpssysdynamodelid__eq(String value){
        this.setFieldCond("refpssysdynamodelid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[引用动态模型]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter refpssysdynamodelname__eq(String value){
        this.setFieldCond("refpssysdynamodelname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[引用动态模型]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter refpssysdynamodelname__like(String value){
        this.setFieldCond("refpssysdynamodelname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[限制属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter restrictedpsdefid__eq(String value){
        this.setFieldCond("restrictedpsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[限制属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter restrictedpsdefname__eq(String value){
        this.setFieldCond("restrictedpsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[限制属性]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter restrictedpsdefname__like(String value){
        this.setFieldCond("restrictedpsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[值序列使用]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter sequencemode__eq(String value){
        this.setFieldCond("sequencemode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[主状态属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter statefield__eq(String value){
        this.setFieldCond("statefield", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[字符转换]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter stringcase__eq(String value){
        this.setFieldCond("stringcase", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[表范围]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter tablescope__eq(String value){
        this.setFieldCond("tablescope", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[值转换使用]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter translatormode__eq(String value){
        this.setFieldCond("translatormode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[联合键值]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter unionkeyvalue__eq(String value){
        this.setFieldCond("unionkeyvalue", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[更新旧值回填]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter updateovmode__eq(String value){
        this.setFieldCond("updateovmode", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[用户分类]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter usercat__eq(String value){
        this.setFieldCond("usercat", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[值项属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter valuepsdefid__eq(String value){
        this.setFieldCond("valuepsdefid", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[值项属性]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter valuepsdefname__eq(String value){
        this.setFieldCond("valuepsdefname", Conditions.EQ, value);
        return this;
    }

    /**
     * 设置属性[值项属性]过滤操作[LIKE]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter valuepsdefname__like(String value){
        this.setFieldCond("valuepsdefname", Conditions.LIKE, value);
        return this;
    }

    /**
     * 设置属性[视图列级别]过滤操作[EQ]
     * @param value
     * @return
     */
    @JsonIgnore
    public PSDEFieldFilter viewcollevel__eq(Integer value){
        this.setFieldCond("viewcollevel", Conditions.EQ, value);
        return this;
    }

}
